let currentStep = 1;

document.addEventListener("DOMContentLoaded", function () {
  showStep(currentStep);
  updatePageNumber();
  updatePagination();
});

function gotoStep(step) {
  const formStep = document.getElementById(`step-${step}`);
  if (formStep) {
    currentStep = step;
    showStep(currentStep);
    updatePageNumber();
    updatePagination();
  }
}

function showStep(step) {
  const formSteps = document.querySelectorAll(".form-step");
  formSteps.forEach((stepElement) => stepElement.classList.remove("active"));

  const currentFormStep = document.getElementById(`step-${step}`);
  if (currentFormStep) {
    currentFormStep.classList.add("active");
  }
}

function nextStep() {
  if (currentStep < 5) {
    currentStep++;
    showStep(currentStep);
    updatePageNumber();
    updatePagination();
  }
}

function prevStep() {
  if (currentStep > 1) {
    currentStep--;
    showStep(currentStep);
    updatePageNumber();
    updatePagination();
  }
}

function updatePageNumber() {
  const pageNumber = document.getElementById("page-number");
  pageNumber.innerText = `Step ${currentStep} of 5`;
}
//Submit Step 2 Data
function substep2() {
  var recordid = $("#recordid").val();
  var patientid = $("#patientid").val();
  var fname = $("#fname").val();
  var lname = $("#lname").val();
  var pdob = $("#pdob").val();
  var psex = $("#psex").val();
  var contact = $("#pcontact").val();
  var doctorpermis = $("#doctorpermis").val();
  $.ajax({
    url: "https://providerondemandapp.com/mPanel/patients/substep2.php",
    type: "POST",
    data: {
      recordid: recordid,
      patientid: patientid,
      fname: fname,
      lname: lname,
      pdob: pdob,
      psex: psex,
      contact: contact,
      doctorpermis: doctorpermis,
    },
  });
}
//Submit Step 3 Data
function substep3() {
  var recordid = $("#recordid").val();
  var patientid = $("#patientid").val();
  var chiefcomplaint = $("#chiefcomplaint").val();
  $.ajax({
    url: "https://providerondemandapp.com/mPanel/patients/substep3.php",
    type: "POST",
    data: {
      recordid: recordid,
      patientid: patientid,
      chiefcomplaint: chiefcomplaint,
    },
  });
}
//Submit Step 4 Data
function substep4() {
  var recordid = $("#recordid").val();
  var patientid = $("#patientid").val();
  var vbp = $("#vbp").val();
  var vtemp = $("#vtemp").val();
  var vresp = $("#vresp").val();
  var vhr = $("#vhr").val();
  var vweight = $("#vweight").val();
  var vhg = $("#vhg").val();
  var vsot = $("#vsot").val();
  var final = $("#final").val();
  $.ajax({
    url: "https://providerondemandapp.com/mPanel/patients/substep4.php",
    type: "POST",
    data: {
      recordid: recordid,
      patientid: patientid,
      vbp: vbp,
      vtemp: vtemp,
      vresp: vresp,
      vhr: vhr,
      vweight: vweight,
      vsot: vsot,
      final: final,
    },
  });
}

function updatePagination() {
  const pageItems = document.querySelectorAll(".pagination .page-item");
  pageItems.forEach((pageItem) => pageItem.classList.remove("active"));

  const currentPaginationItem = document.getElementById(`page-${currentStep}`);
  if (currentPaginationItem) {
    currentPaginationItem.classList.add("active");
  }
  // Logic Next Prev Button
  const prevPreviousbtn = document.getElementById("med-prev");
  const pagspan = document.getElementById("page-number");
  const nextButton = document.getElementById("med-next");
  const sbmtButton = document.getElementById("med-submit");
  const paginationframe = document.getElementById("page-lists");
  const lftpag1 = document.getElementById("page1lftnm");
  const lftpag2 = document.getElementById("page2lftnm");
  const lftpag3 = document.getElementById("page3lftnm");
  const lftpag4 = document.getElementById("page4lftnm");
  if (currentStep === 5) {
    prevPreviousbtn.removeAttribute("disabled", "");
    nextButton.style.display = "none"; // or use nextButton.remove() to completely remove the button
    sbmtButton.style.display = "block";
    //add class and remove class
    paginationframe.classList.add("finish");
    nextButton.classList.remove("sbmtbtnstep2");
    nextButton.classList.remove("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep4");
    //add checklist to left pagnation number
    lftpag4.classList.add("done");
  }
  if (currentStep === 1) {
    nextButton.style.display = "none";
    sbmtButton.style.display = "none";
    pagspan.style.display = "none";
    prevPreviousbtn.style.display = "none";
    nextButton.classList.remove("sbmtbtnstep2");
    nextButton.classList.remove("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep4");
    nextButton.classList.remove("sbmtbtnstep5");
  }
  if (currentStep === 2) {
    prevPreviousbtn.setAttribute("disabled", "");
    nextButton.style.display = "block";
    sbmtButton.style.display = "none";
    pagspan.style.display = "block";
    prevPreviousbtn.style.display = "block";
    //add class and remove class
    nextButton.classList.add("sbmtbtnstep2");
    nextButton.classList.remove("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep4");
    //add checklist to left pagnation number
    lftpag1.classList.add("done");
    lftpag2.classList.remove("done");
    $("#med-next").click(function () {
      console.log("Step 2 Update Successfully!");
      substep2();
    });
  }
  if (currentStep === 3) {
    prevPreviousbtn.removeAttribute("disabled", "");
    nextButton.style.display = "block";
    sbmtButton.style.display = "none";
    pagspan.style.display = "block";
    prevPreviousbtn.style.display = "block";
    //add class and remove class
    nextButton.classList.add("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep2");
    nextButton.classList.remove("sbmtbtnstep4");
    //add checklist to left pagnation number
    lftpag2.classList.add("done");
    lftpag3.classList.remove("done");
    $("#med-next").click(function () {
      console.log("Step 3 Update Successfully!");
      substep3();
    });
  }
  if (currentStep === 4) {
    prevPreviousbtn.removeAttribute("disabled", "");
    nextButton.style.display = "block";
    sbmtButton.style.display = "none";
    pagspan.style.display = "block";
    prevPreviousbtn.style.display = "block";
    //add class and remove class
    nextButton.classList.add("sbmtbtnstep4");
    nextButton.classList.remove("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep2");
    //add checklist to left pagnation number
    lftpag3.classList.add("done");
    lftpag4.classList.remove("done");
    $("#med-next").click(function () {
      console.log("Step 4 Update Successfully!");
      substep4();
    });
  }
}

function validateForm() {
    var recordid = $("#recordid").val();
    if (!recordid.trim()) {
        // If recordid is not filled, show a sweet alert
        Swal.fire({
            title: "Error!",
            text: "Please fill out the recordid field before submitting.",
            icon: "error",
            confirmButtonText: "OK",
        });
        return;
    }

    // If recordid is filled, proceed with form submission
    Swal.fire({
        title: "Success!",
        text: "Form submitted successfully.",
        icon: "success",
        confirmButtonText: "OK",
    }).then(() => {
        //Redirect to a PDF download
        var newTab = window.open("https://providerondemandapp.com/mPanel/PatientDetails/getpdf.php?id=" + recordid, '_blank');
        newTab.focus();
        //Redirect to standby
        window.location.href = "https://providerondemandapp.com/mPanel/standby";
    });
}
// Alert if the user tries to refresh the page
window.onbeforeunload = function () {
  return true;
};
