<?php
include 'header.php';
session_start();

// Check if the user is not authenticated, redirect to login page
if (!isset($_SESSION["authenticated"]) || $_SESSION["authenticated"] !== true) {
    header("Location: wawai-auth.php");
    exit();
}
?><!DOCTYPE html>
<div class="uk-section">
  <div class="uk-container">
    <div class="uk-grid-large" data-uk-grid>
      <div class="sidebar-fixed-width uk-visible@m">
        <div class="sidebar-docs uk-position-fixed uk-margin-top">
          <h5>Getting Started</h5>
          <ul class="uk-nav uk-nav-default doc-nav">
            <li class="menu-item uk-active"><a href="#install">Installation</a></li>
            <li class="menu-item"><a href="#technology">Web Development Technologies</a></li>
          </ul>
          <h5>User Guide</h5>
          <ul class="uk-nav uk-nav-default doc-nav">
            <li class="menu-item"><a href="#rolegeneral">General</a></li>
            <li class="menu-item"><a href="#roleadmin">Admin Role</a></li>
            <li class="menu-item"><a href="#roledoctor">Doctor Role</a></li>
            <li class="menu-item"><a href="#rolenurse">Nurse Role</a></li>
          </ul>
          <h5>Customization</h5>
          <ul class="uk-nav uk-nav-default doc-nav">
            <li class="menu-item"><a href="doc">Translation</a></li>
            <li class="menu-item"><a href="doc">Customization</a></li>
            <li class="menu-item"><a href="doc">Development</a></li>
            <li class="menu-item"><a href="doc">Sources and credits</a></li>
          </ul>
          <h5>Help</h5>
          <ul class="uk-nav uk-nav-default doc-nav">
            <li class="menu-item"><a href="doc">Contacting support</a></li>
          </ul>
        </div>
      </div>
      <div class="uk-width-1-1 uk-width-expand@m">
        <?php
        include('docs/1-installation.php');
        include('docs/2-technology.php');
        include('docs/3-rolegeneral.php');
        include('docs/3-roleadmin.php');
        include('docs/3-roledoctor.php');
        include('docs/3-rolenurse.php');
        ?>
      </div>
    </div>
  </div>
</div>

<div id="offcanvas-docs" data-uk-offcanvas="overlay: true">
  <div class="uk-offcanvas-bar">
    <button class="uk-offcanvas-close" type="button" data-uk-close></button>
    <h5 class="uk-margin-top">Getting Started</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li class="uk-active"><a href="doc">Template setup</a></li>
      <li><a href="doc">Basic theme setup</a></li>
      <li><a href="doc">Navigation bar</a></li>
      <li><a href="doc">Footer options</a></li>
      <li><a href="doc">Creating your first post</a></li>
      <li><a href="doc">Creating docs posts</a></li>
      <li><a href="doc">Enabling comments</a></li>
      <li><a href="doc">Google Analytics</a></li>
    </ul>
    <h5 class="uk-margin-top">Product Features</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li><a href="doc">Hero page header</a></li>
      <li><a href="doc">Category boxes section</a></li>
      <li><a href="doc">Fearured docs section</a></li>
      <li><a href="doc">Video lightbox boxes section</a></li>
      <li><a href="doc">Frequently asked questions section</a></li>
      <li><a href="doc">Team members section</a></li>
      <li><a href="doc">Call to action section</a></li>
      <li><a href="doc">Creating a changelog</a></li>
      <li><a href="doc">Contact form</a></li>
      <li><a href="doc">Adding media to post and doc content</a></li>
      <li><a href="doc">Adding table of contents to docs</a></li>
      <li><a href="doc">Adding alerts to content</a></li>
    </ul>
    <h5 class="uk-margin-top">Customization</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li><a href="doc">Translation</a></li>
      <li><a href="doc">Customization</a></li>
      <li><a href="doc">Development</a></li>
      <li><a href="doc">Sources and credits</a></li>
    </ul>
    <h5 class="uk-margin-top">Help</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li><a href="doc">Contacting support</a></li>
    </ul>
  </div>
</div>
<?php
include 'footer.php';
?>
