<article class="uk-article active" id="install">
          <h1 class="uk-article-title">App setup</h1>
          <p class="uk-text-lead uk-text-muted">Here's a step-by-step guide to installing web applications using the POD_mPanel.zip file on a cPanel server </p>
          <div class="uk-article-meta uk-margin-top uk-margin-medium-bottom uk-flex uk-flex-middle">
            <img class="uk-border-circle avatar" src="https://providerondemandapp.com/!documentation/img/Profile_Rounded-small.png" alt="Wahyu Reza Nuari Prasetyo">
            <div>
              Written by
              <span>Wahyu Reza NP, DFE., CEH., CTIA.</span><br>
              <time datetime="2024-04-18">Thursday, April 18, 2024</time>
            </div>
          </div>
          <div class="article-content link-primary">
              
            <h2 id="tools">Prerequisites:</h2>
            <ol>
              <li>Access to a cPanel hosting account.</li>
              <li>Ensure your server meets the requirements listed (PHP version, Apache, cPanel, etc.).</li>
            </ol>
            
            <h2 id="step1">Step 1: Upload POD_mPanel.zip</h2>
            <ol>
              <li>Log in to your cPanel account.</li>
              <li>Navigate to the "File Manager" under the "Files" section.</li>
              <li>Upload the POD_mPanel.zip file to the public_html directory or any other directory where you want to install the web application.</li>
            </ol>
            
            <h2 id="step2">Step 2: Extract the ZIP File</h2>
            <ol>
              <li>Select the POD_mPanel.zip file in the File Manager.</li>
              <li>Click on the "Extract" button in the toolbar.</li>
              <li>Choose the directory where you want to extract the files (e.g., public_html/mPanel).</li>
              <li>Click "Extract File(s)".</li>
            </ol>
            
            <h2 id="step3">Step 3: Create Database User</h2>
            <ol>
              <li>In cPanel, navigate to the "MySQL Databases" or "Databases" section.</li>
              <li>Scroll down to the "MySQL Users" section.</li>
              <li>Enter a username and strong password for the new database user.</li>
              <li>Click "Create User".</li>
            </ol>
            
            <h2 id="step4">Step 4: Add New Database</h2>
            <ol>
              <li>In the same "MySQL Databases" or "Databases" section, find the "Create New Database" section.</li>
              <li>Enter a name for the new database (e.g., maindb).</li>
              <li>Click "Create Database".</li>
            </ol> 
            
            <h2 id="step5">Step 5: Set Privilege Access</h2>
            <ol>
              <li>After creating the database and user, scroll down to the "Add User to Database" section.</li>
              <li>Select the newly created user from the dropdown menu.</li>
              <li>Choose the newly created database from the dropdown menu.</li>
              <li>Click "Add".</li>
            </ol> 
            
            <h2 id="step6">Step 6: Upload maindb.sql into phpMyAdmin</h2>
            <ol>
              <li>Navigate back to cPanel's dashboard and locate "phpMyAdmin" under the "Databases" section.</li>
              <li>Click on phpMyAdmin to open the database management interface.</li>
              <li>Select the database you created (maindb) from the left-hand sidebar.</li>
              <li>Click on the "Import" tab from the top menu.</li>
              <li>Click on "Choose File" and select the maindb.sql file from your local computer.</li>
              <li>Optionally, you can set encoding or format options if necessary.</li>
              <li>Click "Go" to import the SQL file into the database.</li>
            </ol> 
            
            <h2 id="step7">Step 7: Configure PHP Settings</h2>
            <ol>
              <li>Go back to the cPanel dashboard.</li>
              <li>Under the "Software" section, locate and click on "MultiPHP Manager".</li>
              <li>Select the domain or directory where you extracted the files.</li>
              <li>Choose PHP version 7.4 (ea-php74) from the dropdown.</li>
              <li>Click "Apply".</li>
            </ol>
            
            <h2 id="step8">Step 8: Adjust PHP Settings</h2>
            <ol>
              <li>While still in cPanel, navigate to "PHP Options" or "PHP Settings" (depends on your cPanel version).</li>
              <li>Set the following values:</li>
              <ul>
                  <li>max_execution_time: 5000</li>
                  <li>max_input_vars: 128000</li>
                  <li>memory_limit: 3500M</li>
                  <li>post_max_size: 200M</li>
                  <li>upload_max_filesize: 200M</li>
                  <li>zlib.output_compression: Enabled</li>
              </ul>
              <li>Click "Apply".</li>
            </ol>
            
            <h2 id="step9">Step 5: Enable Let's Encrypt SSL</h2>
            <ol>
              <li>In cPanel, find and click on "Let's Encrypt SSL" under the "Security" section.</li>
              <li>Select the domain where you installed the application.</li>
              <li>Click "Issue" or "Install" to enable SSL.</li>
            </ol>
            
            <h2 id="step10">Step 6: Verify Installation</h2>
            <ol>
              <li>Open a web browser and navigate to your domain (e.g., https://yourdomain.com/mPanel).</li>
              <li>If everything is set up correctly, you should see the installation wizard or the login page of your web application.</li>
            </ol>
            
            <h2 id="notes">Additional Notes:</h2>
            <ul>
              <li>Make sure the SQL file (maindb.sql) contains the necessary database structure and initial data required by your web application.</li>
              <li>After importing the SQL file, verify the database structure and data in phpMyAdmin to ensure successful importation.</li>
              <li>Ensure correct file permissions after extraction, especially if you encounter any permission-related errors.</li>
              <li>Make sure to follow security best practices, such as regularly updating your software and using strong passwords.</li>
            </ul>
            <p>By following these steps, you should be able to successfully install the web application using the POD_mPanel.zip file on your cPanel server.</p>

            
          <hr class="uk-margin-medium">
          
</article>