<article class="uk-article" id="rolegeneral">
          <h1 class="uk-article-title">User Guide for General Users</h1>
          <p class="uk-text-lead uk-text-muted">The following is a guide to using the Medical Panel application for all users</p>
          <div class="uk-article-meta uk-margin-top uk-margin-medium-bottom uk-flex uk-flex-middle">
            <img class="uk-border-circle avatar" src="https://providerondemandapp.com/!documentation/img/Profile_Rounded-small.png" alt="Wahyu Reza Nuari Prasetyo">
            <div>
              Written by
              <span>Wahyu Reza NP, DFE., CEH., CTIA.</span><br>
              <time datetime="2024-04-18">Thursday, April 18, 2024</time>
            </div>
          </div>
          <div class="article-content link-primary">
              
            <h2 id="tools">Login URL</h2>
            <div class="language-bash highlighter-rouge">
              <div class="highlight">
                <pre class="highlight"><code>https://providerondemandapp.com/mPanel/</code></pre>
              </div>
            </div>
            
            <h2 id="step1">Start Medical Record</h2>
            <div class="language-bash highlighter-rouge">
              <div class="highlight">
                <pre class="highlight"><code>https://providerondemandapp.com/mPanel/standby</code></pre>
              </div>
            </div>
            <p>On this page, you should make sure your camera, mic, and speakers are working and linked to your browser. If you are sure everything is correct, click on the big logo in the center of the screen to start the session.</p>
                <h3 id="step1appstart">Log In</h2>
                <p>You cannot change the location and Patient Care specialist data that appears there, the data is automatically retrieved based on your account information.<br>Please checklist "The above information is correct" to bring up the "Begin Patient Ecounter" button, then click on it. </p>
                
                <h3 id="step1patientinformation">Patient Information</h2>
                <p>In this section, all sections must be filled in. If the patient's name is only 1 word, please fill in the First Name section only. The phone number should be filled in with a "+" sign and without spaces, for example: +17373582384</p>
                
                <h3 id="step1chiefcomplaint">Chief Complaint</h2>
                <p>This section contains medical information that the patient complains about or that the nurse finds, fill in as clearly as possible.</p>
                
                <h3 id="step1chiefcomplaint">Vital Signs</h2>
                <p>Enter the information according to its section. In the Height, Weight, Temperature and Blood Pressure sections, you only need to input the numbers.</p>
                
                <h3 id="step1chiefcomplaint">Exam & Testing</h2>
                <p>In this section, there will be 1 button with an icon like streaming. Click that button to bring up a series of tests. There will be many icons and menus there, when clicked the button will change color. But this has no effect at all on the patient's test results.</p>
                <p>In the Exam Picture section, you must use the appropriate device and this uses a camera. If you want another test, make sure you have changed the camera source under the "Exam & Testing" heading.<br>
                    In the Exam Audio section, you must use the appropriate recording device and this will record the sound from the device. If you want another test, make sure you have changed the camera source under the "Exam & Testing" heading.<br>
                    In the Rapid Test Results section, you must use a camera to capture the test results that have come out.</p>
                <p>Before clicking the Submit button, you should first check that the data you input in all steps is correct. If an error occurs, please return to the "Patient Information" step to check the data in that section and click the "Next" button.</p>
                
            <h2 id="step2">Provider On Call</h2>
            
            <h2 id="notes">Additional Notes:</h2>
            <ul>
              <li>Make sure the SQL file (maindb.sql) contains the necessary database structure and initial data required by your web application.</li>
              <li>After importing the SQL file, verify the database structure and data in phpMyAdmin to ensure successful importation.</li>
              <li>Ensure correct file permissions after extraction, especially if you encounter any permission-related errors.</li>
              <li>Make sure to follow security best practices, such as regularly updating your software and using strong passwords.</li>
            </ul>
            <p>By following these steps, you should be able to successfully install the web application using the POD_mPanel.zip file on your cPanel server.</p>

            
          <hr class="uk-margin-medium">
          
</article>