<?php
include 'header.php';
session_start();

// Check if the user is not authenticated, redirect to login page
if (!isset($_SESSION["authenticated"]) || $_SESSION["authenticated"] !== true) {
    header("Location: wawai-auth.php");
    exit();
}
?>

<div class="uk-section">
	<div class="uk-container uk-container-xsmall">
		<article class="uk-article">
			<h1 class="uk-article-title">Getting started with our application</h1>
			<div class="uk-article-meta uk-margin-top uk-margin-medium-bottom uk-flex uk-flex-middle">
				<img class="uk-border-circle avatar" src="https://via.placeholder.com/80" alt="Tom Farrell">
				<div>
					Written by Tom Farrell<br>
					<time datetime="2017-05-25T00:00:00+00:00">May 25, 2017</time>
				</div>
			</div>
			<div class="article-content link-primary">
				<p>Musce libero nunc, dignissim quis turpis quis, semper vehicula dolor. Suspendisse tincidunt consequat quam,
					ac posuere leo dapibus id. Cras fringilla convallis elit, at eleifend mi interam.</p>
				<p>Nulla non sollicitudin. Morbi sit amet laoreet ipsum, vel pretium mi. Morbi varius, tellus in accumsan
					blandit, elit ligula eleifend velit, luctus mattis ante nulla condimentum nulla. Etiam vestibulum risus vel
					arcu elementum eleifend. Cras at dolor eget urna varius faucibus tempus in elit.</p>
				<h2 id="image-lightbox-example">Image Lightbox Example</h2>
				<p>Nunc porta malesuada porta. Etiam tristique vestibulum dolor at ultricies. Proin hendrerit sapien sed erat
					fermentum, at commodo velit consectetur.</p>
				<figure data-uk-lightbox="animation: slide">
					<a class="uk-inline" href="https://via.placeholder.com/1000x500.png" data-caption="Image in lightbox">
						<img src="https://via.placeholder.com/1000x500" alt="Alt for image">
						<div class="uk-position-center">
							<span data-uk-overlay-icon></span>
						</div>
					</a>
					<figcaption data-uk-grid class="uk-flex-right uk-grid uk-grid-stack"><span
							class="uk-width-auto uk-first-column">Image in lightbox</span></figcaption>
				</figure>
				<p>Etiam vestibulum risus vel arcu elementum eleifend. Cras at dolor eget urna varius faucibus tempus in elit.
					Cras a dui imperdiet, tempus metus quis, pharetra turpis. Phasellus at massa sit amet ante semper fermentum
					sed eget lectus. Quisque id dictum magna, et dapibus turpis.</p>
				<h2 id="example-of-code-block">Example Of Code Block</h2>
				<p>In accumsan lacus ac neque maximus dictum. Phasellus eleifend leo id mattis bibendum. Curabitur et purus
					turpis. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae;</p>
				<div class="language-html highlighter-rouge">
					<div class="highlight">
<pre class="highlight"><code><span class="nt">&lt;head&gt;</span>
	<span class="nt">&lt;meta</span> <span class="na">charset=</span><span class="s">"utf-8"</span><span class="nt">&gt;</span>
	<span class="nt">&lt;meta</span> <span class="na">http-equiv=</span><span class="s">"X-UA-Compatible"</span> <span class="na">content=</span><span class="s">"IE=edge"</span><span class="nt">&gt;</span>
	<span class="nt">&lt;meta</span> <span class="na">name=</span><span class="s">"viewport"</span> <span class="na">content=</span><span class="s">"width=device-width, initial-scale=1"</span><span class="nt">&gt;</span>
	<span class="nt">&lt;link</span> <span class="na">rel=</span><span class="s">"stylesheet"</span> <span class="na">href=</span><span class="s">"/assets/css/main.css"</span><span class="nt">&gt;</span>
	<span class="nt">&lt;link</span> <span class="na">rel=</span><span class="s">"shortcut icon"</span> <span class="na">type=</span><span class="s">"image/png"</span> <span class="na">href=</span><span class="s">"/assets/img/favicon.png"</span> <span class="nt">&gt;</span>
	<span class="nt">&lt;script </span><span class="na">src=</span><span class="s">"/assets/js/main.js"</span><span class="nt">&gt;&lt;/script&gt;</span>
<span class="nt">&lt;/head&gt;</span>
</code></pre>
					</div>
				</div>
				<h2 id="text-and-quote">Text and Quote</h2>
				<p>Cras at dolor eget urna varius faucibus tempus in elit. Cras a dui imperdiet, tempus metus quis, pharetra
					turpis. Phasellus at massa sit amet ante semper fermentum sed eget lectus. Quisque id dictum magna turpis.</p>
				<blockquote>
					<p>Etiam vestibulum risus vel arcu elementum eleifend. Cras at dolor eget urna varius faucibus tempus in elit.
						Cras a dui imperdiet</p>
				</blockquote>
				<p>In accumsan lacus ac neque maximus dictum. Phasellus eleifend leo id mattis bibendum. Curabitur et purus
					turpis. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae;</p>
				<p>Etiam in fermentum mi. Sed et tempor felis, eu aliquet nisi. Nam eget ullamcorper arcu. Nunc porttitor nisl a
					dolor blandit, eget consequat sem maximus. Phasellus lacinia quam porta orci malesuada, vel tincidunt.</p>
				<div class="share uk-text-center uk-margin-medium-top">
					<a class="uk-link-muted" href="#" rel="nofollow" 
						target="_blank" title="Share on Twitter"><span data-uk-icon="icon: twitter; ratio: 1.2"></span></a>
					<a class="uk-link-muted uk-margin-small-left" href="#" rel="nofollow"
						target="_blank" title="Share on Facebook"><span data-uk-icon="icon: facebook; ratio: 1.2"></span></a>
				</div>
			</div>
			<hr class="uk-margin-medium">
			<div class="uk-margin-large-top paginate-post">
				<div class="uk-child-width-expand@s uk-grid-large" data-uk-grid>
					<div class="uk-first-column">
						<h4>How to setup naked domain SSL with Github pages</h4>
						<div class="uk-visible@s uk-text-muted uk-text-small">
							<p>Libero nunc, gignissim quis turpis quis, semper vehicula dolor. Suspendisse ti...</p>
						</div>
						<div><a class="remove-underline hvr-back" href="#">← Previous</a></div>
					</div>
					<div>
						<h4>Setting up new domain and DNS records</h4>
						<div class="uk-visible@s uk-text-muted uk-text-small">
							<p>Musce libero nunc, dignissim quis turpis quis, semper vehicula dolor. Suspendisse ti...</p>
						</div>
						<div class="uk-text-right"><a class="remove-underline hvr-forward" href="#">Next →</a></div>
					</div>
				</div>
			</div>
			<div class="uk-margin-large-top">
				<h3>Related Posts</h3>
				<ul class="uk-list link-secondary">
					<li><a href="#">Selecting the right fonts and colors</a></li>
					<li><a href="#">Design tips for choosing great images</a></li>
					<li><a href="#">Purchasing domain name and DNS setup</a></li>
					<li><a href="#">Using Private Browsing or Incognito mode</a></li>
				</ul>
			</div>
		</article>
	</div>
</div>

<div id="offcanvas-docs" data-uk-offcanvas="overlay: true">
  <div class="uk-offcanvas-bar">
    <button class="uk-offcanvas-close" type="button" data-uk-close></button>
    <h5 class="uk-margin-top">Getting Started</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li class="uk-active"><a href="doc.html">Template setup</a></li>
      <li><a href="doc.html">Basic theme setup</a></li>
      <li><a href="doc.html">Navigation bar</a></li>
      <li><a href="doc.html">Footer options</a></li>
      <li><a href="doc.html">Creating your first post</a></li>
      <li><a href="doc.html">Creating docs posts</a></li>
      <li><a href="doc.html">Enabling comments</a></li>
      <li><a href="doc.html">Google Analytics</a></li>
    </ul>
    <h5 class="uk-margin-top">Product Features</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li><a href="doc.html">Hero page header</a></li>
      <li><a href="doc.html">Category boxes section</a></li>
      <li><a href="doc.html">Fearured docs section</a></li>
      <li><a href="doc.html">Video lightbox boxes section</a></li>
      <li><a href="doc.html">Frequently asked questions section</a></li>
      <li><a href="doc.html">Team members section</a></li>
      <li><a href="doc.html">Call to action section</a></li>
      <li><a href="doc.html">Creating a changelog</a></li>
      <li><a href="doc.html">Contact form</a></li>
      <li><a href="doc.html">Adding media to post and doc content</a></li>
      <li><a href="doc.html">Adding table of contents to docs</a></li>
      <li><a href="doc.html">Adding alerts to content</a></li>
    </ul>
    <h5 class="uk-margin-top">Customization</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li><a href="doc.html">Translation</a></li>
      <li><a href="doc.html">Customization</a></li>
      <li><a href="doc.html">Development</a></li>
      <li><a href="doc.html">Sources and credits</a></li>
    </ul>
    <h5 class="uk-margin-top">Help</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li><a href="doc.html">Contacting support</a></li>
    </ul>
  </div>
</div>

<?php
include 'footer.php';
?>