let mediaRecorder;
let audioChunks = [];

function startRecording() {
  const selectedDeviceId = document.getElementById("audio-source").value;
  navigator.mediaDevices
    .getUserMedia({
      audio: { deviceId: { exact: selectedDeviceId } },
    })
    .then(function (stream) {
      mediaRecorder = new MediaRecorder(stream);
      audioChunks = [];
      mediaRecorder.ondataavailable = function (event) {
        if (event.data.size > 0) {
          audioChunks.push(event.data);
        }
      };

      mediaRecorder.onstop = function () {
        const audioBlob = new Blob(audioChunks, { type: "audio/wav" });
        const audioUrl = URL.createObjectURL(audioBlob);
        updateAudio(audioBlob);
        displayAudioPlayer(audioUrl);
      };

      mediaRecorder.start();
    })
    .catch(function (err) {
      console.error("Error accessing microphone: " + err);
    });
}

function stopRecording() {
  if (mediaRecorder && mediaRecorder.state !== "inactive") {
    mediaRecorder.stop();
    audioChunks = [];
  }
}
//create trigger live to change source mic
function changeMicrophone(deviceId) {
  // Stop the existing media stream
  if (mediaRecorder && mediaRecorder.state !== "inactive") {
    mediaRecorder.stop();
  }

  // Start recording with the selected microphone
  startRecording();
}

//update audio
function updateAudio(audioBlob) {
  var form = new FormData();
  form.append("recordid", document.getElementById("recordid").value);
  form.append("patientid", document.getElementById("patientid").value);
  form.append("branchid", document.getElementById("branchid").value);
  form.append("branchname", document.getElementById("branchname").value);
  form.append("checkdevice", document.getElementById("checkdevice").value);
  form.append("audio", audioBlob, "hearthbeat_audio.wav");

  $.ajax({
    type: "POST",
    url: "https://providerondemandapp.com/mPanel/act-audio-hb.php",
    data: form,
    contentType: false,
    processData: false,
    success: function (response) {
      // Assuming the response is the new audio file name
      Swal.fire({
        title: "Success!",
        text: "Audio has been saved.",
        icon: "success",
        confirmButtonText: "OK",
      });
      updateaudiosreza();
      var audioFileName = response;
      displayAudioPlayer(audioFileName);
    },
    error: function (error) {
      console.error("Error updating audio: " + error.responseText);
    },
  });
}

function displayAudioPlayer(audioUrl) {
  var audioPlayer = document.getElementById("audioPlayer");
  var audioPlayerContainer = document.getElementById("audioPlayerContainer");

  // Set the source of the audio player
  audioPlayer.src = audioUrl;

  // Show the audio player container
  audioPlayerContainer.style.display = "block";
}

//fungsi update untuk menampilkan data
function updateaudiosreza() {
  var recordid = $("#recordid").val();
  $.ajax({
    url: "https://providerondemandapp.com/mPanel/act-audio-data.php",
    type: "get",
    data: {
      recordid: recordid,
    },
    success: function (tmpilaudios) {
      $("#showallaudio").html(tmpilaudios);
    },
  });
}
