let currentStep = 1;

document.addEventListener("DOMContentLoaded", function () {
  showStep(currentStep);
  updatePageNumber();
});

function gotoStep(step) {
  const formStep = document.getElementById(`step-${step}`);
  if (formStep) {
    currentStep = step;
    showStep(currentStep);
    updatePageNumber();
    updatePagination();
  }
}

function showStep(step) {
  const formSteps = document.querySelectorAll(".form-step");
  formSteps.forEach((stepElement) => stepElement.classList.remove("active"));

  const currentFormStep = document.getElementById(`step-${step}`);
  if (currentFormStep) {
    currentFormStep.classList.add("active");
  }
}

function nextStep() {
  if (currentStep < 4) {
    currentStep++;
    showStep(currentStep);
    updatePageNumber();
    updatePagination();
  }
}

function prevStep() {
  if (currentStep > 1) {
    currentStep--;
    showStep(currentStep);
    updatePageNumber();
    updatePagination();
  }
}

function updatePageNumber() {
  const pageNumber = document.getElementById("page-number");
  pageNumber.innerText = `Step ${currentStep} of 4`;
}

function updatePagination() {
  const pageItems = document.querySelectorAll(".pagination .page-item");
  pageItems.forEach((pageItem) => pageItem.classList.remove("active"));

  const currentPaginationItem = document.getElementById(`page-${currentStep}`);
  if (currentPaginationItem) {
    currentPaginationItem.classList.add("active");
  }

  // Remove the "Next" button at Step 4
  const nextButton = document.getElementById("med-next");
  const paginationframe = document.getElementById("page-lists");
  if (currentStep === 4) {
    nextButton.style.display = "none"; // or use nextButton.remove() to completely remove the button
    paginationframe.classList.add("finish");
  } else {
    nextButton.style.display = "block"; // or use nextButton.style.display = ''; to show the button
  }
}

function validateForm() {
  const form = document.getElementById("multiform");
  if (form.checkValidity()) {
    // Form is valid, show a sweet alert
    Swal.fire({
      title: "Success!",
      text: "Form submitted successfully.",
      icon: "success",
      confirmButtonText: "OK",
    });
  } else {
    // Form is not valid, show a sweet alert
    Swal.fire({
      title: "Error!",
      text: "Please fill out all fields before submitting.",
      icon: "error",
      confirmButtonText: "OK",
    });
  }
}

// Alert if the user tries to refresh the page
window.onbeforeunload = function () {
  return true;
};
