<?php
require_once('bridge.php');
require_once __DIR__ . '/mpdf803/vendor/autoload.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);


use Mpdf\Mpdf;
// Get the record_id from the URL parameter
$record_id = isset($_GET['id']) ? $_GET['id'] : null;

// Validate record_id
if (!$record_id) {
    die("Record ID not provided.");
}

// Prepare the SELECT query to fetch patient record details
    $stmt = $conn->prepare("SELECT pr.*, 
pf.picts, pf.record_at AS file_record_at, pf.record_date AS file_record_date, pf.device_type AS file_device_type, 
pa.files, pa.record_by AS file_record_by, pa.record_date AS audio_record_date, pa.device_type AS audio_device_type
    FROM patients_record AS pr
    LEFT JOIN patients_files AS pf ON pr.record_id = pf.record_id
    LEFT JOIN patients_audio AS pa ON pr.record_id = pa.record_id
    WHERE pr.record_id = ?
    ");
    
    $stmt->bind_param('i', $record_id);
    $stmt->execute();

// Get the result set
$result = $stmt->get_result();

// Fetch data as an associative array
$patientRecordData = $result->fetch_assoc();

// Close the statement
$stmt->close();

// Now, retrieve all image URLs associated with the record_id
$stmt2 = $conn->prepare("
    SELECT picts, record_date, device_type, record_at
    FROM patients_files
    WHERE record_id = ?
");
$stmt2->bind_param('i', $record_id);
$stmt2->execute();

// Get the result set
$result2 = $stmt2->get_result();

// Fetch all image URLs as an associative array
$imageUrls2 = [];
$imageRecordDates = [];
$imageDeviceTypes = [];
$imageRecordAts = [];
while ($row = $result2->fetch_assoc()) {
    $imageUrls2[] = $row['picts'];
    $imageRecordDates[] = $row['record_date'];
    $imageDeviceTypes[] = $row['device_type'];
    $imageRecordAts[] = $row['record_at'];
}

// Close the statement
$stmt2->close();

// Define the file name using patient's last name and first name
$filename = $patientRecordData['patient_lname'] . '_' . $patientRecordData['patient_fname'] . '_record_' . $patientRecordData['record_id'] . '.pdf';

// Define all data with record ID in 3 tables
// Generate HTML content for images
$imageHtml = '';
if ($patientRecordData['picts']) {
    $imageUrls = explode(',', $patientRecordData['picts']);
    $recordDates = explode(',', $patientRecordData['file_record_date']);
    $deviceTypes = explode(',', $patientRecordData['file_device_type']);
    $PCS = explode(',', $patientRecordData['file_record_at']);
    
    foreach ($imageUrls as $key => $imageUrl) {
        $imageHtml .= '<div>';
        $imageHtml .= '<img src="https://providerondemandapp.com/mPanel/' . $imageUrl . '" style="width: 40%;">';
        $imageHtml .= '<p>Device Type: ' . $deviceTypes[$key] . '</p>';
        $imageHtml .= '<span>Record Date: ' . $deviceTypes[$key] . '</span>';
        $imageHtml .= '<br>';
        $imageHtml .= '<span>PCS: ' . $PCS[$key] . '</span>';
        $imageHtml .= '</div>';
    }
}

// Generate PDF content
$htmlContent = '
<html>
    <head>
        <style>
            .pagenumber {
                position: absolute;
                bottom: 10px;
                left: 50%;
                transform: translateX(-50%);
                font-size: 12px;
            }
              .page-break {
            page-break-before: always;
        }
            h1{
                font-weight: bold;
                font-family: Arial, Helvetica, sans-serif !important;
                font-size: 2em;
                color: #222222;
            }
            h2{
                font-weight: bold;
                font-family: Arial, Helvetica, sans-serif !important;
                font-size: 1.167em;
                padding-bottom: 10px;
                padding-top: 10px;
                color:#444444;
            }
            h3{
                font-weight: bold;
                font-size: 16px;
                font-family: Arial, Helvetica, sans-serif !important;
    
            }
            .header {
                width: 100%;
                text-align: center;
                margin-bottom: 20px;
                display: flex !important;
                align-content: center;
                align-items: center;
                border-bottom: double 4px #32ABE2;
                padding-bottom: 7px;
                margin: 0px 5px 0px 5px;
                justify-content: space-between;
                flex-wrap: nowrap;
                flex-direction: row;
            }
            .left-header{
                width:29%;
                float:left;
               
            }
            .right-header{
                max-width:69%;
                float:right !important;
                text-align: -webkit-right !important;
                margin-left:25mm;
            }
            .table-header{
                float:right;
                
            }
            .header img {
                width:100%;
            }
            .isi {
                margin-bottom: 20px;
                margin: 0px 5px 0px 5px;
            }
            .isi .judul-isi{
                text-align: center;
            }
            .isi p {
                margin: 5px 0;
            }
            /*Table 1*/
            .table-p1{
                width: 100%;
            }
            .table-p1, .table-p1 th, .table-p1 td{
                border: 1px solid #000000;
                border-collapse: collapse;
            }
            .table-sub{
                text-align: left;
                background: #32ABE2;
                font-weight: 600;
                font-size: 20px;
                line-height: 27px;
            }
            .data .data-title{
                font-size: 12px;
                color:#373737;
            }
            .gallery p{
                font-weight: 600;
            }
            .audio{
                display: flex;
                flex-wrap: wrap;
                justify-content: space-between;
            }
            .audiosrc{
                display: flex;
            }
            .audio .audiosrc img{
                width: 25px;
                margin-right: 10px;
            }
            .imggal{
                vertical-align: top;
            }
        </style>
    </head>
    <body style="font-family: Arial, Helvetica, sans-serif;
                font-size: 16px;
                -webkit-user-select: auto;
            -moz-user-select: auto;
            -ms-user-select: auto;
            user-select: auto; max-width: 216mm;
            width: 100% !important;
            margin: 15mm !important;">
        <div class="header">
            <div class="left-header">
                <img src="https://providerondemand.com/do-not-remove/logo-POD-dark.svg">
            </div>
            <div class="right-header">
                <table class="table-header">
                    <tbody>
                        <tr>
                            <td>Record Date</td>
                            <td>:</td>
                            <td>' . $patientRecordData['record_date'] . '</td>
                        </tr>
                        <tr>
                            <td>POD Location</td>
                            <td>:</td>
                            <td>' . $patientRecordData['record_at'] . '</td>
                        </tr>
                        <tr>
                            <td>Patient Care Specialist</td>
                            <td>:</td>
                            <td>' . $patientRecordData['record_by'] . '</td>
                        </tr>
                    </tbody>
                </table>
                
            </div>
        </div>
        <div class="isi">
            <div class="judul-isi">
                <h1>Patient Record Details</h1>
            </div>
            <div class="card-isi">
                <p>The patient data below is taken directly from our database. The nurse uses Provider on Demand mPanel Medical program during the examination session to communicate directly with the Doctor. This PDF file is not stored on the server, but can only be downloaded. The database source we use to display the data below will also be automatically deleted on our server in less than 2 days, from the time this data is retrieved.</p>
            <br>
                <table class="table-p1">
                    <tbody>
                        <tr>
                            <td colspan="4" class="table-sub">Patient Information</td>
                        </tr>
                        <tr class="data">
                            <td><p class="data-title">First Name</p>
                                <p class="data-isi">' . $patientRecordData['patient_fname'] . '</p>
                            </td>
                            <td><p class="data-title">Last Name</p>
                                <p class="data-isi">' . $patientRecordData['patient_lname'] . '</p>
                            </td>
                            <td><p class="data-title">Date of Birth</p>
                                <p class="data-isi">' . $patientRecordData['patient_dob'] . '</p>
                            </td>
                            <td><p class="data-title">Sex/Gender</p>
                                <p class="data-isi">' . $patientRecordData['patient_sex'] . '</p>
                            </td>
                        </tr>
                        <tr class="data">
                            <td colspan="4" class="data-isi"><p class="data-title">Address</p>
                                <p class="data-isi">' . $patientRecordData['patient_address'] . '</p>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4" class="table-sub">Medical Records Summary Information</td>
                        </tr>
                        <tr>
                            <td colspan="4"  style="height: 40px;">Summary of Patient Medical Records at <span style="border-bottom: solid 1px;">' . $patientRecordData['record_date'] . '</span></td>
                        </tr>
                        <tr class="data">
                            <td colspan="3"><p class="data-title">Patient Care Specialist</p>
                                            <p class="data-isi">' . $patientRecordData['record_by'] . '</p>
                            </td>
                            <td><p class="data-title">Location</p>
                                <p class="data-isi">' . $patientRecordData['record_at'] . '</p>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4" class="table-sub">Patient Vital Records</td>
                        </tr>
                        <tr class="data">
                            <td><p class="data-title">Height (in)</p></td>
                            <td colspan="3"><p class="data-isi">' . $patientRecordData['vhg'] . '</p></td>
                        </tr>
                        <tr class="data">
                            <td><p class="data-title">Weight (lbs)</p></td>
                            <td colspan="3"><p class="data-isi">' . $patientRecordData['vweight'] . '</p></td>
                        </tr>
                        <tr class="data">
                            <td><p class="data-title">Temperature (F)</p></td>
                            <td colspan="3"><p class="data-isi">' . $patientRecordData['vtemp'] . '</p></td>
                        </tr>
                        <tr class="data">
                            <td><p class="data-title">Blood Pressure (BP)</p></td>
                            <td colspan="3"><p class="data-isi">' . $patientRecordData['vbp'] . '</p></td>
                        </tr>
                        <tr class="data">
                            <td><p class="data-title">Heart Rate</p></td>
                            <td colspan="3"><p class="data-isi">' . $patientRecordData['vhr'] . '</p></td>
                        </tr>
                        <tr class="data">
                            <td><p class="data-title">Respiratory Rate</p></td>
                            <td colspan="3"><p class="data-isi">' . $patientRecordData['vresp'] . '</p></td>
                        </tr>
                        <tr class="data">
                            <td><p class="data-title">Oxygen Saturation</p></td>
                            <td colspan="3"><p class="data-isi">' . $patientRecordData['vsot'] . '</p></td>
                        </tr>
                        <tr>
                            <td colspan="4" class="table-sub">Chief Complaint Information</td>
                        </tr>
                        <tr>
                            <td colspan="4"  style="height: 40px;">' . $patientRecordData['record_notes'] . '</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="page-break"></div>
        <div class="isi">
            <div class="judul-isi">
                <h1>Exam Image Results</h1>
            </div>
            <div class="card-isi">
                <div class="gallery">
                    ';
                        // Add each image URL to the HTML content
                            foreach ($imageUrls2 as $key => $imageUrl2) {
                                $htmlContent .= '<p class="galisi" style="width:10% !important;">';
                        $htmlContent .= '<img class="imggal" src="https://providerondemandapp.com/mPanel/' . $imageUrl2 . '">';
                        $htmlContent .= '<p>Device Type: ' . $imageDeviceTypes[$key] . '</p>';
                        $htmlContent .= '<span>Record Date: ' . $imageRecordDates[$key] . '</span>';
                        $htmlContent .= '</br>';
                        $htmlContent .= '<span>PCS: ' . $imageRecordAts[$key] . '</span>';
                        $htmlContent .= '</p>';
                            }
                        
                        
                        $htmlContent .= '
                    
                </div>
            </div>
        </div>
        
</body>
</html>';

// Create MPDF object
$mpdf = new Mpdf();

// Write HTML content to PDF
$mpdf->WriteHTML($htmlContent);

// Output PDF
$mpdf->Output($filename, 'D'); // 'D' for download
?>