

CREATE TABLE `location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `location_name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO location VALUES("1","POD1","Palmas Del Mar");
INSERT INTO location VALUES("2","POD2","Waco");
INSERT INTO location VALUES("3","POD3","Atascocita");
INSERT INTO location VALUES("4","POD3","Humble");
INSERT INTO location VALUES("5","POD4","Castle Hills");



CREATE TABLE `patients` (
  `patient_id` int(50) NOT NULL AUTO_INCREMENT,
  `full_name` varchar(255) NOT NULL,
  `dob` date NOT NULL,
  `sex` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `register_at` varchar(255) NOT NULL,
  `add_by` varchar(255) NOT NULL,
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




CREATE TABLE `patients_audio` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `record_id` varchar(255) NOT NULL,
  `patient_id` varchar(255) NOT NULL,
  `files` varchar(355) NOT NULL,
  `device_type` varchar(255) NOT NULL,
  `record_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `record_at` varchar(100) NOT NULL,
  `record_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=217 DEFAULT CHARSET=utf8mb4;

INSERT INTO patients_audio VALUES("126","2024040512387","202404052307","patients/p_audio/HeartBeat_1712328712.wav","HeartBeat","2024-04-05 14:51:52","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("127","2024040512387","202404052307","patients/p_audio/HeartBeat_1712328755.wav","HeartBeat","2024-04-05 14:52:35","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("128","2024040512387","202404052307","patients/p_audio/HeartBeat_1712328817.wav","HeartBeat","2024-04-05 14:53:37","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("129","2024040596301","2024040534838","patients/p_audio/HeartBeat_1712330515.wav","HeartBeat","2024-04-05 15:21:55","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("130","2024040851674","2024040819495","patients/p_audio/HeartBeat_1712627105.wav","HeartBeat","2024-04-09 01:45:05","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("131","2024041186656","2024041127356","patients/p_audio/HeartBeat_1712858113.wav","HeartBeat","2024-04-11 17:55:13","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("132","2024041291187","202404128338","patients/p_audio/HeartBeat_1712933619.wav","HeartBeat","2024-04-12 14:53:39","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("133","2024041258217","2024041247969","patients/p_audio/HeartBeat_1712934067.wav","HeartBeat","2024-04-12 15:01:07","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("134","2024041249416","2024041216294","patients/p_audio/HeartBeat_1712941961.wav","HeartBeat","2024-04-12 17:12:41","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("135","2024041262342","2024041226693","patients/p_audio/HeartBeat_1712951090.wav","HeartBeat","2024-04-12 19:44:50","Palmas Del Mar","Reza");
INSERT INTO patients_audio VALUES("136","2024041262342","2024041226693","patients/p_audio/HeartBeat_1712951106.wav","HeartBeat","2024-04-12 19:45:06","Palmas Del Mar","Reza");
INSERT INTO patients_audio VALUES("137","2024041360289","2024041328955","patients/p_audio/HeartBeat_1713002591.wav","HeartBeat","2024-04-13 10:03:11","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("138","2024041317577","2024041347452","patients/p_audio/HeartBeat_1713002644.wav","HeartBeat","2024-04-13 10:04:04","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("139","2024041361882","2024041349312","patients/p_audio/HeartBeat_1713002777.wav","HeartBeat","2024-04-13 10:06:17","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("140","2024041361882","2024041349312","patients/p_audio/HeartBeat_1713002781.wav","HeartBeat","2024-04-13 10:06:21","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("141","2024041361882","2024041349312","patients/p_audio/HeartBeat_1713002784.wav","HeartBeat","2024-04-13 10:06:24","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("142","2024041320851","202404136029","patients/p_audio/HeartBeat_1713002968.wav","HeartBeat","2024-04-13 10:09:28","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("143","2024041320851","202404136029","patients/p_audio/HeartBeat_1713002985.wav","HeartBeat","2024-04-13 10:09:45","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("144","2024041320851","202404136029","patients/p_audio/HeartBeat_1713003056.wav","HeartBeat","2024-04-13 10:10:56","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("145","2024041315461","2024041340255","patients/p_audio/HeartBeat_1713003227.wav","HeartBeat","2024-04-13 10:13:47","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("146","2024041315461","2024041340255","patients/p_audio/HeartBeat_1713003243.wav","HeartBeat","2024-04-13 10:14:03","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("147","2024041315461","2024041340255","patients/p_audio/HeartBeat_1713003247.wav","HeartBeat","2024-04-13 10:14:07","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("148","2024041371188","2024041337410","patients/p_audio/HeartBeat_1713003372.wav","HeartBeat","2024-04-13 10:16:12","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("149","2024041371188","2024041337410","patients/p_audio/HeartBeat_1713003384.wav","HeartBeat","2024-04-13 10:16:24","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("150","2024041371188","2024041337410","patients/p_audio/HeartBeat_1713003438.wav","HeartBeat","2024-04-13 10:17:18","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("151","2024041389192","2024041348563","patients/p_audio/HeartBeat_1713003581.wav","HeartBeat","2024-04-13 10:19:41","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("152","2024041389192","2024041348563","patients/p_audio/HeartBeat_1713003601.wav","HeartBeat","2024-04-13 10:20:01","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("153","2024041382307","2024041313879","patients/p_audio/HeartBeat_1713003675.wav","HeartBeat","2024-04-13 10:21:15","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("154","2024041364922","2024041344065","patients/p_audio/HeartBeat_1713003780.wav","HeartBeat","2024-04-13 10:23:00","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("155","2024041364922","2024041344065","patients/p_audio/HeartBeat_1713003784.wav","HeartBeat","2024-04-13 10:23:04","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("156","2024041384431","2024041338961","patients/p_audio/HeartBeat_1713003918.wav","HeartBeat","2024-04-13 10:25:18","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("157","2024041384431","2024041338961","patients/p_audio/HeartBeat_1713003961.wav","HeartBeat","2024-04-13 10:26:01","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("158","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004648.wav","HeartBeat","2024-04-13 10:37:28","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("159","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004651.wav","HeartBeat","2024-04-13 10:37:31","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("160","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004660.wav","HeartBeat","2024-04-13 10:37:40","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("161","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004669.wav","HeartBeat","2024-04-13 10:37:49","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("162","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004701.wav","HeartBeat","2024-04-13 10:38:21","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("163","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004722.wav","HeartBeat","2024-04-13 10:38:42","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("164","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004767.wav","HeartBeat","2024-04-13 10:39:27","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("165","2024041364672","2024041329124","patients/p_audio/HeartBeat_1713012400.wav","HeartBeat","2024-04-13 12:46:40","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("166","2024041682079","2024041649963","patients/p_audio/HeartBeat_1713286628.wav","HeartBeat","2024-04-16 16:57:08","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("167","2024041682079","2024041649963","patients/p_audio/HeartBeat_1713286638.wav","HeartBeat","2024-04-16 16:57:18","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("168","2024041648570","2024041617038","patients/p_audio/HeartBeat_1713287033.wav","HeartBeat","2024-04-16 17:03:53","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("169","2024041620351","2024041643291","patients/p_audio/HeartBeat_1713295765.wav","HeartBeat","2024-04-16 19:29:25","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("170","2024041620351","2024041643291","patients/p_audio/LungSound_1713295775.wav","LungSound","2024-04-16 19:29:35","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("171","2024041783674","2024041740873","patients/p_audio/HeartBeat_1713365875.wav","HeartBeat","2024-04-17 14:57:55","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("172","2024041783674","2024041740873","patients/p_audio/LungSound_1713365905.wav","LungSound","2024-04-17 14:58:25","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("173","2024041797408","2024041714285","patients/p_audio/HeartBeat_1713375486.wav","HeartBeat","2024-04-17 17:38:06","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("174","2024041780850","2024041713828","patients/p_audio/HeartBeat_1713393173.wav","HeartBeat","2024-04-17 22:32:53","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("175","2024041780850","2024041713828","patients/p_audio/LungSound_1713393214.wav","LungSound","2024-04-17 22:33:34","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("176","2024041780850","2024041713828","patients/p_audio/LungSound_1713393229.wav","LungSound","2024-04-17 22:33:49","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("177","2024041928284","2024041922142","patients/p_audio/HeartBeat_1713539601.wav","HeartBeat","2024-04-19 15:13:21","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("178","2024041955406","2024041917759","patients/p_audio/HeartBeat_1713548810.wav","HeartBeat","2024-04-19 17:46:50","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("179","2024041929312","2024041945218","patients/p_audio/HeartBeat_1713552034.wav","HeartBeat","2024-04-19 18:40:34","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("180","2024042155900","202404215219","patients/p_audio/HeartBeat_1713721512.wav","HeartBeat","2024-04-21 17:45:12","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("181","2024042196022","202404213005","patients/p_audio/HeartBeat_1713722397.wav","HeartBeat","2024-04-21 17:59:57","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("182","2024042196022","202404213005","patients/p_audio/LungSound_1713722413.wav","LungSound","2024-04-21 18:00:13","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("183","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724344.wav","HeartBeat","2024-04-21 18:32:24","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("184","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724419.wav","HeartBeat","2024-04-21 18:33:39","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("185","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724476.wav","HeartBeat","2024-04-21 18:34:36","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("186","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724648.wav","HeartBeat","2024-04-21 18:37:28","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("187","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724676.wav","HeartBeat","2024-04-21 18:37:56","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("188","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724707.wav","HeartBeat","2024-04-21 18:38:27","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("189","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724733.wav","HeartBeat","2024-04-21 18:38:53","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("190","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724800.wav","HeartBeat","2024-04-21 18:40:00","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("191","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724847.wav","HeartBeat","2024-04-21 18:40:47","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("192","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724914.wav","HeartBeat","2024-04-21 18:41:54","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("193","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724958.wav","HeartBeat","2024-04-21 18:42:38","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("194","2024042298153","2024042220191","patients/p_audio/HeartBeat_1713793555.wav","HeartBeat","2024-04-22 13:45:55","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("195","2024042232660","2024042236573","patients/p_audio/LungSound_1713802582.wav","LungSound","2024-04-22 16:16:22","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("196","2024042232660","2024042236573","patients/p_audio/LungSound_1713802611.wav","LungSound","2024-04-22 16:16:51","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("197","2024042232660","2024042236573","patients/p_audio/LungSound_1713802644.wav","LungSound","2024-04-22 16:17:24","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("198","2024042253987","202404221789","patients/p_audio/HeartBeat_1713802776.wav","HeartBeat","2024-04-22 16:19:36","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("199","2024042298751","2024042210479","patients/p_audio/HeartBeat_1713823166.wav","HeartBeat","2024-04-22 21:59:26","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("200","2024042390740","2024042329763","patients/p_audio/HeartBeat_1713877921.wav","HeartBeat","2024-04-23 13:12:01","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("201","2024042337842","2024042348744","patients/p_audio/HeartBeat_1713894116.wav","HeartBeat","2024-04-23 17:41:56","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("202","2024042337842","2024042348744","patients/p_audio/LungSound_1713894128.wav","LungSound","2024-04-23 17:42:08","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("203","2024042363370","2024042327186","patients/p_audio/HeartBeat_1713897411.wav","HeartBeat","2024-04-23 18:36:51","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("204","2024042474456","2024042441979","patients/p_audio/HeartBeat_1713979361.wav","HeartBeat","2024-04-24 17:22:41","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("205","2024042441794","2024042449889","patients/p_audio/HeartBeat_1713979875.wav","HeartBeat","2024-04-24 17:31:15","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("206","2024042469996","2024042438431","patients/p_audio/HeartBeat_1713985773.wav","HeartBeat","2024-04-24 19:09:33","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("207","2024042469996","2024042438431","patients/p_audio/HeartBeat_1713985828.wav","HeartBeat","2024-04-24 19:10:28","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("208","2024042469996","2024042438431","patients/p_audio/HeartBeat_1713985882.wav","HeartBeat","2024-04-24 19:11:22","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("209","2024042417328","2024042421440","patients/p_audio/HeartBeat_1713991297.wav","HeartBeat","2024-04-24 20:41:37","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("210","2024042585467","2024042540692","patients/p_audio/HeartBeat_1714053572.wav","HeartBeat","2024-04-25 13:59:32","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("211","2024042552948","2024042543478","patients/p_audio/HeartBeat_1714077669.wav","HeartBeat","2024-04-25 20:41:09","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("212","2024042689734","202404263528","patients/p_audio/HeartBeat_1714153807.wav","HeartBeat","2024-04-26 17:50:07","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("213","2024042764218","2024042720246","patients/p_audio/HeartBeat_1714227015.wav","HeartBeat","2024-04-27 14:10:15","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("214","2024042845605","2024042819479","patients/p_audio/LungSound_1714344878.wav","LungSound","2024-04-28 22:54:38","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("215","2024042845605","2024042819479","patients/p_audio/LungSound_1714344909.wav","LungSound","2024-04-28 22:55:09","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("216","2024042929929","2024042940862","patients/p_audio/HeartBeat_1714406488.wav","HeartBeat","2024-04-29 16:01:28","Palmas Del Mar","nurse1");



CREATE TABLE `patients_files` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `record_id` varchar(255) NOT NULL,
  `patient_id` varchar(255) NOT NULL,
  `picts` varchar(355) NOT NULL,
  `device_type` varchar(225) NOT NULL,
  `record_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `record_at` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=442 DEFAULT CHARSET=utf8mb4;

INSERT INTO patients_files VALUES("278","2024031537311","2024031527825","patients/p_pictures/Ear_1710514389.png","Ear","2024-03-15 14:53:09","nurse1");
INSERT INTO patients_files VALUES("279","2024031537311","2024031527825","patients/p_pictures/Ear_1710514460.png","Ear","2024-03-15 14:54:20","nurse1");
INSERT INTO patients_files VALUES("280","2024031529546","202403158274","patients/p_pictures/Ear_1710539616.png","Ear","2024-03-15 21:53:36","nurse1");
INSERT INTO patients_files VALUES("281","2024031529546","202403158274","patients/p_pictures/TestResult_COVID_1710539666.png","TestResult_COVID","2024-03-15 21:54:26","nurse1");
INSERT INTO patients_files VALUES("282","2024031591850","2024031530297","patients/p_pictures/TestResult_COVID_1710540187.png","TestResult_COVID","2024-03-15 22:03:07","nurse1");
INSERT INTO patients_files VALUES("283","2024032117263","2024032134960","patients/p_pictures/Mouth_1711036532.png","Mouth","2024-03-21 15:55:32","Reza");
INSERT INTO patients_files VALUES("284","2024032117263","2024032134960","patients/p_pictures/Mouth_1711036568.png","Mouth","2024-03-21 15:56:08","Reza");
INSERT INTO patients_files VALUES("285","2024032117263","2024032134960","patients/p_pictures/Mouth_1711036638.png","Mouth","2024-03-21 15:57:18","Reza");
INSERT INTO patients_files VALUES("286","2024032117263","2024032134960","patients/p_pictures/Mouth_1711036639.png","Mouth","2024-03-21 15:57:19","Reza");
INSERT INTO patients_files VALUES("287","2024032795415","2024032745433","patients/p_pictures/Skin_1711557290.png","Skin","2024-03-27 16:34:50","Dr. Marvel");
INSERT INTO patients_files VALUES("288","2024032795415","2024032745433","patients/p_pictures/Skin_1711557290.png","Skin","2024-03-27 16:34:50","Dr. Marvel");
INSERT INTO patients_files VALUES("289","2024032795415","2024032745433","patients/p_pictures/Skin_1711557290.png","Skin","2024-03-27 16:34:50","Dr. Marvel");
INSERT INTO patients_files VALUES("290","2024032795415","2024032745433","patients/p_pictures/Skin_1711557291.png","Skin","2024-03-27 16:34:51","Dr. Marvel");
INSERT INTO patients_files VALUES("291","2024032795415","2024032745433","patients/p_pictures/Skin_1711557291.png","Skin","2024-03-27 16:34:51","Dr. Marvel");
INSERT INTO patients_files VALUES("292","2024032795415","2024032745433","patients/p_pictures/Skin_1711557291.png","Skin","2024-03-27 16:34:51","Dr. Marvel");
INSERT INTO patients_files VALUES("293","2024032795415","2024032745433","patients/p_pictures/Skin_1711557291.png","Skin","2024-03-27 16:34:51","Dr. Marvel");
INSERT INTO patients_files VALUES("294","2024032795415","2024032745433","patients/p_pictures/TestResult_Flu_1711557349.png","TestResult_Flu","2024-03-27 16:35:49","Dr. Marvel");
INSERT INTO patients_files VALUES("295","2024032777557","202403276113","patients/p_pictures/Mouth_1711560057.png","Mouth","2024-03-27 17:20:57","Dr. Marvel");
INSERT INTO patients_files VALUES("296","2024032777557","202403276113","patients/p_pictures/Ear_1711560149.png","Ear","2024-03-27 17:22:29","Dr. Marvel");
INSERT INTO patients_files VALUES("297","2024032777557","202403276113","patients/p_pictures/Skin_1711560243.png","Skin","2024-03-27 17:24:03","Dr. Marvel");
INSERT INTO patients_files VALUES("298","2024032777557","202403276113","patients/p_pictures/TestResult_Flu_1711560596.png","TestResult_Flu","2024-03-27 17:29:56","Dr. Marvel");
INSERT INTO patients_files VALUES("299","2024032882769","2024032810393","patients/p_pictures/Ear_1711646140.png","Ear","2024-03-28 17:15:40","Dr. Marvel");
INSERT INTO patients_files VALUES("300","2024032882769","2024032810393","patients/p_pictures/Skin_1711646150.png","Skin","2024-03-28 17:15:50","Dr. Marvel");
INSERT INTO patients_files VALUES("301","2024032882769","2024032810393","patients/p_pictures/Skin_1711646150.png","Skin","2024-03-28 17:15:50","Dr. Marvel");
INSERT INTO patients_files VALUES("302","2024032882769","2024032810393","patients/p_pictures/Eye_1711646172.png","Eye","2024-03-28 17:16:12","Dr. Marvel");
INSERT INTO patients_files VALUES("303","2024032882769","2024032810393","patients/p_pictures/Mouth_1711646198.png","Mouth","2024-03-28 17:16:38","Dr. Marvel");
INSERT INTO patients_files VALUES("304","2024032882769","2024032810393","patients/p_pictures/TestResult_Flu_1711646224.png","TestResult_Flu","2024-03-28 17:17:04","Dr. Marvel");
INSERT INTO patients_files VALUES("305","2024032845836","2024032820940","patients/p_pictures/Ear_1711650040.png","Ear","2024-03-28 18:20:40","nurse1");
INSERT INTO patients_files VALUES("306","2024032845836","2024032820940","patients/p_pictures/EKG_1711650060.png","EKG","2024-03-28 18:21:00","nurse1");
INSERT INTO patients_files VALUES("307","2024032845836","2024032820940","patients/p_pictures/TestResult_Flu_1711650390.png","TestResult_Flu","2024-03-28 18:26:30","nurse1");
INSERT INTO patients_files VALUES("308","2024040222092","2024040229698","patients/p_pictures/Skin_1712068800.png","Skin","2024-04-02 14:40:00","Reza");
INSERT INTO patients_files VALUES("309","2024040263458","2024040210119","patients/p_pictures/Ear_1712070673.png","Ear","2024-04-02 15:11:13","Reza");
INSERT INTO patients_files VALUES("310","2024040263458","2024040210119","patients/p_pictures/Ear_1712070677.png","Ear","2024-04-02 15:11:17","Reza");
INSERT INTO patients_files VALUES("311","2024040480992","20240404766","patients/p_pictures/Ear_1712252646.png","Ear","2024-04-04 17:44:06","Reza");
INSERT INTO patients_files VALUES("312","2024040494378","2024040416550","patients/p_pictures/Ear_1712253163.png","Ear","2024-04-04 17:52:43","nurse1");
INSERT INTO patients_files VALUES("313","2024040497191","202404044619","patients/p_pictures/Ear_1712253528.png","Ear","2024-04-04 17:58:48","nurse1");
INSERT INTO patients_files VALUES("314","2024040429804","2024040411400","patients/p_pictures/Ear_1712253846.png","Ear","2024-04-04 18:04:06","Dr. Marvel");
INSERT INTO patients_files VALUES("315","2024040492678","2024040442376","patients/p_pictures/TestResult_Flu_1712255171.png","TestResult_Flu","2024-04-04 18:26:11","nurse1");
INSERT INTO patients_files VALUES("316","2024040492678","2024040442376","patients/p_pictures/TestResult_strep_1712255206.png","TestResult_strep","2024-04-04 18:26:46","nurse1");
INSERT INTO patients_files VALUES("317","2024040430797","2024040434981","patients/p_pictures/Ear_1712258319.png","Ear","2024-04-04 19:18:39","nurse1");
INSERT INTO patients_files VALUES("318","2024040423997","2024040421387","patients/p_pictures/Ear_1712258496.png","Ear","2024-04-04 19:21:36","nurse1");
INSERT INTO patients_files VALUES("319","2024040489360","202404044657","patients/p_pictures/TestResult_Flu_1712260633.png","TestResult_Flu","2024-04-04 19:57:13","nurse1");
INSERT INTO patients_files VALUES("320","2024040459408","2024040447258","patients/p_pictures/TestResult_UA_1712261528.png","TestResult_UA","2024-04-04 20:12:08","nurse1");
INSERT INTO patients_files VALUES("321","2024040494507","202404047757","patients/p_pictures/Ear_1712262522.png","Ear","2024-04-04 20:28:42","nurse1");
INSERT INTO patients_files VALUES("322","2024040419818","2024040431160","patients/p_pictures/Ear_1712267051.png","Ear","2024-04-04 21:44:11","nurse1");
INSERT INTO patients_files VALUES("323","2024040419818","2024040431160","patients/p_pictures/Ear_1712267138.png","Ear","2024-04-04 21:45:38","nurse1");
INSERT INTO patients_files VALUES("324","2024040512387","202404052307","patients/p_pictures/Ear_1712328679.png","Ear","2024-04-05 14:51:19","nurse1");
INSERT INTO patients_files VALUES("325","2024040596301","2024040534838","patients/p_pictures/Skin_1712330454.png","Skin","2024-04-05 15:20:54","nurse1");
INSERT INTO patients_files VALUES("326","2024040596301","2024040534838","patients/p_pictures/Skin_1712330477.png","Skin","2024-04-05 15:21:17","nurse1");
INSERT INTO patients_files VALUES("327","2024040587198","2024040531470","patients/p_pictures/TestResult_COVID_1712334552.png","TestResult_COVID","2024-04-05 16:29:12","nurse1");
INSERT INTO patients_files VALUES("328","2024040851674","2024040819495","patients/p_pictures/Ear_1712627089.png","Ear","2024-04-09 01:44:49","nurse1");
INSERT INTO patients_files VALUES("329","2024040999785","202404091752","patients/p_pictures/TestResult_UA_1712686639.png","TestResult_UA","2024-04-09 18:17:19","nurse1");
INSERT INTO patients_files VALUES("330","2024040999785","202404091752","patients/p_pictures/TestResult_UA_1712686928.png","TestResult_UA","2024-04-09 18:22:08","nurse1");
INSERT INTO patients_files VALUES("331","2024040947388","2024040932098","patients/p_pictures/TestResult_Flu_1712687750.png","TestResult_Flu","2024-04-09 18:35:50","nurse1");
INSERT INTO patients_files VALUES("332","2024040947388","2024040932098","patients/p_pictures/TestResult_COVID_1712687781.png","TestResult_COVID","2024-04-09 18:36:21","nurse1");
INSERT INTO patients_files VALUES("333","2024041186656","2024041127356","patients/p_pictures/Ear_1712857976.png","Ear","2024-04-11 17:52:56","nurse1");
INSERT INTO patients_files VALUES("334","2024041186656","2024041127356","patients/p_pictures/Ear_1712858076.png","Ear","2024-04-11 17:54:36","nurse1");
INSERT INTO patients_files VALUES("335","2024041186656","2024041127356","patients/p_pictures/TestResult_Flu_1712858094.png","TestResult_Flu","2024-04-11 17:54:54","nurse1");
INSERT INTO patients_files VALUES("336","2024041131410","202404115234","patients/p_pictures/Ear_1712858883.png","Ear","2024-04-11 18:08:03","nurse1");
INSERT INTO patients_files VALUES("337","2024041131410","202404115234","patients/p_pictures/Ear_1712859001.png","Ear","2024-04-11 18:10:01","nurse1");
INSERT INTO patients_files VALUES("338","2024041291187","202404128338","patients/p_pictures/TestResult_COVID_1712933560.png","TestResult_COVID","2024-04-12 14:52:40","nurse1");
INSERT INTO patients_files VALUES("339","2024041291187","202404128338","patients/p_pictures/Skin_1712933588.png","Skin","2024-04-12 14:53:08","nurse1");
INSERT INTO patients_files VALUES("340","2024041258217","2024041247969","patients/p_pictures/Skin_1712933992.png","Skin","2024-04-12 14:59:52","nurse1");
INSERT INTO patients_files VALUES("341","2024041258217","2024041247969","patients/p_pictures/Skin_1712934039.png","Skin","2024-04-12 15:00:39","nurse1");
INSERT INTO patients_files VALUES("342","2024041258217","2024041247969","patients/p_pictures/TestResult_COVID_1712934167.png","TestResult_COVID","2024-04-12 15:02:47","nurse1");
INSERT INTO patients_files VALUES("343","2024041219491","2024041219852","patients/p_pictures/Ear_1712940035.png","Ear","2024-04-12 16:40:35","nurse1");
INSERT INTO patients_files VALUES("344","2024041219491","2024041219852","patients/p_pictures/Ear_1712940073.png","Ear","2024-04-12 16:41:13","nurse1");
INSERT INTO patients_files VALUES("345","2024041249416","2024041216294","patients/p_pictures/Ear_1712941942.png","Ear","2024-04-12 17:12:22","nurse1");
INSERT INTO patients_files VALUES("346","2024041259382","2024041247505","patients/p_pictures/TestResult_Flu_1712945064.png","TestResult_Flu","2024-04-12 18:04:24","nurse1");
INSERT INTO patients_files VALUES("347","2024041291919","2024041222809","patients/p_pictures/Ear_1712946079.png","Ear","2024-04-12 18:21:19","nurse1");
INSERT INTO patients_files VALUES("348","2024041620351","2024041643291","patients/p_pictures/Ear_1713295736.png","Ear","2024-04-16 19:28:56","nurse1");
INSERT INTO patients_files VALUES("349","2024041620351","2024041643291","patients/p_pictures/Eye_1713295751.png","Eye","2024-04-16 19:29:11","nurse1");
INSERT INTO patients_files VALUES("350","2024041620351","2024041643291","patients/p_pictures/TestResult_Flu_1713295793.png","TestResult_Flu","2024-04-16 19:29:53","nurse1");
INSERT INTO patients_files VALUES("351","2024041631970","2024041612800","patients/p_pictures/Skin_1713296602.png","Skin","2024-04-16 19:43:22","nurse1");
INSERT INTO patients_files VALUES("352","2024041783674","2024041740873","patients/p_pictures/Ear_1713365791.png","Ear","2024-04-17 14:56:31","nurse1");
INSERT INTO patients_files VALUES("353","2024041783674","2024041740873","patients/p_pictures/Ear_1713365836.png","Ear","2024-04-17 14:57:16","nurse1");
INSERT INTO patients_files VALUES("354","2024041783674","2024041740873","patients/p_pictures/TestResult_Flu_1713365930.png","TestResult_Flu","2024-04-17 14:58:50","nurse1");
INSERT INTO patients_files VALUES("355","2024041781347","202404178418","patients/p_pictures/Ear_1713370654.png","Ear","2024-04-17 16:17:34","Reza");
INSERT INTO patients_files VALUES("356","2024041781347","202404178418","patients/p_pictures/Ear_1713370675.png","Ear","2024-04-17 16:17:55","Reza");
INSERT INTO patients_files VALUES("357","2024041768107","202404171091","patients/p_pictures/Skin_1713371703.png","Skin","2024-04-17 16:35:03","nurse1");
INSERT INTO patients_files VALUES("358","2024041768107","202404171091","patients/p_pictures/Mouth_1713372049.png","Mouth","2024-04-17 16:40:49","nurse1");
INSERT INTO patients_files VALUES("359","2024041797408","2024041714285","patients/p_pictures/Ear_1713375441.png","Ear","2024-04-17 17:37:21","nurse1");
INSERT INTO patients_files VALUES("360","2024041797408","2024041714285","patients/p_pictures/TestResult_Hcg_1713375528.png","TestResult_Hcg","2024-04-17 17:38:48","nurse1");
INSERT INTO patients_files VALUES("361","2024041790463","2024041720730","patients/p_pictures/TestResult_UA_1713377394.png","TestResult_UA","2024-04-17 18:09:54","nurse1");
INSERT INTO patients_files VALUES("362","2024041780850","2024041713828","patients/p_pictures/Ear_1713393061.png","Ear","2024-04-17 22:31:01","nurse1");
INSERT INTO patients_files VALUES("363","2024041780850","2024041713828","patients/p_pictures/Ear_1713393117.png","Ear","2024-04-17 22:31:57","nurse1");
INSERT INTO patients_files VALUES("364","2024041758466","2024041732356","patients/p_pictures/Mouth_1713394712.png","Mouth","2024-04-17 22:58:32","nurse1");
INSERT INTO patients_files VALUES("365","2024041826809","202404184167","patients/p_pictures/Ear_1713470892.png","Ear","2024-04-18 20:08:12","nurse1");
INSERT INTO patients_files VALUES("366","2024041826809","202404184167","patients/p_pictures/Ear_1713470954.png","Ear","2024-04-18 20:09:14","nurse1");
INSERT INTO patients_files VALUES("367","2024041847990","2024041810052","patients/p_pictures/Skin_1713471235.png","Skin","2024-04-18 20:13:55","nurse1");
INSERT INTO patients_files VALUES("368","2024041876959","2024041830298","patients/p_pictures/Ear_1713472297.png","Ear","2024-04-18 20:31:37","nurse1");
INSERT INTO patients_files VALUES("369","2024041876959","2024041830298","patients/p_pictures/TestResult_Hcg_1713472317.png","TestResult_Hcg","2024-04-18 20:31:57","nurse1");
INSERT INTO patients_files VALUES("370","2024041865190","2024041841711","patients/p_pictures/Ear_1713473323.png","Ear","2024-04-18 20:48:43","nurse1");
INSERT INTO patients_files VALUES("371","2024041865190","2024041841711","patients/p_pictures/TestResult_Hcg_1713473334.png","TestResult_Hcg","2024-04-18 20:48:54","nurse1");
INSERT INTO patients_files VALUES("372","2024041824524","2024041824137","patients/p_pictures/Ear_1713474214.png","Ear","2024-04-18 21:03:34","nurse1");
INSERT INTO patients_files VALUES("373","2024041813681","2024041827294","patients/p_pictures/Eye_1713474834.png","Eye","2024-04-18 21:13:54","nurse1");
INSERT INTO patients_files VALUES("374","2024041811021","2024041833030","patients/p_pictures/Ear_1713475386.png","Ear","2024-04-18 21:23:06","nurse1");
INSERT INTO patients_files VALUES("375","2024041893131","2024041834078","patients/p_pictures/Ear_1713476851.png","Ear","2024-04-18 21:47:31","nurse1");
INSERT INTO patients_files VALUES("376","2024041928284","2024041922142","patients/p_pictures/Ear_1713539539.png","Ear","2024-04-19 15:12:19","nurse1");
INSERT INTO patients_files VALUES("377","2024041928284","2024041922142","patients/p_pictures/TestResult_Flu_1713539665.png","TestResult_Flu","2024-04-19 15:14:25","nurse1");
INSERT INTO patients_files VALUES("378","2024041917830","2024041919967","patients/p_pictures/Mouth_1713540546.png","Mouth","2024-04-19 15:29:06","nurse1");
INSERT INTO patients_files VALUES("379","2024041917830","2024041919967","patients/p_pictures/Eye_1713540614.png","Eye","2024-04-19 15:30:14","nurse1");
INSERT INTO patients_files VALUES("380","2024041962703","2024041942442","patients/p_pictures/Ear_1713542104.png","Ear","2024-04-19 15:55:04","nurse1");
INSERT INTO patients_files VALUES("381","2024041962703","2024041942442","patients/p_pictures/TestResult_Flu_1713542113.png","TestResult_Flu","2024-04-19 15:55:13","nurse1");
INSERT INTO patients_files VALUES("382","2024041962703","2024041942442","patients/p_pictures/TestResult_Flu_1713542113.png","TestResult_Flu","2024-04-19 15:55:13","nurse1");
INSERT INTO patients_files VALUES("383","2024041955406","2024041917759","patients/p_pictures/Ear_1713548720.png","Ear","2024-04-19 17:45:20","nurse1");
INSERT INTO patients_files VALUES("384","2024041955406","2024041917759","patients/p_pictures/Ear_1713548756.png","Ear","2024-04-19 17:45:56","nurse1");
INSERT INTO patients_files VALUES("385","2024041955406","2024041917759","patients/p_pictures/TestResult_strep_1713548845.png","TestResult_strep","2024-04-19 17:47:25","nurse1");
INSERT INTO patients_files VALUES("386","2024041982797","2024041922637","patients/p_pictures/Mouth_1713550169.png","Mouth","2024-04-19 18:09:29","nurse1");
INSERT INTO patients_files VALUES("387","2024041982797","2024041922637","patients/p_pictures/TestResult_strep_1713550243.png","TestResult_strep","2024-04-19 18:10:43","nurse1");
INSERT INTO patients_files VALUES("388","2024041929312","2024041945218","patients/p_pictures/Ear_1713551945.png","Ear","2024-04-19 18:39:05","nurse1");
INSERT INTO patients_files VALUES("389","2024041929312","2024041945218","patients/p_pictures/Skin_1713551980.png","Skin","2024-04-19 18:39:40","nurse1");
INSERT INTO patients_files VALUES("390","2024041929312","2024041945218","patients/p_pictures/TestResult_strep_1713552079.png","TestResult_strep","2024-04-19 18:41:19","nurse1");
INSERT INTO patients_files VALUES("391","2024042155900","202404215219","patients/p_pictures/Ear_1713721398.png","Ear","2024-04-21 17:43:18","nurse1");
INSERT INTO patients_files VALUES("392","2024042155900","202404215219","patients/p_pictures/Ear_1713721412.png","Ear","2024-04-21 17:43:32","nurse1");
INSERT INTO patients_files VALUES("393","2024042155900","202404215219","patients/p_pictures/TestResult_COVID_1713721462.png","TestResult_COVID","2024-04-21 17:44:22","nurse1");
INSERT INTO patients_files VALUES("394","2024042196022","202404213005","patients/p_pictures/Mouth_1713722384.png","Mouth","2024-04-21 17:59:44","nurse1");
INSERT INTO patients_files VALUES("395","2024042196022","202404213005","patients/p_pictures/TestResult_strep_1713722426.png","TestResult_strep","2024-04-21 18:00:26","nurse1");
INSERT INTO patients_files VALUES("396","2024042166231","2024042121913","patients/p_pictures/Ear_1713724133.png","Ear","2024-04-21 18:28:53","nurse1");
INSERT INTO patients_files VALUES("397","2024042166231","2024042121913","patients/p_pictures/Ear_1713724180.png","Ear","2024-04-21 18:29:40","nurse1");
INSERT INTO patients_files VALUES("398","2024042166231","2024042121913","patients/p_pictures/Ear_1713724180.png","Ear","2024-04-21 18:29:40","nurse1");
INSERT INTO patients_files VALUES("399","2024042140238","2024042141151","patients/p_pictures/Mouth_1713726552.png","Mouth","2024-04-21 19:09:12","nurse1");
INSERT INTO patients_files VALUES("400","2024042119092","2024042136451","patients/p_pictures/Mouth_1713728243.png","Mouth","2024-04-21 19:37:23","nurse1");
INSERT INTO patients_files VALUES("401","2024042119092","2024042136451","patients/p_pictures/Ear_1713728336.png","Ear","2024-04-21 19:38:56","nurse1");
INSERT INTO patients_files VALUES("402","2024042119092","2024042136451","patients/p_pictures/TestResult_strep_1713728404.png","TestResult_strep","2024-04-21 19:40:04","nurse1");
INSERT INTO patients_files VALUES("403","2024042196053","2024042133042","patients/p_pictures/TestResult_Flu_1713730405.png","TestResult_Flu","2024-04-21 20:13:25","nurse1");
INSERT INTO patients_files VALUES("404","2024042298153","2024042220191","patients/p_pictures/Ear_1713793463.png","Ear","2024-04-22 13:44:23","nurse1");
INSERT INTO patients_files VALUES("405","2024042253987","202404221789","patients/p_pictures/Skin_1713802751.png","Skin","2024-04-22 16:19:11","nurse1");
INSERT INTO patients_files VALUES("406","2024042390740","2024042329763","patients/p_pictures/Ear_1713877880.png","Ear","2024-04-23 13:11:20","nurse1");
INSERT INTO patients_files VALUES("407","2024042373545","202404232211","patients/p_pictures/Mouth_1713886450.png","Mouth","2024-04-23 15:34:10","nurse1");
INSERT INTO patients_files VALUES("408","2024042373545","202404232211","patients/p_pictures/Mouth_1713886471.png","Mouth","2024-04-23 15:34:31","nurse1");
INSERT INTO patients_files VALUES("409","2024042373545","202404232211","patients/p_pictures/Mouth_1713886480.png","Mouth","2024-04-23 15:34:40","nurse1");
INSERT INTO patients_files VALUES("410","2024042373545","202404232211","patients/p_pictures/Mouth_1713886480.png","Mouth","2024-04-23 15:34:40","nurse1");
INSERT INTO patients_files VALUES("411","2024042337842","2024042348744","patients/p_pictures/Ear_1713893977.png","Ear","2024-04-23 17:39:37","nurse1");
INSERT INTO patients_files VALUES("412","2024042337842","2024042348744","patients/p_pictures/Skin_1713894085.png","Skin","2024-04-23 17:41:25","nurse1");
INSERT INTO patients_files VALUES("413","2024042337842","2024042348744","patients/p_pictures/TestResult_RSV_1713894188.png","TestResult_RSV","2024-04-23 17:43:08","nurse1");
INSERT INTO patients_files VALUES("414","2024042363370","2024042327186","patients/p_pictures/Ear_1713897345.png","Ear","2024-04-23 18:35:45","nurse1");
INSERT INTO patients_files VALUES("415","2024042441794","2024042449889","patients/p_pictures/Mouth_1713979809.png","Mouth","2024-04-24 17:30:09","nurse1");
INSERT INTO patients_files VALUES("416","2024042491472","2024042412981","patients/p_pictures/Mouth_1713980499.png","Mouth","2024-04-24 17:41:39","nurse1");
INSERT INTO patients_files VALUES("417","2024042477890","2024042436536","patients/p_pictures/Mouth_1713981537.png","Mouth","2024-04-24 17:58:57","nurse1");
INSERT INTO patients_files VALUES("418","2024042477890","2024042436536","patients/p_pictures/Ear_1713981664.png","Ear","2024-04-24 18:01:04","nurse1");
INSERT INTO patients_files VALUES("419","2024042469996","2024042438431","patients/p_pictures/Ear_1713985630.png","Ear","2024-04-24 19:07:10","nurse1");
INSERT INTO patients_files VALUES("420","2024042469996","2024042438431","patients/p_pictures/Ear_1713985728.png","Ear","2024-04-24 19:08:48","nurse1");
INSERT INTO patients_files VALUES("421","2024042417328","2024042421440","patients/p_pictures/Mouth_1713991260.png","Mouth","2024-04-24 20:41:00","nurse1");
INSERT INTO patients_files VALUES("422","2024042585467","2024042540692","patients/p_pictures/Mouth_1714053530.png","Mouth","2024-04-25 13:58:50","nurse1");
INSERT INTO patients_files VALUES("423","2024042689734","202404263528","patients/p_pictures/Ear_1714153549.png","Ear","2024-04-26 17:45:49","nurse1");
INSERT INTO patients_files VALUES("424","2024042689734","202404263528","patients/p_pictures/Ear_1714153609.png","Ear","2024-04-26 17:46:49","nurse1");
INSERT INTO patients_files VALUES("425","2024042689734","202404263528","patients/p_pictures/Mouth_1714153763.png","Mouth","2024-04-26 17:49:23","nurse1");
INSERT INTO patients_files VALUES("426","2024042689734","202404263528","patients/p_pictures/TestResult_COVID_1714153847.png","TestResult_COVID","2024-04-26 17:50:47","nurse1");
INSERT INTO patients_files VALUES("427","2024042746485","2024042734449","patients/p_pictures/Ear_1714229001.png","Ear","2024-04-27 14:43:21","nurse1");
INSERT INTO patients_files VALUES("428","2024042746485","2024042734449","patients/p_pictures/Ear_1714229009.png","Ear","2024-04-27 14:43:29","nurse1");
INSERT INTO patients_files VALUES("429","2024042746485","2024042734449","patients/p_pictures/Ear_1714229197.png","Ear","2024-04-27 14:46:37","nurse1");
INSERT INTO patients_files VALUES("430","2024042729996","2024042711761","patients/p_pictures/Ear_1714229803.png","Ear","2024-04-27 14:56:43","nurse1");
INSERT INTO patients_files VALUES("431","2024042729996","2024042711761","patients/p_pictures/Ear_1714229808.png","Ear","2024-04-27 14:56:48","nurse1");
INSERT INTO patients_files VALUES("432","2024042717732","2024042719994","patients/p_pictures/Ear_1714230313.png","Ear","2024-04-27 15:05:13","nurse1");
INSERT INTO patients_files VALUES("433","2024042717732","2024042719994","patients/p_pictures/Ear_1714230322.png","Ear","2024-04-27 15:05:22","nurse1");
INSERT INTO patients_files VALUES("434","2024042717732","2024042719994","patients/p_pictures/Ear_1714230408.png","Ear","2024-04-27 15:06:48","nurse1");
INSERT INTO patients_files VALUES("435","2024042862344","2024042818987","patients/p_pictures/Skin_1714314217.png","Skin","2024-04-28 14:23:37","nurse1");
INSERT INTO patients_files VALUES("436","2024042862344","2024042818987","patients/p_pictures/Skin_1714314234.png","Skin","2024-04-28 14:23:54","nurse1");
INSERT INTO patients_files VALUES("437","2024042862344","2024042818987","patients/p_pictures/Skin_1714314234.png","Skin","2024-04-28 14:23:54","nurse1");
INSERT INTO patients_files VALUES("438","2024042929929","2024042940862","patients/p_pictures/Ear_1714406113.png","Ear","2024-04-29 15:55:13","nurse1");
INSERT INTO patients_files VALUES("439","2024042929929","2024042940862","patients/p_pictures/Mouth_1714406264.png","Mouth","2024-04-29 15:57:44","nurse1");
INSERT INTO patients_files VALUES("440","2024042929929","2024042940862","patients/p_pictures/Skin_1714406363.png","Skin","2024-04-29 15:59:23","nurse1");
INSERT INTO patients_files VALUES("441","2024042929929","2024042940862","patients/p_pictures/TestResult_COVID_1714406719.png","TestResult_COVID","2024-04-29 16:05:19","nurse1");



CREATE TABLE `patients_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `record_id` varchar(255) DEFAULT NULL,
  `patient_fname` varchar(255) DEFAULT NULL,
  `patient_lname` varchar(255) DEFAULT NULL,
  `patient_dob` varchar(255) DEFAULT NULL,
  `patient_sex` varchar(255) DEFAULT NULL,
  `patient_contact` varchar(255) DEFAULT NULL,
  `patient_address` varchar(355) DEFAULT NULL,
  `vbp` varchar(100) DEFAULT NULL,
  `vtemp` varchar(100) DEFAULT NULL,
  `vresp` varchar(100) DEFAULT NULL,
  `vhr` varchar(100) DEFAULT NULL,
  `vweight` varchar(100) DEFAULT NULL,
  `vhg` varchar(100) DEFAULT NULL,
  `vsot` varchar(100) DEFAULT NULL,
  `patient_id` varchar(255) DEFAULT NULL,
  `record_by` varchar(255) DEFAULT NULL,
  `record_at` varchar(255) DEFAULT NULL,
  `record_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `record_notes` varchar(1024) DEFAULT NULL,
  `doctor_permission` varchar(225) DEFAULT NULL,
  `final` varchar(255) DEFAULT NULL,
  `already_oncall` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=612 DEFAULT CHARSET=utf8mb4;

INSERT INTO patients_record VALUES("477","2024040512387","BRETT","MARVEL","1982-08-22","Male","1236545623","1 the hill","111/74","97.6","18","57","190","72","95","202404052307","nurse1","Palmas Del Mar","2024-04-05 14:44:53","right ear ache.

NKDA

WALGREENS ON ARASCOSIAT RD","All","Yes","");
INSERT INTO patients_record VALUES("478","2024040596301","Brett","Marvel","","Male","","","","97.7","","","190","72","","2024040534838","nurse1","Palmas Del Mar","2024-04-05 15:18:04","cut to wrist","All","Yes","");
INSERT INTO patients_record VALUES("479","2024040587198","BRETT","MARVEL","1982-08-22","Male","125612361256","321 hill dr","111/72","97.7","18","60","190","72","96","2024040531470","nurse1","Palmas Del Mar","2024-04-05 16:22:34","COVID EXPOSURE.


SULFA DRUGS


KROGER ATASCOCITA RD","All","Yes","");
INSERT INTO patients_record VALUES("480","2024040599491","","","","Male","","","","","","","","","","2024040544847","nurse1","Palmas Del Mar","2024-04-05 16:49:51","","All","Yes","");
INSERT INTO patients_record VALUES("481","2024040572796","GIGI","ACOSTA","2002-11-05","Male","12356212365","9","119/97","97.6","18","80","198","65","99","2024040546047","nurse1","Palmas Del Mar","2024-04-05 17:02:16","TROAT PAIN.","All","Yes","");
INSERT INTO patients_record VALUES("482","2024040567733","Test After Update","1","","Male","","","","","","","","","","2024040525181","Dr. Marvel","Waco","2024-04-05 19:49:28","","All","Yes","Finish");
INSERT INTO patients_record VALUES("483","2024040530144","Test Update Redirect","1","","Male","","","","","","","","","","202404052686","Dr. Marvel","Waco","2024-04-05 20:01:56","","All","Yes","Ready");
INSERT INTO patients_record VALUES("484","2024040570396","Test String Room Conference Name","1","","Male","","","","","","","","","","2024040521056","Dr. Marvel","Waco","2024-04-05 20:07:01","","All","Yes","Finish");
INSERT INTO patients_record VALUES("485","2024040547893","Test String Room Conference Name","3","","Male","","","","","","","","","","2024040542457","Dr. Marvel","Waco","2024-04-05 20:41:34","","All","Yes","Finish");
INSERT INTO patients_record VALUES("486","2024040546587","Test String Room Conference Name","4","","Male","","","","","","","","","","2024040536768","Dr. Marvel","Waco","2024-04-06 20:44:56","","All","Yes","Ready");
INSERT INTO patients_record VALUES("487","2024040596807","Test String Room Conference Name","5","","Male","","","","","","","","","","2024040543524","Dr. Marvel","Waco","2024-04-06 20:46:13","","All","Yes","Finish");
INSERT INTO patients_record VALUES("488","2024040512162","","","","Male","","","","","","","","","","2024040535091","Dr. Marvel","Waco","2024-04-07 21:21:55","","All","Yes","Ready");
INSERT INTO patients_record VALUES("489","2024040851674","Bob","Dole","","Male","","","","","","","","","","2024040819495","nurse1","Palmas Del Mar","2024-04-09 01:44:13","hand cramp","All","Yes","Finish");
INSERT INTO patients_record VALUES("490","2024040952406","","","","","","","","","","","","","","2024040919853","nurse1","Palmas Del Mar","2024-04-09 16:31:42","","","","");
INSERT INTO patients_record VALUES("491","2024040999785","michelle","gage","1989-09-14","Female","1236545698","1230","125/84","98.4","18","70","65","195","99","202404091752","nurse1","Palmas Del Mar","2024-04-09 18:07:32","PAIN WHILE URINATION, MILD HEAD ACHE,  LOWER BACK PAIN. 3 DAYS

ALLERGIES: NKDA


PHARMACY: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778


PERFORMED HCG TEST(NEG)","All","Yes","Finish");
INSERT INTO patients_record VALUES("492","2024040912790","TEST2","MARVEL","2001-12-25","Male","1236548956","","","","","","","","","2024040945294","nurse1","Palmas Del Mar","2024-04-09 18:24:11","HEAD ACHE","All","Yes","Finish");
INSERT INTO patients_record VALUES("493","2024040947388","michelle","gage","1989-09-14","Female","1236548953","1456 lane drive","126/74","98.0","18","68","196","65","99","2024040932098","nurse1","Palmas Del Mar","2024-04-09 18:31:19","FEVER, CHILLS, VOMETING, BODYACHES, 3 DAYS. BROTHER IS SICK. TAKING DAYQUIL NO RELAF.


ALLERGIES: NKDA

PHARMACY: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("494","2024041186656","","Sanch","1977-12-12","Male","1","1","120/66","98.0","18","60","160","69","99","2024041127356","nurse1","Palmas Del Mar","2024-04-11 17:48:34","Earache
NKDA
The Walmarts Pharmacy
5551112222","All","Yes","Ready");
INSERT INTO patients_record VALUES("495","2024041160489","renzo","","","Male","","","","","","","","69","","2024041128860","nurse1","Palmas Del Mar","2024-04-11 17:57:51","ear","All","Yes","Finish");
INSERT INTO patients_record VALUES("496","2024041131410","renz","test","","Male","","","","","","","","","","202404115234","nurse1","Palmas Del Mar","2024-04-11 18:06:14","ear","All","Yes","Finish");
INSERT INTO patients_record VALUES("497","2024041230332","Joseph","Biden","1905-01-02","Male","","7410","110/71","98.0","18","54","160","72","99","2024041227415","nurse1","Palmas Del Mar","2024-04-12 14:49:13",""I forgot"","All","Yes","Ready");
INSERT INTO patients_record VALUES("498","2024041291187","Joseph","Biden","1905-01-02","Male","","","110/71","97.7","18","54","160","72","99","202404128338","nurse1","Palmas Del Mar","2024-04-12 14:51:23","oldness","All","Yes","Ready");
INSERT INTO patients_record VALUES("499","2024041258217","John","Doe","1665-01-02","Male","","","110/71","97.7","18","54","190","72","99","2024041247969","nurse1","Palmas Del Mar","2024-04-12 14:57:22","sore throat

nkda

Wallgreens atascocita","All","Yes","Ready");
INSERT INTO patients_record VALUES("500","2024041219491","John ","Doe","3161-12-05","Male","","","","","","","175","72","","2024041219852","nurse1","Palmas Del Mar","2024-04-12 16:38:30","Headache, not feeling self, sinus congestion","All","Yes","Ready");
INSERT INTO patients_record VALUES("501","2024041249416","Test!","test","5465-06-05","Male","","","110/71","97.7","","","190","72","","2024041216294","nurse1","Palmas Del Mar","2024-04-12 17:11:22","sore throat","All","Yes","Finish");
INSERT INTO patients_record VALUES("502","2024041259382","New","Test1","1541-01-24","Male","","","110/71","97.8","","","160","72","","2024041247505","nurse1","Palmas Del Mar","2024-04-13 18:03:39","testiness","All","Yes","Ready");
INSERT INTO patients_record VALUES("503","2024041291919","Calvin ","Phillips","5165-06-05","Male","","","110/71","97.7","","54","190","72","","2024041222809","nurse1","Palmas Del Mar","2024-04-13 18:19:32","asdgsdg","All","","Ready");
INSERT INTO patients_record VALUES("504","2024041262342","","","","Male","","","","","","","","","","2024041226693","Reza","Palmas Del Mar","2024-04-13 19:44:24","","All","Yes","Finish");
INSERT INTO patients_record VALUES("505","2024041323987","","","","Male","","","","","","","","","","202404133958","Dr. Marvel","Waco","2024-04-13 09:48:08","","All","Yes","Ready");
INSERT INTO patients_record VALUES("506","2024041360289","","","","Male","","","","","","","","","","2024041328955","Dr. Marvel","Waco","2024-04-13 10:03:00","","All","Yes","Ready");
INSERT INTO patients_record VALUES("507","2024041317577","","","","Male","","","","","","","","","","2024041347452","Dr. Marvel","Waco","2024-04-13 10:03:52","","All","Yes","Ready");
INSERT INTO patients_record VALUES("508","2024041361882","","","","Male","","","","","","","","","","2024041349312","Dr. Marvel","Waco","2024-04-13 10:06:07","","All","Yes","Ready");
INSERT INTO patients_record VALUES("509","2024041320851","","","","Male","","","","","","","","","","202404136029","Dr. Marvel","Waco","2024-04-13 10:09:14","","All","Yes","Ready");
INSERT INTO patients_record VALUES("510","2024041315461","","","","Male","","","","","","","","","","2024041340255","Dr. Marvel","Waco","2024-04-13 10:13:40","","All","Yes","Ready");
INSERT INTO patients_record VALUES("511","2024041371188","","","","Male","","","","","","","","","","2024041337410","Dr. Marvel","Waco","2024-04-13 10:15:47","","All","Yes","Ready");
INSERT INTO patients_record VALUES("512","2024041389192","","","","Male","","","","","","","","","","2024041348563","Dr. Marvel","Waco","2024-04-13 10:19:31","","All","Yes","Ready");
INSERT INTO patients_record VALUES("513","2024041382307","","","","Male","","","","","","","","","","2024041313879","Dr. Marvel","Waco","2024-04-13 10:21:03","","All","Yes","Ready");
INSERT INTO patients_record VALUES("514","2024041364922","","","","Male","","","","","","","","","","2024041344065","Dr. Marvel","Waco","2024-04-13 10:22:50","","All","Yes","Ready");
INSERT INTO patients_record VALUES("515","2024041384431","","","","Male","","","","","","","","","","2024041338961","Dr. Marvel","Waco","2024-04-13 10:25:09","","All","Yes","Ready");
INSERT INTO patients_record VALUES("516","2024041338941","","","","Male","","","","","","","","","","2024041317164","Dr. Marvel","Waco","2024-04-13 10:29:34","","All","Yes","Ready");
INSERT INTO patients_record VALUES("517","2024041368691","","","","Male","","","","","","","","","","2024041313988","Dr. Marvel","Waco","2024-04-13 10:37:20","","All","Yes","Ready");
INSERT INTO patients_record VALUES("518","2024041364672","","","","Male","","","","","","","","","","2024041329124","Dr. Marvel","Waco","2024-04-13 12:46:33","","All","Yes","Ready");
INSERT INTO patients_record VALUES("519","2024041372356","","","","Male","","","","","","","","","","2024041340344","Dr. Marvel","Waco","2024-04-13 12:59:45","","All","Yes","Ready");
INSERT INTO patients_record VALUES("520","2024041452346","","","","Male","","","","","","","","","","2024041445887","Dr. Marvel","Waco","2024-04-14 21:56:17","","All","Yes","Ready");
INSERT INTO patients_record VALUES("521","2024041435369","","","","Male","","","","","","","","","","2024041422071","Dr. Marvel","Waco","2024-04-14 22:05:58","","All","Yes","Ready");
INSERT INTO patients_record VALUES("522","2024041470537","","","","Male","","","","","","","","","","2024041429965","Dr. Marvel","Waco","2024-04-14 22:06:38","","All","Yes","Ready");
INSERT INTO patients_record VALUES("523","2024041424065","","","","Male","","","","","","","","","","2024041446673","Dr. Marvel","Waco","2024-04-14 22:08:40","","All","Yes","Ready");
INSERT INTO patients_record VALUES("524","2024041440798","","","","Male","","","","","","","","","","2024041448671","Dr. Marvel","Waco","2024-04-14 22:42:49","","All","Yes","Ready");
INSERT INTO patients_record VALUES("525","2024041682079","Test Audio Animation","","","Male","","","","","","","","11","","2024041649963","Dr. Marvel","Waco","2024-04-16 16:51:48","","All","Yes","Ready");
INSERT INTO patients_record VALUES("526","2024041648570","","","","Male","","","","","","","","","","2024041617038","Dr. Marvel","Waco","2024-04-16 17:03:20","","All","Yes","Ready");
INSERT INTO patients_record VALUES("527","2024041620351","1 test","t","","Male","1","1","1","1","1","1","1","1 test","1","2024041643291","nurse1","Palmas Del Mar","2024-04-16 19:28:09","1 test","All","Yes","Finish");
INSERT INTO patients_record VALUES("528","2024041698739","2 test","","","Male","","","2","2","2","2","2","2","2","202404166861","nurse1","Palmas Del Mar","2024-04-16 19:41:14","2 test","All","Yes","Ready");
INSERT INTO patients_record VALUES("529","2024041631970","2 test","2","","Male","2","2","2","2","2","2","2","2","2","2024041612800","nurse1","Palmas Del Mar","2024-04-16 19:42:17","2 test","All","Yes","Finish");
INSERT INTO patients_record VALUES("530","2024041746295","1test","1","","Male","1","1","120/66","98.0","18","60","160","69","99","2024041731025","nurse1","Palmas Del Mar","2024-04-17 14:49:07","1test
","All","Yes","Finish");
INSERT INTO patients_record VALUES("531","2024041783674","1test","1","","Male","1","1","120/66","98.0","18","60","160","69","99","2024041740873","nurse1","Palmas Del Mar","2024-04-17 14:51:21","1test
","All","Yes","Finish");
INSERT INTO patients_record VALUES("532","2024041754373","michelle ","gage","1989-09-14","Female","3239722961","","130/80","99.0","18","80","190","65","100","2024041722622","Reza","Palmas Del Mar","2024-04-17 15:50:24","ptt states is having a sore throat for 3 days 
pt states her daughter is sick at home 
pt states has body aches and headaches 
pt states is taking Tylenol for pain but has no relief

allergies: none 
pharmacy : Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("533","2024041781347","TEST2","test","0198-09-14","Male","","","","98.4","","","200","65","","202404178418","Reza","Palmas Del Mar","2024-04-17 16:16:30","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("534","2024041768107","Michelle","gage","1989-09-14","Female","3239722961","","120/80","98.6","18","80","190","65","100","202404171091","nurse1","Palmas Del Mar","2024-04-17 16:29:43","Pt states she has a stuffy nose, itchy eyes, scratchy throat
pt took Zyrtec put no relief
pt states she goes to the park a lot to run
pt states it happens more after the park

NKA
pharmacy: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("535","2024041797408","Renz","Test","1977-12-12","Male","1","1","120/66","98.0","18","60","160","69","99","2024041714285","nurse1","Palmas Del Mar","2024-04-17 17:33:40","CC; Fell Off Ladder.  Blood in Left Ear

Allergies:  NKDA

Rx;  The Walmarts
210-555-6666","All","Yes","Finish");
INSERT INTO patients_record VALUES("536","2024041790463","michelle","gage","1989-09-14","Female","3231979659","","118/90","99.0","20","18","190","65","100","2024041720730","nurse1","Palmas Del Mar","2024-04-17 17:56:24","pt has lower back pain, pain while urinating since last week and has taken azo otc w/no relief. Pts lmp 03/20, pt also take a Tylenol today

NKA
pharmacy: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("537","2024041753526","Green","Button","","Male","","","","","","","","","","2024041748254","nurse1","Palmas Del Mar","2024-04-17 18:23:03","","All","Yes","Ready");
INSERT INTO patients_record VALUES("538","2024041797789","Red ","Button","","Male","","","","","","","","","","2024041739844","nurse1","Palmas Del Mar","2024-04-17 18:23:45","sdgsdfg","All","Yes","Ready");
INSERT INTO patients_record VALUES("539","2024041784013","TEST2","test","","Male","","","126/74","","","","190","65","","2024041749728","nurse1","Palmas Del Mar","2024-04-17 18:31:13","ujyfuy","All","Yes","Ready");
INSERT INTO patients_record VALUES("540","2024041780850","Bob","Doe","1789-02-19","Male","123456789","","112/86","97.8","18","86","205","68","99","2024041713828","nurse1","Palmas Del Mar","2024-04-17 22:20:13","Pt is has ear pain both w/fluid and drainage, Pt states pain is constant for a week, pt also has heart palpations, pt has not taken anything, pt also has headaches w/ nervousness

NKA
Pharmacy: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("541","2024041758466","Kathy","Garcia","8699-06-05","Female","","","135/90","101.0","20","86","195","67","100","2024041732356","nurse1","Palmas Del Mar","2024-04-17 22:52:39","Pt states has a sore throat, fatigue, swollen tonsils every 2 months, pat took Tylenol and vomited today, no other house mm sick, pt works at a daycare

Allergies: Ibuprofen
Pharmacy: Kroger 
Atascocita
19300 W Lake Houston Pkwy Humble,
TX 77346

Get Directions
Hours & Contact
Main Store
281–812–4422
OPEN until 11:00 PM
Sun - Sat: 6:00 AM - 11:00 PM
Pharmacy
281–812–4499
OPEN until 8:00 PM
Sun: 10:00 AM - 5:00 PM
Mon - Fri: 9:00 AM - 8:00 PM
Sat: 9:00 AM - 6:00 PM
Closed (excluding holidays):
Sun - Sat: 1:00 PM - 1:30 PM ","All","Yes","Finish");
INSERT INTO patients_record VALUES("542","2024041799491","Test 1","","","Male","","","","","","","","","","2024041739199","Dr. Marvel","Waco","2024-04-18 01:47:38","","All","Yes","Ready");
INSERT INTO patients_record VALUES("543","2024041711853","Test 2","x","","Male","","","","","","","","","","2024041733980","Dr. Marvel","Waco","2024-04-18 03:44:34","","All","Yes","Ready");
INSERT INTO patients_record VALUES("544","2024041723688","Test moved function at end","1","","Male","","","","","","","","","","2024041746880","Dr. Marvel","Waco","2024-04-18 03:56:08","","All","Yes","");
INSERT INTO patients_record VALUES("545","2024041715712","Test moved function at end","2","","Male","","","","","","","","","","202404177997","Dr. Marvel","Waco","2024-04-18 04:01:43","","All","Yes","Ready");
INSERT INTO patients_record VALUES("546","2024041894305","","","","Male","","","","","","","","","","2024041831363","Dr. Marvel","Waco","2024-04-18 18:05:52","","All","","");
INSERT INTO patients_record VALUES("547","2024041879360","","","","Male","","","","","","","","","","2024041821448","Dr. Marvel","Waco","2024-04-18 18:07:12","","All","","");
INSERT INTO patients_record VALUES("548","2024041869426","","","","","","","","","","","","","","2024041812648","nurse1","Palmas Del Mar","2024-04-18 19:59:48","","","","");
INSERT INTO patients_record VALUES("549","2024041826809","Michelle","Gage","4154-12-05","Male","","","120/80","98.6","18","76","205","65","100","202404184167","nurse1","Palmas Del Mar","2024-04-18 20:06:03","sore throat, watery eyes","All","Yes","Finish");
INSERT INTO patients_record VALUES("550","2024041847990","Ben","Jerry","9968-12-05","Male","","","106/98","98.6","16","20","205","65","100","2024041810052","nurse1","Palmas Del Mar","2024-04-18 20:12:34","sore throat","All","Yes","Finish");
INSERT INTO patients_record VALUES("551","2024041876959","renzo","S","1977-12-13","Male","1","1","110/69","98.1","18","60","160","69","99","2024041830298","nurse1","Palmas Del Mar","2024-04-18 20:30:32","Rash

KNDA

Pharmacy:  The Walmarts 555-555-5555","All","Yes","Ready");
INSERT INTO patients_record VALUES("552","2024041865190","Testrenzo","s","","Male","1","1","110/69","98.1","18","60","160","69","99","2024041841711","nurse1","Palmas Del Mar","2024-04-18 20:47:52","Sick

knda

Rx:  The Walmarts","All","Yes","Finish");
INSERT INTO patients_record VALUES("553","2024041824524","LS","s","","Male","1","1","11","1","1","1","1","1","1","2024041824137","nurse1","Palmas Del Mar","2024-04-18 21:02:38","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("554","2024041813681","22222","22","","Male","2","2","2","2","2","2","2","2","2","2024041827294","nurse1","Palmas Del Mar","2024-04-18 21:13:25","2","All","Yes","Ready");
INSERT INTO patients_record VALUES("555","2024041811021","3333","3","","Male","3","3","3","3","3","3","3","3","3","2024041833030","nurse1","Palmas Del Mar","2024-04-18 21:22:44","3","All","Yes","Finish");
INSERT INTO patients_record VALUES("556","2024041861019","44444","44444","1975-09-17","Male","9999999","6 priors","122/80","98.","18","89","220","69","99","2024041810396","nurse1","Palmas Del Mar","2024-04-18 21:29:45","sore throat","All","Yes","Finish");
INSERT INTO patients_record VALUES("557","2024041876513","michelle","gage","","Male","3239722961","","120/80","98.7","18","8","120","65","100","2024041836966","nurse1","Palmas Del Mar","2024-04-18 21:34:43","sorethroat","All","Yes","Finish");
INSERT INTO patients_record VALUES("558","2024041893131","6","6","","Male","6","6","6","6","6","6","6","6","6","2024041834078","nurse1","Palmas Del Mar","2024-04-18 21:47:01","666666","All","Yes","Finish");
INSERT INTO patients_record VALUES("559","2024041899403","michelle ","Gage","1989-09-14","Female","","","120/80","98.6","18","76","205","65","100","2024041817399","nurse1","Palmas Del Mar","2024-04-18 22:03:27","sorethroat","All","Yes","Finish");
INSERT INTO patients_record VALUES("560","2024041928284","CH test","S","1978-01-01","Male","1","1","120/66","98.0","18","60","160","69","99","2024041922142","nurse1","Palmas Del Mar","2024-04-19 15:08:45","Manfluenza symptoms x 8 minutes

Allergies:  1 mg Dilaudid, but not 2mg or 4mg

Rx:  Walmart 111-222-3333","All","Yes","Ready");
INSERT INTO patients_record VALUES("561","2024041917830","s","s","","Male","1","1","120/66","98.0","18","60","160","69","99","2024041919967","nurse1","Palmas Del Mar","2024-04-19 15:26:58","sick","All","","");
INSERT INTO patients_record VALUES("562","2024041962703","2CH Test","2","0001-11-11","Male","1","1","120/66","98.0","18","60","160","69","99","2024041942442","nurse1","Palmas Del Mar","2024-04-19 15:53:58","Sick
","All","Yes","Finish");
INSERT INTO patients_record VALUES("563","2024041955406","Test5","5","0011-11-11","Male","1","1","120/66","98.0","18","60","160","69","99","2024041917759","nurse1","Palmas Del Mar","2024-04-19 17:43:28","CC:  Sore throat x 5 days

NKDA

Rx:  Walmart 555-333-2222","All","Yes","Ready");
INSERT INTO patients_record VALUES("564","2024041982797","Renzo","s","0011-11-11","Male","1","1","120/66","98.0","18","60","160","69","99","2024041922637","nurse1","Palmas Del Mar","2024-04-19 18:06:17","Sick

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("565","2024041929312","L","S","0001-01-01","Male","1","1","120/66","98.0","18","60","160","69","99","2024041945218","nurse1","Palmas Del Mar","2024-04-19 18:36:48","Flu Like Symptoms","All","Yes","Ready");
INSERT INTO patients_record VALUES("566","2024041912620","Billy Bob","Bobbington","1912-01-02","Male","1234567890","","140/80","98.6","","","180","6","","2024041927888","nurse1","Palmas Del Mar","2024-04-19 18:45:55","low self esteem from terrible name ","All","Yes","Ready");
INSERT INTO patients_record VALUES("567","2024041940622","r","r","","Male","1","1","120/66","98.0","18","60","160","69","99","2024041949550","nurse1","Palmas Del Mar","2024-04-19 19:22:04","1","All","","");
INSERT INTO patients_record VALUES("568","2024042025733","","","","Male","","","","","","","","","","2024042042010","Reza","Palmas Del Mar","2024-04-20 13:46:17","","All","","");
INSERT INTO patients_record VALUES("569","2024042150631","dghsdfg","sdfgsdfg","1354-01-02","Male","","","","","","","","","","202404219780","nurse1","Palmas Del Mar","2024-04-21 17:38:36","cp x 3 days

nkda

walgreens atascosita rd","All","","");
INSERT INTO patients_record VALUES("570","2024042155900","TEST2","gage","5165-05-16","Male","","1 the hill","110/71","97.7","18","80","190","65","99","202404215219","nurse1","Palmas Del Mar","2024-04-21 17:41:38","sdrhsdfh","All","Yes","Ready");
INSERT INTO patients_record VALUES("571","2024042196022","Renzo Test","T","1977-12-13","Male","2","2","110/69","98.1","18","60","160","69","99","202404213005","nurse1","Palmas Del Mar","2024-04-21 17:57:54","Sore Throat x 4 days

NKDA

Rx:  Walmart 555-555-5555","All","Yes","Finish");
INSERT INTO patients_record VALUES("572","2024042166231","Mayra ","Rubalcava ","1983-01-03","Female","8954741251","12345 Elm sT ","127/77","97.7","87","86","120","5 ft 6 in ","99","2024042121913","nurse1","Palmas Del Mar","2024-04-21 18:14:44","Ear pain X 2 weeks. Ringing in the ear 

Allergic to Lisinopril, Amoxicillin, Penicillin, and shrimp 
Medication List
Duloxetine, Migraine medication unknown name, Over the counter Vitamins
Pharmacy : Walgreens in Crosby TX   ","All","Yes","Ready");
INSERT INTO patients_record VALUES("573","2024042166231","Mayra ","Rubalcava ","1983-01-03","Female","8954741251","12345 Elm sT ","127/77","97.7","87","86","120","5 ft 6 in ","99","2024042121913","nurse1","Palmas Del Mar","2024-04-21 18:23:31","Ear pain X 2 weeks. Ringing in the ear 

Allergic to Lisinopril, Amoxicillin, Penicillin, and shrimp 
Medication List
Duloxetine, Migraine medication unknown name, Over the counter Vitamins
Pharmacy : Walgreens in Crosby TX   ","All","Yes","Ready");
INSERT INTO patients_record VALUES("574","2024042140238","Rubi","Castro","1990-02-03","Female","1231231234","4321 Barbosa houston Tx 77026","143","98","16","143/81","110","60","99","2024042141151","nurse1","Palmas Del Mar","2024-04-21 18:44:52","Sore throat x 1 day. 
Allergic to Lisinopril
Current meds: Effexor 75.5 mg once a day, HCTZ 25 mg once a day, Vit D once weekly and losartan 25 mg once a day.
Pharmacy: Walgreens 747 E. Cross timbers. Houston Tx ","All","Yes","Ready");
INSERT INTO patients_record VALUES("575","2024042119092","Ruby","Lopez","1651-06-05","Female","","","110/71","97.7","","86","190","65","","2024042136451","nurse1","Palmas Del Mar","2024-04-21 19:35:11","sore throat x 3 days, itchy ears

lisinopril

wallgreens 747 east cross timbers","All","Yes","Ready");
INSERT INTO patients_record VALUES("576","2024042196053","BRETT","MARVEL","1982-08-22","Male","7132222222","1 the hill","118/67","99.2","16","55","190","72","95","2024042133042","nurse1","Palmas Del Mar","2024-04-21 20:07:00","body aches x 2 days
Nkda
phar: kroger atascosita","All","Yes","Ready");
INSERT INTO patients_record VALUES("577","2024042134432","","","","Male","","","","","","","","","","2024042144137","nurse1","Palmas Del Mar","2024-04-21 20:28:00","","All","","");
INSERT INTO patients_record VALUES("578","2024042123368","Mayra ","Rubalcava ","1982-01-03","Female","12345691241","1 the hill","132/83","98.7","16","77","100","63","99","2024042135972","nurse1","Palmas Del Mar","2024-04-21 20:42:27","Migraine Headache for 1 mth","All","Yes","Ready");
INSERT INTO patients_record VALUES("579","2024042159897","Rubi","Lopez","1981-09-02","Female","1231231234","12345 Elm sT ","113/76","97.8","18","80","140","40","99","2024042115931","nurse1","Palmas Del Mar","2024-04-21 20:58:05","Left leg pain x 2 days.
Allergic to tylenol and all nuts
Current taking. Pic on file","All","Yes","Ready");
INSERT INTO patients_record VALUES("580","2024042298153","Testy","McTesterson","1234-01-12","Male","","","","97.8","16","86","160","72","","2024042220191","nurse1","Palmas Del Mar","2024-04-22 13:42:14","test test","All","Yes","Finish");
INSERT INTO patients_record VALUES("581","2024042232660","esteban","valencia","","Male","","","","","","","","","","2024042236573","nurse1","Palmas Del Mar","2024-04-22 16:15:07","sinus","All","Yes","Finish");
INSERT INTO patients_record VALUES("582","2024042253987","Ken","Jones","6055-12-31","Male","","","","","","","","72","","202404221789","nurse1","Palmas Del Mar","2024-04-22 16:18:05","back pain","All","Yes","Finish");
INSERT INTO patients_record VALUES("583","2024042298751","Test","Test","","Male","","","","","","","","","","2024042210479","nurse1","Palmas Del Mar","2024-04-22 21:56:38","gerd","All","Yes","Ready");
INSERT INTO patients_record VALUES("584","2024042390740","Brett","Marvel","5615-04-05","Male","","","","97.7","","","190","72","","2024042329763","nurse1","Palmas Del Mar","2024-04-23 13:07:53","sore throat x 3 days

nkda

walgreens","All","Yes","Ready");
INSERT INTO patients_record VALUES("585","2024042397225","s;klrrmg","dsfgdf","1651-12-31","Male","","","","97.8","","","160","72","","2024042340910","nurse1","Palmas Del Mar","2024-04-23 14:10:06","dfhbdsfh","All","Yes","Ready");
INSERT INTO patients_record VALUES("586","2024042390212","michelle","gage","1989-09-14","Female","","","110/71","97.7","18","86","190","72","99","2024042316535","nurse1","Palmas Del Mar","2024-04-23 14:18:40","sorethroat","All","Yes","Finish");
INSERT INTO patients_record VALUES("587","2024042373545","TEST2","test","","Male","","","","97.7","","","","65","","202404232211","nurse1","Palmas Del Mar","2024-04-23 15:33:03","hurt","All","Yes","Finish");
INSERT INTO patients_record VALUES("588","2024042337842","Renzo","Sanch","1977-12-13","Male","1","1","120/66","98.0","18","60","160","69","99","2024042348744","nurse1","Palmas Del Mar","2024-04-23 17:36:46","Sick

NKDA

Rx;  Walgreens ","All","Yes","Finish");
INSERT INTO patients_record VALUES("589","2024042363370","michelle","gage","1989-09-14","Female","3239722961","","110/71","97.7","18","86","190","72","99","2024042327186","nurse1","Palmas Del Mar","2024-04-23 18:33:41","sorethroat","All","Yes","Ready");
INSERT INTO patients_record VALUES("590","2024042387740","Amanda","TORREZ","1983-04-30","Female","","","130/80","98.8","18","82","202","65","100","2024042341178","nurse1","Palmas Del Mar","2024-04-23 22:28:48","UTI SYMPTOMS ","All","Yes","Ready");
INSERT INTO patients_record VALUES("591","2024042332847","Michelle","test","1980-03-15","Male","","","130/80","","","","160","72","99","2024042317894","nurse1","Palmas Del Mar","2024-04-23 22:38:41","UTI","All","Yes","Finish");
INSERT INTO patients_record VALUES("592","2024042474456","TEST","TEST 1","","Male","","","120/86","98.6","60","18","230","65","100","2024042441979","nurse1","Palmas Del Mar","2024-04-24 17:21:20","RUNNY NOSE","All","Yes","Ready");
INSERT INTO patients_record VALUES("593","2024042441794","tiffany","ortiz","1987-06-19","Female","","","106/72","98.6","96","20","232","63","100","2024042449889","nurse1","Palmas Del Mar","2024-04-24 17:27:11","runny nose ","All","Yes","Finish");
INSERT INTO patients_record VALUES("594","2024042491472","test2","test","","Male","","","106/64","97.8","","","203","63","","2024042412981","nurse1","Palmas Del Mar","2024-04-24 17:38:07","sore throat ","All","Yes","Ready");
INSERT INTO patients_record VALUES("595","2024042477890","test1","test","","Male","","","","","","","","","","2024042436536","nurse1","Palmas Del Mar","2024-04-24 17:58:03","sore throat","All","Yes","Ready");
INSERT INTO patients_record VALUES("596","2024042469996","test","garcia","1987-10-14","Male","","","112/86","98.6","16","86","203","65","98","2024042438431","nurse1","Palmas Del Mar","2024-04-24 19:02:37","sore throat","All","Yes","Ready");
INSERT INTO patients_record VALUES("597","2024042497876","ben","test","","Male","","","","","","","","","","2024042447186","nurse1","Palmas Del Mar","2024-04-24 19:16:53","runny nose","All","Yes","Finish");
INSERT INTO patients_record VALUES("598","2024042417328","joe","dow","","Male","","","","","","","","65","","2024042421440","nurse1","Palmas Del Mar","2024-04-24 20:38:43","runny nose","All","Yes","Finish");
INSERT INTO patients_record VALUES("599","2024042585467","Jim","test","","Male","","","116/78","98.6","","","230","65","","2024042540692","nurse1","Palmas Del Mar","2024-04-25 13:56:39","sore throat","All","Yes","Finish");
INSERT INTO patients_record VALUES("600","2024042552948","Ashley","jones","2002-12-19","Female","7136895934","","116/74","98.6","18","86","230","63","100","2024042543478","nurse1","Palmas Del Mar","2024-04-25 20:39:18","Runny rose","All","Yes","Finish");
INSERT INTO patients_record VALUES("601","2024042649780","Test Test","S","1977-01-01","Male","1","1","120/66","98.0","18","60","160","69","99","2024042620253","nurse1","Palmas Del Mar","2024-04-26 17:41:10","Test Test","All","","");
INSERT INTO patients_record VALUES("602","2024042689734","1test","S","1998-04-24","Male","1","1","120/66","98.0","18","60","160","69","99","202404263528","nurse1","Palmas Del Mar","2024-04-26 17:43:15","sick","All","","");
INSERT INTO patients_record VALUES("603","2024042633764","","","","","","","","","","","","","","2024042624569","nurse1","Palmas Del Mar","2024-04-26 19:35:58","","","","");
INSERT INTO patients_record VALUES("604","2024042764218","Juan ","Juan ","1950-10-20","Male","1231234123","1230 HILL","110/71","97.7","18","86","230","63","100","2024042720246","nurse1","Palmas Del Mar","2024-04-27 14:06:14","back pain X4 days 
KNA 
Pharmacy Walgreens on Atascocita
Daily Medications Losartan,  
","All","Yes","Finish");
INSERT INTO patients_record VALUES("605","2024042746485","Stephanny","Lopez ","2003-09-02","Female","1235452525","1 the hill","110/71","97.7","16","68","196","72","98","2024042734449","nurse1","Palmas Del Mar","2024-04-27 14:38:24","Ear pain X 3 days 
KNA
Pharmacy Walgreens 747 e cross timbers 77016
Daily Medication : Vitamin D 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("606","2024042729996","Thomas ","Smith ","2008-10-20","Male","1234561212","","130/80","97.7","16","80","196","69","100","2024042711761","nurse1","Palmas Del Mar","2024-04-27 14:54:26","Ear pain , allergies X3 days 
KNA 
Pharmacy Kroger across the street 
Daily MEds. Allegra ","All","","");
INSERT INTO patients_record VALUES("607","2024042717732","Jose ","Pable","2000-05-05","Male","1234569478","12345 Elm sT ","112/86","97.7","16","80","160","63","99","2024042719994","nurse1","Palmas Del Mar","2024-04-27 15:01:26","Ear pain X 3 days 
NKA 
Pharmacy : Kroger across the street 3820 Atascocita RD 
Daily Meds Allegra 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("608","2024042862344","TEST2","Test","2000-10-20","Female","1231231236","","110/71","98.6","16","80","120","60","100","2024042818987","nurse1","Palmas Del Mar","2024-04-28 14:18:47","Rash on the hand X3 days. States partner was diagnosed with scabies. 
Allergic to Amoxicillin
Kroger 2818126397
No daily meds  ","All","Yes","Finish");
INSERT INTO patients_record VALUES("609","2024042845605","Lloyd ","Freeman ","1960-10-20","Male","8322050888","1234 Elm st ","130/80","98.6","18","80","186","72","100","2024042819479","nurse1","Palmas Del Mar","2024-04-28 22:49:00","Cough X 2 days 
Environmental allergies
, NKA to meds 
Pharmacy CVS Houston
 No daily medicataions 

","All","Yes","Finish");
INSERT INTO patients_record VALUES("610","2024042986785","test","test2","","Male","","","","","","","","","","2024042922296","nurse1","Palmas Del Mar","2024-04-29 14:05:40","runny nose","All","Yes","Finish");
INSERT INTO patients_record VALUES("611","2024042929929","Renzo","Sanch","1977-12-13","Male","5554443333","123","120/60","101.5","18","60","160","69","95","2024042940862","nurse1","Palmas Del Mar","2024-04-29 15:47:27","Sinus congestion and body aches x 2 days

NKDA

Rx:  Walmart 222-333-6666","All","Yes","Ready");



CREATE TABLE `tbl_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'role_id',
  `role` varchar(255) DEFAULT NULL COMMENT 'role_text',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

INSERT INTO tbl_roles VALUES("1","ICT");
INSERT INTO tbl_roles VALUES("2","Doctor");
INSERT INTO tbl_roles VALUES("3","Nurse");



CREATE TABLE `tbl_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pod` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `sex` varchar(100) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `mobile` varchar(25) DEFAULT NULL,
  `tgl_lahir` date NOT NULL,
  `roleid` tinyint(4) DEFAULT NULL,
  `isActive` tinyint(4) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastlogin_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `u_ID` varchar(255) NOT NULL,
  `f_profile` varchar(355) DEFAULT NULL,
  `doctor_permission` varchar(225) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4;

INSERT INTO tbl_users VALUES("1","Palmas Del Mar","Reza","Male","PODICT","cyber@providerondemand.com","8151e41c465d23729a35c96aa08b9c8a2175f3e6","089633919827","1992-01-15","1","0","2020-03-12 16:23:01","2020-03-12 16:23:01","2023-11-26 13:14:04","POD1","5061Reza.png","All");
INSERT INTO tbl_users VALUES("2","Waco","Dr. Marvel","Male","POD2","marvel@providerondemand.com","8151e41c465d23729a35c96aa08b9c8a2175f3e6","08888888881","2023-11-26","2","0","2020-03-13 05:11:02","2020-03-13 05:11:02","2023-11-26 13:14:04","POD2","1330Dr Marvel.jpg","All");
INSERT INTO tbl_users VALUES("24","Palmas Del Mar","nurse1","Female","POD3","nurse01@providerondemand.com","8151e41c465d23729a35c96aa08b9c8a2175f3e6","081200000080","1991-01-15","3","0","2023-12-03 19:47:36","2023-12-03 19:47:36","2023-12-03 19:47:36","POD3","2938clay-elliot-mpDV4xaFP8c-unsplash.jpg","All");

