

CREATE TABLE `location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `location_name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO location VALUES("1","POD1","VAM");
INSERT INTO location VALUES("2","POD2","Palmas");
INSERT INTO location VALUES("3","POD3","Atascocita");
INSERT INTO location VALUES("4","POD3","Humble");
INSERT INTO location VALUES("5","POD4","Castle Hills");



CREATE TABLE `patients` (
  `patient_id` int(50) NOT NULL AUTO_INCREMENT,
  `full_name` varchar(255) NOT NULL,
  `dob` date NOT NULL,
  `sex` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `register_at` varchar(255) NOT NULL,
  `add_by` varchar(255) NOT NULL,
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




CREATE TABLE `patients_audio` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `record_id` varchar(255) NOT NULL,
  `patient_id` varchar(255) NOT NULL,
  `files` varchar(355) NOT NULL,
  `device_type` varchar(255) NOT NULL,
  `record_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `record_at` varchar(100) NOT NULL,
  `record_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=544 DEFAULT CHARSET=utf8mb4;

INSERT INTO patients_audio VALUES("126","2024040512387","202404052307","patients/p_audio/HeartBeat_1712328712.wav","HeartBeat","2024-04-05 14:51:52","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("127","2024040512387","202404052307","patients/p_audio/HeartBeat_1712328755.wav","HeartBeat","2024-04-05 14:52:35","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("128","2024040512387","202404052307","patients/p_audio/HeartBeat_1712328817.wav","HeartBeat","2024-04-05 14:53:37","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("129","2024040596301","2024040534838","patients/p_audio/HeartBeat_1712330515.wav","HeartBeat","2024-04-05 15:21:55","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("130","2024040851674","2024040819495","patients/p_audio/HeartBeat_1712627105.wav","HeartBeat","2024-04-09 01:45:05","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("131","2024041186656","2024041127356","patients/p_audio/HeartBeat_1712858113.wav","HeartBeat","2024-04-11 17:55:13","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("132","2024041291187","202404128338","patients/p_audio/HeartBeat_1712933619.wav","HeartBeat","2024-04-12 14:53:39","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("133","2024041258217","2024041247969","patients/p_audio/HeartBeat_1712934067.wav","HeartBeat","2024-04-12 15:01:07","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("134","2024041249416","2024041216294","patients/p_audio/HeartBeat_1712941961.wav","HeartBeat","2024-04-12 17:12:41","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("135","2024041262342","2024041226693","patients/p_audio/HeartBeat_1712951090.wav","HeartBeat","2024-04-12 19:44:50","Palmas Del Mar","Reza");
INSERT INTO patients_audio VALUES("136","2024041262342","2024041226693","patients/p_audio/HeartBeat_1712951106.wav","HeartBeat","2024-04-12 19:45:06","Palmas Del Mar","Reza");
INSERT INTO patients_audio VALUES("137","2024041360289","2024041328955","patients/p_audio/HeartBeat_1713002591.wav","HeartBeat","2024-04-13 10:03:11","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("138","2024041317577","2024041347452","patients/p_audio/HeartBeat_1713002644.wav","HeartBeat","2024-04-13 10:04:04","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("139","2024041361882","2024041349312","patients/p_audio/HeartBeat_1713002777.wav","HeartBeat","2024-04-13 10:06:17","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("140","2024041361882","2024041349312","patients/p_audio/HeartBeat_1713002781.wav","HeartBeat","2024-04-13 10:06:21","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("141","2024041361882","2024041349312","patients/p_audio/HeartBeat_1713002784.wav","HeartBeat","2024-04-13 10:06:24","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("142","2024041320851","202404136029","patients/p_audio/HeartBeat_1713002968.wav","HeartBeat","2024-04-13 10:09:28","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("143","2024041320851","202404136029","patients/p_audio/HeartBeat_1713002985.wav","HeartBeat","2024-04-13 10:09:45","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("144","2024041320851","202404136029","patients/p_audio/HeartBeat_1713003056.wav","HeartBeat","2024-04-13 10:10:56","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("145","2024041315461","2024041340255","patients/p_audio/HeartBeat_1713003227.wav","HeartBeat","2024-04-13 10:13:47","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("146","2024041315461","2024041340255","patients/p_audio/HeartBeat_1713003243.wav","HeartBeat","2024-04-13 10:14:03","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("147","2024041315461","2024041340255","patients/p_audio/HeartBeat_1713003247.wav","HeartBeat","2024-04-13 10:14:07","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("148","2024041371188","2024041337410","patients/p_audio/HeartBeat_1713003372.wav","HeartBeat","2024-04-13 10:16:12","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("149","2024041371188","2024041337410","patients/p_audio/HeartBeat_1713003384.wav","HeartBeat","2024-04-13 10:16:24","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("150","2024041371188","2024041337410","patients/p_audio/HeartBeat_1713003438.wav","HeartBeat","2024-04-13 10:17:18","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("151","2024041389192","2024041348563","patients/p_audio/HeartBeat_1713003581.wav","HeartBeat","2024-04-13 10:19:41","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("152","2024041389192","2024041348563","patients/p_audio/HeartBeat_1713003601.wav","HeartBeat","2024-04-13 10:20:01","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("153","2024041382307","2024041313879","patients/p_audio/HeartBeat_1713003675.wav","HeartBeat","2024-04-13 10:21:15","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("154","2024041364922","2024041344065","patients/p_audio/HeartBeat_1713003780.wav","HeartBeat","2024-04-13 10:23:00","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("155","2024041364922","2024041344065","patients/p_audio/HeartBeat_1713003784.wav","HeartBeat","2024-04-13 10:23:04","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("156","2024041384431","2024041338961","patients/p_audio/HeartBeat_1713003918.wav","HeartBeat","2024-04-13 10:25:18","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("157","2024041384431","2024041338961","patients/p_audio/HeartBeat_1713003961.wav","HeartBeat","2024-04-13 10:26:01","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("158","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004648.wav","HeartBeat","2024-04-13 10:37:28","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("159","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004651.wav","HeartBeat","2024-04-13 10:37:31","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("160","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004660.wav","HeartBeat","2024-04-13 10:37:40","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("161","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004669.wav","HeartBeat","2024-04-13 10:37:49","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("162","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004701.wav","HeartBeat","2024-04-13 10:38:21","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("163","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004722.wav","HeartBeat","2024-04-13 10:38:42","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("164","2024041368691","2024041313988","patients/p_audio/HeartBeat_1713004767.wav","HeartBeat","2024-04-13 10:39:27","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("165","2024041364672","2024041329124","patients/p_audio/HeartBeat_1713012400.wav","HeartBeat","2024-04-13 12:46:40","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("166","2024041682079","2024041649963","patients/p_audio/HeartBeat_1713286628.wav","HeartBeat","2024-04-16 16:57:08","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("167","2024041682079","2024041649963","patients/p_audio/HeartBeat_1713286638.wav","HeartBeat","2024-04-16 16:57:18","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("168","2024041648570","2024041617038","patients/p_audio/HeartBeat_1713287033.wav","HeartBeat","2024-04-16 17:03:53","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("169","2024041620351","2024041643291","patients/p_audio/HeartBeat_1713295765.wav","HeartBeat","2024-04-16 19:29:25","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("170","2024041620351","2024041643291","patients/p_audio/LungSound_1713295775.wav","LungSound","2024-04-16 19:29:35","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("171","2024041783674","2024041740873","patients/p_audio/HeartBeat_1713365875.wav","HeartBeat","2024-04-17 14:57:55","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("172","2024041783674","2024041740873","patients/p_audio/LungSound_1713365905.wav","LungSound","2024-04-17 14:58:25","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("173","2024041797408","2024041714285","patients/p_audio/HeartBeat_1713375486.wav","HeartBeat","2024-04-17 17:38:06","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("174","2024041780850","2024041713828","patients/p_audio/HeartBeat_1713393173.wav","HeartBeat","2024-04-17 22:32:53","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("175","2024041780850","2024041713828","patients/p_audio/LungSound_1713393214.wav","LungSound","2024-04-17 22:33:34","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("176","2024041780850","2024041713828","patients/p_audio/LungSound_1713393229.wav","LungSound","2024-04-17 22:33:49","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("177","2024041928284","2024041922142","patients/p_audio/HeartBeat_1713539601.wav","HeartBeat","2024-04-19 15:13:21","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("178","2024041955406","2024041917759","patients/p_audio/HeartBeat_1713548810.wav","HeartBeat","2024-04-19 17:46:50","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("179","2024041929312","2024041945218","patients/p_audio/HeartBeat_1713552034.wav","HeartBeat","2024-04-19 18:40:34","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("180","2024042155900","202404215219","patients/p_audio/HeartBeat_1713721512.wav","HeartBeat","2024-04-21 17:45:12","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("181","2024042196022","202404213005","patients/p_audio/HeartBeat_1713722397.wav","HeartBeat","2024-04-21 17:59:57","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("182","2024042196022","202404213005","patients/p_audio/LungSound_1713722413.wav","LungSound","2024-04-21 18:00:13","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("183","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724344.wav","HeartBeat","2024-04-21 18:32:24","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("184","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724419.wav","HeartBeat","2024-04-21 18:33:39","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("185","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724476.wav","HeartBeat","2024-04-21 18:34:36","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("186","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724648.wav","HeartBeat","2024-04-21 18:37:28","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("187","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724676.wav","HeartBeat","2024-04-21 18:37:56","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("188","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724707.wav","HeartBeat","2024-04-21 18:38:27","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("189","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724733.wav","HeartBeat","2024-04-21 18:38:53","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("190","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724800.wav","HeartBeat","2024-04-21 18:40:00","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("191","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724847.wav","HeartBeat","2024-04-21 18:40:47","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("192","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724914.wav","HeartBeat","2024-04-21 18:41:54","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("193","2024042166231","2024042121913","patients/p_audio/HeartBeat_1713724958.wav","HeartBeat","2024-04-21 18:42:38","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("194","2024042298153","2024042220191","patients/p_audio/HeartBeat_1713793555.wav","HeartBeat","2024-04-22 13:45:55","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("195","2024042232660","2024042236573","patients/p_audio/LungSound_1713802582.wav","LungSound","2024-04-22 16:16:22","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("196","2024042232660","2024042236573","patients/p_audio/LungSound_1713802611.wav","LungSound","2024-04-22 16:16:51","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("197","2024042232660","2024042236573","patients/p_audio/LungSound_1713802644.wav","LungSound","2024-04-22 16:17:24","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("198","2024042253987","202404221789","patients/p_audio/HeartBeat_1713802776.wav","HeartBeat","2024-04-22 16:19:36","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("199","2024042298751","2024042210479","patients/p_audio/HeartBeat_1713823166.wav","HeartBeat","2024-04-22 21:59:26","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("200","2024042390740","2024042329763","patients/p_audio/HeartBeat_1713877921.wav","HeartBeat","2024-04-23 13:12:01","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("201","2024042337842","2024042348744","patients/p_audio/HeartBeat_1713894116.wav","HeartBeat","2024-04-23 17:41:56","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("202","2024042337842","2024042348744","patients/p_audio/LungSound_1713894128.wav","LungSound","2024-04-23 17:42:08","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("203","2024042363370","2024042327186","patients/p_audio/HeartBeat_1713897411.wav","HeartBeat","2024-04-23 18:36:51","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("204","2024042474456","2024042441979","patients/p_audio/HeartBeat_1713979361.wav","HeartBeat","2024-04-24 17:22:41","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("205","2024042441794","2024042449889","patients/p_audio/HeartBeat_1713979875.wav","HeartBeat","2024-04-24 17:31:15","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("206","2024042469996","2024042438431","patients/p_audio/HeartBeat_1713985773.wav","HeartBeat","2024-04-24 19:09:33","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("207","2024042469996","2024042438431","patients/p_audio/HeartBeat_1713985828.wav","HeartBeat","2024-04-24 19:10:28","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("208","2024042469996","2024042438431","patients/p_audio/HeartBeat_1713985882.wav","HeartBeat","2024-04-24 19:11:22","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("209","2024042417328","2024042421440","patients/p_audio/HeartBeat_1713991297.wav","HeartBeat","2024-04-24 20:41:37","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("210","2024042585467","2024042540692","patients/p_audio/HeartBeat_1714053572.wav","HeartBeat","2024-04-25 13:59:32","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("211","2024042552948","2024042543478","patients/p_audio/HeartBeat_1714077669.wav","HeartBeat","2024-04-25 20:41:09","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("212","2024042689734","202404263528","patients/p_audio/HeartBeat_1714153807.wav","HeartBeat","2024-04-26 17:50:07","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("213","2024042764218","2024042720246","patients/p_audio/HeartBeat_1714227015.wav","HeartBeat","2024-04-27 14:10:15","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("214","2024042845605","2024042819479","patients/p_audio/LungSound_1714344878.wav","LungSound","2024-04-28 22:54:38","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("215","2024042845605","2024042819479","patients/p_audio/LungSound_1714344909.wav","LungSound","2024-04-28 22:55:09","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("216","2024042929929","2024042940862","patients/p_audio/HeartBeat_1714406488.wav","HeartBeat","2024-04-29 16:01:28","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("217","2024042964194","2024042939638","patients/p_audio/LungSound_1714411492.wav","LungSound","2024-04-29 17:24:52","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("218","2024042967570","2024042921881","patients/p_audio/LungSound_1714412977.wav","LungSound","2024-04-29 17:49:37","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("219","2024042967570","2024042921881","patients/p_audio/LungSound_1714412990.wav","LungSound","2024-04-29 17:49:50","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("220","2024042967570","2024042921881","patients/p_audio/HeartBeat_1714413030.wav","HeartBeat","2024-04-29 17:50:30","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("221","2024042986124","2024042947036","patients/p_audio/HeartBeat_1714417625.wav","HeartBeat","2024-04-29 19:07:05","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("222","2024042986124","2024042947036","patients/p_audio/LungSound_1714417677.wav","LungSound","2024-04-29 19:07:57","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("223","2024042920447","202404294342","patients/p_audio/HeartBeat_1714421460.wav","HeartBeat","2024-04-29 20:11:00","Humble","Humble");
INSERT INTO patients_audio VALUES("224","2024042920447","202404294342","patients/p_audio/HeartBeat_1714421494.wav","HeartBeat","2024-04-29 20:11:34","Humble","Humble");
INSERT INTO patients_audio VALUES("225","2024043061921","202404309194","patients/p_audio/HeartBeat_1714491309.wav","HeartBeat","2024-04-30 15:35:09","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("226","2024043025772","2024043029675","patients/p_audio/HeartBeat_1714493307.wav","HeartBeat","2024-04-30 16:08:27","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("227","2024043025772","2024043029675","patients/p_audio/HeartBeat_1714493326.wav","HeartBeat","2024-04-30 16:08:46","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("228","2024050136913","2024050147159","patients/p_audio/HeartBeat_1714576665.wav","HeartBeat","2024-05-01 15:17:45","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("229","2024050281944","202405022476","patients/p_audio/HeartBeat_1714657396.wav","HeartBeat","2024-05-02 13:43:16","Humble","Humble");
INSERT INTO patients_audio VALUES("230","2024050281944","202405022476","patients/p_audio/HeartBeat_1714657417.wav","HeartBeat","2024-05-02 13:43:37","Humble","Humble");
INSERT INTO patients_audio VALUES("231","2024050281944","202405022476","patients/p_audio/LungSound_1714657449.wav","LungSound","2024-05-02 13:44:09","Humble","Humble");
INSERT INTO patients_audio VALUES("232","2024050245679","2024050211685","patients/p_audio/HeartBeat_1714660159.wav","HeartBeat","2024-05-02 14:29:19","Humble","Humble");
INSERT INTO patients_audio VALUES("233","2024050253242","2024050235084","patients/p_audio/HeartBeat_1714663658.wav","HeartBeat","2024-05-02 15:27:38","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("234","2024050258178","202405025633","patients/p_audio/HeartBeat_1714670973.wav","HeartBeat","2024-05-02 17:29:33","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("235","2024050258178","202405025633","patients/p_audio/LungSound_1714671100.wav","LungSound","2024-05-02 17:31:40","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("236","2024050286445","2024050227127","patients/p_audio/HeartBeat_1714673711.wav","HeartBeat","2024-05-02 18:15:11","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("237","2024050286445","2024050227127","patients/p_audio/LungSound_1714673792.wav","LungSound","2024-05-02 18:16:32","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("238","2024050395801","202405031610","patients/p_audio/HeartBeat_1714748487.wav","HeartBeat","2024-05-03 15:01:27","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("239","2024050395801","202405031610","patients/p_audio/HeartBeat_1714748522.wav","HeartBeat","2024-05-03 15:02:02","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("240","2024050390402","2024050317706","patients/p_audio/HeartBeat_1714754971.wav","HeartBeat","2024-05-03 16:49:31","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("241","2024050363294","2024050345772","patients/p_audio/HeartBeat_1714760616.wav","HeartBeat","2024-05-03 18:23:36","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("242","2024050424446","2024050432700","patients/p_audio/HeartBeat_1714833891.wav","HeartBeat","2024-05-04 14:44:51","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("243","2024050424446","2024050432700","patients/p_audio/LungSound_1714833942.wav","LungSound","2024-05-04 14:45:42","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("244","2024050459411","2024050443801","patients/p_audio/HeartBeat_1714835093.wav","HeartBeat","2024-05-04 15:04:53","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("245","2024050459411","2024050443801","patients/p_audio/HeartBeat_1714835125.wav","HeartBeat","2024-05-04 15:05:25","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("246","2024050459411","2024050443801","patients/p_audio/HeartBeat_1714835157.wav","HeartBeat","2024-05-04 15:05:57","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("247","2024050437948","2024050445031","patients/p_audio/HeartBeat_1714836845.wav","HeartBeat","2024-05-04 15:34:05","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("248","2024050437948","2024050445031","patients/p_audio/HeartBeat_1714844153.wav","HeartBeat","2024-05-04 17:35:53","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("249","2024050475556","2024050428613","patients/p_audio/HeartBeat_1714851419.wav","HeartBeat","2024-05-04 19:36:59","Humble","Humble");
INSERT INTO patients_audio VALUES("250","2024050475556","2024050428613","patients/p_audio/HeartBeat_1714851456.wav","HeartBeat","2024-05-04 19:37:36","Humble","Humble");
INSERT INTO patients_audio VALUES("251","2024050487662","2024050446648","patients/p_audio/HeartBeat_1714853032.wav","HeartBeat","2024-05-04 20:03:52","Humble","Humble");
INSERT INTO patients_audio VALUES("252","2024050481063","2024050449849","patients/p_audio/HeartBeat_1714862548.wav","HeartBeat","2024-05-04 22:42:28","Humble","Humble");
INSERT INTO patients_audio VALUES("253","2024050481063","2024050449849","patients/p_audio/HeartBeat_1714862560.wav","HeartBeat","2024-05-04 22:42:40","Humble","Humble");
INSERT INTO patients_audio VALUES("254","2024050619268","2024050645415","patients/p_audio/HeartBeat_1715017291.wav","HeartBeat","2024-05-06 17:41:31","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("255","2024050619268","2024050645415","patients/p_audio/HeartBeat_1715017336.wav","HeartBeat","2024-05-06 17:42:16","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("256","2024050777390","2024050731698","patients/p_audio/HeartBeat_1715116482.wav","HeartBeat","2024-05-07 21:14:42","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("257","2024050777390","2024050731698","patients/p_audio/LungSound_1715116526.wav","LungSound","2024-05-07 21:15:26","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("258","2024050786148","2024050718827","patients/p_audio/HeartBeat_1715121888.wav","HeartBeat","2024-05-07 22:44:48","Humble","Humble");
INSERT INTO patients_audio VALUES("259","2024050916724","2024050916590","patients/p_audio/HeartBeat_1715276803.wav","HeartBeat","2024-05-09 17:46:43","Humble","Humble");
INSERT INTO patients_audio VALUES("260","2024051063770","2024051029432","patients/p_audio/HeartBeat_1715360912.wav","HeartBeat","2024-05-10 17:08:32","Humble","Humble");
INSERT INTO patients_audio VALUES("261","2024051063770","2024051029432","patients/p_audio/LungSound_1715360957.wav","LungSound","2024-05-10 17:09:17","Humble","Humble");
INSERT INTO patients_audio VALUES("262","2024051155440","202405113880","patients/p_audio/HeartBeat_1715437352.wav","HeartBeat","2024-05-11 14:22:32","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("263","2024051284334","2024051228747","patients/p_audio/HeartBeat_1715523568.wav","HeartBeat","2024-05-12 14:19:28","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("264","2024051215982","2024051233851","patients/p_audio/HeartBeat_1715535870.wav","HeartBeat","2024-05-12 17:44:30","Humble","Humble");
INSERT INTO patients_audio VALUES("265","2024051215982","2024051233851","patients/p_audio/HeartBeat_1715535887.wav","HeartBeat","2024-05-12 17:44:47","Humble","Humble");
INSERT INTO patients_audio VALUES("266","2024051215982","2024051233851","patients/p_audio/HeartBeat_1715535913.wav","HeartBeat","2024-05-12 17:45:13","Humble","Humble");
INSERT INTO patients_audio VALUES("267","2024051215982","2024051233851","patients/p_audio/LungSound_1715535996.wav","LungSound","2024-05-12 17:46:36","Humble","Humble");
INSERT INTO patients_audio VALUES("268","2024051215982","2024051233851","patients/p_audio/LungSound_1715536034.wav","LungSound","2024-05-12 17:47:14","Humble","Humble");
INSERT INTO patients_audio VALUES("269","2024051215982","2024051233851","patients/p_audio/LungSound_1715536076.wav","LungSound","2024-05-12 17:47:56","Humble","Humble");
INSERT INTO patients_audio VALUES("270","2024051215982","2024051233851","patients/p_audio/HeartBeat_1715536103.wav","HeartBeat","2024-05-12 17:48:23","Humble","Humble");
INSERT INTO patients_audio VALUES("271","2024051215982","2024051233851","patients/p_audio/HeartBeat_1715536133.wav","HeartBeat","2024-05-12 17:48:53","Humble","Humble");
INSERT INTO patients_audio VALUES("272","2024051229396","2024051224118","patients/p_audio/HeartBeat_1715539044.wav","HeartBeat","2024-05-12 18:37:24","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("273","2024051229396","2024051224118","patients/p_audio/LungSound_1715539117.wav","LungSound","2024-05-12 18:38:37","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("274","2024051250729","2024051243057","patients/p_audio/HeartBeat_1715543000.wav","HeartBeat","2024-05-12 19:43:20","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("275","2024051250729","2024051243057","patients/p_audio/LungSound_1715543054.wav","LungSound","2024-05-12 19:44:14","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("276","2024051416478","2024051448430","patients/p_audio/HeartBeat_1715714594.wav","HeartBeat","2024-05-14 19:23:14","Humble","Humble");
INSERT INTO patients_audio VALUES("277","2024051416478","2024051448430","patients/p_audio/LungSound_1715714615.wav","LungSound","2024-05-14 19:23:35","Humble","Humble");
INSERT INTO patients_audio VALUES("278","2024051488476","202405145848","patients/p_audio/HeartBeat_1715716262.wav","HeartBeat","2024-05-14 19:51:02","Humble","Humble");
INSERT INTO patients_audio VALUES("279","2024051488476","202405145848","patients/p_audio/HeartBeat_1715716336.wav","HeartBeat","2024-05-14 19:52:16","Humble","Humble");
INSERT INTO patients_audio VALUES("280","2024051594476","2024051538265","patients/p_audio/HeartBeat_1715775228.wav","HeartBeat","2024-05-15 12:13:48","VAM","VAM");
INSERT INTO patients_audio VALUES("281","2024051560221","2024051523889","patients/p_audio/LungSound_1715784397.wav","LungSound","2024-05-15 14:46:37","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("282","2024051565268","2024051518753","patients/p_audio/HeartBeat_1715795928.wav","HeartBeat","2024-05-15 17:58:48","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("283","2024051565268","2024051518753","patients/p_audio/HeartBeat_1715796013.wav","HeartBeat","2024-05-15 18:00:13","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("284","2024051565268","2024051518753","patients/p_audio/HeartBeat_1715796071.wav","HeartBeat","2024-05-15 18:01:11","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("285","2024051565268","2024051518753","patients/p_audio/HeartBeat_1715796281.wav","HeartBeat","2024-05-15 18:04:41","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("286","2024051565268","2024051518753","patients/p_audio/HeartBeat_1715796312.wav","HeartBeat","2024-05-15 18:05:12","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("287","2024051565268","2024051518753","patients/p_audio/HeartBeat_1715796404.wav","HeartBeat","2024-05-15 18:06:44","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("288","2024051565268","2024051518753","patients/p_audio/HeartBeat_1715796432.wav","HeartBeat","2024-05-15 18:07:12","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("289","2024051565268","2024051518753","patients/p_audio/HeartBeat_1715796457.wav","HeartBeat","2024-05-15 18:07:37","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("290","2024051597299","202405154995","patients/p_audio/HeartBeat_1715797223.wav","HeartBeat","2024-05-15 18:20:23","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("291","2024051563472","2024051547022","patients/p_audio/HeartBeat_1715801070.wav","HeartBeat","2024-05-15 19:24:30","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("292","2024051563472","2024051547022","patients/p_audio/HeartBeat_1715801112.wav","HeartBeat","2024-05-15 19:25:12","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("293","2024051544383","202405157843","patients/p_audio/HeartBeat_1715805984.wav","HeartBeat","2024-05-15 20:46:24","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("294","2024051544383","202405157843","patients/p_audio/HeartBeat_1715806007.wav","HeartBeat","2024-05-15 20:46:47","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("295","2024051651458","202405162800","patients/p_audio/HeartBeat_1715872785.wav","HeartBeat","2024-05-16 15:19:45","Palmas","Palmas");
INSERT INTO patients_audio VALUES("296","2024051651458","202405162800","patients/p_audio/HeartBeat_1715872950.wav","HeartBeat","2024-05-16 15:22:30","Palmas","Palmas");
INSERT INTO patients_audio VALUES("297","2024051625585","2024051644094","patients/p_audio/HeartBeat_1715876605.wav","HeartBeat","2024-05-16 16:23:25","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("298","2024051732896","202405171872","patients/p_audio/LungSound_1715964187.wav","LungSound","2024-05-17 16:43:07","Palmas","Palmas");
INSERT INTO patients_audio VALUES("299","2024051878610","202405182288","patients/p_audio/HeartBeat_1716062551.wav","HeartBeat","2024-05-18 20:02:31","Humble","Humble");
INSERT INTO patients_audio VALUES("300","2024051878610","202405182288","patients/p_audio/HeartBeat_1716062581.wav","HeartBeat","2024-05-18 20:03:01","Humble","Humble");
INSERT INTO patients_audio VALUES("301","2024051878610","202405182288","patients/p_audio/LungSound_1716062611.wav","LungSound","2024-05-18 20:03:31","Humble","Humble");
INSERT INTO patients_audio VALUES("302","2024051811473","2024051832511","patients/p_audio/HeartBeat_1716063306.wav","HeartBeat","2024-05-18 20:15:06","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("303","2024052012888","2024052018057","patients/p_audio/LungSound_1716216354.wav","LungSound","2024-05-20 14:45:54","Palmas","Palmas");
INSERT INTO patients_audio VALUES("304","2024052073528","202405206057","patients/p_audio/HeartBeat_1716221073.wav","HeartBeat","2024-05-20 16:04:33","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("305","2024052073528","202405206057","patients/p_audio/LungSound_1716221113.wav","LungSound","2024-05-20 16:05:13","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("306","2024052033915","2024052046776","patients/p_audio/HeartBeat_1716232145.wav","HeartBeat","2024-05-20 19:09:05","Humble","Humble");
INSERT INTO patients_audio VALUES("307","2024052033915","2024052046776","patients/p_audio/LungSound_1716232172.wav","LungSound","2024-05-20 19:09:32","Humble","Humble");
INSERT INTO patients_audio VALUES("308","2024052127287","2024052116544","patients/p_audio/HeartBeat_1716304873.wav","HeartBeat","2024-05-21 15:21:13","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("309","2024052148535","2024052142827","patients/p_audio/HeartBeat_1716306091.wav","HeartBeat","2024-05-21 15:41:31","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("310","2024052148535","2024052142827","patients/p_audio/LungSound_1716306133.wav","LungSound","2024-05-21 15:42:13","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("311","2024052226408","2024052231059","patients/p_audio/HeartBeat_1716408402.wav","HeartBeat","2024-05-22 20:06:42","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("312","2024052226408","2024052231059","patients/p_audio/LungSound_1716408476.wav","LungSound","2024-05-22 20:07:56","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("313","2024052333810","202405231817","patients/p_audio/HeartBeat_1716478231.wav","HeartBeat","2024-05-23 15:30:31","Humble","Humble");
INSERT INTO patients_audio VALUES("314","2024052333810","202405231817","patients/p_audio/HeartBeat_1716478291.wav","HeartBeat","2024-05-23 15:31:31","Humble","Humble");
INSERT INTO patients_audio VALUES("315","2024052333810","202405231817","patients/p_audio/LungSound_1716478316.wav","LungSound","2024-05-23 15:31:56","Humble","Humble");
INSERT INTO patients_audio VALUES("316","2024052372672","2024052346642","patients/p_audio/LungSound_1716488678.wav","LungSound","2024-05-23 18:24:38","Palmas","Palmas");
INSERT INTO patients_audio VALUES("317","2024052372672","2024052346642","patients/p_audio/HeartBeat_1716488741.wav","HeartBeat","2024-05-23 18:25:41","Palmas","Palmas");
INSERT INTO patients_audio VALUES("318","2024052348909","2024052324161","patients/p_audio/LungSound_1716490053.wav","LungSound","2024-05-23 18:47:33","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("319","2024052348909","2024052324161","patients/p_audio/LungSound_1716490075.wav","LungSound","2024-05-23 18:47:55","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("320","2024052352139","2024052335079","patients/p_audio/LungSound_1716491659.wav","LungSound","2024-05-23 19:14:19","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("321","2024052369317","2024052340534","patients/p_audio/HeartBeat_1716504961.wav","HeartBeat","2024-05-23 22:56:01","Humble","Humble");
INSERT INTO patients_audio VALUES("322","2024052436514","2024052449281","patients/p_audio/HeartBeat_1716589149.wav","HeartBeat","2024-05-24 22:19:09","Humble","Humble");
INSERT INTO patients_audio VALUES("323","2024052436514","2024052449281","patients/p_audio/LungSound_1716589185.wav","LungSound","2024-05-24 22:19:45","Humble","Humble");
INSERT INTO patients_audio VALUES("324","2024052522724","2024052517529","patients/p_audio/HeartBeat_1716646805.wav","HeartBeat","2024-05-25 14:20:05","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("325","2024053014091","2024053040128","patients/p_audio/HeartBeat_1717082437.wav","HeartBeat","2024-05-30 15:20:37","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("326","2024053157099","2024053124122","patients/p_audio/HeartBeat_1717178455.wav","HeartBeat","2024-05-31 18:00:55","Humble","Humble");
INSERT INTO patients_audio VALUES("327","2024053157099","2024053124122","patients/p_audio/LungSound_1717178494.wav","LungSound","2024-05-31 18:01:34","Humble","Humble");
INSERT INTO patients_audio VALUES("328","2024053196899","2024053139919","patients/p_audio/HeartBeat_1717183133.wav","HeartBeat","2024-05-31 19:18:53","Humble","Humble");
INSERT INTO patients_audio VALUES("329","2024053196899","2024053139919","patients/p_audio/LungSound_1717183170.wav","LungSound","2024-05-31 19:19:30","Humble","Humble");
INSERT INTO patients_audio VALUES("330","2024060150225","202406014165","patients/p_audio/HeartBeat_1717260774.wav","HeartBeat","2024-06-01 16:52:54","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("331","2024060316718","2024060329865","patients/p_audio/HeartBeat_1717427817.wav","HeartBeat","2024-06-03 15:16:57","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("332","2024060373940","202406036105","patients/p_audio/LungSound_1717432609.wav","LungSound","2024-06-03 16:36:49","Palmas","Palmas");
INSERT INTO patients_audio VALUES("333","2024060378302","2024060321064","patients/p_audio/HeartBeat_1717434661.wav","HeartBeat","2024-06-03 17:11:01","Humble","Humble");
INSERT INTO patients_audio VALUES("334","2024060378302","2024060321064","patients/p_audio/LungSound_1717434703.wav","LungSound","2024-06-03 17:11:43","Humble","Humble");
INSERT INTO patients_audio VALUES("335","2024060377283","2024060324290","patients/p_audio/HeartBeat_1717449096.wav","HeartBeat","2024-06-03 21:11:36","Humble","Humble");
INSERT INTO patients_audio VALUES("336","2024060377283","2024060324290","patients/p_audio/LungSound_1717449134.wav","LungSound","2024-06-03 21:12:14","Humble","Humble");
INSERT INTO patients_audio VALUES("337","2024060416733","2024060442116","patients/p_audio/HeartBeat_1717514944.wav","HeartBeat","2024-06-04 15:29:04","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("338","2024060880104","20240608167","patients/p_audio/HeartBeat_1717862326.wav","HeartBeat","2024-06-08 15:58:46","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("339","2024060837402","2024060842670","patients/p_audio/HeartBeat_1717862330.wav","HeartBeat","2024-06-08 15:58:50","Humble","Humble");
INSERT INTO patients_audio VALUES("340","2024060837402","2024060842670","patients/p_audio/LungSound_1717862359.wav","LungSound","2024-06-08 15:59:19","Humble","Humble");
INSERT INTO patients_audio VALUES("341","2024060854045","2024060818672","patients/p_audio/HeartBeat_1717862669.wav","HeartBeat","2024-06-08 16:04:29","Humble","Humble");
INSERT INTO patients_audio VALUES("342","2024061044101","2024061014364","patients/p_audio/HeartBeat_1718034022.wav","HeartBeat","2024-06-10 15:40:22","Palmas Del Mar","Reza");
INSERT INTO patients_audio VALUES("343","2024061086627","2024061022121","patients/p_audio/HeartBeat_1718034773.wav","HeartBeat","2024-06-10 15:52:53","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("344","2024061216277","2024061221319","patients/p_audio/HeartBeat_1718200981.wav","HeartBeat","2024-06-12 14:03:01","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("345","2024061249533","2024061227965","patients/p_audio/HeartBeat_1718212612.wav","HeartBeat","2024-06-12 17:16:52","Humble","Humble");
INSERT INTO patients_audio VALUES("346","2024061249533","2024061227965","patients/p_audio/LungSound_1718212642.wav","LungSound","2024-06-12 17:17:22","Humble","Humble");
INSERT INTO patients_audio VALUES("347","2024061384884","2024061311452","patients/p_audio/HeartBeat_1718288419.wav","HeartBeat","2024-06-13 14:20:19","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("348","2024061317417","2024061343755","patients/p_audio/HeartBeat_1718319667.wav","HeartBeat","2024-06-13 23:01:07","Humble","Humble");
INSERT INTO patients_audio VALUES("349","2024061317417","2024061343755","patients/p_audio/LungSound_1718319705.wav","LungSound","2024-06-13 23:01:45","Humble","Humble");
INSERT INTO patients_audio VALUES("350","2024061473198","2024061413755","patients/p_audio/HeartBeat_1718370580.wav","HeartBeat","2024-06-14 13:09:40","Palmas Del Mar","Reza");
INSERT INTO patients_audio VALUES("351","2024061510909","202406153038","patients/p_audio/HeartBeat_1718476308.wav","HeartBeat","2024-06-15 18:31:48","Humble","Humble");
INSERT INTO patients_audio VALUES("352","2024061586062","2024061540563","patients/p_audio/HeartBeat_1718476679.wav","HeartBeat","2024-06-15 18:37:59","Humble","Humble");
INSERT INTO patients_audio VALUES("353","2024061644644","2024061633458","patients/p_audio/HeartBeat_1718552579.wav","HeartBeat","2024-06-16 15:42:59","Humble","Humble");
INSERT INTO patients_audio VALUES("354","2024062171458","2024062128407","patients/p_audio/HeartBeat_1719001012.wav","HeartBeat","2024-06-21 20:16:52","Palmas","Palmas");
INSERT INTO patients_audio VALUES("355","2024062171458","2024062128407","patients/p_audio/HeartBeat_1719001031.wav","HeartBeat","2024-06-21 20:17:11","Palmas","Palmas");
INSERT INTO patients_audio VALUES("356","2024062171458","2024062128407","patients/p_audio/LungSound_1719001048.wav","LungSound","2024-06-21 20:17:28","Palmas","Palmas");
INSERT INTO patients_audio VALUES("357","2024062295952","2024062216390","patients/p_audio/LungSound_1719079657.wav","LungSound","2024-06-22 18:07:37","Humble","Humble");
INSERT INTO patients_audio VALUES("358","2024062525827","2024062518804","patients/p_audio/HeartBeat_1719331364.wav","HeartBeat","2024-06-25 16:02:44","Palmas","Palmas");
INSERT INTO patients_audio VALUES("359","2024062525827","2024062518804","patients/p_audio/LungSound_1719331473.wav","LungSound","2024-06-25 16:04:33","Palmas","Palmas");
INSERT INTO patients_audio VALUES("360","2024062572746","2024062544588","patients/p_audio/HeartBeat_1719331692.wav","HeartBeat","2024-06-25 16:08:12","Palmas","Palmas");
INSERT INTO patients_audio VALUES("361","2024062572746","2024062544588","patients/p_audio/LungSound_1719331771.wav","LungSound","2024-06-25 16:09:31","Palmas","Palmas");
INSERT INTO patients_audio VALUES("362","2024062675883","2024062620877","patients/p_audio/HeartBeat_1719421289.wav","HeartBeat","2024-06-26 17:01:29","Humble","Humble");
INSERT INTO patients_audio VALUES("363","2024062675883","2024062620877","patients/p_audio/LungSound_1719421333.wav","LungSound","2024-06-26 17:02:13","Humble","Humble");
INSERT INTO patients_audio VALUES("364","2024062625932","2024062630620","patients/p_audio/HeartBeat_1719423215.wav","HeartBeat","2024-06-26 17:33:35","Humble","Humble");
INSERT INTO patients_audio VALUES("365","2024062625932","2024062630620","patients/p_audio/LungSound_1719423235.wav","LungSound","2024-06-26 17:33:55","Humble","Humble");
INSERT INTO patients_audio VALUES("366","2024062625932","2024062630620","patients/p_audio/LungSound_1719423283.wav","LungSound","2024-06-26 17:34:43","Humble","Humble");
INSERT INTO patients_audio VALUES("367","2024062732173","202406278635","patients/p_audio/HeartBeat_1719522139.wav","HeartBeat","2024-06-27 21:02:19","Humble","Humble");
INSERT INTO patients_audio VALUES("368","2024062732173","202406278635","patients/p_audio/LungSound_1719522174.wav","LungSound","2024-06-27 21:02:54","Humble","Humble");
INSERT INTO patients_audio VALUES("369","2024062957767","2024062948946","patients/p_audio/HeartBeat_1719678037.wav","HeartBeat","2024-06-29 16:20:37","Humble","Humble");
INSERT INTO patients_audio VALUES("370","2024062912297","2024062943530","patients/p_audio/HeartBeat_1719679343.wav","HeartBeat","2024-06-29 16:42:23","Humble","Humble");
INSERT INTO patients_audio VALUES("371","2024063032792","2024063035541","patients/p_audio/HeartBeat_1719756062.wav","HeartBeat","2024-06-30 14:01:02","Humble","Humble");
INSERT INTO patients_audio VALUES("372","2024063015657","2024063027122","patients/p_audio/HeartBeat_1719760517.wav","HeartBeat","2024-06-30 15:15:17","Humble","Humble");
INSERT INTO patients_audio VALUES("373","2024070185971","2024070116512","patients/p_audio/HeartBeat_1719863316.wav","HeartBeat","2024-07-01 19:48:36","Humble","Humble");
INSERT INTO patients_audio VALUES("374","2024070185971","2024070116512","patients/p_audio/LungSound_1719863360.wav","LungSound","2024-07-01 19:49:20","Humble","Humble");
INSERT INTO patients_audio VALUES("375","2024070580177","2024070518536","patients/p_audio/HeartBeat_1720191506.wav","HeartBeat","2024-07-05 14:58:26","Humble","Humble");
INSERT INTO patients_audio VALUES("376","2024070580177","2024070518536","patients/p_audio/LungSound_1720191542.wav","LungSound","2024-07-05 14:59:02","Humble","Humble");
INSERT INTO patients_audio VALUES("377","2024070546067","2024070526566","patients/p_audio/HeartBeat_1720209523.wav","HeartBeat","2024-07-05 19:58:43","Humble","Humble");
INSERT INTO patients_audio VALUES("378","2024070546067","2024070526566","patients/p_audio/LungSound_1720209555.wav","LungSound","2024-07-05 19:59:15","Humble","Humble");
INSERT INTO patients_audio VALUES("379","2024070730995","2024070748594","patients/p_audio/HeartBeat_1720379850.wav","HeartBeat","2024-07-07 19:17:30","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("380","2024070730995","2024070748594","patients/p_audio/LungSound_1720379893.wav","LungSound","2024-07-07 19:18:13","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("381","2024070725129","2024070732978","patients/p_audio/HeartBeat_1720385180.wav","HeartBeat","2024-07-07 20:46:20","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("382","2024070725129","2024070732978","patients/p_audio/LungSound_1720385229.wav","LungSound","2024-07-07 20:47:09","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("383","2024071192288","2024071120153","patients/p_audio/HeartBeat_1720724277.wav","HeartBeat","2024-07-11 18:57:57","Humble","Humble");
INSERT INTO patients_audio VALUES("384","2024071192288","2024071120153","patients/p_audio/LungSound_1720724315.wav","LungSound","2024-07-11 18:58:35","Humble","Humble");
INSERT INTO patients_audio VALUES("385","2024071153278","2024071111941","patients/p_audio/HeartBeat_1720726232.wav","HeartBeat","2024-07-11 19:30:32","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("386","2024071153278","2024071111941","patients/p_audio/LungSound_1720726271.wav","LungSound","2024-07-11 19:31:11","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("387","2024071290503","2024071239304","patients/p_audio/HeartBeat_1720794415.wav","HeartBeat","2024-07-12 14:26:55","Humble","Humble");
INSERT INTO patients_audio VALUES("388","2024071290503","2024071239304","patients/p_audio/LungSound_1720794449.wav","LungSound","2024-07-12 14:27:29","Humble","Humble");
INSERT INTO patients_audio VALUES("389","2024071235456","2024071229122","patients/p_audio/HeartBeat_1720796833.wav","HeartBeat","2024-07-12 15:07:13","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("390","2024071235456","2024071229122","patients/p_audio/LungSound_1720796887.wav","LungSound","2024-07-12 15:08:07","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("391","2024071235872","2024071218394","patients/p_audio/HeartBeat_1720798578.wav","HeartBeat","2024-07-12 15:36:18","Humble","Humble");
INSERT INTO patients_audio VALUES("392","2024071235872","2024071218394","patients/p_audio/LungSound_1720798633.wav","LungSound","2024-07-12 15:37:13","Humble","Humble");
INSERT INTO patients_audio VALUES("393","2024071268382","2024071239120","patients/p_audio/HeartBeat_1720825742.wav","HeartBeat","2024-07-12 23:09:02","Humble","Humble");
INSERT INTO patients_audio VALUES("394","2024071268382","2024071239120","patients/p_audio/LungSound_1720825746.wav","LungSound","2024-07-12 23:09:06","Humble","Humble");
INSERT INTO patients_audio VALUES("395","2024071268382","2024071239120","patients/p_audio/LungSound_1720825774.wav","LungSound","2024-07-12 23:09:34","Humble","Humble");
INSERT INTO patients_audio VALUES("396","2024071320876","2024071315003","patients/p_audio/HeartBeat_1720878511.wav","HeartBeat","2024-07-13 13:48:31","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("397","2024071320876","2024071315003","patients/p_audio/LungSound_1720878530.wav","LungSound","2024-07-13 13:48:50","Waco","Dr. Marvel");
INSERT INTO patients_audio VALUES("398","2024071324725","2024071335578","patients/p_audio/LungSound_1720891238.wav","LungSound","2024-07-13 17:20:38","Humble","Humble");
INSERT INTO patients_audio VALUES("399","2024071429902","2024071445794","patients/p_audio/HeartBeat_1720965863.wav","HeartBeat","2024-07-14 14:04:23","Humble","Humble");
INSERT INTO patients_audio VALUES("400","2024071617143","202407169587","patients/p_audio/HeartBeat_1721168882.wav","HeartBeat","2024-07-16 22:28:02","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("401","2024071617143","202407169587","patients/p_audio/LungSound_1721168923.wav","LungSound","2024-07-16 22:28:43","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("402","2024071777370","2024071726855","patients/p_audio/HeartBeat_1721242076.wav","HeartBeat","2024-07-17 18:47:56","Humble","Humble");
INSERT INTO patients_audio VALUES("403","2024071777370","2024071726855","patients/p_audio/LungSound_1721242108.wav","LungSound","2024-07-17 18:48:28","Humble","Humble");
INSERT INTO patients_audio VALUES("404","2024071755356","2024071743809","patients/p_audio/HeartBeat_1721247019.wav","HeartBeat","2024-07-17 20:10:19","Humble","Humble");
INSERT INTO patients_audio VALUES("405","2024071755356","2024071743809","patients/p_audio/LungSound_1721247056.wav","LungSound","2024-07-17 20:10:56","Humble","Humble");
INSERT INTO patients_audio VALUES("406","2024071793156","202407171317","patients/p_audio/HeartBeat_1721251482.wav","HeartBeat","2024-07-17 21:24:42","Humble","Humble");
INSERT INTO patients_audio VALUES("407","2024071793156","202407171317","patients/p_audio/LungSound_1721251512.wav","LungSound","2024-07-17 21:25:12","Humble","Humble");
INSERT INTO patients_audio VALUES("408","2024071713692","2024071740573","patients/p_audio/HeartBeat_1721254146.wav","HeartBeat","2024-07-17 22:09:06","Humble","Humble");
INSERT INTO patients_audio VALUES("409","2024071713692","2024071740573","patients/p_audio/LungSound_1721254186.wav","LungSound","2024-07-17 22:09:46","Humble","Humble");
INSERT INTO patients_audio VALUES("410","2024071754028","2024071733963","patients/p_audio/HeartBeat_1721255945.wav","HeartBeat","2024-07-17 22:39:05","Humble","Humble");
INSERT INTO patients_audio VALUES("411","2024071754028","2024071733963","patients/p_audio/LungSound_1721255983.wav","LungSound","2024-07-17 22:39:43","Humble","Humble");
INSERT INTO patients_audio VALUES("412","2024071822034","2024071830442","patients/p_audio/HeartBeat_1721339241.wav","HeartBeat","2024-07-18 21:47:21","Humble","Humble");
INSERT INTO patients_audio VALUES("413","2024071822034","2024071830442","patients/p_audio/LungSound_1721339283.wav","LungSound","2024-07-18 21:48:03","Humble","Humble");
INSERT INTO patients_audio VALUES("414","2024072031387","202407209155","patients/p_audio/HeartBeat_1721486342.wav","HeartBeat","2024-07-20 14:39:02","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("415","2024072046283","2024072016883","patients/p_audio/HeartBeat_1721497491.wav","HeartBeat","2024-07-20 17:44:51","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("416","2024072046283","2024072016883","patients/p_audio/LungSound_1721497539.wav","LungSound","2024-07-20 17:45:39","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("417","2024072025599","2024072038096","patients/p_audio/HeartBeat_1721510161.wav","HeartBeat","2024-07-20 21:16:01","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("418","2024072025599","2024072038096","patients/p_audio/LungSound_1721510210.wav","LungSound","2024-07-20 21:16:50","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("419","2024072293562","2024072227143","patients/p_audio/LungSound_1721662677.wav","LungSound","2024-07-22 15:37:57","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("420","2024072293562","2024072227143","patients/p_audio/HeartBeat_1721662711.wav","HeartBeat","2024-07-22 15:38:31","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("421","2024072292370","2024072238831","patients/p_audio/HeartBeat_1721663974.wav","HeartBeat","2024-07-22 15:59:34","Palmas","Palmas");
INSERT INTO patients_audio VALUES("422","2024072292370","2024072238831","patients/p_audio/LungSound_1721664070.wav","LungSound","2024-07-22 16:01:10","Palmas","Palmas");
INSERT INTO patients_audio VALUES("423","2024072269950","2024072240837","patients/p_audio/HeartBeat_1721669861.wav","HeartBeat","2024-07-22 17:37:41","Humble","Humble");
INSERT INTO patients_audio VALUES("424","2024072269950","2024072240837","patients/p_audio/LungSound_1721669900.wav","LungSound","2024-07-22 17:38:20","Humble","Humble");
INSERT INTO patients_audio VALUES("425","2024072429393","2024072413951","patients/p_audio/HeartBeat_1721858554.wav","HeartBeat","2024-07-24 22:02:34","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("426","2024072547036","202407257628","patients/p_audio/HeartBeat_1721928711.wav","HeartBeat","2024-07-25 17:31:51","Humble","Humble");
INSERT INTO patients_audio VALUES("427","2024072547036","202407257628","patients/p_audio/LungSound_1721928756.wav","LungSound","2024-07-25 17:32:36","Humble","Humble");
INSERT INTO patients_audio VALUES("428","2024072547611","2024072540995","patients/p_audio/HeartBeat_1721944932.wav","HeartBeat","2024-07-25 22:02:12","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("429","2024072547611","2024072540995","patients/p_audio/LungSound_1721944977.wav","LungSound","2024-07-25 22:02:57","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("430","2024072659414","20240726162","patients/p_audio/LungSound_1722005948.wav","LungSound","2024-07-26 14:59:08","Palmas","Palmas");
INSERT INTO patients_audio VALUES("431","2024072659414","20240726162","patients/p_audio/LungSound_1722006028.wav","LungSound","2024-07-26 15:00:28","Palmas","Palmas");
INSERT INTO patients_audio VALUES("432","2024072659414","20240726162","patients/p_audio/HeartBeat_1722006065.wav","HeartBeat","2024-07-26 15:01:05","Palmas","Palmas");
INSERT INTO patients_audio VALUES("433","2024072647914","2024072616216","patients/p_audio/HeartBeat_1722008525.wav","HeartBeat","2024-07-26 15:42:05","Humble","Humble");
INSERT INTO patients_audio VALUES("434","2024072647914","2024072616216","patients/p_audio/LungSound_1722008570.wav","LungSound","2024-07-26 15:42:50","Humble","Humble");
INSERT INTO patients_audio VALUES("435","2024072622710","2024072632800","patients/p_audio/HeartBeat_1722013446.wav","HeartBeat","2024-07-26 17:04:06","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("436","2024072622710","2024072632800","patients/p_audio/LungSound_1722013507.wav","LungSound","2024-07-26 17:05:07","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("437","2024072638102","2024072611697","patients/p_audio/HeartBeat_1722019280.wav","HeartBeat","2024-07-26 18:41:20","Humble","Humble");
INSERT INTO patients_audio VALUES("438","2024072638102","2024072611697","patients/p_audio/LungSound_1722019330.wav","LungSound","2024-07-26 18:42:10","Humble","Humble");
INSERT INTO patients_audio VALUES("439","2024072672549","202407266955","patients/p_audio/HeartBeat_1722024804.wav","HeartBeat","2024-07-26 20:13:24","Humble","Humble");
INSERT INTO patients_audio VALUES("440","2024072672549","202407266955","patients/p_audio/LungSound_1722024835.wav","LungSound","2024-07-26 20:13:55","Humble","Humble");
INSERT INTO patients_audio VALUES("441","2024072675224","202407269481","patients/p_audio/HeartBeat_1722027626.wav","HeartBeat","2024-07-26 21:00:26","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("442","2024072675224","202407269481","patients/p_audio/LungSound_1722027671.wav","LungSound","2024-07-26 21:01:11","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("443","2024072613650","2024072632579","patients/p_audio/HeartBeat_1722033592.wav","HeartBeat","2024-07-26 22:39:52","Humble","Humble");
INSERT INTO patients_audio VALUES("444","2024072613650","2024072632579","patients/p_audio/LungSound_1722033632.wav","LungSound","2024-07-26 22:40:32","Humble","Humble");
INSERT INTO patients_audio VALUES("445","2024072940267","2024072930617","patients/p_audio/HeartBeat_1722267517.wav","HeartBeat","2024-07-29 15:38:37","Humble","Humble");
INSERT INTO patients_audio VALUES("446","2024072940267","2024072930617","patients/p_audio/LungSound_1722267549.wav","LungSound","2024-07-29 15:39:09","Humble","Humble");
INSERT INTO patients_audio VALUES("447","2024072926556","2024072940501","patients/p_audio/HeartBeat_1722282166.wav","HeartBeat","2024-07-29 19:42:46","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("448","2024072926556","2024072940501","patients/p_audio/LungSound_1722282219.wav","LungSound","2024-07-29 19:43:39","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("449","2024072929355","2024072936332","patients/p_audio/HeartBeat_1722289429.wav","HeartBeat","2024-07-29 21:43:49","Humble","Humble");
INSERT INTO patients_audio VALUES("450","2024072929355","2024072936332","patients/p_audio/LungSound_1722289477.wav","LungSound","2024-07-29 21:44:37","Humble","Humble");
INSERT INTO patients_audio VALUES("451","2024072985214","2024072944437","patients/p_audio/HeartBeat_1722293583.wav","HeartBeat","2024-07-29 22:53:03","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("452","2024072985214","2024072944437","patients/p_audio/LungSound_1722293628.wav","LungSound","2024-07-29 22:53:48","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("453","2024073022963","2024073031766","patients/p_audio/HeartBeat_1722353563.wav","HeartBeat","2024-07-30 15:32:43","Humble","Humble");
INSERT INTO patients_audio VALUES("454","2024073022963","2024073031766","patients/p_audio/LungSound_1722353604.wav","LungSound","2024-07-30 15:33:24","Humble","Humble");
INSERT INTO patients_audio VALUES("455","2024073010394","2024073047768","patients/p_audio/HeartBeat_1722372236.wav","HeartBeat","2024-07-30 20:43:56","Humble","Humble");
INSERT INTO patients_audio VALUES("456","2024073010394","2024073047768","patients/p_audio/LungSound_1722372285.wav","LungSound","2024-07-30 20:44:45","Humble","Humble");
INSERT INTO patients_audio VALUES("457","2024073112259","20240731813","patients/p_audio/HeartBeat_1722448289.wav","HeartBeat","2024-07-31 17:51:29","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("458","2024073112259","20240731813","patients/p_audio/LungSound_1722448354.wav","LungSound","2024-07-31 17:52:34","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("459","2024073187988","2024073140136","patients/p_audio/HeartBeat_1722449997.wav","HeartBeat","2024-07-31 18:19:57","Humble","Humble");
INSERT INTO patients_audio VALUES("460","2024073187988","2024073140136","patients/p_audio/LungSound_1722450033.wav","LungSound","2024-07-31 18:20:33","Humble","Humble");
INSERT INTO patients_audio VALUES("461","2024080147658","2024080135319","patients/p_audio/HeartBeat_1722524963.wav","HeartBeat","2024-08-01 15:09:23","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("462","2024080147658","2024080135319","patients/p_audio/LungSound_1722525010.wav","LungSound","2024-08-01 15:10:10","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("463","2024080177561","2024080146473","patients/p_audio/HeartBeat_1722527223.wav","HeartBeat","2024-08-01 15:47:03","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("464","2024080177561","2024080146473","patients/p_audio/LungSound_1722527270.wav","LungSound","2024-08-01 15:47:50","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("465","2024080115545","2024080131279","patients/p_audio/HeartBeat_1722545350.wav","HeartBeat","2024-08-01 20:49:10","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("466","2024080115545","2024080131279","patients/p_audio/LungSound_1722545387.wav","LungSound","2024-08-01 20:49:47","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("467","2024080211659","2024080246941","patients/p_audio/HeartBeat_1722615720.wav","HeartBeat","2024-08-02 16:22:00","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("468","2024080211659","2024080246941","patients/p_audio/LungSound_1722615779.wav","LungSound","2024-08-02 16:22:59","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("469","2024080246776","2024080237580","patients/p_audio/HeartBeat_1722636582.wav","HeartBeat","2024-08-02 22:09:42","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("470","2024080246776","2024080237580","patients/p_audio/LungSound_1722636620.wav","LungSound","2024-08-02 22:10:20","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("471","2024080323497","202408038862","patients/p_audio/HeartBeat_1722695272.wav","HeartBeat","2024-08-03 14:27:52","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("472","2024080367487","2024080312356","patients/p_audio/HeartBeat_1722703837.wav","HeartBeat","2024-08-03 16:50:37","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("473","2024080367487","2024080312356","patients/p_audio/LungSound_1722703888.wav","LungSound","2024-08-03 16:51:28","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("474","2024080332527","2024080332286","patients/p_audio/LungSound_1722704404.wav","LungSound","2024-08-03 17:00:04","Humble","Humble");
INSERT INTO patients_audio VALUES("475","2024080330275","2024080344882","patients/p_audio/HeartBeat_1722709351.wav","HeartBeat","2024-08-03 18:22:31","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("476","2024080330275","2024080344882","patients/p_audio/LungSound_1722709428.wav","LungSound","2024-08-03 18:23:48","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("477","2024080499034","2024080441428","patients/p_audio/HeartBeat_1722782410.wav","HeartBeat","2024-08-04 14:40:10","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("478","2024080493854","2024080428066","patients/p_audio/HeartBeat_1722802517.wav","HeartBeat","2024-08-04 20:15:17","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("479","2024080493854","2024080428066","patients/p_audio/LungSound_1722802553.wav","LungSound","2024-08-04 20:15:53","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("480","2024080444255","2024080447176","patients/p_audio/HeartBeat_1722811097.wav","HeartBeat","2024-08-04 22:38:17","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("481","2024080444255","2024080447176","patients/p_audio/LungSound_1722811137.wav","LungSound","2024-08-04 22:38:57","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("482","2024080522358","2024080543714","patients/p_audio/HeartBeat_1722872720.wav","HeartBeat","2024-08-05 15:45:20","Humble","Humble");
INSERT INTO patients_audio VALUES("483","2024080522358","2024080543714","patients/p_audio/LungSound_1722872760.wav","LungSound","2024-08-05 15:46:00","Humble","Humble");
INSERT INTO patients_audio VALUES("484","2024080548687","202408051300","patients/p_audio/HeartBeat_1722880920.wav","HeartBeat","2024-08-05 18:02:00","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("485","2024080548687","202408051300","patients/p_audio/LungSound_1722880957.wav","LungSound","2024-08-05 18:02:37","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("486","2024080598542","2024080510290","patients/p_audio/HeartBeat_1722882928.wav","HeartBeat","2024-08-05 18:35:28","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("487","2024080598542","2024080510290","patients/p_audio/HeartBeat_1722882967.wav","HeartBeat","2024-08-05 18:36:07","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("488","2024080598542","2024080510290","patients/p_audio/LungSound_1722883008.wav","LungSound","2024-08-05 18:36:48","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("489","2024080527174","2024080525223","patients/p_audio/HeartBeat_1722892875.wav","HeartBeat","2024-08-05 21:21:15","Humble","Humble");
INSERT INTO patients_audio VALUES("490","2024080527174","2024080525223","patients/p_audio/LungSound_1722892911.wav","LungSound","2024-08-05 21:21:51","Humble","Humble");
INSERT INTO patients_audio VALUES("491","2024080533424","202408054684","patients/p_audio/HeartBeat_1722896975.wav","HeartBeat","2024-08-05 22:29:35","Humble","Humble");
INSERT INTO patients_audio VALUES("492","2024080533424","202408054684","patients/p_audio/LungSound_1722897009.wav","LungSound","2024-08-05 22:30:09","Humble","Humble");
INSERT INTO patients_audio VALUES("493","2024080645199","2024080648495","patients/p_audio/HeartBeat_1722951720.wav","HeartBeat","2024-08-06 13:42:00","Palmas Del Mar","nurse1");
INSERT INTO patients_audio VALUES("494","2024080686478","2024080625698","patients/p_audio/HeartBeat_1722957159.wav","HeartBeat","2024-08-06 15:12:39","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("495","2024080686478","2024080625698","patients/p_audio/LungSound_1722957195.wav","LungSound","2024-08-06 15:13:15","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("496","2024080694623","2024080618302","patients/p_audio/HeartBeat_1722967076.wav","HeartBeat","2024-08-06 17:57:56","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("497","2024080694623","2024080618302","patients/p_audio/LungSound_1722967116.wav","LungSound","2024-08-06 17:58:36","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("498","2024080736029","2024080748766","patients/p_audio/HeartBeat_1723039862.wav","HeartBeat","2024-08-07 14:11:02","Humble","Humble");
INSERT INTO patients_audio VALUES("499","2024080736029","2024080748766","patients/p_audio/LungSound_1723039914.wav","LungSound","2024-08-07 14:11:54","Humble","Humble");
INSERT INTO patients_audio VALUES("500","2024080794594","2024080742685","patients/p_audio/HeartBeat_1723042639.wav","HeartBeat","2024-08-07 14:57:19","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("501","2024080794594","2024080742685","patients/p_audio/LungSound_1723042696.wav","LungSound","2024-08-07 14:58:16","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("502","2024080769772","202408079425","patients/p_audio/HeartBeat_1723057923.wav","HeartBeat","2024-08-07 19:12:03","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("503","2024080769772","202408079425","patients/p_audio/LungSound_1723057969.wav","LungSound","2024-08-07 19:12:49","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("504","2024080743820","202408078595","patients/p_audio/HeartBeat_1723062355.wav","HeartBeat","2024-08-07 20:25:55","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("505","2024080743820","202408078595","patients/p_audio/LungSound_1723062402.wav","LungSound","2024-08-07 20:26:42","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("506","2024080763528","2024080747258","patients/p_audio/HeartBeat_1723069551.wav","HeartBeat","2024-08-07 22:25:51","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("507","2024080763528","2024080747258","patients/p_audio/LungSound_1723069600.wav","LungSound","2024-08-07 22:26:40","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("508","2024080794741","202408072369","patients/p_audio/LungSound_1723071577.wav","LungSound","2024-08-07 22:59:37","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("509","2024080844540","202408083858","patients/p_audio/HeartBeat_1723149631.wav","HeartBeat","2024-08-08 20:40:31","Humble","Humble");
INSERT INTO patients_audio VALUES("510","2024080844540","202408083858","patients/p_audio/LungSound_1723149664.wav","LungSound","2024-08-08 20:41:04","Humble","Humble");
INSERT INTO patients_audio VALUES("511","2024080877275","202408089364","patients/p_audio/HeartBeat_1723153331.wav","HeartBeat","2024-08-08 21:42:11","Humble","Humble");
INSERT INTO patients_audio VALUES("512","2024080877275","202408089364","patients/p_audio/LungSound_1723153365.wav","LungSound","2024-08-08 21:42:45","Humble","Humble");
INSERT INTO patients_audio VALUES("513","2024080932465","202408092421","patients/p_audio/HeartBeat_1723220801.wav","HeartBeat","2024-08-09 16:26:41","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("514","2024080932465","202408092421","patients/p_audio/LungSound_1723220840.wav","LungSound","2024-08-09 16:27:20","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("515","2024080995755","2024080949214","patients/p_audio/HeartBeat_1723233733.wav","HeartBeat","2024-08-09 20:02:13","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("516","2024080995755","2024080949214","patients/p_audio/LungSound_1723233775.wav","LungSound","2024-08-09 20:02:55","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("517","2024081097724","2024081049296","patients/p_audio/HeartBeat_1723300306.wav","HeartBeat","2024-08-10 14:31:46","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("518","2024081097724","2024081049296","patients/p_audio/LungSound_1723300340.wav","LungSound","2024-08-10 14:32:20","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("519","2024081062311","20240810128","patients/p_audio/HeartBeat_1723302218.wav","HeartBeat","2024-08-10 15:03:38","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("520","2024081062311","20240810128","patients/p_audio/LungSound_1723302257.wav","LungSound","2024-08-10 15:04:17","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("521","2024081062311","20240810128","patients/p_audio/LungSound_1723302278.wav","LungSound","2024-08-10 15:04:38","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("522","2024081085345","202408101478","patients/p_audio/HeartBeat_1723304384.wav","HeartBeat","2024-08-10 15:39:44","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("523","2024081085345","202408101478","patients/p_audio/LungSound_1723304416.wav","LungSound","2024-08-10 15:40:16","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("524","2024081095123","202408105622","patients/p_audio/HeartBeat_1723305927.wav","HeartBeat","2024-08-10 16:05:27","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("525","2024081095123","202408105622","patients/p_audio/LungSound_1723305961.wav","LungSound","2024-08-10 16:06:01","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("526","2024081040555","2024081017324","patients/p_audio/HeartBeat_1723308283.wav","HeartBeat","2024-08-10 16:44:43","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("527","2024081040555","2024081017324","patients/p_audio/LungSound_1723308316.wav","LungSound","2024-08-10 16:45:16","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("528","2024081189673","2024081120981","patients/p_audio/HeartBeat_1723397306.wav","HeartBeat","2024-08-11 17:28:26","Humble","Humble");
INSERT INTO patients_audio VALUES("529","2024081189673","2024081120981","patients/p_audio/LungSound_1723397371.wav","LungSound","2024-08-11 17:29:31","Humble","Humble");
INSERT INTO patients_audio VALUES("530","2024081160419","20240811529","patients/p_audio/HeartBeat_1723405738.wav","HeartBeat","2024-08-11 19:48:58","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("531","2024081160419","20240811529","patients/p_audio/LungSound_1723405781.wav","LungSound","2024-08-11 19:49:41","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("532","2024081166832","2024081126411","patients/p_audio/HeartBeat_1723412196.wav","HeartBeat","2024-08-11 21:36:36","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("533","2024081166832","2024081126411","patients/p_audio/LungSound_1723412230.wav","LungSound","2024-08-11 21:37:10","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("534","2024081217125","202408128421","patients/p_audio/HeartBeat_1723489340.wav","HeartBeat","2024-08-12 19:02:20","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("535","2024081232472","2024081216381","patients/p_audio/HeartBeat_1723489947.wav","HeartBeat","2024-08-12 19:12:27","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("536","2024081276768","2024081219518","patients/p_audio/HeartBeat_1723496807.wav","HeartBeat","2024-08-12 21:06:47","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("537","2024081276768","2024081219518","patients/p_audio/LungSound_1723496861.wav","LungSound","2024-08-12 21:07:41","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("538","2024081295755","2024081215755","patients/p_audio/HeartBeat_1723498287.wav","HeartBeat","2024-08-12 21:31:27","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("539","2024081295755","2024081215755","patients/p_audio/LungSound_1723498334.wav","LungSound","2024-08-12 21:32:14","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("540","2024081281804","202408121601","patients/p_audio/HeartBeat_1723501447.wav","HeartBeat","2024-08-12 22:24:07","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("541","2024081281804","202408121601","patients/p_audio/LungSound_1723501493.wav","LungSound","2024-08-12 22:24:53","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("542","2024081214908","2024081241024","patients/p_audio/HeartBeat_1723503502.wav","HeartBeat","2024-08-12 22:58:22","Castle Hills","Castle Hills");
INSERT INTO patients_audio VALUES("543","2024081214908","2024081241024","patients/p_audio/LungSound_1723503541.wav","LungSound","2024-08-12 22:59:01","Castle Hills","Castle Hills");



CREATE TABLE `patients_files` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `record_id` varchar(255) NOT NULL,
  `patient_id` varchar(255) NOT NULL,
  `picts` varchar(355) NOT NULL,
  `device_type` varchar(225) NOT NULL,
  `record_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `record_at` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1222 DEFAULT CHARSET=utf8mb4;

INSERT INTO patients_files VALUES("278","2024031537311","2024031527825","patients/p_pictures/Ear_1710514389.png","Ear","2024-03-15 14:53:09","nurse1");
INSERT INTO patients_files VALUES("279","2024031537311","2024031527825","patients/p_pictures/Ear_1710514460.png","Ear","2024-03-15 14:54:20","nurse1");
INSERT INTO patients_files VALUES("280","2024031529546","202403158274","patients/p_pictures/Ear_1710539616.png","Ear","2024-03-15 21:53:36","nurse1");
INSERT INTO patients_files VALUES("281","2024031529546","202403158274","patients/p_pictures/TestResult_COVID_1710539666.png","TestResult_COVID","2024-03-15 21:54:26","nurse1");
INSERT INTO patients_files VALUES("282","2024031591850","2024031530297","patients/p_pictures/TestResult_COVID_1710540187.png","TestResult_COVID","2024-03-15 22:03:07","nurse1");
INSERT INTO patients_files VALUES("283","2024032117263","2024032134960","patients/p_pictures/Mouth_1711036532.png","Mouth","2024-03-21 15:55:32","Reza");
INSERT INTO patients_files VALUES("284","2024032117263","2024032134960","patients/p_pictures/Mouth_1711036568.png","Mouth","2024-03-21 15:56:08","Reza");
INSERT INTO patients_files VALUES("285","2024032117263","2024032134960","patients/p_pictures/Mouth_1711036638.png","Mouth","2024-03-21 15:57:18","Reza");
INSERT INTO patients_files VALUES("286","2024032117263","2024032134960","patients/p_pictures/Mouth_1711036639.png","Mouth","2024-03-21 15:57:19","Reza");
INSERT INTO patients_files VALUES("287","2024032795415","2024032745433","patients/p_pictures/Skin_1711557290.png","Skin","2024-03-27 16:34:50","Dr. Marvel");
INSERT INTO patients_files VALUES("288","2024032795415","2024032745433","patients/p_pictures/Skin_1711557290.png","Skin","2024-03-27 16:34:50","Dr. Marvel");
INSERT INTO patients_files VALUES("289","2024032795415","2024032745433","patients/p_pictures/Skin_1711557290.png","Skin","2024-03-27 16:34:50","Dr. Marvel");
INSERT INTO patients_files VALUES("290","2024032795415","2024032745433","patients/p_pictures/Skin_1711557291.png","Skin","2024-03-27 16:34:51","Dr. Marvel");
INSERT INTO patients_files VALUES("291","2024032795415","2024032745433","patients/p_pictures/Skin_1711557291.png","Skin","2024-03-27 16:34:51","Dr. Marvel");
INSERT INTO patients_files VALUES("292","2024032795415","2024032745433","patients/p_pictures/Skin_1711557291.png","Skin","2024-03-27 16:34:51","Dr. Marvel");
INSERT INTO patients_files VALUES("293","2024032795415","2024032745433","patients/p_pictures/Skin_1711557291.png","Skin","2024-03-27 16:34:51","Dr. Marvel");
INSERT INTO patients_files VALUES("294","2024032795415","2024032745433","patients/p_pictures/TestResult_Flu_1711557349.png","TestResult_Flu","2024-03-27 16:35:49","Dr. Marvel");
INSERT INTO patients_files VALUES("295","2024032777557","202403276113","patients/p_pictures/Mouth_1711560057.png","Mouth","2024-03-27 17:20:57","Dr. Marvel");
INSERT INTO patients_files VALUES("296","2024032777557","202403276113","patients/p_pictures/Ear_1711560149.png","Ear","2024-03-27 17:22:29","Dr. Marvel");
INSERT INTO patients_files VALUES("297","2024032777557","202403276113","patients/p_pictures/Skin_1711560243.png","Skin","2024-03-27 17:24:03","Dr. Marvel");
INSERT INTO patients_files VALUES("298","2024032777557","202403276113","patients/p_pictures/TestResult_Flu_1711560596.png","TestResult_Flu","2024-03-27 17:29:56","Dr. Marvel");
INSERT INTO patients_files VALUES("299","2024032882769","2024032810393","patients/p_pictures/Ear_1711646140.png","Ear","2024-03-28 17:15:40","Dr. Marvel");
INSERT INTO patients_files VALUES("300","2024032882769","2024032810393","patients/p_pictures/Skin_1711646150.png","Skin","2024-03-28 17:15:50","Dr. Marvel");
INSERT INTO patients_files VALUES("301","2024032882769","2024032810393","patients/p_pictures/Skin_1711646150.png","Skin","2024-03-28 17:15:50","Dr. Marvel");
INSERT INTO patients_files VALUES("302","2024032882769","2024032810393","patients/p_pictures/Eye_1711646172.png","Eye","2024-03-28 17:16:12","Dr. Marvel");
INSERT INTO patients_files VALUES("303","2024032882769","2024032810393","patients/p_pictures/Mouth_1711646198.png","Mouth","2024-03-28 17:16:38","Dr. Marvel");
INSERT INTO patients_files VALUES("304","2024032882769","2024032810393","patients/p_pictures/TestResult_Flu_1711646224.png","TestResult_Flu","2024-03-28 17:17:04","Dr. Marvel");
INSERT INTO patients_files VALUES("305","2024032845836","2024032820940","patients/p_pictures/Ear_1711650040.png","Ear","2024-03-28 18:20:40","nurse1");
INSERT INTO patients_files VALUES("306","2024032845836","2024032820940","patients/p_pictures/EKG_1711650060.png","EKG","2024-03-28 18:21:00","nurse1");
INSERT INTO patients_files VALUES("307","2024032845836","2024032820940","patients/p_pictures/TestResult_Flu_1711650390.png","TestResult_Flu","2024-03-28 18:26:30","nurse1");
INSERT INTO patients_files VALUES("308","2024040222092","2024040229698","patients/p_pictures/Skin_1712068800.png","Skin","2024-04-02 14:40:00","Reza");
INSERT INTO patients_files VALUES("309","2024040263458","2024040210119","patients/p_pictures/Ear_1712070673.png","Ear","2024-04-02 15:11:13","Reza");
INSERT INTO patients_files VALUES("310","2024040263458","2024040210119","patients/p_pictures/Ear_1712070677.png","Ear","2024-04-02 15:11:17","Reza");
INSERT INTO patients_files VALUES("311","2024040480992","20240404766","patients/p_pictures/Ear_1712252646.png","Ear","2024-04-04 17:44:06","Reza");
INSERT INTO patients_files VALUES("312","2024040494378","2024040416550","patients/p_pictures/Ear_1712253163.png","Ear","2024-04-04 17:52:43","nurse1");
INSERT INTO patients_files VALUES("313","2024040497191","202404044619","patients/p_pictures/Ear_1712253528.png","Ear","2024-04-04 17:58:48","nurse1");
INSERT INTO patients_files VALUES("314","2024040429804","2024040411400","patients/p_pictures/Ear_1712253846.png","Ear","2024-04-04 18:04:06","Dr. Marvel");
INSERT INTO patients_files VALUES("315","2024040492678","2024040442376","patients/p_pictures/TestResult_Flu_1712255171.png","TestResult_Flu","2024-04-04 18:26:11","nurse1");
INSERT INTO patients_files VALUES("316","2024040492678","2024040442376","patients/p_pictures/TestResult_strep_1712255206.png","TestResult_strep","2024-04-04 18:26:46","nurse1");
INSERT INTO patients_files VALUES("317","2024040430797","2024040434981","patients/p_pictures/Ear_1712258319.png","Ear","2024-04-04 19:18:39","nurse1");
INSERT INTO patients_files VALUES("318","2024040423997","2024040421387","patients/p_pictures/Ear_1712258496.png","Ear","2024-04-04 19:21:36","nurse1");
INSERT INTO patients_files VALUES("319","2024040489360","202404044657","patients/p_pictures/TestResult_Flu_1712260633.png","TestResult_Flu","2024-04-04 19:57:13","nurse1");
INSERT INTO patients_files VALUES("320","2024040459408","2024040447258","patients/p_pictures/TestResult_UA_1712261528.png","TestResult_UA","2024-04-04 20:12:08","nurse1");
INSERT INTO patients_files VALUES("321","2024040494507","202404047757","patients/p_pictures/Ear_1712262522.png","Ear","2024-04-04 20:28:42","nurse1");
INSERT INTO patients_files VALUES("322","2024040419818","2024040431160","patients/p_pictures/Ear_1712267051.png","Ear","2024-04-04 21:44:11","nurse1");
INSERT INTO patients_files VALUES("323","2024040419818","2024040431160","patients/p_pictures/Ear_1712267138.png","Ear","2024-04-04 21:45:38","nurse1");
INSERT INTO patients_files VALUES("324","2024040512387","202404052307","patients/p_pictures/Ear_1712328679.png","Ear","2024-04-05 14:51:19","nurse1");
INSERT INTO patients_files VALUES("325","2024040596301","2024040534838","patients/p_pictures/Skin_1712330454.png","Skin","2024-04-05 15:20:54","nurse1");
INSERT INTO patients_files VALUES("326","2024040596301","2024040534838","patients/p_pictures/Skin_1712330477.png","Skin","2024-04-05 15:21:17","nurse1");
INSERT INTO patients_files VALUES("327","2024040587198","2024040531470","patients/p_pictures/TestResult_COVID_1712334552.png","TestResult_COVID","2024-04-05 16:29:12","nurse1");
INSERT INTO patients_files VALUES("328","2024040851674","2024040819495","patients/p_pictures/Ear_1712627089.png","Ear","2024-04-09 01:44:49","nurse1");
INSERT INTO patients_files VALUES("329","2024040999785","202404091752","patients/p_pictures/TestResult_UA_1712686639.png","TestResult_UA","2024-04-09 18:17:19","nurse1");
INSERT INTO patients_files VALUES("330","2024040999785","202404091752","patients/p_pictures/TestResult_UA_1712686928.png","TestResult_UA","2024-04-09 18:22:08","nurse1");
INSERT INTO patients_files VALUES("331","2024040947388","2024040932098","patients/p_pictures/TestResult_Flu_1712687750.png","TestResult_Flu","2024-04-09 18:35:50","nurse1");
INSERT INTO patients_files VALUES("332","2024040947388","2024040932098","patients/p_pictures/TestResult_COVID_1712687781.png","TestResult_COVID","2024-04-09 18:36:21","nurse1");
INSERT INTO patients_files VALUES("333","2024041186656","2024041127356","patients/p_pictures/Ear_1712857976.png","Ear","2024-04-11 17:52:56","nurse1");
INSERT INTO patients_files VALUES("334","2024041186656","2024041127356","patients/p_pictures/Ear_1712858076.png","Ear","2024-04-11 17:54:36","nurse1");
INSERT INTO patients_files VALUES("335","2024041186656","2024041127356","patients/p_pictures/TestResult_Flu_1712858094.png","TestResult_Flu","2024-04-11 17:54:54","nurse1");
INSERT INTO patients_files VALUES("336","2024041131410","202404115234","patients/p_pictures/Ear_1712858883.png","Ear","2024-04-11 18:08:03","nurse1");
INSERT INTO patients_files VALUES("337","2024041131410","202404115234","patients/p_pictures/Ear_1712859001.png","Ear","2024-04-11 18:10:01","nurse1");
INSERT INTO patients_files VALUES("338","2024041291187","202404128338","patients/p_pictures/TestResult_COVID_1712933560.png","TestResult_COVID","2024-04-12 14:52:40","nurse1");
INSERT INTO patients_files VALUES("339","2024041291187","202404128338","patients/p_pictures/Skin_1712933588.png","Skin","2024-04-12 14:53:08","nurse1");
INSERT INTO patients_files VALUES("340","2024041258217","2024041247969","patients/p_pictures/Skin_1712933992.png","Skin","2024-04-12 14:59:52","nurse1");
INSERT INTO patients_files VALUES("341","2024041258217","2024041247969","patients/p_pictures/Skin_1712934039.png","Skin","2024-04-12 15:00:39","nurse1");
INSERT INTO patients_files VALUES("342","2024041258217","2024041247969","patients/p_pictures/TestResult_COVID_1712934167.png","TestResult_COVID","2024-04-12 15:02:47","nurse1");
INSERT INTO patients_files VALUES("343","2024041219491","2024041219852","patients/p_pictures/Ear_1712940035.png","Ear","2024-04-12 16:40:35","nurse1");
INSERT INTO patients_files VALUES("344","2024041219491","2024041219852","patients/p_pictures/Ear_1712940073.png","Ear","2024-04-12 16:41:13","nurse1");
INSERT INTO patients_files VALUES("345","2024041249416","2024041216294","patients/p_pictures/Ear_1712941942.png","Ear","2024-04-12 17:12:22","nurse1");
INSERT INTO patients_files VALUES("346","2024041259382","2024041247505","patients/p_pictures/TestResult_Flu_1712945064.png","TestResult_Flu","2024-04-12 18:04:24","nurse1");
INSERT INTO patients_files VALUES("347","2024041291919","2024041222809","patients/p_pictures/Ear_1712946079.png","Ear","2024-04-12 18:21:19","nurse1");
INSERT INTO patients_files VALUES("348","2024041620351","2024041643291","patients/p_pictures/Ear_1713295736.png","Ear","2024-04-16 19:28:56","nurse1");
INSERT INTO patients_files VALUES("349","2024041620351","2024041643291","patients/p_pictures/Eye_1713295751.png","Eye","2024-04-16 19:29:11","nurse1");
INSERT INTO patients_files VALUES("350","2024041620351","2024041643291","patients/p_pictures/TestResult_Flu_1713295793.png","TestResult_Flu","2024-04-16 19:29:53","nurse1");
INSERT INTO patients_files VALUES("351","2024041631970","2024041612800","patients/p_pictures/Skin_1713296602.png","Skin","2024-04-16 19:43:22","nurse1");
INSERT INTO patients_files VALUES("352","2024041783674","2024041740873","patients/p_pictures/Ear_1713365791.png","Ear","2024-04-17 14:56:31","nurse1");
INSERT INTO patients_files VALUES("353","2024041783674","2024041740873","patients/p_pictures/Ear_1713365836.png","Ear","2024-04-17 14:57:16","nurse1");
INSERT INTO patients_files VALUES("354","2024041783674","2024041740873","patients/p_pictures/TestResult_Flu_1713365930.png","TestResult_Flu","2024-04-17 14:58:50","nurse1");
INSERT INTO patients_files VALUES("355","2024041781347","202404178418","patients/p_pictures/Ear_1713370654.png","Ear","2024-04-17 16:17:34","Reza");
INSERT INTO patients_files VALUES("356","2024041781347","202404178418","patients/p_pictures/Ear_1713370675.png","Ear","2024-04-17 16:17:55","Reza");
INSERT INTO patients_files VALUES("357","2024041768107","202404171091","patients/p_pictures/Skin_1713371703.png","Skin","2024-04-17 16:35:03","nurse1");
INSERT INTO patients_files VALUES("358","2024041768107","202404171091","patients/p_pictures/Mouth_1713372049.png","Mouth","2024-04-17 16:40:49","nurse1");
INSERT INTO patients_files VALUES("359","2024041797408","2024041714285","patients/p_pictures/Ear_1713375441.png","Ear","2024-04-17 17:37:21","nurse1");
INSERT INTO patients_files VALUES("360","2024041797408","2024041714285","patients/p_pictures/TestResult_Hcg_1713375528.png","TestResult_Hcg","2024-04-17 17:38:48","nurse1");
INSERT INTO patients_files VALUES("361","2024041790463","2024041720730","patients/p_pictures/TestResult_UA_1713377394.png","TestResult_UA","2024-04-17 18:09:54","nurse1");
INSERT INTO patients_files VALUES("362","2024041780850","2024041713828","patients/p_pictures/Ear_1713393061.png","Ear","2024-04-17 22:31:01","nurse1");
INSERT INTO patients_files VALUES("363","2024041780850","2024041713828","patients/p_pictures/Ear_1713393117.png","Ear","2024-04-17 22:31:57","nurse1");
INSERT INTO patients_files VALUES("364","2024041758466","2024041732356","patients/p_pictures/Mouth_1713394712.png","Mouth","2024-04-17 22:58:32","nurse1");
INSERT INTO patients_files VALUES("365","2024041826809","202404184167","patients/p_pictures/Ear_1713470892.png","Ear","2024-04-18 20:08:12","nurse1");
INSERT INTO patients_files VALUES("366","2024041826809","202404184167","patients/p_pictures/Ear_1713470954.png","Ear","2024-04-18 20:09:14","nurse1");
INSERT INTO patients_files VALUES("367","2024041847990","2024041810052","patients/p_pictures/Skin_1713471235.png","Skin","2024-04-18 20:13:55","nurse1");
INSERT INTO patients_files VALUES("368","2024041876959","2024041830298","patients/p_pictures/Ear_1713472297.png","Ear","2024-04-18 20:31:37","nurse1");
INSERT INTO patients_files VALUES("369","2024041876959","2024041830298","patients/p_pictures/TestResult_Hcg_1713472317.png","TestResult_Hcg","2024-04-18 20:31:57","nurse1");
INSERT INTO patients_files VALUES("370","2024041865190","2024041841711","patients/p_pictures/Ear_1713473323.png","Ear","2024-04-18 20:48:43","nurse1");
INSERT INTO patients_files VALUES("371","2024041865190","2024041841711","patients/p_pictures/TestResult_Hcg_1713473334.png","TestResult_Hcg","2024-04-18 20:48:54","nurse1");
INSERT INTO patients_files VALUES("372","2024041824524","2024041824137","patients/p_pictures/Ear_1713474214.png","Ear","2024-04-18 21:03:34","nurse1");
INSERT INTO patients_files VALUES("373","2024041813681","2024041827294","patients/p_pictures/Eye_1713474834.png","Eye","2024-04-18 21:13:54","nurse1");
INSERT INTO patients_files VALUES("374","2024041811021","2024041833030","patients/p_pictures/Ear_1713475386.png","Ear","2024-04-18 21:23:06","nurse1");
INSERT INTO patients_files VALUES("375","2024041893131","2024041834078","patients/p_pictures/Ear_1713476851.png","Ear","2024-04-18 21:47:31","nurse1");
INSERT INTO patients_files VALUES("376","2024041928284","2024041922142","patients/p_pictures/Ear_1713539539.png","Ear","2024-04-19 15:12:19","nurse1");
INSERT INTO patients_files VALUES("377","2024041928284","2024041922142","patients/p_pictures/TestResult_Flu_1713539665.png","TestResult_Flu","2024-04-19 15:14:25","nurse1");
INSERT INTO patients_files VALUES("378","2024041917830","2024041919967","patients/p_pictures/Mouth_1713540546.png","Mouth","2024-04-19 15:29:06","nurse1");
INSERT INTO patients_files VALUES("379","2024041917830","2024041919967","patients/p_pictures/Eye_1713540614.png","Eye","2024-04-19 15:30:14","nurse1");
INSERT INTO patients_files VALUES("380","2024041962703","2024041942442","patients/p_pictures/Ear_1713542104.png","Ear","2024-04-19 15:55:04","nurse1");
INSERT INTO patients_files VALUES("381","2024041962703","2024041942442","patients/p_pictures/TestResult_Flu_1713542113.png","TestResult_Flu","2024-04-19 15:55:13","nurse1");
INSERT INTO patients_files VALUES("382","2024041962703","2024041942442","patients/p_pictures/TestResult_Flu_1713542113.png","TestResult_Flu","2024-04-19 15:55:13","nurse1");
INSERT INTO patients_files VALUES("383","2024041955406","2024041917759","patients/p_pictures/Ear_1713548720.png","Ear","2024-04-19 17:45:20","nurse1");
INSERT INTO patients_files VALUES("384","2024041955406","2024041917759","patients/p_pictures/Ear_1713548756.png","Ear","2024-04-19 17:45:56","nurse1");
INSERT INTO patients_files VALUES("385","2024041955406","2024041917759","patients/p_pictures/TestResult_strep_1713548845.png","TestResult_strep","2024-04-19 17:47:25","nurse1");
INSERT INTO patients_files VALUES("386","2024041982797","2024041922637","patients/p_pictures/Mouth_1713550169.png","Mouth","2024-04-19 18:09:29","nurse1");
INSERT INTO patients_files VALUES("387","2024041982797","2024041922637","patients/p_pictures/TestResult_strep_1713550243.png","TestResult_strep","2024-04-19 18:10:43","nurse1");
INSERT INTO patients_files VALUES("388","2024041929312","2024041945218","patients/p_pictures/Ear_1713551945.png","Ear","2024-04-19 18:39:05","nurse1");
INSERT INTO patients_files VALUES("389","2024041929312","2024041945218","patients/p_pictures/Skin_1713551980.png","Skin","2024-04-19 18:39:40","nurse1");
INSERT INTO patients_files VALUES("390","2024041929312","2024041945218","patients/p_pictures/TestResult_strep_1713552079.png","TestResult_strep","2024-04-19 18:41:19","nurse1");
INSERT INTO patients_files VALUES("391","2024042155900","202404215219","patients/p_pictures/Ear_1713721398.png","Ear","2024-04-21 17:43:18","nurse1");
INSERT INTO patients_files VALUES("392","2024042155900","202404215219","patients/p_pictures/Ear_1713721412.png","Ear","2024-04-21 17:43:32","nurse1");
INSERT INTO patients_files VALUES("393","2024042155900","202404215219","patients/p_pictures/TestResult_COVID_1713721462.png","TestResult_COVID","2024-04-21 17:44:22","nurse1");
INSERT INTO patients_files VALUES("394","2024042196022","202404213005","patients/p_pictures/Mouth_1713722384.png","Mouth","2024-04-21 17:59:44","nurse1");
INSERT INTO patients_files VALUES("395","2024042196022","202404213005","patients/p_pictures/TestResult_strep_1713722426.png","TestResult_strep","2024-04-21 18:00:26","nurse1");
INSERT INTO patients_files VALUES("396","2024042166231","2024042121913","patients/p_pictures/Ear_1713724133.png","Ear","2024-04-21 18:28:53","nurse1");
INSERT INTO patients_files VALUES("397","2024042166231","2024042121913","patients/p_pictures/Ear_1713724180.png","Ear","2024-04-21 18:29:40","nurse1");
INSERT INTO patients_files VALUES("398","2024042166231","2024042121913","patients/p_pictures/Ear_1713724180.png","Ear","2024-04-21 18:29:40","nurse1");
INSERT INTO patients_files VALUES("399","2024042140238","2024042141151","patients/p_pictures/Mouth_1713726552.png","Mouth","2024-04-21 19:09:12","nurse1");
INSERT INTO patients_files VALUES("400","2024042119092","2024042136451","patients/p_pictures/Mouth_1713728243.png","Mouth","2024-04-21 19:37:23","nurse1");
INSERT INTO patients_files VALUES("401","2024042119092","2024042136451","patients/p_pictures/Ear_1713728336.png","Ear","2024-04-21 19:38:56","nurse1");
INSERT INTO patients_files VALUES("402","2024042119092","2024042136451","patients/p_pictures/TestResult_strep_1713728404.png","TestResult_strep","2024-04-21 19:40:04","nurse1");
INSERT INTO patients_files VALUES("403","2024042196053","2024042133042","patients/p_pictures/TestResult_Flu_1713730405.png","TestResult_Flu","2024-04-21 20:13:25","nurse1");
INSERT INTO patients_files VALUES("404","2024042298153","2024042220191","patients/p_pictures/Ear_1713793463.png","Ear","2024-04-22 13:44:23","nurse1");
INSERT INTO patients_files VALUES("405","2024042253987","202404221789","patients/p_pictures/Skin_1713802751.png","Skin","2024-04-22 16:19:11","nurse1");
INSERT INTO patients_files VALUES("406","2024042390740","2024042329763","patients/p_pictures/Ear_1713877880.png","Ear","2024-04-23 13:11:20","nurse1");
INSERT INTO patients_files VALUES("407","2024042373545","202404232211","patients/p_pictures/Mouth_1713886450.png","Mouth","2024-04-23 15:34:10","nurse1");
INSERT INTO patients_files VALUES("408","2024042373545","202404232211","patients/p_pictures/Mouth_1713886471.png","Mouth","2024-04-23 15:34:31","nurse1");
INSERT INTO patients_files VALUES("409","2024042373545","202404232211","patients/p_pictures/Mouth_1713886480.png","Mouth","2024-04-23 15:34:40","nurse1");
INSERT INTO patients_files VALUES("410","2024042373545","202404232211","patients/p_pictures/Mouth_1713886480.png","Mouth","2024-04-23 15:34:40","nurse1");
INSERT INTO patients_files VALUES("411","2024042337842","2024042348744","patients/p_pictures/Ear_1713893977.png","Ear","2024-04-23 17:39:37","nurse1");
INSERT INTO patients_files VALUES("412","2024042337842","2024042348744","patients/p_pictures/Skin_1713894085.png","Skin","2024-04-23 17:41:25","nurse1");
INSERT INTO patients_files VALUES("413","2024042337842","2024042348744","patients/p_pictures/TestResult_RSV_1713894188.png","TestResult_RSV","2024-04-23 17:43:08","nurse1");
INSERT INTO patients_files VALUES("414","2024042363370","2024042327186","patients/p_pictures/Ear_1713897345.png","Ear","2024-04-23 18:35:45","nurse1");
INSERT INTO patients_files VALUES("415","2024042441794","2024042449889","patients/p_pictures/Mouth_1713979809.png","Mouth","2024-04-24 17:30:09","nurse1");
INSERT INTO patients_files VALUES("416","2024042491472","2024042412981","patients/p_pictures/Mouth_1713980499.png","Mouth","2024-04-24 17:41:39","nurse1");
INSERT INTO patients_files VALUES("417","2024042477890","2024042436536","patients/p_pictures/Mouth_1713981537.png","Mouth","2024-04-24 17:58:57","nurse1");
INSERT INTO patients_files VALUES("418","2024042477890","2024042436536","patients/p_pictures/Ear_1713981664.png","Ear","2024-04-24 18:01:04","nurse1");
INSERT INTO patients_files VALUES("419","2024042469996","2024042438431","patients/p_pictures/Ear_1713985630.png","Ear","2024-04-24 19:07:10","nurse1");
INSERT INTO patients_files VALUES("420","2024042469996","2024042438431","patients/p_pictures/Ear_1713985728.png","Ear","2024-04-24 19:08:48","nurse1");
INSERT INTO patients_files VALUES("421","2024042417328","2024042421440","patients/p_pictures/Mouth_1713991260.png","Mouth","2024-04-24 20:41:00","nurse1");
INSERT INTO patients_files VALUES("422","2024042585467","2024042540692","patients/p_pictures/Mouth_1714053530.png","Mouth","2024-04-25 13:58:50","nurse1");
INSERT INTO patients_files VALUES("423","2024042689734","202404263528","patients/p_pictures/Ear_1714153549.png","Ear","2024-04-26 17:45:49","nurse1");
INSERT INTO patients_files VALUES("424","2024042689734","202404263528","patients/p_pictures/Ear_1714153609.png","Ear","2024-04-26 17:46:49","nurse1");
INSERT INTO patients_files VALUES("425","2024042689734","202404263528","patients/p_pictures/Mouth_1714153763.png","Mouth","2024-04-26 17:49:23","nurse1");
INSERT INTO patients_files VALUES("426","2024042689734","202404263528","patients/p_pictures/TestResult_COVID_1714153847.png","TestResult_COVID","2024-04-26 17:50:47","nurse1");
INSERT INTO patients_files VALUES("427","2024042746485","2024042734449","patients/p_pictures/Ear_1714229001.png","Ear","2024-04-27 14:43:21","nurse1");
INSERT INTO patients_files VALUES("428","2024042746485","2024042734449","patients/p_pictures/Ear_1714229009.png","Ear","2024-04-27 14:43:29","nurse1");
INSERT INTO patients_files VALUES("429","2024042746485","2024042734449","patients/p_pictures/Ear_1714229197.png","Ear","2024-04-27 14:46:37","nurse1");
INSERT INTO patients_files VALUES("430","2024042729996","2024042711761","patients/p_pictures/Ear_1714229803.png","Ear","2024-04-27 14:56:43","nurse1");
INSERT INTO patients_files VALUES("431","2024042729996","2024042711761","patients/p_pictures/Ear_1714229808.png","Ear","2024-04-27 14:56:48","nurse1");
INSERT INTO patients_files VALUES("432","2024042717732","2024042719994","patients/p_pictures/Ear_1714230313.png","Ear","2024-04-27 15:05:13","nurse1");
INSERT INTO patients_files VALUES("433","2024042717732","2024042719994","patients/p_pictures/Ear_1714230322.png","Ear","2024-04-27 15:05:22","nurse1");
INSERT INTO patients_files VALUES("434","2024042717732","2024042719994","patients/p_pictures/Ear_1714230408.png","Ear","2024-04-27 15:06:48","nurse1");
INSERT INTO patients_files VALUES("435","2024042862344","2024042818987","patients/p_pictures/Skin_1714314217.png","Skin","2024-04-28 14:23:37","nurse1");
INSERT INTO patients_files VALUES("436","2024042862344","2024042818987","patients/p_pictures/Skin_1714314234.png","Skin","2024-04-28 14:23:54","nurse1");
INSERT INTO patients_files VALUES("437","2024042862344","2024042818987","patients/p_pictures/Skin_1714314234.png","Skin","2024-04-28 14:23:54","nurse1");
INSERT INTO patients_files VALUES("438","2024042929929","2024042940862","patients/p_pictures/Ear_1714406113.png","Ear","2024-04-29 15:55:13","nurse1");
INSERT INTO patients_files VALUES("439","2024042929929","2024042940862","patients/p_pictures/Mouth_1714406264.png","Mouth","2024-04-29 15:57:44","nurse1");
INSERT INTO patients_files VALUES("440","2024042929929","2024042940862","patients/p_pictures/Skin_1714406363.png","Skin","2024-04-29 15:59:23","nurse1");
INSERT INTO patients_files VALUES("441","2024042929929","2024042940862","patients/p_pictures/TestResult_COVID_1714406719.png","TestResult_COVID","2024-04-29 16:05:19","nurse1");
INSERT INTO patients_files VALUES("442","2024042964194","2024042939638","patients/p_pictures/Ear_1714410467.png","Ear","2024-04-29 17:07:47","nurse1");
INSERT INTO patients_files VALUES("443","2024042964194","2024042939638","patients/p_pictures/Ear_1714410959.png","Ear","2024-04-29 17:15:59","nurse1");
INSERT INTO patients_files VALUES("444","2024042964194","2024042939638","patients/p_pictures/Mouth_1714411358.png","Mouth","2024-04-29 17:22:38","nurse1");
INSERT INTO patients_files VALUES("445","2024042964194","2024042939638","patients/p_pictures/TestResult_Flu_1714411569.png","TestResult_Flu","2024-04-29 17:26:09","nurse1");
INSERT INTO patients_files VALUES("446","2024042967570","2024042921881","patients/p_pictures/Mouth_1714412736.png","Mouth","2024-04-29 17:45:36","nurse1");
INSERT INTO patients_files VALUES("447","2024042967570","2024042921881","patients/p_pictures/Ear_1714412892.png","Ear","2024-04-29 17:48:12","nurse1");
INSERT INTO patients_files VALUES("448","2024042967570","2024042921881","patients/p_pictures/TestResult_strep_1714413127.png","TestResult_strep","2024-04-29 17:52:07","nurse1");
INSERT INTO patients_files VALUES("449","2024042947762","2024042937917","patients/p_pictures/Skin_1714414973.png","Skin","2024-04-29 18:22:53","Castle Hills");
INSERT INTO patients_files VALUES("450","2024042986124","2024042947036","patients/p_pictures/Ear_1714417262.png","Ear","2024-04-29 19:01:02","Castle Hills");
INSERT INTO patients_files VALUES("451","2024042986124","2024042947036","patients/p_pictures/Ear_1714417327.png","Ear","2024-04-29 19:02:07","Castle Hills");
INSERT INTO patients_files VALUES("452","2024042986124","2024042947036","patients/p_pictures/Mouth_1714417521.png","Mouth","2024-04-29 19:05:21","Castle Hills");
INSERT INTO patients_files VALUES("453","2024042986124","2024042947036","patients/p_pictures/TestResult_Flu_1714417727.png","TestResult_Flu","2024-04-29 19:08:47","Castle Hills");
INSERT INTO patients_files VALUES("454","2024042986124","2024042947036","patients/p_pictures/TestResult_Flu_1714417728.png","TestResult_Flu","2024-04-29 19:08:48","Castle Hills");
INSERT INTO patients_files VALUES("455","2024042922098","2024042929676","patients/p_pictures/Mouth_1714418881.png","Mouth","2024-04-29 19:28:01","Humble");
INSERT INTO patients_files VALUES("456","2024042922098","2024042929676","patients/p_pictures/Ear_1714419046.png","Ear","2024-04-29 19:30:46","Humble");
INSERT INTO patients_files VALUES("457","2024042920447","202404294342","patients/p_pictures/Ear_1714421167.png","Ear","2024-04-29 20:06:07","Humble");
INSERT INTO patients_files VALUES("458","2024042920447","202404294342","patients/p_pictures/Ear_1714421213.png","Ear","2024-04-29 20:06:53","Humble");
INSERT INTO patients_files VALUES("459","2024042920447","202404294342","patients/p_pictures/Ear_1714421421.png","Ear","2024-04-29 20:10:21","Humble");
INSERT INTO patients_files VALUES("460","2024043061921","202404309194","patients/p_pictures/TestResult_Flu_1714491335.png","TestResult_Flu","2024-04-30 15:35:35","nurse1");
INSERT INTO patients_files VALUES("461","2024043091574","2024043025018","patients/p_pictures/Ear_1714492529.png","Ear","2024-04-30 15:55:29","nurse1");
INSERT INTO patients_files VALUES("462","2024043025772","2024043029675","patients/p_pictures/Ear_1714493278.png","Ear","2024-04-30 16:07:58","nurse1");
INSERT INTO patients_files VALUES("463","2024043062128","2024043028925","patients/p_pictures/Mouth_1714496576.png","Mouth","2024-04-30 17:02:56","Castle Hills");
INSERT INTO patients_files VALUES("464","2024043018013","2024043035192","patients/p_pictures/Skin_1714496920.png","Skin","2024-04-30 17:08:40","Castle Hills");
INSERT INTO patients_files VALUES("465","2024043082792","2024043040524","patients/p_pictures/Ear_1714514355.png","Ear","2024-04-30 21:59:15","Humble");
INSERT INTO patients_files VALUES("466","2024050136913","2024050147159","patients/p_pictures/Mouth_1714576464.png","Mouth","2024-05-01 15:14:24","Castle Hills");
INSERT INTO patients_files VALUES("467","2024050136913","2024050147159","patients/p_pictures/Mouth_1714576565.png","Mouth","2024-05-01 15:16:05","Castle Hills");
INSERT INTO patients_files VALUES("468","2024050136913","2024050147159","patients/p_pictures/Mouth_1714576606.png","Mouth","2024-05-01 15:16:46","Castle Hills");
INSERT INTO patients_files VALUES("469","2024050136913","2024050147159","patients/p_pictures/TestResult_COVID_1714576758.png","TestResult_COVID","2024-05-01 15:19:18","Castle Hills");
INSERT INTO patients_files VALUES("470","2024050168744","2024050138546","patients/p_pictures/Mouth_1714583035.png","Mouth","2024-05-01 17:03:55","Humble");
INSERT INTO patients_files VALUES("471","2024050168744","2024050138546","patients/p_pictures/Ear_1714583197.png","Ear","2024-05-01 17:06:37","Humble");
INSERT INTO patients_files VALUES("472","2024050168744","2024050138546","patients/p_pictures/Ear_1714583225.png","Ear","2024-05-01 17:07:05","Humble");
INSERT INTO patients_files VALUES("473","2024050281944","202405022476","patients/p_pictures/Ear_1714657264.png","Ear","2024-05-02 13:41:04","Humble");
INSERT INTO patients_files VALUES("474","2024050281944","202405022476","patients/p_pictures/Ear_1714657376.png","Ear","2024-05-02 13:42:56","Humble");
INSERT INTO patients_files VALUES("475","2024050245679","2024050211685","patients/p_pictures/Ear_1714660134.png","Ear","2024-05-02 14:28:54","Humble");
INSERT INTO patients_files VALUES("476","2024050253242","2024050235084","patients/p_pictures/EKG_1714663552.png","EKG","2024-05-02 15:25:52","Castle Hills");
INSERT INTO patients_files VALUES("477","2024050253242","2024050235084","patients/p_pictures/TestResult_Flu_1714663768.png","TestResult_Flu","2024-05-02 15:29:28","Castle Hills");
INSERT INTO patients_files VALUES("478","2024050253327","2024050212495","patients/p_pictures/Ear_1714664321.png","Ear","2024-05-02 15:38:41","Humble");
INSERT INTO patients_files VALUES("479","2024050223475","2024050248603","patients/p_pictures/Mouth_1714667124.png","Mouth","2024-05-02 16:25:24","Castle Hills");
INSERT INTO patients_files VALUES("480","2024050223475","2024050248603","patients/p_pictures/Mouth_1714667232.png","Mouth","2024-05-02 16:27:12","Castle Hills");
INSERT INTO patients_files VALUES("481","2024050223475","2024050248603","patients/p_pictures/Mouth_1714667299.png","Mouth","2024-05-02 16:28:19","Castle Hills");
INSERT INTO patients_files VALUES("482","2024050223475","2024050248603","patients/p_pictures/Skin_1714667373.png","Skin","2024-05-02 16:29:33","Castle Hills");
INSERT INTO patients_files VALUES("483","2024050258178","202405025633","patients/p_pictures/Mouth_1714670506.png","Mouth","2024-05-02 17:21:46","Castle Hills");
INSERT INTO patients_files VALUES("484","2024050258178","202405025633","patients/p_pictures/Ear_1714670698.png","Ear","2024-05-02 17:24:58","Castle Hills");
INSERT INTO patients_files VALUES("485","2024050258178","202405025633","patients/p_pictures/Ear_1714670796.png","Ear","2024-05-02 17:26:36","Castle Hills");
INSERT INTO patients_files VALUES("486","2024050258178","202405025633","patients/p_pictures/TestResult_strep_1714671330.png","TestResult_strep","2024-05-02 17:35:30","Castle Hills");
INSERT INTO patients_files VALUES("487","2024050286445","2024050227127","patients/p_pictures/Ear_1714673536.png","Ear","2024-05-02 18:12:16","Castle Hills");
INSERT INTO patients_files VALUES("488","2024050286445","2024050227127","patients/p_pictures/Ear_1714673597.png","Ear","2024-05-02 18:13:17","Castle Hills");
INSERT INTO patients_files VALUES("489","2024050229930","2024050246898","patients/p_pictures/Ear_1714674151.png","Ear","2024-05-02 18:22:31","Castle Hills");
INSERT INTO patients_files VALUES("490","2024050395801","202405031610","patients/p_pictures/Ear_1714748399.png","Ear","2024-05-03 14:59:59","Castle Hills");
INSERT INTO patients_files VALUES("491","2024050395801","202405031610","patients/p_pictures/Ear_1714748455.png","Ear","2024-05-03 15:00:55","Castle Hills");
INSERT INTO patients_files VALUES("492","2024050380571","2024050340858","patients/p_pictures/Ear_1714756103.png","Ear","2024-05-03 17:08:23","Castle Hills");
INSERT INTO patients_files VALUES("493","2024050380571","2024050340858","patients/p_pictures/Ear_1714756166.png","Ear","2024-05-03 17:09:26","Castle Hills");
INSERT INTO patients_files VALUES("494","2024050355789","20240503839","patients/p_pictures/TestResult_Flu_1714757349.png","TestResult_Flu","2024-05-03 17:29:09","Castle Hills");
INSERT INTO patients_files VALUES("495","2024050355789","20240503839","patients/p_pictures/TestResult_COVID_1714757412.png","TestResult_COVID","2024-05-03 17:30:12","Castle Hills");
INSERT INTO patients_files VALUES("496","2024050355789","20240503839","patients/p_pictures/TestResult_strep_1714757438.png","TestResult_strep","2024-05-03 17:30:38","Castle Hills");
INSERT INTO patients_files VALUES("497","2024050363294","2024050345772","patients/p_pictures/Ear_1714760478.png","Ear","2024-05-03 18:21:18","Castle Hills");
INSERT INTO patients_files VALUES("498","2024050363294","2024050345772","patients/p_pictures/Ear_1714760518.png","Ear","2024-05-03 18:21:58","Castle Hills");
INSERT INTO patients_files VALUES("499","2024050363294","2024050345772","patients/p_pictures/TestResult_Flu_1714760572.png","TestResult_Flu","2024-05-03 18:22:52","Castle Hills");
INSERT INTO patients_files VALUES("500","2024050424446","2024050432700","patients/p_pictures/Ear_1714833481.png","Ear","2024-05-04 14:38:01","Castle Hills");
INSERT INTO patients_files VALUES("501","2024050424446","2024050432700","patients/p_pictures/Ear_1714833856.png","Ear","2024-05-04 14:44:16","Castle Hills");
INSERT INTO patients_files VALUES("502","2024050459411","2024050443801","patients/p_pictures/Ear_1714834973.png","Ear","2024-05-04 15:02:53","Castle Hills");
INSERT INTO patients_files VALUES("503","2024050459411","2024050443801","patients/p_pictures/Mouth_1714834983.png","Mouth","2024-05-04 15:03:03","Castle Hills");
INSERT INTO patients_files VALUES("504","2024050459411","2024050443801","patients/p_pictures/Skin_1714835028.png","Skin","2024-05-04 15:03:48","Castle Hills");
INSERT INTO patients_files VALUES("505","2024050459411","2024050443801","patients/p_pictures/Skin_1714835065.png","Skin","2024-05-04 15:04:25","Castle Hills");
INSERT INTO patients_files VALUES("506","2024050437948","2024050445031","patients/p_pictures/Ear_1714836125.png","Ear","2024-05-04 15:22:05","Castle Hills");
INSERT INTO patients_files VALUES("507","2024050437948","2024050445031","patients/p_pictures/Mouth_1714837312.png","Mouth","2024-05-04 15:41:52","Castle Hills");
INSERT INTO patients_files VALUES("508","2024050437948","2024050445031","patients/p_pictures/Mouth_1714838597.png","Mouth","2024-05-04 16:03:17","Castle Hills");
INSERT INTO patients_files VALUES("509","2024050470881","2024050430701","patients/p_pictures/Eye_1714849344.png","Eye","2024-05-04 19:02:24","Humble");
INSERT INTO patients_files VALUES("510","2024050475556","2024050428613","patients/p_pictures/Ear_1714851363.png","Ear","2024-05-04 19:36:03","Humble");
INSERT INTO patients_files VALUES("511","2024050475556","2024050428613","patients/p_pictures/Skin_1714851556.png","Skin","2024-05-04 19:39:16","Humble");
INSERT INTO patients_files VALUES("512","2024050475556","2024050428613","patients/p_pictures/Mouth_1714851635.png","Mouth","2024-05-04 19:40:35","Humble");
INSERT INTO patients_files VALUES("513","2024050475556","2024050428613","patients/p_pictures/Mouth_1714851658.png","Mouth","2024-05-04 19:40:58","Humble");
INSERT INTO patients_files VALUES("514","2024050475556","2024050428613","patients/p_pictures/Ear_1714851744.png","Ear","2024-05-04 19:42:24","Humble");
INSERT INTO patients_files VALUES("515","2024050475556","2024050428613","patients/p_pictures/Ear_1714851782.png","Ear","2024-05-04 19:43:02","Humble");
INSERT INTO patients_files VALUES("516","2024050487662","2024050446648","patients/p_pictures/TestResult_COVID_1714852988.png","TestResult_COVID","2024-05-04 20:03:08","Humble");
INSERT INTO patients_files VALUES("517","2024050487662","2024050446648","patients/p_pictures/TestResult_Flu_1714853004.png","TestResult_Flu","2024-05-04 20:03:24","Humble");
INSERT INTO patients_files VALUES("518","2024050469702","2024050457","patients/p_pictures/Skin_1714853586.png","Skin","2024-05-04 20:13:06","Humble");
INSERT INTO patients_files VALUES("519","2024050454521","2024050426608","patients/p_pictures/Skin_1714854052.png","Skin","2024-05-04 20:20:52","Humble");
INSERT INTO patients_files VALUES("520","2024050478758","2024050425510","patients/p_pictures/Mouth_1714855504.png","Mouth","2024-05-04 20:45:04","Humble");
INSERT INTO patients_files VALUES("521","2024050478758","2024050425510","patients/p_pictures/TestResult_strep_1714855561.png","TestResult_strep","2024-05-04 20:46:01","Humble");
INSERT INTO patients_files VALUES("522","2024050455336","2024050424406","patients/p_pictures/Eye_1714856498.png","Eye","2024-05-04 21:01:38","Humble");
INSERT INTO patients_files VALUES("523","2024050423167","202405049547","patients/p_pictures/Mouth_1714857730.png","Mouth","2024-05-04 21:22:10","Humble");
INSERT INTO patients_files VALUES("524","2024050423167","202405049547","patients/p_pictures/TestResult_strep_1714857753.png","TestResult_strep","2024-05-04 21:22:33","Humble");
INSERT INTO patients_files VALUES("525","2024050481063","2024050449849","patients/p_pictures/Ear_1714862515.png","Ear","2024-05-04 22:41:55","Humble");
INSERT INTO patients_files VALUES("526","2024050537004","2024050533910","patients/p_pictures/Skin_1714937538.png","Skin","2024-05-05 19:32:18","Humble");
INSERT INTO patients_files VALUES("527","2024050537004","2024050533910","patients/p_pictures/Skin_1714937566.png","Skin","2024-05-05 19:32:46","Humble");
INSERT INTO patients_files VALUES("528","2024050558498","2024050530013","patients/p_pictures/Eye_1714945345.png","Eye","2024-05-05 21:42:25","Humble");
INSERT INTO patients_files VALUES("529","2024050558498","2024050530013","patients/p_pictures/Eye_1714945386.png","Eye","2024-05-05 21:43:06","Humble");
INSERT INTO patients_files VALUES("530","2024050688572","2024050612306","patients/p_pictures/Skin_1715017911.png","Skin","2024-05-06 17:51:51","Castle Hills");
INSERT INTO patients_files VALUES("531","2024050761567","2024050712761","patients/p_pictures/Ear_1715091168.png","Ear","2024-05-07 14:12:48","Castle Hills");
INSERT INTO patients_files VALUES("532","2024050777390","2024050731698","patients/p_pictures/Mouth_1715116393.png","Mouth","2024-05-07 21:13:13","Castle Hills");
INSERT INTO patients_files VALUES("533","2024050777390","2024050731698","patients/p_pictures/Mouth_1715116758.png","Mouth","2024-05-07 21:19:18","Castle Hills");
INSERT INTO patients_files VALUES("534","2024050840282","2024050824423","patients/p_pictures/Mouth_1715177089.png","Mouth","2024-05-08 14:04:49","Humble");
INSERT INTO patients_files VALUES("535","2024050810325","2024050823027","patients/p_pictures/Ear_1715178422.png","Ear","2024-05-08 14:27:02","Castle Hills");
INSERT INTO patients_files VALUES("536","2024050941309","2024050916912","patients/p_pictures/Mouth_1715270094.png","Mouth","2024-05-09 15:54:54","Castle Hills");
INSERT INTO patients_files VALUES("537","2024050916724","2024050916590","patients/p_pictures/Ear_1715276775.png","Ear","2024-05-09 17:46:15","Humble");
INSERT INTO patients_files VALUES("538","2024051011688","2024051017963","patients/p_pictures/Mouth_1715350055.png","Mouth","2024-05-10 14:07:35","Castle Hills");
INSERT INTO patients_files VALUES("539","2024051063770","2024051029432","patients/p_pictures/TestResult_COVID_1715361015.png","TestResult_COVID","2024-05-10 17:10:15","Humble");
INSERT INTO patients_files VALUES("540","2024051155440","202405113880","patients/p_pictures/Skin_1715437304.png","Skin","2024-05-11 14:21:44","Castle Hills");
INSERT INTO patients_files VALUES("541","2024051220850","2024051227524","patients/p_pictures/Ear_1715521467.png","Ear","2024-05-12 13:44:27","nurse1");
INSERT INTO patients_files VALUES("542","2024051294376","2024051217134","patients/p_pictures/Skin_1715521655.png","Skin","2024-05-12 13:47:35","Reza");
INSERT INTO patients_files VALUES("543","2024051275400","2024051240321","patients/p_pictures/Ear_1715521877.png","Ear","2024-05-12 13:51:17","Castle Hills");
INSERT INTO patients_files VALUES("544","2024051238401","2024051237154","patients/p_pictures/Skin_1715522120.png","Skin","2024-05-12 13:55:20","Castle Hills");
INSERT INTO patients_files VALUES("545","2024051214544","2024051223392","patients/p_pictures/TestResult_hpybri_1715522618.png","TestResult_hpybri","2024-05-12 14:03:38","nurse1");
INSERT INTO patients_files VALUES("546","2024051221924","2024051240273","patients/p_pictures/Skin_1715522888.png","Skin","2024-05-12 14:08:08","Reza");
INSERT INTO patients_files VALUES("547","2024051180945","2024051136667","patients/p_pictures/Skin_1715523044.png","Skin","2024-05-12 14:10:44","Humble");
INSERT INTO patients_files VALUES("548","2024051180945","2024051136667","patients/p_pictures/Skin_1715523074.png","Skin","2024-05-12 14:11:14","Humble");
INSERT INTO patients_files VALUES("549","2024051180945","2024051136667","patients/p_pictures/Skin_1715523109.png","Skin","2024-05-12 14:11:49","Humble");
INSERT INTO patients_files VALUES("550","2024051284334","2024051228747","patients/p_pictures/Skin_1715523492.png","Skin","2024-05-12 14:18:12","Castle Hills");
INSERT INTO patients_files VALUES("551","2024051284334","2024051228747","patients/p_pictures/TestResult_Flu_1715523619.png","TestResult_Flu","2024-05-12 14:20:19","Castle Hills");
INSERT INTO patients_files VALUES("552","2024051240526","20240512858","patients/p_pictures/Skin_1715524203.png","Skin","2024-05-12 14:30:03","Humble");
INSERT INTO patients_files VALUES("553","2024051229396","2024051224118","patients/p_pictures/Ear_1715538798.png","Ear","2024-05-12 18:33:18","Castle Hills");
INSERT INTO patients_files VALUES("554","2024051229396","2024051224118","patients/p_pictures/Ear_1715538884.png","Ear","2024-05-12 18:34:44","Castle Hills");
INSERT INTO patients_files VALUES("555","2024051229396","2024051224118","patients/p_pictures/Mouth_1715539004.png","Mouth","2024-05-12 18:36:44","Castle Hills");
INSERT INTO patients_files VALUES("556","2024051250729","2024051243057","patients/p_pictures/Mouth_1715542940.png","Mouth","2024-05-12 19:42:20","Castle Hills");
INSERT INTO patients_files VALUES("557","2024051250729","2024051243057","patients/p_pictures/TestResult_Flu_1715543101.png","TestResult_Flu","2024-05-12 19:45:01","Castle Hills");
INSERT INTO patients_files VALUES("558","2024051374262","2024051323584","patients/p_pictures/Skin_1715609182.png","Skin","2024-05-13 14:06:22","Humble");
INSERT INTO patients_files VALUES("559","2024051432622","202405143626","patients/p_pictures/Skin_1715707961.png","Skin","2024-05-14 17:32:41","Humble");
INSERT INTO patients_files VALUES("560","2024051446518","2024051431750","patients/p_pictures/Eye_1715709546.png","Eye","2024-05-14 17:59:06","Humble");
INSERT INTO patients_files VALUES("561","2024051446518","2024051431750","patients/p_pictures/Eye_1715709559.png","Eye","2024-05-14 17:59:19","Humble");
INSERT INTO patients_files VALUES("562","2024051446518","2024051431750","patients/p_pictures/Eye_1715709585.png","Eye","2024-05-14 17:59:45","Humble");
INSERT INTO patients_files VALUES("563","2024051458387","20240514912","patients/p_pictures/Ear_1715713224.png","Ear","2024-05-14 19:00:24","Humble");
INSERT INTO patients_files VALUES("564","2024051416478","2024051448430","patients/p_pictures/Skin_1715714290.png","Skin","2024-05-14 19:18:10","Humble");
INSERT INTO patients_files VALUES("565","2024051416478","2024051448430","patients/p_pictures/Skin_1715714432.png","Skin","2024-05-14 19:20:32","Humble");
INSERT INTO patients_files VALUES("566","2024051416478","2024051448430","patients/p_pictures/Skin_1715714493.png","Skin","2024-05-14 19:21:33","Humble");
INSERT INTO patients_files VALUES("567","2024051488476","202405145848","patients/p_pictures/Ear_1715715965.png","Ear","2024-05-14 19:46:05","Humble");
INSERT INTO patients_files VALUES("568","2024051488476","202405145848","patients/p_pictures/Mouth_1715716068.png","Mouth","2024-05-14 19:47:48","Humble");
INSERT INTO patients_files VALUES("569","2024051488476","202405145848","patients/p_pictures/Mouth_1715716109.png","Mouth","2024-05-14 19:48:29","Humble");
INSERT INTO patients_files VALUES("570","2024051430141","202405142838","patients/p_pictures/Mouth_1715721735.png","Mouth","2024-05-14 21:22:15","Humble");
INSERT INTO patients_files VALUES("571","2024051430141","202405142838","patients/p_pictures/Ear_1715721809.png","Ear","2024-05-14 21:23:29","Humble");
INSERT INTO patients_files VALUES("572","2024051430141","202405142838","patients/p_pictures/Ear_1715721832.png","Ear","2024-05-14 21:23:52","Humble");
INSERT INTO patients_files VALUES("573","2024051462822","2024051442440","patients/p_pictures/Mouth_1715723455.png","Mouth","2024-05-14 21:50:55","Humble");
INSERT INTO patients_files VALUES("574","2024051462822","2024051442440","patients/p_pictures/TestResult_strep_1715723538.png","TestResult_strep","2024-05-14 21:52:18","Humble");
INSERT INTO patients_files VALUES("575","2024051462822","2024051442440","patients/p_pictures/TestResult_strep_1715723579.png","TestResult_strep","2024-05-14 21:52:59","Humble");
INSERT INTO patients_files VALUES("576","2024051594476","2024051538265","patients/p_pictures/Skin_1715775197.png","Skin","2024-05-15 12:13:17","VAM");
INSERT INTO patients_files VALUES("577","2024051594476","2024051538265","patients/p_pictures/TestResult_Hcg_1715775298.png","TestResult_Hcg","2024-05-15 12:14:58","VAM");
INSERT INTO patients_files VALUES("578","2024051560416","2024051536660","patients/p_pictures/Mouth_1715775701.png","Mouth","2024-05-15 12:21:41","Palmas");
INSERT INTO patients_files VALUES("579","2024051560416","2024051536660","patients/p_pictures/TestResult_Flu_1715775758.png","TestResult_Flu","2024-05-15 12:22:38","Palmas");
INSERT INTO patients_files VALUES("580","2024051596514","202405152123","patients/p_pictures/TestResult_COVID_1715782680.png","TestResult_COVID","2024-05-15 14:18:00","VAM");
INSERT INTO patients_files VALUES("581","2024051560221","2024051523889","patients/p_pictures/Ear_1715784307.png","Ear","2024-05-15 14:45:07","Castle Hills");
INSERT INTO patients_files VALUES("582","2024051574910","2024051532863","patients/p_pictures/Ear_1715785359.png","Ear","2024-05-15 15:02:39","Castle Hills");
INSERT INTO patients_files VALUES("583","2024051574910","2024051532863","patients/p_pictures/Ear_1715785359.png","Ear","2024-05-15 15:02:39","Castle Hills");
INSERT INTO patients_files VALUES("584","2024051574910","2024051532863","patients/p_pictures/Ear_1715785360.png","Ear","2024-05-15 15:02:40","Castle Hills");
INSERT INTO patients_files VALUES("585","2024051559645","202405158032","patients/p_pictures/Skin_1715785701.png","Skin","2024-05-15 15:08:21","Castle Hills");
INSERT INTO patients_files VALUES("586","2024051559645","202405158032","patients/p_pictures/Ear_1715785791.png","Ear","2024-05-15 15:09:51","Castle Hills");
INSERT INTO patients_files VALUES("587","2024051559645","202405158032","patients/p_pictures/Ear_1715785991.png","Ear","2024-05-15 15:13:11","Castle Hills");
INSERT INTO patients_files VALUES("588","2024051565268","2024051518753","patients/p_pictures/Mouth_1715795456.png","Mouth","2024-05-15 17:50:56","Castle Hills");
INSERT INTO patients_files VALUES("589","2024051565268","2024051518753","patients/p_pictures/Ear_1715795728.png","Ear","2024-05-15 17:55:28","Castle Hills");
INSERT INTO patients_files VALUES("590","2024051565268","2024051518753","patients/p_pictures/Ear_1715795786.png","Ear","2024-05-15 17:56:26","Castle Hills");
INSERT INTO patients_files VALUES("591","2024051597299","202405154995","patients/p_pictures/Mouth_1715797161.png","Mouth","2024-05-15 18:19:21","Castle Hills");
INSERT INTO patients_files VALUES("592","2024051597299","202405154995","patients/p_pictures/TestResult_strep_1715797285.png","TestResult_strep","2024-05-15 18:21:25","Castle Hills");
INSERT INTO patients_files VALUES("593","2024051563472","2024051547022","patients/p_pictures/Mouth_1715800746.png","Mouth","2024-05-15 19:19:06","Castle Hills");
INSERT INTO patients_files VALUES("594","2024051563472","2024051547022","patients/p_pictures/Ear_1715800868.png","Ear","2024-05-15 19:21:08","Castle Hills");
INSERT INTO patients_files VALUES("595","2024051563472","2024051547022","patients/p_pictures/Ear_1715800912.png","Ear","2024-05-15 19:21:52","Castle Hills");
INSERT INTO patients_files VALUES("596","2024051563472","2024051547022","patients/p_pictures/Ear_1715800973.png","Ear","2024-05-15 19:22:53","Castle Hills");
INSERT INTO patients_files VALUES("597","2024051544383","202405157843","patients/p_pictures/Ear_1715805904.png","Ear","2024-05-15 20:45:04","Castle Hills");
INSERT INTO patients_files VALUES("598","2024051544383","202405157843","patients/p_pictures/Mouth_1715805962.png","Mouth","2024-05-15 20:46:02","Castle Hills");
INSERT INTO patients_files VALUES("599","2024051651458","202405162800","patients/p_pictures/Ear_1715872725.png","Ear","2024-05-16 15:18:45","Palmas");
INSERT INTO patients_files VALUES("600","2024051651458","202405162800","patients/p_pictures/Ear_1715872730.png","Ear","2024-05-16 15:18:50","Palmas");
INSERT INTO patients_files VALUES("601","2024051625585","2024051644094","patients/p_pictures/Skin_1715876572.png","Skin","2024-05-16 16:22:52","Castle Hills");
INSERT INTO patients_files VALUES("602","2024051625585","2024051644094","patients/p_pictures/TestResult_strep_1715876655.png","TestResult_strep","2024-05-16 16:24:15","Castle Hills");
INSERT INTO patients_files VALUES("603","2024051644288","2024051623234","patients/p_pictures/Mouth_1715879560.png","Mouth","2024-05-16 17:12:40","Palmas");
INSERT INTO patients_files VALUES("604","2024051732896","202405171872","patients/p_pictures/Mouth_1715962470.png","Mouth","2024-05-17 16:14:30","Palmas");
INSERT INTO patients_files VALUES("605","2024051732896","202405171872","patients/p_pictures/Mouth_1715962526.png","Mouth","2024-05-17 16:15:26","Palmas");
INSERT INTO patients_files VALUES("606","2024051732896","202405171872","patients/p_pictures/TestResult_COVID_1715962756.png","TestResult_COVID","2024-05-17 16:19:16","Palmas");
INSERT INTO patients_files VALUES("607","2024051732896","202405171872","patients/p_pictures/TestResult_Flu_1715962803.png","TestResult_Flu","2024-05-17 16:20:03","Palmas");
INSERT INTO patients_files VALUES("608","2024051732896","202405171872","patients/p_pictures/Ear_1715963292.png","Ear","2024-05-17 16:28:12","Palmas");
INSERT INTO patients_files VALUES("609","2024051732896","202405171872","patients/p_pictures/Ear_1715963809.png","Ear","2024-05-17 16:36:49","Palmas");
INSERT INTO patients_files VALUES("610","2024051732896","202405171872","patients/p_pictures/Ear_1715963909.png","Ear","2024-05-17 16:38:29","Palmas");
INSERT INTO patients_files VALUES("611","2024051732896","202405171872","patients/p_pictures/Ear_1715963927.png","Ear","2024-05-17 16:38:47","Palmas");
INSERT INTO patients_files VALUES("612","2024051798901","2024051739787","patients/p_pictures/Mouth_1715974381.png","Mouth","2024-05-17 19:33:01","Palmas");
INSERT INTO patients_files VALUES("613","2024051798901","2024051739787","patients/p_pictures/Mouth_1715974381.png","Mouth","2024-05-17 19:33:01","Palmas");
INSERT INTO patients_files VALUES("614","2024051798901","2024051739787","patients/p_pictures/Mouth_1715974388.png","Mouth","2024-05-17 19:33:08","Palmas");
INSERT INTO patients_files VALUES("615","2024051798901","2024051739787","patients/p_pictures/Ear_1715974417.png","Ear","2024-05-17 19:33:37","Palmas");
INSERT INTO patients_files VALUES("616","2024051798901","2024051739787","patients/p_pictures/TestResult_COVID_1715974452.png","TestResult_COVID","2024-05-17 19:34:12","Palmas");
INSERT INTO patients_files VALUES("617","2024051750449","2024051713082","patients/p_pictures/Mouth_1715974620.png","Mouth","2024-05-17 19:37:00","Palmas");
INSERT INTO patients_files VALUES("618","2024051750449","2024051713082","patients/p_pictures/TestResult_Flu_1715974680.png","TestResult_Flu","2024-05-17 19:38:00","Palmas");
INSERT INTO patients_files VALUES("619","2024051750449","2024051713082","patients/p_pictures/TestResult_COVID_1715974717.png","TestResult_COVID","2024-05-17 19:38:37","Palmas");
INSERT INTO patients_files VALUES("620","2024051750449","2024051713082","patients/p_pictures/TestResult_strep_1715974969.png","TestResult_strep","2024-05-17 19:42:49","Palmas");
INSERT INTO patients_files VALUES("621","2024051878610","202405182288","patients/p_pictures/Skin_1716062519.png","Skin","2024-05-18 20:01:59","Humble");
INSERT INTO patients_files VALUES("622","2024051943753","2024051913034","patients/p_pictures/Skin_1716127407.png","Skin","2024-05-19 14:03:27","Castle Hills");
INSERT INTO patients_files VALUES("623","2024051984373","2024051949988","patients/p_pictures/Skin_1716134659.png","Skin","2024-05-19 16:04:19","Castle Hills");
INSERT INTO patients_files VALUES("624","2024052012888","2024052018057","patients/p_pictures/TestResult_COVID_1716216012.png","TestResult_COVID","2024-05-20 14:40:12","Palmas");
INSERT INTO patients_files VALUES("625","2024052012888","2024052018057","patients/p_pictures/TestResult_Flu_1716216027.png","TestResult_Flu","2024-05-20 14:40:27","Palmas");
INSERT INTO patients_files VALUES("626","2024052012888","2024052018057","patients/p_pictures/TestResult_RSV_1716216054.png","TestResult_RSV","2024-05-20 14:40:54","Palmas");
INSERT INTO patients_files VALUES("627","2024052012888","2024052018057","patients/p_pictures/TestResult_strep_1716216075.png","TestResult_strep","2024-05-20 14:41:15","Palmas");
INSERT INTO patients_files VALUES("628","2024052088840","2024052034817","patients/p_pictures/Skin_1716219803.png","Skin","2024-05-20 15:43:23","Palmas");
INSERT INTO patients_files VALUES("629","2024052088840","2024052034817","patients/p_pictures/Skin_1716220045.png","Skin","2024-05-20 15:47:25","Palmas");
INSERT INTO patients_files VALUES("630","2024052073528","202405206057","patients/p_pictures/TestResult_COVID_1716221157.png","TestResult_COVID","2024-05-20 16:05:57","Castle Hills");
INSERT INTO patients_files VALUES("631","2024052073528","202405206057","patients/p_pictures/TestResult_COVID_1716221165.png","TestResult_COVID","2024-05-20 16:06:05","Castle Hills");
INSERT INTO patients_files VALUES("632","2024052073528","202405206057","patients/p_pictures/TestResult_Flu_1716221194.png","TestResult_Flu","2024-05-20 16:06:34","Castle Hills");
INSERT INTO patients_files VALUES("633","2024052014476","2024052037890","patients/p_pictures/TestResult_COVID_1716228957.png","TestResult_COVID","2024-05-20 18:15:57","Palmas");
INSERT INTO patients_files VALUES("634","2024052014476","2024052037890","patients/p_pictures/Mouth_1716229007.png","Mouth","2024-05-20 18:16:47","Palmas");
INSERT INTO patients_files VALUES("635","2024052132529","202405215683","patients/p_pictures/Mouth_1716301458.png","Mouth","2024-05-21 14:24:18","VAM");
INSERT INTO patients_files VALUES("636","2024052132529","202405215683","patients/p_pictures/Mouth_1716301477.png","Mouth","2024-05-21 14:24:37","VAM");
INSERT INTO patients_files VALUES("637","2024052127287","2024052116544","patients/p_pictures/Ear_1716304765.png","Ear","2024-05-21 15:19:25","Castle Hills");
INSERT INTO patients_files VALUES("638","2024052127287","2024052116544","patients/p_pictures/Skin_1716304818.png","Skin","2024-05-21 15:20:18","Castle Hills");
INSERT INTO patients_files VALUES("639","2024052148535","2024052142827","patients/p_pictures/Ear_1716305971.png","Ear","2024-05-21 15:39:31","Castle Hills");
INSERT INTO patients_files VALUES("640","2024052148535","2024052142827","patients/p_pictures/Ear_1716306011.png","Ear","2024-05-21 15:40:11","Castle Hills");
INSERT INTO patients_files VALUES("641","2024052174923","2024052124077","patients/p_pictures/TestResult_COVID_1716308143.png","TestResult_COVID","2024-05-21 16:15:43","VAM");
INSERT INTO patients_files VALUES("642","2024052174923","2024052124077","patients/p_pictures/Mouth_1716308220.png","Mouth","2024-05-21 16:17:00","VAM");
INSERT INTO patients_files VALUES("643","2024052174923","2024052124077","patients/p_pictures/TestResult_strep_1716308279.png","TestResult_strep","2024-05-21 16:17:59","VAM");
INSERT INTO patients_files VALUES("644","2024052118362","2024052150","patients/p_pictures/TestResult_COVID_1716325467.png","TestResult_COVID","2024-05-21 21:04:27","Palmas");
INSERT INTO patients_files VALUES("645","2024052118362","2024052150","patients/p_pictures/TestResult_Mono_1716325502.png","TestResult_Mono","2024-05-21 21:05:02","Palmas");
INSERT INTO patients_files VALUES("646","2024052118362","2024052150","patients/p_pictures/TestResult_Hcg_1716328488.png","TestResult_Hcg","2024-05-21 21:54:48","Palmas");
INSERT INTO patients_files VALUES("647","2024052273375","20240522188","patients/p_pictures/Skin_1716387415.png","Skin","2024-05-22 14:16:55","VAM");
INSERT INTO patients_files VALUES("648","2024052288305","2024052229373","patients/p_pictures/TestResult_COVID_1716394761.png","TestResult_COVID","2024-05-22 16:19:21","VAM");
INSERT INTO patients_files VALUES("649","2024052223007","2024052214065","patients/p_pictures/Ear_1716402990.png","Ear","2024-05-22 18:36:30","Castle Hills");
INSERT INTO patients_files VALUES("650","2024052226408","2024052231059","patients/p_pictures/Ear_1716408165.png","Ear","2024-05-22 20:02:45","Castle Hills");
INSERT INTO patients_files VALUES("651","2024052226408","2024052231059","patients/p_pictures/Ear_1716408245.png","Ear","2024-05-22 20:04:05","Castle Hills");
INSERT INTO patients_files VALUES("652","2024052226408","2024052231059","patients/p_pictures/Mouth_1716408327.png","Mouth","2024-05-22 20:05:27","Castle Hills");
INSERT INTO patients_files VALUES("653","2024052328836","2024052322315","patients/p_pictures/Skin_1716473959.png","Skin","2024-05-23 14:19:19","Castle Hills");
INSERT INTO patients_files VALUES("654","2024052383493","2024052348522","patients/p_pictures/TestResult_RSV_1716475116.png","TestResult_RSV","2024-05-23 14:38:36","Humble");
INSERT INTO patients_files VALUES("655","2024052383493","2024052348522","patients/p_pictures/Ear_1716475124.png","Ear","2024-05-23 14:38:44","Humble");
INSERT INTO patients_files VALUES("656","2024052319090","2024052340731","patients/p_pictures/Eye_1716479992.png","Eye","2024-05-23 15:59:52","Palmas");
INSERT INTO patients_files VALUES("657","2024052319090","2024052340731","patients/p_pictures/Mouth_1716480027.png","Mouth","2024-05-23 16:00:27","Palmas");
INSERT INTO patients_files VALUES("658","2024052369317","2024052340534","patients/p_pictures/Ear_1716504915.png","Ear","2024-05-23 22:55:15","Humble");
INSERT INTO patients_files VALUES("659","2024052498717","202405245689","patients/p_pictures/Skin_1716560272.png","Skin","2024-05-24 14:17:52","Castle Hills");
INSERT INTO patients_files VALUES("660","2024052448075","2024052447015","patients/p_pictures/Skin_1716565644.png","Skin","2024-05-24 15:47:24","Palmas");
INSERT INTO patients_files VALUES("661","2024052446994","20240524516","patients/p_pictures/Skin_1716587068.png","Skin","2024-05-24 21:44:28","Palmas");
INSERT INTO patients_files VALUES("662","2024052446994","20240524516","patients/p_pictures/Skin_1716587133.png","Skin","2024-05-24 21:45:33","Palmas");
INSERT INTO patients_files VALUES("663","2024052446994","20240524516","patients/p_pictures/Skin_1716587164.png","Skin","2024-05-24 21:46:04","Palmas");
INSERT INTO patients_files VALUES("664","2024052522724","2024052517529","patients/p_pictures/Skin_1716646767.png","Skin","2024-05-25 14:19:27","Castle Hills");
INSERT INTO patients_files VALUES("665","2024052679957","2024052610282","patients/p_pictures/Skin_1716733234.png","Skin","2024-05-26 14:20:34","Castle Hills");
INSERT INTO patients_files VALUES("666","2024052649897","2024052614554","patients/p_pictures/Skin_1716733940.png","Skin","2024-05-26 14:32:20","Humble");
INSERT INTO patients_files VALUES("667","2024052830975","2024052836074","patients/p_pictures/Ear_1716905462.png","Ear","2024-05-28 14:11:03","VAM");
INSERT INTO patients_files VALUES("668","2024052830975","2024052836074","patients/p_pictures/Ear_1716905502.png","Ear","2024-05-28 14:11:42","VAM");
INSERT INTO patients_files VALUES("669","2024052830975","2024052836074","patients/p_pictures/Ear_1716905575.png","Ear","2024-05-28 14:12:55","VAM");
INSERT INTO patients_files VALUES("670","2024052829191","2024052819603","patients/p_pictures/Ear_1716907849.png","Ear","2024-05-28 14:50:49","VAM");
INSERT INTO patients_files VALUES("671","2024052859072","202405284092","patients/p_pictures/TestResult_Flu_1716911937.png","TestResult_Flu","2024-05-28 15:58:57","Palmas");
INSERT INTO patients_files VALUES("672","2024052859072","202405284092","patients/p_pictures/TestResult_COVID_1716911972.png","TestResult_COVID","2024-05-28 15:59:32","Palmas");
INSERT INTO patients_files VALUES("673","2024052937932","202405295606","patients/p_pictures/Skin_1717013180.png","Skin","2024-05-29 20:06:20","Palmas");
INSERT INTO patients_files VALUES("674","2024052937932","202405295606","patients/p_pictures/Skin_1717013218.png","Skin","2024-05-29 20:06:58","Palmas");
INSERT INTO patients_files VALUES("675","2024053057140","202405305704","patients/p_pictures/Ear_1717088634.png","Ear","2024-05-30 17:03:54","Castle Hills");
INSERT INTO patients_files VALUES("676","2024053131929","202405315874","patients/p_pictures/Skin_1717170888.png","Skin","2024-05-31 15:54:48","Palmas");
INSERT INTO patients_files VALUES("677","2024053125377","2024053124994","patients/p_pictures/Mouth_1717175107.png","Mouth","2024-05-31 17:05:07","Palmas");
INSERT INTO patients_files VALUES("678","2024053157099","2024053124122","patients/p_pictures/Mouth_1717178219.png","Mouth","2024-05-31 17:56:59","Humble");
INSERT INTO patients_files VALUES("679","2024053157099","2024053124122","patients/p_pictures/Mouth_1717178234.png","Mouth","2024-05-31 17:57:14","Humble");
INSERT INTO patients_files VALUES("680","2024053157099","2024053124122","patients/p_pictures/Ear_1717178366.png","Ear","2024-05-31 17:59:26","Humble");
INSERT INTO patients_files VALUES("681","2024053157099","2024053124122","patients/p_pictures/Ear_1717178419.png","Ear","2024-05-31 18:00:19","Humble");
INSERT INTO patients_files VALUES("682","2024053157099","2024053124122","patients/p_pictures/TestResult_COVID_1717178596.png","TestResult_COVID","2024-05-31 18:03:16","Humble");
INSERT INTO patients_files VALUES("683","2024053157099","2024053124122","patients/p_pictures/TestResult_COVID_1717178614.png","TestResult_COVID","2024-05-31 18:03:34","Humble");
INSERT INTO patients_files VALUES("684","2024053196899","2024053139919","patients/p_pictures/Mouth_1717183060.png","Mouth","2024-05-31 19:17:40","Humble");
INSERT INTO patients_files VALUES("685","2024053196899","2024053139919","patients/p_pictures/Mouth_1717183105.png","Mouth","2024-05-31 19:18:25","Humble");
INSERT INTO patients_files VALUES("686","2024053196899","2024053139919","patients/p_pictures/TestResult_COVID_1717183213.png","TestResult_COVID","2024-05-31 19:20:13","Humble");
INSERT INTO patients_files VALUES("687","2024060150225","202406014165","patients/p_pictures/Mouth_1717260734.png","Mouth","2024-06-01 16:52:14","Castle Hills");
INSERT INTO patients_files VALUES("688","2024060150225","202406014165","patients/p_pictures/TestResult_Flu_1717260805.png","TestResult_Flu","2024-06-01 16:53:25","Castle Hills");
INSERT INTO patients_files VALUES("689","2024060386861","2024060347162","patients/p_pictures/Ear_1717426246.png","Ear","2024-06-03 14:50:46","Castle Hills");
INSERT INTO patients_files VALUES("690","2024060316718","2024060329865","patients/p_pictures/Skin_1717427608.png","Skin","2024-06-03 15:13:28","Castle Hills");
INSERT INTO patients_files VALUES("691","2024060373940","202406036105","patients/p_pictures/TestResult_Flu_1717431513.png","TestResult_Flu","2024-06-03 16:18:33","Palmas");
INSERT INTO patients_files VALUES("692","2024060373940","202406036105","patients/p_pictures/TestResult_COVID_1717431554.png","TestResult_COVID","2024-06-03 16:19:14","Palmas");
INSERT INTO patients_files VALUES("693","2024060454472","2024060446638","patients/p_pictures/TestResult_UA_1717512775.png","TestResult_UA","2024-06-04 14:52:55","Palmas");
INSERT INTO patients_files VALUES("694","2024060416733","2024060442116","patients/p_pictures/Ear_1717514789.png","Ear","2024-06-04 15:26:29","Castle Hills");
INSERT INTO patients_files VALUES("695","2024060416733","2024060442116","patients/p_pictures/Ear_1717514892.png","Ear","2024-06-04 15:28:12","Castle Hills");
INSERT INTO patients_files VALUES("696","2024060416733","2024060442116","patients/p_pictures/Skin_1717515046.png","Skin","2024-06-04 15:30:46","Castle Hills");
INSERT INTO patients_files VALUES("697","2024060416733","2024060442116","patients/p_pictures/Skin_1717515064.png","Skin","2024-06-04 15:31:04","Castle Hills");
INSERT INTO patients_files VALUES("698","2024060476996","2024060413071","patients/p_pictures/Skin_1717517990.png","Skin","2024-06-04 16:19:50","Castle Hills");
INSERT INTO patients_files VALUES("699","2024060590974","2024060526964","patients/p_pictures/Mouth_1717599007.png","Mouth","2024-06-05 14:50:07","Palmas");
INSERT INTO patients_files VALUES("700","2024060511835","202406058316","patients/p_pictures/Skin_1717610407.png","Skin","2024-06-05 18:00:07","Palmas");
INSERT INTO patients_files VALUES("701","2024060598519","2024060523095","patients/p_pictures/Eye_1717614430.png","Eye","2024-06-05 19:07:10","Palmas");
INSERT INTO patients_files VALUES("702","2024060598519","2024060523095","patients/p_pictures/Eye_1717614509.png","Eye","2024-06-05 19:08:29","Palmas");
INSERT INTO patients_files VALUES("703","2024060598519","2024060523095","patients/p_pictures/Eye_1717614563.png","Eye","2024-06-05 19:09:23","Palmas");
INSERT INTO patients_files VALUES("704","2024060598519","2024060523095","patients/p_pictures/Eye_1717614589.png","Eye","2024-06-05 19:09:49","Palmas");
INSERT INTO patients_files VALUES("705","2024060636738","20240606338","patients/p_pictures/Skin_1717686194.png","Skin","2024-06-06 15:03:14","Castle Hills");
INSERT INTO patients_files VALUES("706","2024060880104","20240608167","patients/p_pictures/Skin_1717862291.png","Skin","2024-06-08 15:58:11","Castle Hills");
INSERT INTO patients_files VALUES("707","2024060837402","2024060842670","patients/p_pictures/Skin_1717862306.png","Skin","2024-06-08 15:58:26","Humble");
INSERT INTO patients_files VALUES("708","2024061045078","2024061022218","patients/p_pictures/Skin_1718031867.png","Skin","2024-06-10 15:04:27","Castle Hills");
INSERT INTO patients_files VALUES("709","2024061044101","2024061014364","patients/p_pictures/Mouth_1718033990.png","Mouth","2024-06-10 15:39:50","Reza");
INSERT INTO patients_files VALUES("710","2024061044101","2024061014364","patients/p_pictures/Eye_1718034002.png","Eye","2024-06-10 15:40:02","Reza");
INSERT INTO patients_files VALUES("711","2024061044101","2024061014364","patients/p_pictures/TestResult_Flu_1718034120.png","TestResult_Flu","2024-06-10 15:42:00","Reza");
INSERT INTO patients_files VALUES("712","2024061086627","2024061022121","patients/p_pictures/Skin_1718034838.png","Skin","2024-06-10 15:53:58","Castle Hills");
INSERT INTO patients_files VALUES("713","2024061168230","2024061146474","patients/p_pictures/Mouth_1718123709.png","Mouth","2024-06-11 16:35:09","Palmas");
INSERT INTO patients_files VALUES("714","2024061168230","2024061146474","patients/p_pictures/Mouth_1718123730.png","Mouth","2024-06-11 16:35:30","Palmas");
INSERT INTO patients_files VALUES("715","2024061168230","2024061146474","patients/p_pictures/Mouth_1718123751.png","Mouth","2024-06-11 16:35:51","Palmas");
INSERT INTO patients_files VALUES("716","2024061168230","2024061146474","patients/p_pictures/Mouth_1718123771.png","Mouth","2024-06-11 16:36:11","Palmas");
INSERT INTO patients_files VALUES("717","2024061216277","2024061221319","patients/p_pictures/Ear_1718200423.png","Ear","2024-06-12 13:53:43","Castle Hills");
INSERT INTO patients_files VALUES("718","2024061216277","2024061221319","patients/p_pictures/Ear_1718200568.png","Ear","2024-06-12 13:56:08","Castle Hills");
INSERT INTO patients_files VALUES("719","2024061227592","2024061235867","patients/p_pictures/Ear_1718221421.png","Ear","2024-06-12 19:43:41","VAM");
INSERT INTO patients_files VALUES("720","2024061294491","2024061224280","patients/p_pictures/Ear_1718223365.png","Ear","2024-06-12 20:16:05","VAM");
INSERT INTO patients_files VALUES("721","2024061315343","2024061328730","patients/p_pictures/Eye_1718286728.png","Eye","2024-06-13 13:52:08","Palmas");
INSERT INTO patients_files VALUES("722","2024061384884","2024061311452","patients/p_pictures/Skin_1718288385.png","Skin","2024-06-13 14:19:45","Castle Hills");
INSERT INTO patients_files VALUES("723","2024061354420","2024061324287","patients/p_pictures/Mouth_1718294509.png","Mouth","2024-06-13 16:01:49","VAM");
INSERT INTO patients_files VALUES("724","2024061366614","2024061371","patients/p_pictures/Ear_1718298766.png","Ear","2024-06-13 17:12:46","Castle Hills");
INSERT INTO patients_files VALUES("725","2024061366614","2024061371","patients/p_pictures/Ear_1718298822.png","Ear","2024-06-13 17:13:42","Castle Hills");
INSERT INTO patients_files VALUES("726","2024061381878","2024061323655","patients/p_pictures/Ear_1718302820.png","Ear","2024-06-13 18:20:20","Castle Hills");
INSERT INTO patients_files VALUES("727","2024061381878","2024061323655","patients/p_pictures/Ear_1718302850.png","Ear","2024-06-13 18:20:50","Castle Hills");
INSERT INTO patients_files VALUES("728","2024061362298","202406131761","patients/p_pictures/Mouth_1718318507.png","Mouth","2024-06-13 22:41:47","VAM");
INSERT INTO patients_files VALUES("729","2024061473198","2024061413755","patients/p_pictures/Mouth_1718370554.png","Mouth","2024-06-14 13:09:14","Reza");
INSERT INTO patients_files VALUES("730","2024061473198","2024061413755","patients/p_pictures/TestResult_strep_1718370608.png","TestResult_strep","2024-06-14 13:10:08","Reza");
INSERT INTO patients_files VALUES("731","2024061421410","2024061419524","patients/p_pictures/Mouth_1718375717.png","Mouth","2024-06-14 14:35:17","VAM");
INSERT INTO patients_files VALUES("732","2024061493061","2024061419208","patients/p_pictures/TestResult_UA_1718378418.png","TestResult_UA","2024-06-14 15:20:18","VAM");
INSERT INTO patients_files VALUES("733","2024061510909","202406153038","patients/p_pictures/Mouth_1718476265.png","Mouth","2024-06-15 18:31:05","Humble");
INSERT INTO patients_files VALUES("734","2024061510909","202406153038","patients/p_pictures/Mouth_1718476279.png","Mouth","2024-06-15 18:31:19","Humble");
INSERT INTO patients_files VALUES("735","2024061586062","2024061540563","patients/p_pictures/Mouth_1718476659.png","Mouth","2024-06-15 18:37:39","Humble");
INSERT INTO patients_files VALUES("736","2024061712848","2024061739792","patients/p_pictures/Mouth_1718639536.png","Mouth","2024-06-17 15:52:16","VAM");
INSERT INTO patients_files VALUES("737","2024061712848","2024061739792","patients/p_pictures/Mouth_1718639582.png","Mouth","2024-06-17 15:53:02","VAM");
INSERT INTO patients_files VALUES("738","2024061712196","2024061749832","patients/p_pictures/Ear_1718649527.png","Ear","2024-06-17 18:38:47","VAM");
INSERT INTO patients_files VALUES("739","2024061712196","2024061749832","patients/p_pictures/Ear_1718649630.png","Ear","2024-06-17 18:40:30","VAM");
INSERT INTO patients_files VALUES("740","2024061780353","2024061725445","patients/p_pictures/Skin_1718654453.png","Skin","2024-06-17 20:00:53","Palmas");
INSERT INTO patients_files VALUES("741","2024061780353","2024061725445","patients/p_pictures/Skin_1718654477.png","Skin","2024-06-17 20:01:17","Palmas");
INSERT INTO patients_files VALUES("742","2024061818972","2024061823927","patients/p_pictures/Skin_1718719182.png","Skin","2024-06-18 13:59:42","Castle Hills");
INSERT INTO patients_files VALUES("743","2024061843999","2024061830444","patients/p_pictures/Ear_1718722041.png","Ear","2024-06-18 14:47:21","Castle Hills");
INSERT INTO patients_files VALUES("744","2024061867349","2024061815132","patients/p_pictures/Mouth_1718736199.png","Mouth","2024-06-18 18:43:19","VAM");
INSERT INTO patients_files VALUES("745","2024061967603","2024061916100","patients/p_pictures/Skin_1718825847.png","Skin","2024-06-19 19:37:27","Humble");
INSERT INTO patients_files VALUES("746","2024061935235","2024061946962","patients/p_pictures/TestResult_COVID_1718829466.png","TestResult_COVID","2024-06-19 20:37:46","VAM");
INSERT INTO patients_files VALUES("747","2024061935235","2024061946962","patients/p_pictures/TestResult_COVID_1718829532.png","TestResult_COVID","2024-06-19 20:38:52","VAM");
INSERT INTO patients_files VALUES("748","2024061935235","2024061946962","patients/p_pictures/TestResult_Flu_1718829616.png","TestResult_Flu","2024-06-19 20:40:16","VAM");
INSERT INTO patients_files VALUES("749","2024061917725","2024061930790","patients/p_pictures/TestResult_Hcg_1718833610.png","TestResult_Hcg","2024-06-19 21:46:50","VAM");
INSERT INTO patients_files VALUES("750","2024062046998","2024062034730","patients/p_pictures/Ear_1718896679.png","Ear","2024-06-20 15:17:59","Palmas");
INSERT INTO patients_files VALUES("751","2024062099623","2024062049283","patients/p_pictures/Ear_1718898644.png","Ear","2024-06-20 15:50:44","Castle Hills");
INSERT INTO patients_files VALUES("752","2024062099623","2024062049283","patients/p_pictures/Ear_1718898766.png","Ear","2024-06-20 15:52:46","Castle Hills");
INSERT INTO patients_files VALUES("753","2024062099623","2024062049283","patients/p_pictures/Ear_1718898816.png","Ear","2024-06-20 15:53:36","Castle Hills");
INSERT INTO patients_files VALUES("754","2024062099623","2024062049283","patients/p_pictures/Ear_1718898835.png","Ear","2024-06-20 15:53:55","Castle Hills");
INSERT INTO patients_files VALUES("755","2024062149052","2024062138855","patients/p_pictures/Skin_1719002035.png","Skin","2024-06-21 20:33:55","Palmas");
INSERT INTO patients_files VALUES("756","2024062149052","2024062138855","patients/p_pictures/Skin_1719002065.png","Skin","2024-06-21 20:34:25","Palmas");
INSERT INTO patients_files VALUES("757","2024062149052","2024062138855","patients/p_pictures/Skin_1719002122.png","Skin","2024-06-21 20:35:22","Palmas");
INSERT INTO patients_files VALUES("758","2024062216579","2024062211867","patients/p_pictures/Skin_1719069039.png","Skin","2024-06-22 15:10:39","Castle Hills");
INSERT INTO patients_files VALUES("759","2024062216579","2024062211867","patients/p_pictures/Skin_1719069073.png","Skin","2024-06-22 15:11:13","Castle Hills");
INSERT INTO patients_files VALUES("760","2024062270140","2024062248619","patients/p_pictures/Skin_1719071721.png","Skin","2024-06-22 15:55:21","Castle Hills");
INSERT INTO patients_files VALUES("761","2024062298622","2024062210138","patients/p_pictures/Ear_1719076064.png","Ear","2024-06-22 17:07:44","Castle Hills");
INSERT INTO patients_files VALUES("762","2024062298622","2024062210138","patients/p_pictures/TestResult_UA_1719076113.png","TestResult_UA","2024-06-22 17:08:33","Castle Hills");
INSERT INTO patients_files VALUES("763","2024062353993","202406239304","patients/p_pictures/Skin_1719154824.png","Skin","2024-06-23 15:00:24","Castle Hills");
INSERT INTO patients_files VALUES("764","2024062414085","2024062412722","patients/p_pictures/Mouth_1719239008.png","Mouth","2024-06-24 14:23:28","VAM");
INSERT INTO patients_files VALUES("765","2024062414085","2024062412722","patients/p_pictures/Eye_1719239055.png","Eye","2024-06-24 14:24:15","VAM");
INSERT INTO patients_files VALUES("766","2024062494590","2024062419628","patients/p_pictures/Eye_1719245205.png","Eye","2024-06-24 16:06:45","VAM");
INSERT INTO patients_files VALUES("767","2024062494590","2024062419628","patients/p_pictures/Eye_1719245230.png","Eye","2024-06-24 16:07:10","VAM");
INSERT INTO patients_files VALUES("768","2024062471164","2024062444244","patients/p_pictures/TestResult_strep_1719249207.png","TestResult_strep","2024-06-24 17:13:27","VAM");
INSERT INTO patients_files VALUES("769","2024062419859","2024062413276","patients/p_pictures/Ear_1719257834.png","Ear","2024-06-24 19:37:14","VAM");
INSERT INTO patients_files VALUES("770","2024062419859","2024062413276","patients/p_pictures/Ear_1719257950.png","Ear","2024-06-24 19:39:10","VAM");
INSERT INTO patients_files VALUES("771","2024062419859","2024062413276","patients/p_pictures/Ear_1719258728.png","Ear","2024-06-24 19:52:08","VAM");
INSERT INTO patients_files VALUES("772","2024062488189","2024062448480","patients/p_pictures/Mouth_1719262724.png","Mouth","2024-06-24 20:58:44","VAM");
INSERT INTO patients_files VALUES("773","2024062488189","2024062448480","patients/p_pictures/Mouth_1719262766.png","Mouth","2024-06-24 20:59:26","VAM");
INSERT INTO patients_files VALUES("774","2024062524160","2024062519941","patients/p_pictures/Skin_1719343169.png","Skin","2024-06-25 19:19:29","VAM");
INSERT INTO patients_files VALUES("775","2024062681089","2024062649726","patients/p_pictures/Ear_1719413140.png","Ear","2024-06-26 14:45:40","VAM");
INSERT INTO patients_files VALUES("776","2024062681089","2024062649726","patients/p_pictures/Ear_1719413192.png","Ear","2024-06-26 14:46:32","VAM");
INSERT INTO patients_files VALUES("777","2024062654713","2024062645190","patients/p_pictures/TestResult_COVID_1719429428.png","TestResult_COVID","2024-06-26 19:17:08","VAM");
INSERT INTO patients_files VALUES("778","2024062654713","2024062645190","patients/p_pictures/Mouth_1719429475.png","Mouth","2024-06-26 19:17:55","VAM");
INSERT INTO patients_files VALUES("779","2024062654713","2024062645190","patients/p_pictures/TestResult_strep_1719429524.png","TestResult_strep","2024-06-26 19:18:44","VAM");
INSERT INTO patients_files VALUES("780","2024062739209","2024062721698","patients/p_pictures/TestResult_strep_1719498057.png","TestResult_strep","2024-06-27 14:20:57","VAM");
INSERT INTO patients_files VALUES("781","2024062743732","2024062714542","patients/p_pictures/Skin_1719509944.png","Skin","2024-06-27 17:39:04","VAM");
INSERT INTO patients_files VALUES("782","2024062743732","2024062714542","patients/p_pictures/Skin_1719509979.png","Skin","2024-06-27 17:39:39","VAM");
INSERT INTO patients_files VALUES("783","2024062743732","2024062714542","patients/p_pictures/Skin_1719510011.png","Skin","2024-06-27 17:40:11","VAM");
INSERT INTO patients_files VALUES("784","2024062743732","2024062714542","patients/p_pictures/Skin_1719510070.png","Skin","2024-06-27 17:41:10","VAM");
INSERT INTO patients_files VALUES("785","2024062743732","2024062714542","patients/p_pictures/Skin_1719510093.png","Skin","2024-06-27 17:41:33","VAM");
INSERT INTO patients_files VALUES("786","2024062888576","2024062835851","patients/p_pictures/Skin_1719606685.png","Skin","2024-06-28 20:31:25","Palmas");
INSERT INTO patients_files VALUES("787","2024062888576","2024062835851","patients/p_pictures/Skin_1719606718.png","Skin","2024-06-28 20:31:58","Palmas");
INSERT INTO patients_files VALUES("788","2024062912297","2024062943530","patients/p_pictures/Skin_1719679311.png","Skin","2024-06-29 16:41:51","Humble");
INSERT INTO patients_files VALUES("789","2024062912297","2024062943530","patients/p_pictures/Skin_1719679312.png","Skin","2024-06-29 16:41:52","Humble");
INSERT INTO patients_files VALUES("790","2024062912297","2024062943530","patients/p_pictures/Skin_1719679313.png","Skin","2024-06-29 16:41:53","Humble");
INSERT INTO patients_files VALUES("791","2024062994969","2024062923080","patients/p_pictures/Skin_1719679473.png","Skin","2024-06-29 16:44:33","Humble");
INSERT INTO patients_files VALUES("792","2024062994969","2024062923080","patients/p_pictures/Skin_1719679477.png","Skin","2024-06-29 16:44:37","Humble");
INSERT INTO patients_files VALUES("793","2024063032792","2024063035541","patients/p_pictures/Skin_1719756036.png","Skin","2024-06-30 14:00:36","Humble");
INSERT INTO patients_files VALUES("794","2024063015657","2024063027122","patients/p_pictures/Skin_1719760489.png","Skin","2024-06-30 15:14:49","Humble");
INSERT INTO patients_files VALUES("795","2024063092547","2024063034826","patients/p_pictures/Skin_1719775122.png","Skin","2024-06-30 19:18:42","Humble");
INSERT INTO patients_files VALUES("796","2024070142288","2024070127673","patients/p_pictures/Skin_1719855818.png","Skin","2024-07-01 17:43:38","VAM");
INSERT INTO patients_files VALUES("797","2024070118441","202407015286","patients/p_pictures/Eye_1719860253.png","Eye","2024-07-01 18:57:33","VAM");
INSERT INTO patients_files VALUES("798","2024070183799","2024070148378","patients/p_pictures/Eye_1719861288.png","Eye","2024-07-01 19:14:48","VAM");
INSERT INTO patients_files VALUES("799","2024070183799","2024070148378","patients/p_pictures/Eye_1719861316.png","Eye","2024-07-01 19:15:16","VAM");
INSERT INTO patients_files VALUES("800","2024070185971","2024070116512","patients/p_pictures/Eye_1719863389.png","Eye","2024-07-01 19:49:49","Humble");
INSERT INTO patients_files VALUES("801","2024070185971","2024070116512","patients/p_pictures/Eye_1719863405.png","Eye","2024-07-01 19:50:05","Humble");
INSERT INTO patients_files VALUES("802","2024070185971","2024070116512","patients/p_pictures/Mouth_1719863466.png","Mouth","2024-07-01 19:51:06","Humble");
INSERT INTO patients_files VALUES("803","2024070185971","2024070116512","patients/p_pictures/Mouth_1719863500.png","Mouth","2024-07-01 19:51:40","Humble");
INSERT INTO patients_files VALUES("804","2024070345756","2024070339333","patients/p_pictures/Mouth_1720016713.png","Mouth","2024-07-03 14:25:13","Palmas");
INSERT INTO patients_files VALUES("805","2024070345756","2024070339333","patients/p_pictures/Ear_1720016788.png","Ear","2024-07-03 14:26:28","Palmas");
INSERT INTO patients_files VALUES("806","2024070345756","2024070339333","patients/p_pictures/Ear_1720016915.png","Ear","2024-07-03 14:28:35","Palmas");
INSERT INTO patients_files VALUES("807","2024070345756","2024070339333","patients/p_pictures/Ear_1720019719.png","Ear","2024-07-03 15:15:19","Palmas");
INSERT INTO patients_files VALUES("808","2024070345756","2024070339333","patients/p_pictures/Ear_1720022102.png","Ear","2024-07-03 15:55:02","Palmas");
INSERT INTO patients_files VALUES("809","2024070325364","2024070322043","patients/p_pictures/Ear_1720022210.png","Ear","2024-07-03 15:56:50","Castle Hills");
INSERT INTO patients_files VALUES("810","2024070325364","2024070322043","patients/p_pictures/Ear_1720022248.png","Ear","2024-07-03 15:57:28","Castle Hills");
INSERT INTO patients_files VALUES("811","2024070325364","2024070322043","patients/p_pictures/Mouth_1720022322.png","Mouth","2024-07-03 15:58:42","Castle Hills");
INSERT INTO patients_files VALUES("812","2024070345756","2024070339333","patients/p_pictures/Ear_1720034590.png","Ear","2024-07-03 19:23:10","Palmas");
INSERT INTO patients_files VALUES("813","2024070343029","2024070321976","patients/p_pictures/Mouth_1720042773.png","Mouth","2024-07-03 21:39:33","VAM");
INSERT INTO patients_files VALUES("814","2024070343029","2024070321976","patients/p_pictures/TestResult_strep_1720043728.png","TestResult_strep","2024-07-03 21:55:28","VAM");
INSERT INTO patients_files VALUES("815","2024070345756","2024070339333","patients/p_pictures/Ear_1720044753.png","Ear","2024-07-03 22:12:33","Palmas");
INSERT INTO patients_files VALUES("816","2024070345756","2024070339333","patients/p_pictures/Ear_1720044797.png","Ear","2024-07-03 22:13:17","Palmas");
INSERT INTO patients_files VALUES("817","2024070345756","2024070339333","patients/p_pictures/Ear_1720044968.png","Ear","2024-07-03 22:16:08","Palmas");
INSERT INTO patients_files VALUES("818","2024070580177","2024070518536","patients/p_pictures/Skin_1720191429.png","Skin","2024-07-05 14:57:09","Humble");
INSERT INTO patients_files VALUES("819","2024070580177","2024070518536","patients/p_pictures/Skin_1720191442.png","Skin","2024-07-05 14:57:22","Humble");
INSERT INTO patients_files VALUES("820","2024070580177","2024070518536","patients/p_pictures/Skin_1720191459.png","Skin","2024-07-05 14:57:39","Humble");
INSERT INTO patients_files VALUES("821","2024070580177","2024070518536","patients/p_pictures/Skin_1720191469.png","Skin","2024-07-05 14:57:49","Humble");
INSERT INTO patients_files VALUES("822","2024070567713","202407058693","patients/p_pictures/Skin_1720192500.png","Skin","2024-07-05 15:15:00","Palmas");
INSERT INTO patients_files VALUES("823","2024070567713","202407058693","patients/p_pictures/Skin_1720192510.png","Skin","2024-07-05 15:15:10","Palmas");
INSERT INTO patients_files VALUES("824","2024070567713","202407058693","patients/p_pictures/Skin_1720192649.png","Skin","2024-07-05 15:17:29","Palmas");
INSERT INTO patients_files VALUES("825","2024070567713","202407058693","patients/p_pictures/Skin_1720192685.png","Skin","2024-07-05 15:18:05","Palmas");
INSERT INTO patients_files VALUES("826","2024070567713","202407058693","patients/p_pictures/Skin_1720192727.png","Skin","2024-07-05 15:18:47","Palmas");
INSERT INTO patients_files VALUES("827","2024070546067","2024070526566","patients/p_pictures/EKG_1720209729.png","EKG","2024-07-05 20:02:09","Humble");
INSERT INTO patients_files VALUES("828","2024070717802","2024070711209","patients/p_pictures/TestResult_Hcg_1720369364.png","TestResult_Hcg","2024-07-07 16:22:44","Castle Hills");
INSERT INTO patients_files VALUES("829","2024070717802","2024070711209","patients/p_pictures/TestResult_UA_1720369393.png","TestResult_UA","2024-07-07 16:23:13","Castle Hills");
INSERT INTO patients_files VALUES("830","2024070725129","2024070732978","patients/p_pictures/TestResult_COVID_1720385285.png","TestResult_COVID","2024-07-07 20:48:05","Castle Hills");
INSERT INTO patients_files VALUES("831","2024070725129","2024070732978","patients/p_pictures/EKG_1720385474.png","EKG","2024-07-07 20:51:14","Castle Hills");
INSERT INTO patients_files VALUES("832","2024070784768","2024070711590","patients/p_pictures/Skin_1720391556.png","Skin","2024-07-07 22:32:36","Humble");
INSERT INTO patients_files VALUES("833","2024070784768","2024070711590","patients/p_pictures/Skin_1720391640.png","Skin","2024-07-07 22:34:00","Humble");
INSERT INTO patients_files VALUES("834","2024070824022","2024070821831","patients/p_pictures/Ear_1720451350.png","Ear","2024-07-08 15:09:10","Palmas");
INSERT INTO patients_files VALUES("835","2024070824022","2024070821831","patients/p_pictures/Ear_1720451432.png","Ear","2024-07-08 15:10:32","Palmas");
INSERT INTO patients_files VALUES("836","2024070979357","2024070944420","patients/p_pictures/Ear_1720545109.png","Ear","2024-07-09 17:11:49","Palmas");
INSERT INTO patients_files VALUES("837","2024071128321","2024071146698","patients/p_pictures/Skin_1720715046.png","Skin","2024-07-11 16:24:06","Palmas");
INSERT INTO patients_files VALUES("838","2024071235456","2024071229122","patients/p_pictures/Ear_1720796729.png","Ear","2024-07-12 15:05:29","Castle Hills");
INSERT INTO patients_files VALUES("839","2024071235456","2024071229122","patients/p_pictures/Ear_1720796764.png","Ear","2024-07-12 15:06:04","Castle Hills");
INSERT INTO patients_files VALUES("840","2024071235456","2024071229122","patients/p_pictures/TestResult_UA_1720797102.png","TestResult_UA","2024-07-12 15:11:42","Castle Hills");
INSERT INTO patients_files VALUES("841","2024071235872","2024071218394","patients/p_pictures/Eye_1720798520.png","Eye","2024-07-12 15:35:20","Humble");
INSERT INTO patients_files VALUES("842","2024071235872","2024071218394","patients/p_pictures/Eye_1720798534.png","Eye","2024-07-12 15:35:34","Humble");
INSERT INTO patients_files VALUES("843","2024071235872","2024071218394","patients/p_pictures/Eye_1720798536.png","Eye","2024-07-12 15:35:36","Humble");
INSERT INTO patients_files VALUES("844","2024071238949","202407126466","patients/p_pictures/EKG_1720806047.png","EKG","2024-07-12 17:40:47","Palmas");
INSERT INTO patients_files VALUES("845","2024071238949","202407126466","patients/p_pictures/EKG_1720806106.png","EKG","2024-07-12 17:41:46","Palmas");
INSERT INTO patients_files VALUES("846","2024071238949","202407126466","patients/p_pictures/EKG_1720807183.png","EKG","2024-07-12 17:59:43","Palmas");
INSERT INTO patients_files VALUES("847","2024071238949","202407126466","patients/p_pictures/EKG_1720807234.png","EKG","2024-07-12 18:00:34","Palmas");
INSERT INTO patients_files VALUES("848","2024071259118","2024071249615","patients/p_pictures/Ear_1720814097.png","Ear","2024-07-12 19:54:57","VAM");
INSERT INTO patients_files VALUES("849","2024071259118","2024071249615","patients/p_pictures/Ear_1720814175.png","Ear","2024-07-12 19:56:15","VAM");
INSERT INTO patients_files VALUES("850","2024071259118","2024071249615","patients/p_pictures/Ear_1720814218.png","Ear","2024-07-12 19:56:58","VAM");
INSERT INTO patients_files VALUES("851","2024071272881","2024071213207","patients/p_pictures/Ear_1720814886.png","Ear","2024-07-12 20:08:06","VAM");
INSERT INTO patients_files VALUES("852","2024071268382","2024071239120","patients/p_pictures/TestResult_COVID_1720825827.png","TestResult_COVID","2024-07-12 23:10:27","Humble");
INSERT INTO patients_files VALUES("853","2024071320876","2024071315003","patients/p_pictures/Ear_1720878162.png","Ear","2024-07-13 13:42:42","Dr. Marvel");
INSERT INTO patients_files VALUES("854","2024071320876","2024071315003","patients/p_pictures/Skin_1720878247.png","Skin","2024-07-13 13:44:07","Dr. Marvel");
INSERT INTO patients_files VALUES("855","2024071320876","2024071315003","patients/p_pictures/Mouth_1720878308.png","Mouth","2024-07-13 13:45:08","Dr. Marvel");
INSERT INTO patients_files VALUES("856","2024071320876","2024071315003","patients/p_pictures/Eye_1720878386.png","Eye","2024-07-13 13:46:26","Dr. Marvel");
INSERT INTO patients_files VALUES("857","2024071320876","2024071315003","patients/p_pictures/Eye_1720878453.png","Eye","2024-07-13 13:47:33","Dr. Marvel");
INSERT INTO patients_files VALUES("858","2024071320876","2024071315003","patients/p_pictures/Eye_1720878460.png","Eye","2024-07-13 13:47:40","Dr. Marvel");
INSERT INTO patients_files VALUES("859","2024071320876","2024071315003","patients/p_pictures/TestResult_COVID_1720878571.png","TestResult_COVID","2024-07-13 13:49:31","Dr. Marvel");
INSERT INTO patients_files VALUES("860","2024071344955","2024071341112","patients/p_pictures/Skin_1720886769.png","Skin","2024-07-13 16:06:09","Humble");
INSERT INTO patients_files VALUES("861","2024071381090","2024071332554","patients/p_pictures/Skin_1720887243.png","Skin","2024-07-13 16:14:03","Humble");
INSERT INTO patients_files VALUES("862","2024071356931","2024071317231","patients/p_pictures/Mouth_1720890412.png","Mouth","2024-07-13 17:06:52","Humble");
INSERT INTO patients_files VALUES("863","2024071324725","2024071335578","patients/p_pictures/Mouth_1720891182.png","Mouth","2024-07-13 17:19:42","Humble");
INSERT INTO patients_files VALUES("864","2024071429902","2024071445794","patients/p_pictures/Skin_1720965831.png","Skin","2024-07-14 14:03:51","Humble");
INSERT INTO patients_files VALUES("865","2024071545206","202407155423","patients/p_pictures/Skin_1721053083.png","Skin","2024-07-15 14:18:03","VAM");
INSERT INTO patients_files VALUES("866","2024071545206","202407155423","patients/p_pictures/Skin_1721053125.png","Skin","2024-07-15 14:18:45","VAM");
INSERT INTO patients_files VALUES("867","2024071564192","202407153440","patients/p_pictures/Mouth_1721055142.png","Mouth","2024-07-15 14:52:22","Palmas");
INSERT INTO patients_files VALUES("868","2024071564192","202407153440","patients/p_pictures/Mouth_1721055274.png","Mouth","2024-07-15 14:54:34","Palmas");
INSERT INTO patients_files VALUES("869","2024071564192","202407153440","patients/p_pictures/Mouth_1721055302.png","Mouth","2024-07-15 14:55:02","Palmas");
INSERT INTO patients_files VALUES("870","2024071564192","202407153440","patients/p_pictures/EKG_1721056609.png","EKG","2024-07-15 15:16:49","Palmas");
INSERT INTO patients_files VALUES("871","2024071564192","202407153440","patients/p_pictures/EKG_1721056677.png","EKG","2024-07-15 15:17:57","Palmas");
INSERT INTO patients_files VALUES("872","2024071558580","202407153051","patients/p_pictures/Skin_1721062794.png","Skin","2024-07-15 16:59:54","Castle Hills");
INSERT INTO patients_files VALUES("873","2024071558580","202407153051","patients/p_pictures/TestResult_COVID_1721062853.png","TestResult_COVID","2024-07-15 17:00:53","Castle Hills");
INSERT INTO patients_files VALUES("874","2024071558580","202407153051","patients/p_pictures/TestResult_COVID_1721062881.png","TestResult_COVID","2024-07-15 17:01:21","Castle Hills");
INSERT INTO patients_files VALUES("875","2024071522712","2024071536343","patients/p_pictures/Eye_1721064986.png","Eye","2024-07-15 17:36:26","VAM");
INSERT INTO patients_files VALUES("876","2024071522712","2024071536343","patients/p_pictures/Eye_1721065026.png","Eye","2024-07-15 17:37:06","VAM");
INSERT INTO patients_files VALUES("877","2024071524015","2024071528859","patients/p_pictures/Skin_1721083243.png","Skin","2024-07-15 22:40:43","Palmas");
INSERT INTO patients_files VALUES("878","2024071524015","2024071528859","patients/p_pictures/Skin_1721083562.png","Skin","2024-07-15 22:46:02","Palmas");
INSERT INTO patients_files VALUES("879","2024071524015","2024071528859","patients/p_pictures/Skin_1721083589.png","Skin","2024-07-15 22:46:29","Palmas");
INSERT INTO patients_files VALUES("880","2024071683359","2024071615071","patients/p_pictures/TestResult_COVID_1721149642.png","TestResult_COVID","2024-07-16 17:07:22","VAM");
INSERT INTO patients_files VALUES("881","2024071683359","2024071615071","patients/p_pictures/Ear_1721149678.png","Ear","2024-07-16 17:07:58","VAM");
INSERT INTO patients_files VALUES("882","2024071623203","2024071612577","patients/p_pictures/Skin_1721165223.png","Skin","2024-07-16 21:27:03","Castle Hills");
INSERT INTO patients_files VALUES("883","2024071777370","2024071726855","patients/p_pictures/TestResult_COVID_1721242015.png","TestResult_COVID","2024-07-17 18:46:55","Humble");
INSERT INTO patients_files VALUES("884","2024071777370","2024071726855","patients/p_pictures/Mouth_1721242139.png","Mouth","2024-07-17 18:48:59","Humble");
INSERT INTO patients_files VALUES("885","2024071777370","2024071726855","patients/p_pictures/Ear_1721242205.png","Ear","2024-07-17 18:50:05","Humble");
INSERT INTO patients_files VALUES("886","2024071777370","2024071726855","patients/p_pictures/Ear_1721242227.png","Ear","2024-07-17 18:50:27","Humble");
INSERT INTO patients_files VALUES("887","2024071777370","2024071726855","patients/p_pictures/TestResult_strep_1721242299.png","TestResult_strep","2024-07-17 18:51:39","Humble");
INSERT INTO patients_files VALUES("888","2024071755356","2024071743809","patients/p_pictures/Skin_1721246937.png","Skin","2024-07-17 20:08:57","Humble");
INSERT INTO patients_files VALUES("889","2024071755356","2024071743809","patients/p_pictures/Skin_1721246952.png","Skin","2024-07-17 20:09:12","Humble");
INSERT INTO patients_files VALUES("890","2024071793156","202407171317","patients/p_pictures/Eye_1721251538.png","Eye","2024-07-17 21:25:38","Humble");
INSERT INTO patients_files VALUES("891","2024071793156","202407171317","patients/p_pictures/Eye_1721251555.png","Eye","2024-07-17 21:25:55","Humble");
INSERT INTO patients_files VALUES("892","2024071713692","2024071740573","patients/p_pictures/Skin_1721254020.png","Skin","2024-07-17 22:07:00","Humble");
INSERT INTO patients_files VALUES("893","2024071713692","2024071740573","patients/p_pictures/Skin_1721254068.png","Skin","2024-07-17 22:07:48","Humble");
INSERT INTO patients_files VALUES("894","2024071837403","2024071815152","patients/p_pictures/Eye_1721339648.png","Eye","2024-07-18 21:54:08","VAM");
INSERT INTO patients_files VALUES("895","2024071837403","2024071815152","patients/p_pictures/Eye_1721339723.png","Eye","2024-07-18 21:55:23","VAM");
INSERT INTO patients_files VALUES("896","2024071981052","2024071925092","patients/p_pictures/Mouth_1721408540.png","Mouth","2024-07-19 17:02:20","VAM");
INSERT INTO patients_files VALUES("897","2024072057840","2024072023433","patients/p_pictures/Ear_1721484725.png","Ear","2024-07-20 14:12:05","nurse1");
INSERT INTO patients_files VALUES("898","2024072031387","202407209155","patients/p_pictures/Skin_1721486299.png","Skin","2024-07-20 14:38:19","Castle Hills");
INSERT INTO patients_files VALUES("899","2024072031387","202407209155","patients/p_pictures/TestResult_Flu_1721486382.png","TestResult_Flu","2024-07-20 14:39:42","Castle Hills");
INSERT INTO patients_files VALUES("900","2024072059215","2024072016122","patients/p_pictures/Mouth_1721508228.png","Mouth","2024-07-20 20:43:48","Castle Hills");
INSERT INTO patients_files VALUES("901","2024072059215","2024072016122","patients/p_pictures/Ear_1721508297.png","Ear","2024-07-20 20:44:57","Castle Hills");
INSERT INTO patients_files VALUES("902","2024072059215","2024072016122","patients/p_pictures/Ear_1721508398.png","Ear","2024-07-20 20:46:38","Castle Hills");
INSERT INTO patients_files VALUES("903","2024072059215","2024072016122","patients/p_pictures/Skin_1721508646.png","Skin","2024-07-20 20:50:46","Castle Hills");
INSERT INTO patients_files VALUES("904","2024072059215","2024072016122","patients/p_pictures/Skin_1721508669.png","Skin","2024-07-20 20:51:09","Castle Hills");
INSERT INTO patients_files VALUES("905","2024072025599","2024072038096","patients/p_pictures/Ear_1721509884.png","Ear","2024-07-20 21:11:24","Castle Hills");
INSERT INTO patients_files VALUES("906","2024072025599","2024072038096","patients/p_pictures/Ear_1721509919.png","Ear","2024-07-20 21:11:59","Castle Hills");
INSERT INTO patients_files VALUES("907","2024072025599","2024072038096","patients/p_pictures/Mouth_1721510006.png","Mouth","2024-07-20 21:13:26","Castle Hills");
INSERT INTO patients_files VALUES("908","2024072025599","2024072038096","patients/p_pictures/Skin_1721510095.png","Skin","2024-07-20 21:14:55","Castle Hills");
INSERT INTO patients_files VALUES("909","2024072025599","2024072038096","patients/p_pictures/Skin_1721510116.png","Skin","2024-07-20 21:15:16","Castle Hills");
INSERT INTO patients_files VALUES("910","2024072194905","2024072133666","patients/p_pictures/TestResult_Hcg_1721574969.png","TestResult_Hcg","2024-07-21 15:16:09","Castle Hills");
INSERT INTO patients_files VALUES("911","2024072194905","2024072133666","patients/p_pictures/TestResult_Glucose_1721574997.png","TestResult_Glucose","2024-07-21 15:16:37","Castle Hills");
INSERT INTO patients_files VALUES("912","2024072191449","2024072116111","patients/p_pictures/Skin_1721589391.png","Skin","2024-07-21 19:16:31","Castle Hills");
INSERT INTO patients_files VALUES("913","2024072191449","2024072116111","patients/p_pictures/Skin_1721589413.png","Skin","2024-07-21 19:16:53","Castle Hills");
INSERT INTO patients_files VALUES("914","2024072191449","2024072116111","patients/p_pictures/Skin_1721589448.png","Skin","2024-07-21 19:17:28","Castle Hills");
INSERT INTO patients_files VALUES("915","2024072191449","2024072116111","patients/p_pictures/Skin_1721589468.png","Skin","2024-07-21 19:17:48","Castle Hills");
INSERT INTO patients_files VALUES("916","2024072191449","2024072116111","patients/p_pictures/Skin_1721589491.png","Skin","2024-07-21 19:18:11","Castle Hills");
INSERT INTO patients_files VALUES("917","2024072220578","2024072213350","patients/p_pictures/Eye_1721657958.png","Eye","2024-07-22 14:19:18","Palmas");
INSERT INTO patients_files VALUES("918","2024072220578","2024072213350","patients/p_pictures/Eye_1721657987.png","Eye","2024-07-22 14:19:47","Palmas");
INSERT INTO patients_files VALUES("919","2024072293562","2024072227143","patients/p_pictures/Mouth_1721662453.png","Mouth","2024-07-22 15:34:13","Castle Hills");
INSERT INTO patients_files VALUES("920","2024072293562","2024072227143","patients/p_pictures/Eye_1721662475.png","Eye","2024-07-22 15:34:35","Castle Hills");
INSERT INTO patients_files VALUES("921","2024072295108","2024072239733","patients/p_pictures/EKG_1721662485.png","EKG","2024-07-22 15:34:45","VAM");
INSERT INTO patients_files VALUES("922","2024072293562","2024072227143","patients/p_pictures/Eye_1721662488.png","Eye","2024-07-22 15:34:48","Castle Hills");
INSERT INTO patients_files VALUES("923","2024072295108","2024072239733","patients/p_pictures/EKG_1721662508.png","EKG","2024-07-22 15:35:08","VAM");
INSERT INTO patients_files VALUES("924","2024072293562","2024072227143","patients/p_pictures/Eye_1721662589.png","Eye","2024-07-22 15:36:29","Castle Hills");
INSERT INTO patients_files VALUES("925","2024072293562","2024072227143","patients/p_pictures/EKG_1721662611.png","EKG","2024-07-22 15:36:51","Castle Hills");
INSERT INTO patients_files VALUES("926","2024072292370","2024072238831","patients/p_pictures/EKG_1721663850.png","EKG","2024-07-22 15:57:30","Palmas");
INSERT INTO patients_files VALUES("927","2024072283381","2024072220906","patients/p_pictures/Eye_1721665021.png","Eye","2024-07-22 16:17:01","Castle Hills");
INSERT INTO patients_files VALUES("928","2024072283381","2024072220906","patients/p_pictures/Eye_1721665048.png","Eye","2024-07-22 16:17:28","Castle Hills");
INSERT INTO patients_files VALUES("929","2024072283381","2024072220906","patients/p_pictures/Ear_1721665136.png","Ear","2024-07-22 16:18:56","Castle Hills");
INSERT INTO patients_files VALUES("930","2024072283381","2024072220906","patients/p_pictures/Eye_1721665170.png","Eye","2024-07-22 16:19:30","Castle Hills");
INSERT INTO patients_files VALUES("931","2024072283381","2024072220906","patients/p_pictures/Eye_1721665182.png","Eye","2024-07-22 16:19:42","Castle Hills");
INSERT INTO patients_files VALUES("932","2024072223333","2024072235145","patients/p_pictures/Skin_1721666806.png","Skin","2024-07-22 16:46:46","Palmas");
INSERT INTO patients_files VALUES("933","2024072220913","2024072211325","patients/p_pictures/Ear_1721667439.png","Ear","2024-07-22 16:57:19","VAM");
INSERT INTO patients_files VALUES("934","2024072220913","2024072211325","patients/p_pictures/Ear_1721667469.png","Ear","2024-07-22 16:57:49","VAM");
INSERT INTO patients_files VALUES("935","2024072210537","2024072236679","patients/p_pictures/Mouth_1721668212.png","Mouth","2024-07-22 17:10:12","Castle Hills");
INSERT INTO patients_files VALUES("936","2024072210537","2024072236679","patients/p_pictures/Eye_1721668235.png","Eye","2024-07-22 17:10:35","Castle Hills");
INSERT INTO patients_files VALUES("937","2024072210537","2024072236679","patients/p_pictures/Eye_1721668247.png","Eye","2024-07-22 17:10:47","Castle Hills");
INSERT INTO patients_files VALUES("938","2024072210537","2024072236679","patients/p_pictures/Ear_1721668304.png","Ear","2024-07-22 17:11:44","Castle Hills");
INSERT INTO patients_files VALUES("939","2024072210537","2024072236679","patients/p_pictures/Ear_1721668330.png","Ear","2024-07-22 17:12:10","Castle Hills");
INSERT INTO patients_files VALUES("940","2024072350885","202407238670","patients/p_pictures/Ear_1721757497.png","Ear","2024-07-23 17:58:17","Palmas");
INSERT INTO patients_files VALUES("941","2024072350885","202407238670","patients/p_pictures/Ear_1721757558.png","Ear","2024-07-23 17:59:18","Palmas");
INSERT INTO patients_files VALUES("942","2024072319257","2024072345350","patients/p_pictures/TestResult_strep_1721770754.png","TestResult_strep","2024-07-23 21:39:14","VAM");
INSERT INTO patients_files VALUES("943","2024072429393","2024072413951","patients/p_pictures/Ear_1721858744.png","Ear","2024-07-24 22:05:44","Castle Hills");
INSERT INTO patients_files VALUES("944","2024072530484","202407256499","patients/p_pictures/Mouth_1721918356.png","Mouth","2024-07-25 14:39:16","VAM");
INSERT INTO patients_files VALUES("945","2024072530484","202407256499","patients/p_pictures/Mouth_1721918393.png","Mouth","2024-07-25 14:39:53","VAM");
INSERT INTO patients_files VALUES("946","2024072547036","202407257628","patients/p_pictures/EKG_1721928649.png","EKG","2024-07-25 17:30:49","Humble");
INSERT INTO patients_files VALUES("947","2024072547036","202407257628","patients/p_pictures/EKG_1721928668.png","EKG","2024-07-25 17:31:08","Humble");
INSERT INTO patients_files VALUES("948","2024072514433","2024072516007","patients/p_pictures/Mouth_1721932228.png","Mouth","2024-07-25 18:30:28","VAM");
INSERT INTO patients_files VALUES("949","2024072510092","2024072544617","patients/p_pictures/Ear_1721938724.png","Ear","2024-07-25 20:18:44","VAM");
INSERT INTO patients_files VALUES("950","2024072510092","2024072544617","patients/p_pictures/Ear_1721938761.png","Ear","2024-07-25 20:19:21","VAM");
INSERT INTO patients_files VALUES("951","2024072544503","2024072526124","patients/p_pictures/Mouth_1721942331.png","Mouth","2024-07-25 21:18:51","VAM");
INSERT INTO patients_files VALUES("952","2024072547611","2024072540995","patients/p_pictures/Skin_1721945030.png","Skin","2024-07-25 22:03:50","Castle Hills");
INSERT INTO patients_files VALUES("953","2024072547611","2024072540995","patients/p_pictures/Mouth_1721945064.png","Mouth","2024-07-25 22:04:24","Castle Hills");
INSERT INTO patients_files VALUES("954","2024072547611","2024072540995","patients/p_pictures/Ear_1721945144.png","Ear","2024-07-25 22:05:44","Castle Hills");
INSERT INTO patients_files VALUES("955","2024072547611","2024072540995","patients/p_pictures/Ear_1721945190.png","Ear","2024-07-25 22:06:30","Castle Hills");
INSERT INTO patients_files VALUES("956","2024072659414","20240726162","patients/p_pictures/Mouth_1722004394.png","Mouth","2024-07-26 14:33:14","Palmas");
INSERT INTO patients_files VALUES("957","2024072659414","20240726162","patients/p_pictures/TestResult_COVID_1722004463.png","TestResult_COVID","2024-07-26 14:34:23","Palmas");
INSERT INTO patients_files VALUES("958","2024072659414","20240726162","patients/p_pictures/TestResult_strep_1722005135.png","TestResult_strep","2024-07-26 14:45:35","Palmas");
INSERT INTO patients_files VALUES("959","2024072647914","2024072616216","patients/p_pictures/TestResult_COVID_1722008468.png","TestResult_COVID","2024-07-26 15:41:08","Humble");
INSERT INTO patients_files VALUES("960","2024072647914","2024072616216","patients/p_pictures/Mouth_1722008599.png","Mouth","2024-07-26 15:43:19","Humble");
INSERT INTO patients_files VALUES("961","2024072647914","2024072616216","patients/p_pictures/Ear_1722008667.png","Ear","2024-07-26 15:44:27","Humble");
INSERT INTO patients_files VALUES("962","2024072647914","2024072616216","patients/p_pictures/Ear_1722008687.png","Ear","2024-07-26 15:44:47","Humble");
INSERT INTO patients_files VALUES("963","2024072622710","2024072632800","patients/p_pictures/Mouth_1722013244.png","Mouth","2024-07-26 17:00:44","Castle Hills");
INSERT INTO patients_files VALUES("964","2024072622710","2024072632800","patients/p_pictures/Ear_1722013351.png","Ear","2024-07-26 17:02:31","Castle Hills");
INSERT INTO patients_files VALUES("965","2024072622710","2024072632800","patients/p_pictures/Ear_1722013389.png","Ear","2024-07-26 17:03:09","Castle Hills");
INSERT INTO patients_files VALUES("966","2024072624341","2024072639555","patients/p_pictures/Ear_1722018455.png","Ear","2024-07-26 18:27:35","Castle Hills");
INSERT INTO patients_files VALUES("967","2024072624341","2024072639555","patients/p_pictures/Ear_1722018474.png","Ear","2024-07-26 18:27:54","Castle Hills");
INSERT INTO patients_files VALUES("968","2024072624341","2024072639555","patients/p_pictures/Mouth_1722018668.png","Mouth","2024-07-26 18:31:08","Castle Hills");
INSERT INTO patients_files VALUES("969","2024072643823","2024072627267","patients/p_pictures/TestResult_Flu_1722023807.png","TestResult_Flu","2024-07-26 19:56:47","Castle Hills");
INSERT INTO patients_files VALUES("970","2024072643823","2024072627267","patients/p_pictures/TestResult_COVID_1722023826.png","TestResult_COVID","2024-07-26 19:57:06","Castle Hills");
INSERT INTO patients_files VALUES("971","2024072643823","2024072627267","patients/p_pictures/Mouth_1722023894.png","Mouth","2024-07-26 19:58:14","Castle Hills");
INSERT INTO patients_files VALUES("972","2024072672549","202407266955","patients/p_pictures/Eye_1722024855.png","Eye","2024-07-26 20:14:15","Humble");
INSERT INTO patients_files VALUES("973","2024072672549","202407266955","patients/p_pictures/Eye_1722024865.png","Eye","2024-07-26 20:14:25","Humble");
INSERT INTO patients_files VALUES("974","2024072672549","202407266955","patients/p_pictures/Mouth_1722024888.png","Mouth","2024-07-26 20:14:48","Humble");
INSERT INTO patients_files VALUES("975","2024072617068","2024072615901","patients/p_pictures/Ear_1722026540.png","Ear","2024-07-26 20:42:20","VAM");
INSERT INTO patients_files VALUES("976","2024072675224","202407269481","patients/p_pictures/Eye_1722027424.png","Eye","2024-07-26 20:57:04","Castle Hills");
INSERT INTO patients_files VALUES("977","2024072675224","202407269481","patients/p_pictures/Mouth_1722027448.png","Mouth","2024-07-26 20:57:28","Castle Hills");
INSERT INTO patients_files VALUES("978","2024072675224","202407269481","patients/p_pictures/Ear_1722027508.png","Ear","2024-07-26 20:58:28","Castle Hills");
INSERT INTO patients_files VALUES("979","2024072675224","202407269481","patients/p_pictures/Ear_1722027574.png","Ear","2024-07-26 20:59:34","Castle Hills");
INSERT INTO patients_files VALUES("980","2024072681075","2024072610878","patients/p_pictures/Mouth_1722031503.png","Mouth","2024-07-26 22:05:03","VAM");
INSERT INTO patients_files VALUES("981","2024072681075","2024072610878","patients/p_pictures/Mouth_1722031551.png","Mouth","2024-07-26 22:05:51","VAM");
INSERT INTO patients_files VALUES("982","2024072757715","2024072717160","patients/p_pictures/Eye_1722106338.png","Eye","2024-07-27 18:52:18","Humble");
INSERT INTO patients_files VALUES("983","2024072757715","2024072717160","patients/p_pictures/Eye_1722106371.png","Eye","2024-07-27 18:52:51","Humble");
INSERT INTO patients_files VALUES("984","2024072940267","2024072930617","patients/p_pictures/Eye_1722267570.png","Eye","2024-07-29 15:39:30","Humble");
INSERT INTO patients_files VALUES("985","2024072940267","2024072930617","patients/p_pictures/Eye_1722267580.png","Eye","2024-07-29 15:39:40","Humble");
INSERT INTO patients_files VALUES("986","2024072940267","2024072930617","patients/p_pictures/Mouth_1722267604.png","Mouth","2024-07-29 15:40:04","Humble");
INSERT INTO patients_files VALUES("987","2024072940267","2024072930617","patients/p_pictures/Ear_1722267696.png","Ear","2024-07-29 15:41:36","Humble");
INSERT INTO patients_files VALUES("988","2024072940267","2024072930617","patients/p_pictures/Ear_1722267713.png","Ear","2024-07-29 15:41:53","Humble");
INSERT INTO patients_files VALUES("989","2024072911534","2024072949001","patients/p_pictures/Skin_1722280418.png","Skin","2024-07-29 19:13:38","Palmas");
INSERT INTO patients_files VALUES("990","2024072911534","2024072949001","patients/p_pictures/Skin_1722280442.png","Skin","2024-07-29 19:14:02","Palmas");
INSERT INTO patients_files VALUES("991","2024072911534","2024072949001","patients/p_pictures/Skin_1722280477.png","Skin","2024-07-29 19:14:37","Palmas");
INSERT INTO patients_files VALUES("992","2024072926556","2024072940501","patients/p_pictures/Mouth_1722282021.png","Mouth","2024-07-29 19:40:21","Castle Hills");
INSERT INTO patients_files VALUES("993","2024072926556","2024072940501","patients/p_pictures/Eye_1722282040.png","Eye","2024-07-29 19:40:40","Castle Hills");
INSERT INTO patients_files VALUES("994","2024072926556","2024072940501","patients/p_pictures/Ear_1722282106.png","Ear","2024-07-29 19:41:46","Castle Hills");
INSERT INTO patients_files VALUES("995","2024072926556","2024072940501","patients/p_pictures/Ear_1722282127.png","Ear","2024-07-29 19:42:07","Castle Hills");
INSERT INTO patients_files VALUES("996","2024072929355","2024072936332","patients/p_pictures/Eye_1722289500.png","Eye","2024-07-29 21:45:00","Humble");
INSERT INTO patients_files VALUES("997","2024072929355","2024072936332","patients/p_pictures/Eye_1722289511.png","Eye","2024-07-29 21:45:11","Humble");
INSERT INTO patients_files VALUES("998","2024072985214","2024072944437","patients/p_pictures/Mouth_1722293428.png","Mouth","2024-07-29 22:50:28","Castle Hills");
INSERT INTO patients_files VALUES("999","2024072985214","2024072944437","patients/p_pictures/Eye_1722293450.png","Eye","2024-07-29 22:50:50","Castle Hills");
INSERT INTO patients_files VALUES("1000","2024072985214","2024072944437","patients/p_pictures/Ear_1722293496.png","Ear","2024-07-29 22:51:36","Castle Hills");
INSERT INTO patients_files VALUES("1001","2024072985214","2024072944437","patients/p_pictures/Ear_1722293518.png","Ear","2024-07-29 22:51:58","Castle Hills");
INSERT INTO patients_files VALUES("1002","2024073073061","2024073042064","patients/p_pictures/Ear_1722352459.png","Ear","2024-07-30 15:14:19","VAM");
INSERT INTO patients_files VALUES("1003","2024073075173","2024073035397","patients/p_pictures/TestResult_Flu_1722355380.png","TestResult_Flu","2024-07-30 16:03:00","Palmas");
INSERT INTO patients_files VALUES("1004","2024073075173","2024073035397","patients/p_pictures/TestResult_COVID_1722355401.png","TestResult_COVID","2024-07-30 16:03:21","Palmas");
INSERT INTO patients_files VALUES("1005","2024073054959","2024073048410","patients/p_pictures/Skin_1722359696.png","Skin","2024-07-30 17:14:56","VAM");
INSERT INTO patients_files VALUES("1006","2024073075173","2024073035397","patients/p_pictures/Eye_1722372099.png","Eye","2024-07-30 20:41:39","Palmas");
INSERT INTO patients_files VALUES("1007","2024073010394","2024073047768","patients/p_pictures/Eye_1722372311.png","Eye","2024-07-30 20:45:11","Humble");
INSERT INTO patients_files VALUES("1008","2024073010394","2024073047768","patients/p_pictures/Eye_1722372335.png","Eye","2024-07-30 20:45:35","Humble");
INSERT INTO patients_files VALUES("1009","2024073010394","2024073047768","patients/p_pictures/Mouth_1722372400.png","Mouth","2024-07-30 20:46:40","Humble");
INSERT INTO patients_files VALUES("1010","2024073010394","2024073047768","patients/p_pictures/Mouth_1722372486.png","Mouth","2024-07-30 20:48:06","Humble");
INSERT INTO patients_files VALUES("1011","2024073010394","2024073047768","patients/p_pictures/Mouth_1722372527.png","Mouth","2024-07-30 20:48:47","Humble");
INSERT INTO patients_files VALUES("1012","2024073116468","2024073136587","patients/p_pictures/TestResult_COVID_1722440059.png","TestResult_COVID","2024-07-31 15:34:19","VAM");
INSERT INTO patients_files VALUES("1013","2024073165293","2024073128206","patients/p_pictures/Skin_1722442459.png","Skin","2024-07-31 16:14:19","Palmas");
INSERT INTO patients_files VALUES("1014","2024073112259","20240731813","patients/p_pictures/Ear_1722448089.png","Ear","2024-07-31 17:48:09","Castle Hills");
INSERT INTO patients_files VALUES("1015","2024073187988","2024073140136","patients/p_pictures/Mouth_1722450070.png","Mouth","2024-07-31 18:21:10","Humble");
INSERT INTO patients_files VALUES("1016","2024073187988","2024073140136","patients/p_pictures/Mouth_1722450078.png","Mouth","2024-07-31 18:21:18","Humble");
INSERT INTO patients_files VALUES("1017","2024073187988","2024073140136","patients/p_pictures/Ear_1722450128.png","Ear","2024-07-31 18:22:08","Humble");
INSERT INTO patients_files VALUES("1018","2024073187988","2024073140136","patients/p_pictures/Ear_1722450150.png","Ear","2024-07-31 18:22:30","Humble");
INSERT INTO patients_files VALUES("1019","2024073182440","2024073120359","patients/p_pictures/TestResult_COVID_1722462669.png","TestResult_COVID","2024-07-31 21:51:09","VAM");
INSERT INTO patients_files VALUES("1020","2024080147658","2024080135319","patients/p_pictures/Mouth_1722524678.png","Mouth","2024-08-01 15:04:38","Castle Hills");
INSERT INTO patients_files VALUES("1021","2024080147658","2024080135319","patients/p_pictures/Mouth_1722524698.png","Mouth","2024-08-01 15:04:58","Castle Hills");
INSERT INTO patients_files VALUES("1022","2024080147658","2024080135319","patients/p_pictures/Mouth_1722524713.png","Mouth","2024-08-01 15:05:13","Castle Hills");
INSERT INTO patients_files VALUES("1023","2024080147658","2024080135319","patients/p_pictures/Ear_1722524788.png","Ear","2024-08-01 15:06:28","Castle Hills");
INSERT INTO patients_files VALUES("1024","2024080147658","2024080135319","patients/p_pictures/Ear_1722524843.png","Ear","2024-08-01 15:07:23","Castle Hills");
INSERT INTO patients_files VALUES("1025","2024080177561","2024080146473","patients/p_pictures/Ear_1722527002.png","Ear","2024-08-01 15:43:22","Castle Hills");
INSERT INTO patients_files VALUES("1026","2024080177561","2024080146473","patients/p_pictures/Ear_1722527014.png","Ear","2024-08-01 15:43:34","Castle Hills");
INSERT INTO patients_files VALUES("1027","2024080177561","2024080146473","patients/p_pictures/Ear_1722527079.png","Ear","2024-08-01 15:44:39","Castle Hills");
INSERT INTO patients_files VALUES("1028","2024080177561","2024080146473","patients/p_pictures/Ear_1722527111.png","Ear","2024-08-01 15:45:11","Castle Hills");
INSERT INTO patients_files VALUES("1029","2024080177561","2024080146473","patients/p_pictures/Ear_1722527151.png","Ear","2024-08-01 15:45:51","Castle Hills");
INSERT INTO patients_files VALUES("1030","2024080177561","2024080146473","patients/p_pictures/Ear_1722527166.png","Ear","2024-08-01 15:46:06","Castle Hills");
INSERT INTO patients_files VALUES("1031","2024080177561","2024080146473","patients/p_pictures/Mouth_1722527185.png","Mouth","2024-08-01 15:46:25","Castle Hills");
INSERT INTO patients_files VALUES("1032","2024080115545","2024080131279","patients/p_pictures/Eye_1722545153.png","Eye","2024-08-01 20:45:53","Castle Hills");
INSERT INTO patients_files VALUES("1033","2024080115545","2024080131279","patients/p_pictures/Eye_1722545165.png","Eye","2024-08-01 20:46:05","Castle Hills");
INSERT INTO patients_files VALUES("1034","2024080115545","2024080131279","patients/p_pictures/Eye_1722545191.png","Eye","2024-08-01 20:46:31","Castle Hills");
INSERT INTO patients_files VALUES("1035","2024080115545","2024080131279","patients/p_pictures/Ear_1722545258.png","Ear","2024-08-01 20:47:38","Castle Hills");
INSERT INTO patients_files VALUES("1036","2024080115545","2024080131279","patients/p_pictures/Ear_1722545293.png","Ear","2024-08-01 20:48:13","Castle Hills");
INSERT INTO patients_files VALUES("1037","2024080224533","2024080211956","patients/p_pictures/Mouth_1722613701.png","Mouth","2024-08-02 15:48:21","VAM");
INSERT INTO patients_files VALUES("1038","2024080224533","2024080211956","patients/p_pictures/Mouth_1722613725.png","Mouth","2024-08-02 15:48:45","VAM");
INSERT INTO patients_files VALUES("1039","2024080224533","2024080211956","patients/p_pictures/Ear_1722613838.png","Ear","2024-08-02 15:50:38","VAM");
INSERT INTO patients_files VALUES("1040","2024080224533","2024080211956","patients/p_pictures/Ear_1722613884.png","Ear","2024-08-02 15:51:24","VAM");
INSERT INTO patients_files VALUES("1041","2024080211659","2024080246941","patients/p_pictures/Ear_1722615550.png","Ear","2024-08-02 16:19:10","Castle Hills");
INSERT INTO patients_files VALUES("1042","2024080211659","2024080246941","patients/p_pictures/Ear_1722615576.png","Ear","2024-08-02 16:19:36","Castle Hills");
INSERT INTO patients_files VALUES("1043","2024080211659","2024080246941","patients/p_pictures/Mouth_1722615624.png","Mouth","2024-08-02 16:20:24","Castle Hills");
INSERT INTO patients_files VALUES("1044","2024080211659","2024080246941","patients/p_pictures/Eye_1722615647.png","Eye","2024-08-02 16:20:47","Castle Hills");
INSERT INTO patients_files VALUES("1045","2024080211659","2024080246941","patients/p_pictures/Eye_1722615667.png","Eye","2024-08-02 16:21:07","Castle Hills");
INSERT INTO patients_files VALUES("1046","2024080246352","202408023067","patients/p_pictures/Eye_1722624689.png","Eye","2024-08-02 18:51:29","Castle Hills");
INSERT INTO patients_files VALUES("1047","2024080275247","2024080243590","patients/p_pictures/Skin_1722629551.png","Skin","2024-08-02 20:12:31","VAM");
INSERT INTO patients_files VALUES("1048","2024080284740","2024080242115","patients/p_pictures/Eye_1722631314.png","Eye","2024-08-02 20:41:54","VAM");
INSERT INTO patients_files VALUES("1049","2024080281666","2024080243408","patients/p_pictures/Skin_1722633504.png","Skin","2024-08-02 21:18:24","Palmas");
INSERT INTO patients_files VALUES("1050","2024080281666","2024080243408","patients/p_pictures/Skin_1722633551.png","Skin","2024-08-02 21:19:11","Palmas");
INSERT INTO patients_files VALUES("1051","2024080281666","2024080243408","patients/p_pictures/Skin_1722633647.png","Skin","2024-08-02 21:20:47","Palmas");
INSERT INTO patients_files VALUES("1052","2024080281666","2024080243408","patients/p_pictures/Skin_1722633725.png","Skin","2024-08-02 21:22:05","Palmas");
INSERT INTO patients_files VALUES("1053","2024080292629","2024080227240","patients/p_pictures/Mouth_1722634157.png","Mouth","2024-08-02 21:29:17","Castle Hills");
INSERT INTO patients_files VALUES("1054","2024080246776","2024080237580","patients/p_pictures/Mouth_1722636420.png","Mouth","2024-08-02 22:07:00","Castle Hills");
INSERT INTO patients_files VALUES("1055","2024080246776","2024080237580","patients/p_pictures/Eye_1722636442.png","Eye","2024-08-02 22:07:22","Castle Hills");
INSERT INTO patients_files VALUES("1056","2024080246776","2024080237580","patients/p_pictures/Eye_1722636457.png","Eye","2024-08-02 22:07:37","Castle Hills");
INSERT INTO patients_files VALUES("1057","2024080246776","2024080237580","patients/p_pictures/Ear_1722636506.png","Ear","2024-08-02 22:08:26","Castle Hills");
INSERT INTO patients_files VALUES("1058","2024080246776","2024080237580","patients/p_pictures/Ear_1722636529.png","Ear","2024-08-02 22:08:49","Castle Hills");
INSERT INTO patients_files VALUES("1059","2024080323497","202408038862","patients/p_pictures/Skin_1722695240.png","Skin","2024-08-03 14:27:20","Castle Hills");
INSERT INTO patients_files VALUES("1060","2024080363649","2024080343616","patients/p_pictures/Eye_1722696493.png","Eye","2024-08-03 14:48:13","Castle Hills");
INSERT INTO patients_files VALUES("1061","2024080363649","2024080343616","patients/p_pictures/Mouth_1722696509.png","Mouth","2024-08-03 14:48:29","Castle Hills");
INSERT INTO patients_files VALUES("1062","2024080363649","2024080343616","patients/p_pictures/Ear_1722696572.png","Ear","2024-08-03 14:49:32","Castle Hills");
INSERT INTO patients_files VALUES("1063","2024080363649","2024080343616","patients/p_pictures/Ear_1722696603.png","Ear","2024-08-03 14:50:03","Castle Hills");
INSERT INTO patients_files VALUES("1064","2024080367487","2024080312356","patients/p_pictures/Mouth_1722703650.png","Mouth","2024-08-03 16:47:30","Castle Hills");
INSERT INTO patients_files VALUES("1065","2024080367487","2024080312356","patients/p_pictures/Eye_1722703666.png","Eye","2024-08-03 16:47:46","Castle Hills");
INSERT INTO patients_files VALUES("1066","2024080367487","2024080312356","patients/p_pictures/Ear_1722703766.png","Ear","2024-08-03 16:49:26","Castle Hills");
INSERT INTO patients_files VALUES("1067","2024080367487","2024080312356","patients/p_pictures/Ear_1722703794.png","Ear","2024-08-03 16:49:54","Castle Hills");
INSERT INTO patients_files VALUES("1068","2024080367487","2024080312356","patients/p_pictures/Skin_1722704031.png","Skin","2024-08-03 16:53:51","Castle Hills");
INSERT INTO patients_files VALUES("1069","2024080367487","2024080312356","patients/p_pictures/Skin_1722704047.png","Skin","2024-08-03 16:54:07","Castle Hills");
INSERT INTO patients_files VALUES("1070","2024080367487","2024080312356","patients/p_pictures/Skin_1722704063.png","Skin","2024-08-03 16:54:23","Castle Hills");
INSERT INTO patients_files VALUES("1071","2024080332527","2024080332286","patients/p_pictures/TestResult_COVID_1722704480.png","TestResult_COVID","2024-08-03 17:01:20","Humble");
INSERT INTO patients_files VALUES("1072","2024080330275","2024080344882","patients/p_pictures/Eye_1722709226.png","Eye","2024-08-03 18:20:26","Castle Hills");
INSERT INTO patients_files VALUES("1073","2024080330275","2024080344882","patients/p_pictures/Mouth_1722709239.png","Mouth","2024-08-03 18:20:39","Castle Hills");
INSERT INTO patients_files VALUES("1074","2024080330275","2024080344882","patients/p_pictures/Ear_1722709286.png","Ear","2024-08-03 18:21:26","Castle Hills");
INSERT INTO patients_files VALUES("1075","2024080330275","2024080344882","patients/p_pictures/Ear_1722709305.png","Ear","2024-08-03 18:21:45","Castle Hills");
INSERT INTO patients_files VALUES("1076","2024080493854","2024080428066","patients/p_pictures/Mouth_1722802399.png","Mouth","2024-08-04 20:13:19","Castle Hills");
INSERT INTO patients_files VALUES("1077","2024080493854","2024080428066","patients/p_pictures/Eye_1722802412.png","Eye","2024-08-04 20:13:32","Castle Hills");
INSERT INTO patients_files VALUES("1078","2024080493854","2024080428066","patients/p_pictures/Ear_1722802459.png","Ear","2024-08-04 20:14:19","Castle Hills");
INSERT INTO patients_files VALUES("1079","2024080493854","2024080428066","patients/p_pictures/Ear_1722802478.png","Ear","2024-08-04 20:14:38","Castle Hills");
INSERT INTO patients_files VALUES("1080","2024080444255","2024080447176","patients/p_pictures/Ear_1722810974.png","Ear","2024-08-04 22:36:14","Castle Hills");
INSERT INTO patients_files VALUES("1081","2024080444255","2024080447176","patients/p_pictures/Ear_1722810993.png","Ear","2024-08-04 22:36:33","Castle Hills");
INSERT INTO patients_files VALUES("1082","2024080444255","2024080447176","patients/p_pictures/Mouth_1722811041.png","Mouth","2024-08-04 22:37:21","Castle Hills");
INSERT INTO patients_files VALUES("1083","2024080444255","2024080447176","patients/p_pictures/Eye_1722811056.png","Eye","2024-08-04 22:37:36","Castle Hills");
INSERT INTO patients_files VALUES("1084","2024080581075","2024080532473","patients/p_pictures/TestResult_COVID_1722875413.png","TestResult_COVID","2024-08-05 16:30:13","VAM");
INSERT INTO patients_files VALUES("1085","2024080548687","202408051300","patients/p_pictures/Mouth_1722880755.png","Mouth","2024-08-05 17:59:15","Castle Hills");
INSERT INTO patients_files VALUES("1086","2024080548687","202408051300","patients/p_pictures/Eye_1722880774.png","Eye","2024-08-05 17:59:34","Castle Hills");
INSERT INTO patients_files VALUES("1087","2024080548687","202408051300","patients/p_pictures/Eye_1722880786.png","Eye","2024-08-05 17:59:46","Castle Hills");
INSERT INTO patients_files VALUES("1088","2024080548687","202408051300","patients/p_pictures/Eye_1722880857.png","Eye","2024-08-05 18:00:57","Castle Hills");
INSERT INTO patients_files VALUES("1089","2024080598542","2024080510290","patients/p_pictures/Ear_1722882770.png","Ear","2024-08-05 18:32:50","Castle Hills");
INSERT INTO patients_files VALUES("1090","2024080598542","2024080510290","patients/p_pictures/Ear_1722882802.png","Ear","2024-08-05 18:33:22","Castle Hills");
INSERT INTO patients_files VALUES("1091","2024080598542","2024080510290","patients/p_pictures/Ear_1722882867.png","Ear","2024-08-05 18:34:27","Castle Hills");
INSERT INTO patients_files VALUES("1092","2024080598542","2024080510290","patients/p_pictures/Ear_1722882887.png","Ear","2024-08-05 18:34:47","Castle Hills");
INSERT INTO patients_files VALUES("1093","2024080532507","2024080532441","patients/p_pictures/TestResult_UA_1722885821.png","TestResult_UA","2024-08-05 19:23:41","VAM");
INSERT INTO patients_files VALUES("1094","2024080574147","2024080548403","patients/p_pictures/TestResult_UA_1722890332.png","TestResult_UA","2024-08-05 20:38:52","VAM");
INSERT INTO patients_files VALUES("1095","2024080533424","202408054684","patients/p_pictures/Ear_1722896794.png","Ear","2024-08-05 22:26:34","Humble");
INSERT INTO patients_files VALUES("1096","2024080533424","202408054684","patients/p_pictures/Ear_1722896819.png","Ear","2024-08-05 22:26:59","Humble");
INSERT INTO patients_files VALUES("1097","2024080533424","202408054684","patients/p_pictures/Mouth_1722896888.png","Mouth","2024-08-05 22:28:08","Humble");
INSERT INTO patients_files VALUES("1098","2024080533424","202408054684","patients/p_pictures/Eye_1722896910.png","Eye","2024-08-05 22:28:30","Humble");
INSERT INTO patients_files VALUES("1099","2024080533424","202408054684","patients/p_pictures/Eye_1722896924.png","Eye","2024-08-05 22:28:44","Humble");
INSERT INTO patients_files VALUES("1100","2024080615475","2024080630256","patients/p_pictures/Ear_1722951250.png","Ear","2024-08-06 13:34:10","nurse1");
INSERT INTO patients_files VALUES("1101","2024080615475","2024080630256","patients/p_pictures/TestResult_Flu_1722951275.png","TestResult_Flu","2024-08-06 13:34:35","nurse1");
INSERT INTO patients_files VALUES("1102","2024080645199","2024080648495","patients/p_pictures/TestResult_Glucose_1722951732.png","TestResult_Glucose","2024-08-06 13:42:12","nurse1");
INSERT INTO patients_files VALUES("1103","2024080686478","2024080625698","patients/p_pictures/Mouth_1722956972.png","Mouth","2024-08-06 15:09:32","Castle Hills");
INSERT INTO patients_files VALUES("1104","2024080686478","2024080625698","patients/p_pictures/Eye_1722957006.png","Eye","2024-08-06 15:10:06","Castle Hills");
INSERT INTO patients_files VALUES("1105","2024080686478","2024080625698","patients/p_pictures/Eye_1722957019.png","Eye","2024-08-06 15:10:19","Castle Hills");
INSERT INTO patients_files VALUES("1106","2024080686478","2024080625698","patients/p_pictures/Ear_1722957068.png","Ear","2024-08-06 15:11:08","Castle Hills");
INSERT INTO patients_files VALUES("1107","2024080686478","2024080625698","patients/p_pictures/Ear_1722957091.png","Ear","2024-08-06 15:11:31","Castle Hills");
INSERT INTO patients_files VALUES("1108","2024080651189","202408061462","patients/p_pictures/Mouth_1722959502.png","Mouth","2024-08-06 15:51:42","Humble");
INSERT INTO patients_files VALUES("1109","2024080694623","2024080618302","patients/p_pictures/Ear_1722966855.png","Ear","2024-08-06 17:54:15","Castle Hills");
INSERT INTO patients_files VALUES("1110","2024080694623","2024080618302","patients/p_pictures/Ear_1722966872.png","Ear","2024-08-06 17:54:32","Castle Hills");
INSERT INTO patients_files VALUES("1111","2024080694623","2024080618302","patients/p_pictures/Mouth_1722966996.png","Mouth","2024-08-06 17:56:36","Castle Hills");
INSERT INTO patients_files VALUES("1112","2024080694623","2024080618302","patients/p_pictures/Eye_1722967017.png","Eye","2024-08-06 17:56:57","Castle Hills");
INSERT INTO patients_files VALUES("1113","2024080694623","2024080618302","patients/p_pictures/Eye_1722967029.png","Eye","2024-08-06 17:57:09","Castle Hills");
INSERT INTO patients_files VALUES("1114","2024080654935","2024080642965","patients/p_pictures/Skin_1722978263.png","Skin","2024-08-06 21:04:23","VAM");
INSERT INTO patients_files VALUES("1115","2024080736029","2024080748766","patients/p_pictures/Mouth_1723039768.png","Mouth","2024-08-07 14:09:28","Humble");
INSERT INTO patients_files VALUES("1116","2024080794594","2024080742685","patients/p_pictures/Ear_1723042424.png","Ear","2024-08-07 14:53:44","Castle Hills");
INSERT INTO patients_files VALUES("1117","2024080794594","2024080742685","patients/p_pictures/Mouth_1723042566.png","Mouth","2024-08-07 14:56:06","Castle Hills");
INSERT INTO patients_files VALUES("1118","2024080794594","2024080742685","patients/p_pictures/Mouth_1723042588.png","Mouth","2024-08-07 14:56:28","Castle Hills");
INSERT INTO patients_files VALUES("1119","2024080796786","2024080731071","patients/p_pictures/Ear_1723061871.png","Ear","2024-08-07 20:17:51","Castle Hills");
INSERT INTO patients_files VALUES("1120","2024080763528","2024080747258","patients/p_pictures/Ear_1723069323.png","Ear","2024-08-07 22:22:03","Castle Hills");
INSERT INTO patients_files VALUES("1121","2024080763528","2024080747258","patients/p_pictures/Ear_1723069355.png","Ear","2024-08-07 22:22:35","Castle Hills");
INSERT INTO patients_files VALUES("1122","2024080794741","202408072369","patients/p_pictures/Ear_1723071407.png","Ear","2024-08-07 22:56:47","Castle Hills");
INSERT INTO patients_files VALUES("1123","2024080794741","202408072369","patients/p_pictures/Ear_1723071456.png","Ear","2024-08-07 22:57:36","Castle Hills");
INSERT INTO patients_files VALUES("1124","2024080794741","202408072369","patients/p_pictures/Mouth_1723071521.png","Mouth","2024-08-07 22:58:41","Castle Hills");
INSERT INTO patients_files VALUES("1125","2024080869902","2024080833725","patients/p_pictures/TestResult_strep_1723133731.png","TestResult_strep","2024-08-08 16:15:31","VAM");
INSERT INTO patients_files VALUES("1126","2024080869902","2024080833725","patients/p_pictures/TestResult_strep_1723133769.png","TestResult_strep","2024-08-08 16:16:09","VAM");
INSERT INTO patients_files VALUES("1127","2024080812207","2024080831762","patients/p_pictures/TestResult_COVID_1723135968.png","TestResult_COVID","2024-08-08 16:52:48","VAM");
INSERT INTO patients_files VALUES("1128","2024080833801","202408082960","patients/p_pictures/Mouth_1723141668.png","Mouth","2024-08-08 18:27:48","Castle Hills");
INSERT INTO patients_files VALUES("1129","2024080833801","202408082960","patients/p_pictures/Eye_1723141683.png","Eye","2024-08-08 18:28:03","Castle Hills");
INSERT INTO patients_files VALUES("1130","2024080833801","202408082960","patients/p_pictures/Ear_1723141738.png","Ear","2024-08-08 18:28:58","Castle Hills");
INSERT INTO patients_files VALUES("1131","2024080833801","202408082960","patients/p_pictures/Ear_1723141758.png","Ear","2024-08-08 18:29:18","Castle Hills");
INSERT INTO patients_files VALUES("1132","2024080811448","2024080849065","patients/p_pictures/Skin_1723144241.png","Skin","2024-08-08 19:10:41","Castle Hills");
INSERT INTO patients_files VALUES("1133","2024080811448","2024080849065","patients/p_pictures/Eye_1723144275.png","Eye","2024-08-08 19:11:15","Castle Hills");
INSERT INTO patients_files VALUES("1134","2024080811448","2024080849065","patients/p_pictures/Eye_1723144294.png","Eye","2024-08-08 19:11:34","Castle Hills");
INSERT INTO patients_files VALUES("1135","2024080811448","2024080849065","patients/p_pictures/Skin_1723144359.png","Skin","2024-08-08 19:12:39","Castle Hills");
INSERT INTO patients_files VALUES("1136","2024080811448","2024080849065","patients/p_pictures/Skin_1723144373.png","Skin","2024-08-08 19:12:53","Castle Hills");
INSERT INTO patients_files VALUES("1137","2024080844540","202408083858","patients/p_pictures/Mouth_1723149700.png","Mouth","2024-08-08 20:41:40","Humble");
INSERT INTO patients_files VALUES("1138","2024080844540","202408083858","patients/p_pictures/Ear_1723149764.png","Ear","2024-08-08 20:42:44","Humble");
INSERT INTO patients_files VALUES("1139","2024080844540","202408083858","patients/p_pictures/Ear_1723149797.png","Ear","2024-08-08 20:43:17","Humble");
INSERT INTO patients_files VALUES("1140","2024080844540","202408083858","patients/p_pictures/TestResult_COVID_1723150086.png","TestResult_COVID","2024-08-08 20:48:06","Humble");
INSERT INTO patients_files VALUES("1141","2024080877275","202408089364","patients/p_pictures/Eye_1723153406.png","Eye","2024-08-08 21:43:26","Humble");
INSERT INTO patients_files VALUES("1142","2024080877275","202408089364","patients/p_pictures/Eye_1723153418.png","Eye","2024-08-08 21:43:38","Humble");
INSERT INTO patients_files VALUES("1143","2024080956661","2024080937104","patients/p_pictures/Mouth_1723213666.png","Mouth","2024-08-09 14:27:46","Castle Hills");
INSERT INTO patients_files VALUES("1144","2024080956661","2024080937104","patients/p_pictures/Eye_1723213683.png","Eye","2024-08-09 14:28:03","Castle Hills");
INSERT INTO patients_files VALUES("1145","2024080956661","2024080937104","patients/p_pictures/Ear_1723213730.png","Ear","2024-08-09 14:28:50","Castle Hills");
INSERT INTO patients_files VALUES("1146","2024080956661","2024080937104","patients/p_pictures/Ear_1723213771.png","Ear","2024-08-09 14:29:31","Castle Hills");
INSERT INTO patients_files VALUES("1147","2024080914197","2024080946299","patients/p_pictures/Ear_1723215110.png","Ear","2024-08-09 14:51:50","Castle Hills");
INSERT INTO patients_files VALUES("1148","2024080914197","2024080946299","patients/p_pictures/Ear_1723215131.png","Ear","2024-08-09 14:52:11","Castle Hills");
INSERT INTO patients_files VALUES("1149","2024080914197","2024080946299","patients/p_pictures/Mouth_1723215166.png","Mouth","2024-08-09 14:52:46","Castle Hills");
INSERT INTO patients_files VALUES("1150","2024080914197","2024080946299","patients/p_pictures/Eye_1723215185.png","Eye","2024-08-09 14:53:05","Castle Hills");
INSERT INTO patients_files VALUES("1151","2024080914197","2024080946299","patients/p_pictures/Eye_1723215227.png","Eye","2024-08-09 14:53:47","Castle Hills");
INSERT INTO patients_files VALUES("1152","2024080932465","202408092421","patients/p_pictures/Eye_1723220560.png","Eye","2024-08-09 16:22:40","Castle Hills");
INSERT INTO patients_files VALUES("1153","2024080932465","202408092421","patients/p_pictures/Mouth_1723220573.png","Mouth","2024-08-09 16:22:53","Castle Hills");
INSERT INTO patients_files VALUES("1154","2024080932465","202408092421","patients/p_pictures/Ear_1723220742.png","Ear","2024-08-09 16:25:42","Castle Hills");
INSERT INTO patients_files VALUES("1155","2024080932465","202408092421","patients/p_pictures/Ear_1723220762.png","Ear","2024-08-09 16:26:02","Castle Hills");
INSERT INTO patients_files VALUES("1156","2024080995755","2024080949214","patients/p_pictures/Eye_1723233534.png","Eye","2024-08-09 19:58:54","Castle Hills");
INSERT INTO patients_files VALUES("1157","2024080995755","2024080949214","patients/p_pictures/Mouth_1723233549.png","Mouth","2024-08-09 19:59:09","Castle Hills");
INSERT INTO patients_files VALUES("1158","2024080995755","2024080949214","patients/p_pictures/Ear_1723233632.png","Ear","2024-08-09 20:00:32","Castle Hills");
INSERT INTO patients_files VALUES("1159","2024080995755","2024080949214","patients/p_pictures/Ear_1723233697.png","Ear","2024-08-09 20:01:37","Castle Hills");
INSERT INTO patients_files VALUES("1160","2024081097724","2024081049296","patients/p_pictures/Mouth_1723300153.png","Mouth","2024-08-10 14:29:13","Castle Hills");
INSERT INTO patients_files VALUES("1161","2024081097724","2024081049296","patients/p_pictures/Eye_1723300177.png","Eye","2024-08-10 14:29:37","Castle Hills");
INSERT INTO patients_files VALUES("1162","2024081097724","2024081049296","patients/p_pictures/Eye_1723300189.png","Eye","2024-08-10 14:29:49","Castle Hills");
INSERT INTO patients_files VALUES("1163","2024081097724","2024081049296","patients/p_pictures/Ear_1723300230.png","Ear","2024-08-10 14:30:30","Castle Hills");
INSERT INTO patients_files VALUES("1164","2024081097724","2024081049296","patients/p_pictures/Ear_1723300259.png","Ear","2024-08-10 14:30:59","Castle Hills");
INSERT INTO patients_files VALUES("1165","2024081062311","20240810128","patients/p_pictures/Ear_1723302065.png","Ear","2024-08-10 15:01:05","Castle Hills");
INSERT INTO patients_files VALUES("1166","2024081062311","20240810128","patients/p_pictures/Ear_1723302112.png","Ear","2024-08-10 15:01:52","Castle Hills");
INSERT INTO patients_files VALUES("1167","2024081062311","20240810128","patients/p_pictures/Ear_1723302144.png","Ear","2024-08-10 15:02:24","Castle Hills");
INSERT INTO patients_files VALUES("1168","2024081062311","20240810128","patients/p_pictures/Ear_1723302164.png","Ear","2024-08-10 15:02:44","Castle Hills");
INSERT INTO patients_files VALUES("1169","2024081062311","20240810128","patients/p_pictures/Ear_1723302179.png","Ear","2024-08-10 15:02:59","Castle Hills");
INSERT INTO patients_files VALUES("1170","2024081085345","202408101478","patients/p_pictures/Mouth_1723304151.png","Mouth","2024-08-10 15:35:51","Castle Hills");
INSERT INTO patients_files VALUES("1171","2024081085345","202408101478","patients/p_pictures/Mouth_1723304192.png","Mouth","2024-08-10 15:36:32","Castle Hills");
INSERT INTO patients_files VALUES("1172","2024081085345","202408101478","patients/p_pictures/Mouth_1723304205.png","Mouth","2024-08-10 15:36:45","Castle Hills");
INSERT INTO patients_files VALUES("1173","2024081085345","202408101478","patients/p_pictures/Eye_1723304303.png","Eye","2024-08-10 15:38:23","Castle Hills");
INSERT INTO patients_files VALUES("1174","2024081085345","202408101478","patients/p_pictures/Eye_1723304330.png","Eye","2024-08-10 15:38:50","Castle Hills");
INSERT INTO patients_files VALUES("1175","2024081095123","202408105622","patients/p_pictures/Ear_1723305782.png","Ear","2024-08-10 16:03:02","Castle Hills");
INSERT INTO patients_files VALUES("1176","2024081095123","202408105622","patients/p_pictures/Ear_1723305801.png","Ear","2024-08-10 16:03:21","Castle Hills");
INSERT INTO patients_files VALUES("1177","2024081095123","202408105622","patients/p_pictures/Mouth_1723305855.png","Mouth","2024-08-10 16:04:15","Castle Hills");
INSERT INTO patients_files VALUES("1178","2024081095123","202408105622","patients/p_pictures/Mouth_1723305872.png","Mouth","2024-08-10 16:04:32","Castle Hills");
INSERT INTO patients_files VALUES("1179","2024081095123","202408105622","patients/p_pictures/Mouth_1723305886.png","Mouth","2024-08-10 16:04:46","Castle Hills");
INSERT INTO patients_files VALUES("1180","2024081039666","202408102997","patients/p_pictures/Ear_1723307080.png","Ear","2024-08-10 16:24:40","Humble");
INSERT INTO patients_files VALUES("1181","2024081039666","202408102997","patients/p_pictures/Ear_1723307113.png","Ear","2024-08-10 16:25:13","Humble");
INSERT INTO patients_files VALUES("1182","2024081039666","202408102997","patients/p_pictures/Mouth_1723307198.png","Mouth","2024-08-10 16:26:38","Humble");
INSERT INTO patients_files VALUES("1183","2024081039666","202408102997","patients/p_pictures/TestResult_COVID_1723307261.png","TestResult_COVID","2024-08-10 16:27:41","Humble");
INSERT INTO patients_files VALUES("1184","2024081039666","202408102997","patients/p_pictures/TestResult_Flu_1723307271.png","TestResult_Flu","2024-08-10 16:27:51","Humble");
INSERT INTO patients_files VALUES("1185","2024081039666","202408102997","patients/p_pictures/TestResult_strep_1723307299.png","TestResult_strep","2024-08-10 16:28:19","Humble");
INSERT INTO patients_files VALUES("1186","2024081040555","2024081017324","patients/p_pictures/Mouth_1723308131.png","Mouth","2024-08-10 16:42:11","Castle Hills");
INSERT INTO patients_files VALUES("1187","2024081040555","2024081017324","patients/p_pictures/Eye_1723308152.png","Eye","2024-08-10 16:42:32","Castle Hills");
INSERT INTO patients_files VALUES("1188","2024081040555","2024081017324","patients/p_pictures/Eye_1723308166.png","Eye","2024-08-10 16:42:46","Castle Hills");
INSERT INTO patients_files VALUES("1189","2024081040555","2024081017324","patients/p_pictures/Eye_1723308227.png","Eye","2024-08-10 16:43:47","Castle Hills");
INSERT INTO patients_files VALUES("1190","2024081040555","2024081017324","patients/p_pictures/Eye_1723308247.png","Eye","2024-08-10 16:44:07","Castle Hills");
INSERT INTO patients_files VALUES("1191","2024081179673","2024081143282","patients/p_pictures/TestResult_Flu_1723404505.png","TestResult_Flu","2024-08-11 19:28:25","Humble");
INSERT INTO patients_files VALUES("1192","2024081179673","2024081143282","patients/p_pictures/TestResult_Flu_1723404505.png","TestResult_Flu","2024-08-11 19:28:25","Humble");
INSERT INTO patients_files VALUES("1193","2024081179673","2024081143282","patients/p_pictures/TestResult_strep_1723404567.png","TestResult_strep","2024-08-11 19:29:27","Humble");
INSERT INTO patients_files VALUES("1194","2024081179673","2024081143282","patients/p_pictures/TestResult_COVID_1723404597.png","TestResult_COVID","2024-08-11 19:29:57","Humble");
INSERT INTO patients_files VALUES("1195","2024081160419","20240811529","patients/p_pictures/Ear_1723405591.png","Ear","2024-08-11 19:46:31","Castle Hills");
INSERT INTO patients_files VALUES("1196","2024081160419","20240811529","patients/p_pictures/Ear_1723405609.png","Ear","2024-08-11 19:46:49","Castle Hills");
INSERT INTO patients_files VALUES("1197","2024081160419","20240811529","patients/p_pictures/Ear_1723405651.png","Ear","2024-08-11 19:47:31","Castle Hills");
INSERT INTO patients_files VALUES("1198","2024081160419","20240811529","patients/p_pictures/Ear_1723405665.png","Ear","2024-08-11 19:47:45","Castle Hills");
INSERT INTO patients_files VALUES("1199","2024081160419","20240811529","patients/p_pictures/Ear_1723405678.png","Ear","2024-08-11 19:47:58","Castle Hills");
INSERT INTO patients_files VALUES("1200","2024081166832","2024081126411","patients/p_pictures/Mouth_1723412003.png","Mouth","2024-08-11 21:33:23","Castle Hills");
INSERT INTO patients_files VALUES("1201","2024081166832","2024081126411","patients/p_pictures/Eye_1723412020.png","Eye","2024-08-11 21:33:40","Castle Hills");
INSERT INTO patients_files VALUES("1202","2024081166832","2024081126411","patients/p_pictures/Eye_1723412032.png","Eye","2024-08-11 21:33:52","Castle Hills");
INSERT INTO patients_files VALUES("1203","2024081166832","2024081126411","patients/p_pictures/Ear_1723412116.png","Ear","2024-08-11 21:35:16","Castle Hills");
INSERT INTO patients_files VALUES("1204","2024081166832","2024081126411","patients/p_pictures/Ear_1723412150.png","Ear","2024-08-11 21:35:50","Castle Hills");
INSERT INTO patients_files VALUES("1205","2024081276768","2024081219518","patients/p_pictures/Mouth_1723496670.png","Mouth","2024-08-12 21:04:30","Castle Hills");
INSERT INTO patients_files VALUES("1206","2024081276768","2024081219518","patients/p_pictures/Eye_1723496685.png","Eye","2024-08-12 21:04:45","Castle Hills");
INSERT INTO patients_files VALUES("1207","2024081276768","2024081219518","patients/p_pictures/Ear_1723496738.png","Ear","2024-08-12 21:05:38","Castle Hills");
INSERT INTO patients_files VALUES("1208","2024081276768","2024081219518","patients/p_pictures/Ear_1723496764.png","Ear","2024-08-12 21:06:04","Castle Hills");
INSERT INTO patients_files VALUES("1209","2024081295755","2024081215755","patients/p_pictures/Ear_1723498143.png","Ear","2024-08-12 21:29:03","Castle Hills");
INSERT INTO patients_files VALUES("1210","2024081295755","2024081215755","patients/p_pictures/Ear_1723498176.png","Ear","2024-08-12 21:29:36","Castle Hills");
INSERT INTO patients_files VALUES("1211","2024081295755","2024081215755","patients/p_pictures/Mouth_1723498232.png","Mouth","2024-08-12 21:30:32","Castle Hills");
INSERT INTO patients_files VALUES("1212","2024081295755","2024081215755","patients/p_pictures/Eye_1723498248.png","Eye","2024-08-12 21:30:48","Castle Hills");
INSERT INTO patients_files VALUES("1213","2024081220400","2024081215355","patients/p_pictures/Ear_1723499157.png","Ear","2024-08-12 21:45:57","VAM");
INSERT INTO patients_files VALUES("1214","2024081220400","2024081215355","patients/p_pictures/Ear_1723499200.png","Ear","2024-08-12 21:46:40","VAM");
INSERT INTO patients_files VALUES("1215","2024081268532","2024081248659","patients/p_pictures/TestResult_UA_1723501259.png","TestResult_UA","2024-08-12 22:20:59","VAM");
INSERT INTO patients_files VALUES("1216","2024081281804","202408121601","patients/p_pictures/Mouth_1723501303.png","Mouth","2024-08-12 22:21:43","Castle Hills");
INSERT INTO patients_files VALUES("1217","2024081281804","202408121601","patients/p_pictures/Eye_1723501320.png","Eye","2024-08-12 22:22:00","Castle Hills");
INSERT INTO patients_files VALUES("1218","2024081281804","202408121601","patients/p_pictures/Ear_1723501383.png","Ear","2024-08-12 22:23:03","Castle Hills");
INSERT INTO patients_files VALUES("1219","2024081281804","202408121601","patients/p_pictures/Ear_1723501410.png","Ear","2024-08-12 22:23:30","Castle Hills");
INSERT INTO patients_files VALUES("1220","2024081214908","2024081241024","patients/p_pictures/Ear_1723503291.png","Ear","2024-08-12 22:54:51","Castle Hills");
INSERT INTO patients_files VALUES("1221","2024081214908","2024081241024","patients/p_pictures/Ear_1723503314.png","Ear","2024-08-12 22:55:14","Castle Hills");



CREATE TABLE `patients_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `record_id` varchar(255) DEFAULT NULL,
  `patient_fname` varchar(255) DEFAULT NULL,
  `patient_lname` varchar(255) DEFAULT NULL,
  `patient_dob` varchar(255) DEFAULT NULL,
  `patient_sex` varchar(255) DEFAULT NULL,
  `patient_contact` varchar(255) DEFAULT NULL,
  `patient_address` varchar(355) DEFAULT NULL,
  `vbp` varchar(100) DEFAULT NULL,
  `vtemp` varchar(100) DEFAULT NULL,
  `vresp` varchar(100) DEFAULT NULL,
  `vhr` varchar(100) DEFAULT NULL,
  `vweight` varchar(100) DEFAULT NULL,
  `vhg` varchar(100) DEFAULT NULL,
  `vsot` varchar(100) DEFAULT NULL,
  `patient_id` varchar(255) DEFAULT NULL,
  `record_by` varchar(255) DEFAULT NULL,
  `record_at` varchar(255) DEFAULT NULL,
  `record_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `record_notes` varchar(1024) DEFAULT NULL,
  `doctor_permission` varchar(225) DEFAULT NULL,
  `final` varchar(255) DEFAULT NULL,
  `already_oncall` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1395 DEFAULT CHARSET=utf8mb4;

INSERT INTO patients_record VALUES("477","2024040512387","BRETT","MARVEL","1982-08-22","Male","1236545623","1 the hill","111/74","97.6","18","57","190","72","95","202404052307","nurse1","Palmas Del Mar","2024-04-05 14:44:53","right ear ache.

NKDA

WALGREENS ON ARASCOSIAT RD","All","Yes","");
INSERT INTO patients_record VALUES("478","2024040596301","Brett","Marvel","","Male","","","","97.7","","","190","72","","2024040534838","nurse1","Palmas Del Mar","2024-04-05 15:18:04","cut to wrist","All","Yes","");
INSERT INTO patients_record VALUES("479","2024040587198","BRETT","MARVEL","1982-08-22","Male","125612361256","321 hill dr","111/72","97.7","18","60","190","72","96","2024040531470","nurse1","Palmas Del Mar","2024-04-05 16:22:34","COVID EXPOSURE.


SULFA DRUGS


KROGER ATASCOCITA RD","All","Yes","");
INSERT INTO patients_record VALUES("480","2024040599491","","","","Male","","","","","","","","","","2024040544847","nurse1","Palmas Del Mar","2024-04-05 16:49:51","","All","Yes","");
INSERT INTO patients_record VALUES("481","2024040572796","GIGI","ACOSTA","2002-11-05","Male","12356212365","9","119/97","97.6","18","80","198","65","99","2024040546047","nurse1","Palmas Del Mar","2024-04-05 17:02:16","TROAT PAIN.","All","Yes","");
INSERT INTO patients_record VALUES("482","2024040567733","Test After Update","1","","Male","","","","","","","","","","2024040525181","Dr. Marvel","Waco","2024-04-05 19:49:28","","All","Yes","Finish");
INSERT INTO patients_record VALUES("483","2024040530144","Test Update Redirect","1","","Male","","","","","","","","","","202404052686","Dr. Marvel","Waco","2024-04-05 20:01:56","","All","Yes","Ready");
INSERT INTO patients_record VALUES("484","2024040570396","Test String Room Conference Name","1","","Male","","","","","","","","","","2024040521056","Dr. Marvel","Waco","2024-04-05 20:07:01","","All","Yes","Finish");
INSERT INTO patients_record VALUES("485","2024040547893","Test String Room Conference Name","3","","Male","","","","","","","","","","2024040542457","Dr. Marvel","Waco","2024-04-05 20:41:34","","All","Yes","Finish");
INSERT INTO patients_record VALUES("486","2024040546587","Test String Room Conference Name","4","","Male","","","","","","","","","","2024040536768","Dr. Marvel","Waco","2024-04-06 20:44:56","","All","Yes","Ready");
INSERT INTO patients_record VALUES("487","2024040596807","Test String Room Conference Name","5","","Male","","","","","","","","","","2024040543524","Dr. Marvel","Waco","2024-04-06 20:46:13","","All","Yes","Finish");
INSERT INTO patients_record VALUES("488","2024040512162","","","","Male","","","","","","","","","","2024040535091","Dr. Marvel","Waco","2024-04-07 21:21:55","","All","Yes","Ready");
INSERT INTO patients_record VALUES("489","2024040851674","Bob","Dole","","Male","","","","","","","","","","2024040819495","nurse1","Palmas Del Mar","2024-04-09 01:44:13","hand cramp","All","Yes","Finish");
INSERT INTO patients_record VALUES("490","2024040952406","","","","","","","","","","","","","","2024040919853","nurse1","Palmas Del Mar","2024-04-09 16:31:42","","","","");
INSERT INTO patients_record VALUES("491","2024040999785","michelle","gage","1989-09-14","Female","1236545698","1230","125/84","98.4","18","70","65","195","99","202404091752","nurse1","Palmas Del Mar","2024-04-09 18:07:32","PAIN WHILE URINATION, MILD HEAD ACHE,  LOWER BACK PAIN. 3 DAYS

ALLERGIES: NKDA


PHARMACY: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778


PERFORMED HCG TEST(NEG)","All","Yes","Finish");
INSERT INTO patients_record VALUES("492","2024040912790","TEST2","MARVEL","2001-12-25","Male","1236548956","","","","","","","","","2024040945294","nurse1","Palmas Del Mar","2024-04-09 18:24:11","HEAD ACHE","All","Yes","Finish");
INSERT INTO patients_record VALUES("493","2024040947388","michelle","gage","1989-09-14","Female","1236548953","1456 lane drive","126/74","98.0","18","68","196","65","99","2024040932098","nurse1","Palmas Del Mar","2024-04-09 18:31:19","FEVER, CHILLS, VOMETING, BODYACHES, 3 DAYS. BROTHER IS SICK. TAKING DAYQUIL NO RELAF.


ALLERGIES: NKDA

PHARMACY: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("494","2024041186656","","Sanch","1977-12-12","Male","1","1","120/66","98.0","18","60","160","69","99","2024041127356","nurse1","Palmas Del Mar","2024-04-11 17:48:34","Earache
NKDA
The Walmarts Pharmacy
5551112222","All","Yes","Ready");
INSERT INTO patients_record VALUES("495","2024041160489","renzo","","","Male","","","","","","","","69","","2024041128860","nurse1","Palmas Del Mar","2024-04-11 17:57:51","ear","All","Yes","Finish");
INSERT INTO patients_record VALUES("496","2024041131410","renz","test","","Male","","","","","","","","","","202404115234","nurse1","Palmas Del Mar","2024-04-11 18:06:14","ear","All","Yes","Finish");
INSERT INTO patients_record VALUES("497","2024041230332","Joseph","Biden","1905-01-02","Male","","7410","110/71","98.0","18","54","160","72","99","2024041227415","nurse1","Palmas Del Mar","2024-04-12 14:49:13",""I forgot"","All","Yes","Ready");
INSERT INTO patients_record VALUES("498","2024041291187","Joseph","Biden","1905-01-02","Male","","","110/71","97.7","18","54","160","72","99","202404128338","nurse1","Palmas Del Mar","2024-04-12 14:51:23","oldness","All","Yes","Ready");
INSERT INTO patients_record VALUES("499","2024041258217","John","Doe","1665-01-02","Male","","","110/71","97.7","18","54","190","72","99","2024041247969","nurse1","Palmas Del Mar","2024-04-12 14:57:22","sore throat

nkda

Wallgreens atascocita","All","Yes","Ready");
INSERT INTO patients_record VALUES("500","2024041219491","John ","Doe","3161-12-05","Male","","","","","","","175","72","","2024041219852","nurse1","Palmas Del Mar","2024-04-12 16:38:30","Headache, not feeling self, sinus congestion","All","Yes","Ready");
INSERT INTO patients_record VALUES("501","2024041249416","Test!","test","5465-06-05","Male","","","110/71","97.7","","","190","72","","2024041216294","nurse1","Palmas Del Mar","2024-04-12 17:11:22","sore throat","All","Yes","Finish");
INSERT INTO patients_record VALUES("502","2024041259382","New","Test1","1541-01-24","Male","","","110/71","97.8","","","160","72","","2024041247505","nurse1","Palmas Del Mar","2024-04-13 18:03:39","testiness","All","Yes","Ready");
INSERT INTO patients_record VALUES("503","2024041291919","Calvin ","Phillips","5165-06-05","Male","","","110/71","97.7","","54","190","72","","2024041222809","nurse1","Palmas Del Mar","2024-04-13 18:19:32","asdgsdg","All","","Ready");
INSERT INTO patients_record VALUES("504","2024041262342","","","","Male","","","","","","","","","","2024041226693","Reza","Palmas Del Mar","2024-04-13 19:44:24","","All","Yes","Finish");
INSERT INTO patients_record VALUES("505","2024041323987","","","","Male","","","","","","","","","","202404133958","Dr. Marvel","Waco","2024-04-13 09:48:08","","All","Yes","Ready");
INSERT INTO patients_record VALUES("506","2024041360289","","","","Male","","","","","","","","","","2024041328955","Dr. Marvel","Waco","2024-04-13 10:03:00","","All","Yes","Ready");
INSERT INTO patients_record VALUES("507","2024041317577","","","","Male","","","","","","","","","","2024041347452","Dr. Marvel","Waco","2024-04-13 10:03:52","","All","Yes","Ready");
INSERT INTO patients_record VALUES("508","2024041361882","","","","Male","","","","","","","","","","2024041349312","Dr. Marvel","Waco","2024-04-13 10:06:07","","All","Yes","Ready");
INSERT INTO patients_record VALUES("509","2024041320851","","","","Male","","","","","","","","","","202404136029","Dr. Marvel","Waco","2024-04-13 10:09:14","","All","Yes","Ready");
INSERT INTO patients_record VALUES("510","2024041315461","","","","Male","","","","","","","","","","2024041340255","Dr. Marvel","Waco","2024-04-13 10:13:40","","All","Yes","Ready");
INSERT INTO patients_record VALUES("511","2024041371188","","","","Male","","","","","","","","","","2024041337410","Dr. Marvel","Waco","2024-04-13 10:15:47","","All","Yes","Ready");
INSERT INTO patients_record VALUES("512","2024041389192","","","","Male","","","","","","","","","","2024041348563","Dr. Marvel","Waco","2024-04-13 10:19:31","","All","Yes","Ready");
INSERT INTO patients_record VALUES("513","2024041382307","","","","Male","","","","","","","","","","2024041313879","Dr. Marvel","Waco","2024-04-13 10:21:03","","All","Yes","Ready");
INSERT INTO patients_record VALUES("514","2024041364922","","","","Male","","","","","","","","","","2024041344065","Dr. Marvel","Waco","2024-04-13 10:22:50","","All","Yes","Ready");
INSERT INTO patients_record VALUES("515","2024041384431","","","","Male","","","","","","","","","","2024041338961","Dr. Marvel","Waco","2024-04-13 10:25:09","","All","Yes","Ready");
INSERT INTO patients_record VALUES("516","2024041338941","","","","Male","","","","","","","","","","2024041317164","Dr. Marvel","Waco","2024-04-13 10:29:34","","All","Yes","Ready");
INSERT INTO patients_record VALUES("517","2024041368691","","","","Male","","","","","","","","","","2024041313988","Dr. Marvel","Waco","2024-04-13 10:37:20","","All","Yes","Ready");
INSERT INTO patients_record VALUES("518","2024041364672","","","","Male","","","","","","","","","","2024041329124","Dr. Marvel","Waco","2024-04-13 12:46:33","","All","Yes","Ready");
INSERT INTO patients_record VALUES("519","2024041372356","","","","Male","","","","","","","","","","2024041340344","Dr. Marvel","Waco","2024-04-13 12:59:45","","All","Yes","Ready");
INSERT INTO patients_record VALUES("520","2024041452346","","","","Male","","","","","","","","","","2024041445887","Dr. Marvel","Waco","2024-04-14 21:56:17","","All","Yes","Ready");
INSERT INTO patients_record VALUES("521","2024041435369","","","","Male","","","","","","","","","","2024041422071","Dr. Marvel","Waco","2024-04-14 22:05:58","","All","Yes","Ready");
INSERT INTO patients_record VALUES("522","2024041470537","","","","Male","","","","","","","","","","2024041429965","Dr. Marvel","Waco","2024-04-14 22:06:38","","All","Yes","Ready");
INSERT INTO patients_record VALUES("523","2024041424065","","","","Male","","","","","","","","","","2024041446673","Dr. Marvel","Waco","2024-04-14 22:08:40","","All","Yes","Ready");
INSERT INTO patients_record VALUES("524","2024041440798","","","","Male","","","","","","","","","","2024041448671","Dr. Marvel","Waco","2024-04-14 22:42:49","","All","Yes","Ready");
INSERT INTO patients_record VALUES("525","2024041682079","Test Audio Animation","","","Male","","","","","","","","11","","2024041649963","Dr. Marvel","Waco","2024-04-16 16:51:48","","All","Yes","Ready");
INSERT INTO patients_record VALUES("526","2024041648570","","","","Male","","","","","","","","","","2024041617038","Dr. Marvel","Waco","2024-04-16 17:03:20","","All","Yes","Ready");
INSERT INTO patients_record VALUES("527","2024041620351","1 test","t","","Male","1","1","1","1","1","1","1","1 test","1","2024041643291","nurse1","Palmas Del Mar","2024-04-16 19:28:09","1 test","All","Yes","Finish");
INSERT INTO patients_record VALUES("528","2024041698739","2 test","","","Male","","","2","2","2","2","2","2","2","202404166861","nurse1","Palmas Del Mar","2024-04-16 19:41:14","2 test","All","Yes","Ready");
INSERT INTO patients_record VALUES("529","2024041631970","2 test","2","","Male","2","2","2","2","2","2","2","2","2","2024041612800","nurse1","Palmas Del Mar","2024-04-16 19:42:17","2 test","All","Yes","Finish");
INSERT INTO patients_record VALUES("530","2024041746295","1test","1","","Male","1","1","120/66","98.0","18","60","160","69","99","2024041731025","nurse1","Palmas Del Mar","2024-04-17 14:49:07","1test
","All","Yes","Finish");
INSERT INTO patients_record VALUES("531","2024041783674","1test","1","","Male","1","1","120/66","98.0","18","60","160","69","99","2024041740873","nurse1","Palmas Del Mar","2024-04-17 14:51:21","1test
","All","Yes","Finish");
INSERT INTO patients_record VALUES("532","2024041754373","michelle ","gage","1989-09-14","Female","3239722961","","130/80","99.0","18","80","190","65","100","2024041722622","Reza","Palmas Del Mar","2024-04-17 15:50:24","ptt states is having a sore throat for 3 days 
pt states her daughter is sick at home 
pt states has body aches and headaches 
pt states is taking Tylenol for pain but has no relief

allergies: none 
pharmacy : Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("533","2024041781347","TEST2","test","0198-09-14","Male","","","","98.4","","","200","65","","202404178418","Reza","Palmas Del Mar","2024-04-17 16:16:30","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("534","2024041768107","Michelle","gage","1989-09-14","Female","3239722961","","120/80","98.6","18","80","190","65","100","202404171091","nurse1","Palmas Del Mar","2024-04-17 16:29:43","Pt states she has a stuffy nose, itchy eyes, scratchy throat
pt took Zyrtec put no relief
pt states she goes to the park a lot to run
pt states it happens more after the park

NKA
pharmacy: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("535","2024041797408","Renz","Test","1977-12-12","Male","1","1","120/66","98.0","18","60","160","69","99","2024041714285","nurse1","Palmas Del Mar","2024-04-17 17:33:40","CC; Fell Off Ladder.  Blood in Left Ear

Allergies:  NKDA

Rx;  The Walmarts
210-555-6666","All","Yes","Finish");
INSERT INTO patients_record VALUES("536","2024041790463","michelle","gage","1989-09-14","Female","3231979659","","118/90","99.0","20","18","190","65","100","2024041720730","nurse1","Palmas Del Mar","2024-04-17 17:56:24","pt has lower back pain, pain while urinating since last week and has taken azo otc w/no relief. Pts lmp 03/20, pt also take a Tylenol today

NKA
pharmacy: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("537","2024041753526","Green","Button","","Male","","","","","","","","","","2024041748254","nurse1","Palmas Del Mar","2024-04-17 18:23:03","","All","Yes","Ready");
INSERT INTO patients_record VALUES("538","2024041797789","Red ","Button","","Male","","","","","","","","","","2024041739844","nurse1","Palmas Del Mar","2024-04-17 18:23:45","sdgsdfg","All","Yes","Ready");
INSERT INTO patients_record VALUES("539","2024041784013","TEST2","test","","Male","","","126/74","","","","190","65","","2024041749728","nurse1","Palmas Del Mar","2024-04-17 18:31:13","ujyfuy","All","Yes","Ready");
INSERT INTO patients_record VALUES("540","2024041780850","Bob","Doe","1789-02-19","Male","123456789","","112/86","97.8","18","86","205","68","99","2024041713828","nurse1","Palmas Del Mar","2024-04-17 22:20:13","Pt is has ear pain both w/fluid and drainage, Pt states pain is constant for a week, pt also has heart palpations, pt has not taken anything, pt also has headaches w/ nervousness

NKA
Pharmacy: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("541","2024041758466","Kathy","Garcia","8699-06-05","Female","","","135/90","101.0","20","86","195","67","100","2024041732356","nurse1","Palmas Del Mar","2024-04-17 22:52:39","Pt states has a sore throat, fatigue, swollen tonsils every 2 months, pat took Tylenol and vomited today, no other house mm sick, pt works at a daycare

Allergies: Ibuprofen
Pharmacy: Kroger 
Atascocita
19300 W Lake Houston Pkwy Humble,
TX 77346

Get Directions
Hours & Contact
Main Store
281–812–4422
OPEN until 11:00 PM
Sun - Sat: 6:00 AM - 11:00 PM
Pharmacy
281–812–4499
OPEN until 8:00 PM
Sun: 10:00 AM - 5:00 PM
Mon - Fri: 9:00 AM - 8:00 PM
Sat: 9:00 AM - 6:00 PM
Closed (excluding holidays):
Sun - Sat: 1:00 PM - 1:30 PM ","All","Yes","Finish");
INSERT INTO patients_record VALUES("542","2024041799491","Test 1","","","Male","","","","","","","","","","2024041739199","Dr. Marvel","Waco","2024-04-18 01:47:38","","All","Yes","Ready");
INSERT INTO patients_record VALUES("543","2024041711853","Test 2","x","","Male","","","","","","","","","","2024041733980","Dr. Marvel","Waco","2024-04-18 03:44:34","","All","Yes","Ready");
INSERT INTO patients_record VALUES("544","2024041723688","Test moved function at end","1","","Male","","","","","","","","","","2024041746880","Dr. Marvel","Waco","2024-04-18 03:56:08","","All","Yes","");
INSERT INTO patients_record VALUES("545","2024041715712","Test moved function at end","2","","Male","","","","","","","","","","202404177997","Dr. Marvel","Waco","2024-04-18 04:01:43","","All","Yes","Ready");
INSERT INTO patients_record VALUES("546","2024041894305","","","","Male","","","","","","","","","","2024041831363","Dr. Marvel","Waco","2024-04-18 18:05:52","","All","","");
INSERT INTO patients_record VALUES("547","2024041879360","","","","Male","","","","","","","","","","2024041821448","Dr. Marvel","Waco","2024-04-18 18:07:12","","All","","");
INSERT INTO patients_record VALUES("548","2024041869426","","","","","","","","","","","","","","2024041812648","nurse1","Palmas Del Mar","2024-04-18 19:59:48","","","","");
INSERT INTO patients_record VALUES("549","2024041826809","Michelle","Gage","4154-12-05","Male","","","120/80","98.6","18","76","205","65","100","202404184167","nurse1","Palmas Del Mar","2024-04-18 20:06:03","sore throat, watery eyes","All","Yes","Finish");
INSERT INTO patients_record VALUES("550","2024041847990","Ben","Jerry","9968-12-05","Male","","","106/98","98.6","16","20","205","65","100","2024041810052","nurse1","Palmas Del Mar","2024-04-18 20:12:34","sore throat","All","Yes","Finish");
INSERT INTO patients_record VALUES("551","2024041876959","renzo","S","1977-12-13","Male","1","1","110/69","98.1","18","60","160","69","99","2024041830298","nurse1","Palmas Del Mar","2024-04-18 20:30:32","Rash

KNDA

Pharmacy:  The Walmarts 555-555-5555","All","Yes","Ready");
INSERT INTO patients_record VALUES("552","2024041865190","Testrenzo","s","","Male","1","1","110/69","98.1","18","60","160","69","99","2024041841711","nurse1","Palmas Del Mar","2024-04-18 20:47:52","Sick

knda

Rx:  The Walmarts","All","Yes","Finish");
INSERT INTO patients_record VALUES("553","2024041824524","LS","s","","Male","1","1","11","1","1","1","1","1","1","2024041824137","nurse1","Palmas Del Mar","2024-04-18 21:02:38","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("554","2024041813681","22222","22","","Male","2","2","2","2","2","2","2","2","2","2024041827294","nurse1","Palmas Del Mar","2024-04-18 21:13:25","2","All","Yes","Ready");
INSERT INTO patients_record VALUES("555","2024041811021","3333","3","","Male","3","3","3","3","3","3","3","3","3","2024041833030","nurse1","Palmas Del Mar","2024-04-18 21:22:44","3","All","Yes","Finish");
INSERT INTO patients_record VALUES("556","2024041861019","44444","44444","1975-09-17","Male","9999999","6 priors","122/80","98.","18","89","220","69","99","2024041810396","nurse1","Palmas Del Mar","2024-04-18 21:29:45","sore throat","All","Yes","Finish");
INSERT INTO patients_record VALUES("557","2024041876513","michelle","gage","","Male","3239722961","","120/80","98.7","18","8","120","65","100","2024041836966","nurse1","Palmas Del Mar","2024-04-18 21:34:43","sorethroat","All","Yes","Finish");
INSERT INTO patients_record VALUES("558","2024041893131","6","6","","Male","6","6","6","6","6","6","6","6","6","2024041834078","nurse1","Palmas Del Mar","2024-04-18 21:47:01","666666","All","Yes","Finish");
INSERT INTO patients_record VALUES("559","2024041899403","michelle ","Gage","1989-09-14","Female","","","120/80","98.6","18","76","205","65","100","2024041817399","nurse1","Palmas Del Mar","2024-04-18 22:03:27","sorethroat","All","Yes","Finish");
INSERT INTO patients_record VALUES("560","2024041928284","CH test","S","1978-01-01","Male","1","1","120/66","98.0","18","60","160","69","99","2024041922142","nurse1","Palmas Del Mar","2024-04-19 15:08:45","Manfluenza symptoms x 8 minutes

Allergies:  1 mg Dilaudid, but not 2mg or 4mg

Rx:  Walmart 111-222-3333","All","Yes","Ready");
INSERT INTO patients_record VALUES("561","2024041917830","s","s","","Male","1","1","120/66","98.0","18","60","160","69","99","2024041919967","nurse1","Palmas Del Mar","2024-04-19 15:26:58","sick","All","","");
INSERT INTO patients_record VALUES("562","2024041962703","2CH Test","2","0001-11-11","Male","1","1","120/66","98.0","18","60","160","69","99","2024041942442","nurse1","Palmas Del Mar","2024-04-19 15:53:58","Sick
","All","Yes","Finish");
INSERT INTO patients_record VALUES("563","2024041955406","Test5","5","0011-11-11","Male","1","1","120/66","98.0","18","60","160","69","99","2024041917759","nurse1","Palmas Del Mar","2024-04-19 17:43:28","CC:  Sore throat x 5 days

NKDA

Rx:  Walmart 555-333-2222","All","Yes","Ready");
INSERT INTO patients_record VALUES("564","2024041982797","Renzo","s","0011-11-11","Male","1","1","120/66","98.0","18","60","160","69","99","2024041922637","nurse1","Palmas Del Mar","2024-04-19 18:06:17","Sick

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("565","2024041929312","L","S","0001-01-01","Male","1","1","120/66","98.0","18","60","160","69","99","2024041945218","nurse1","Palmas Del Mar","2024-04-19 18:36:48","Flu Like Symptoms","All","Yes","Ready");
INSERT INTO patients_record VALUES("566","2024041912620","Billy Bob","Bobbington","1912-01-02","Male","1234567890","","140/80","98.6","","","180","6","","2024041927888","nurse1","Palmas Del Mar","2024-04-19 18:45:55","low self esteem from terrible name ","All","Yes","Ready");
INSERT INTO patients_record VALUES("567","2024041940622","r","r","","Male","1","1","120/66","98.0","18","60","160","69","99","2024041949550","nurse1","Palmas Del Mar","2024-04-19 19:22:04","1","All","","");
INSERT INTO patients_record VALUES("568","2024042025733","","","","Male","","","","","","","","","","2024042042010","Reza","Palmas Del Mar","2024-04-20 13:46:17","","All","","");
INSERT INTO patients_record VALUES("569","2024042150631","dghsdfg","sdfgsdfg","1354-01-02","Male","","","","","","","","","","202404219780","nurse1","Palmas Del Mar","2024-04-21 17:38:36","cp x 3 days

nkda

walgreens atascosita rd","All","","");
INSERT INTO patients_record VALUES("570","2024042155900","TEST2","gage","5165-05-16","Male","","1 the hill","110/71","97.7","18","80","190","65","99","202404215219","nurse1","Palmas Del Mar","2024-04-21 17:41:38","sdrhsdfh","All","Yes","Ready");
INSERT INTO patients_record VALUES("571","2024042196022","Renzo Test","T","1977-12-13","Male","2","2","110/69","98.1","18","60","160","69","99","202404213005","nurse1","Palmas Del Mar","2024-04-21 17:57:54","Sore Throat x 4 days

NKDA

Rx:  Walmart 555-555-5555","All","Yes","Finish");
INSERT INTO patients_record VALUES("572","2024042166231","Mayra ","Rubalcava ","1983-01-03","Female","8954741251","12345 Elm sT ","127/77","97.7","87","86","120","5 ft 6 in ","99","2024042121913","nurse1","Palmas Del Mar","2024-04-21 18:14:44","Ear pain X 2 weeks. Ringing in the ear 

Allergic to Lisinopril, Amoxicillin, Penicillin, and shrimp 
Medication List
Duloxetine, Migraine medication unknown name, Over the counter Vitamins
Pharmacy : Walgreens in Crosby TX   ","All","Yes","Ready");
INSERT INTO patients_record VALUES("573","2024042166231","Mayra ","Rubalcava ","1983-01-03","Female","8954741251","12345 Elm sT ","127/77","97.7","87","86","120","5 ft 6 in ","99","2024042121913","nurse1","Palmas Del Mar","2024-04-21 18:23:31","Ear pain X 2 weeks. Ringing in the ear 

Allergic to Lisinopril, Amoxicillin, Penicillin, and shrimp 
Medication List
Duloxetine, Migraine medication unknown name, Over the counter Vitamins
Pharmacy : Walgreens in Crosby TX   ","All","Yes","Ready");
INSERT INTO patients_record VALUES("574","2024042140238","Rubi","Castro","1990-02-03","Female","1231231234","4321 Barbosa houston Tx 77026","143","98","16","143/81","110","60","99","2024042141151","nurse1","Palmas Del Mar","2024-04-21 18:44:52","Sore throat x 1 day. 
Allergic to Lisinopril
Current meds: Effexor 75.5 mg once a day, HCTZ 25 mg once a day, Vit D once weekly and losartan 25 mg once a day.
Pharmacy: Walgreens 747 E. Cross timbers. Houston Tx ","All","Yes","Ready");
INSERT INTO patients_record VALUES("575","2024042119092","Ruby","Lopez","1651-06-05","Female","","","110/71","97.7","","86","190","65","","2024042136451","nurse1","Palmas Del Mar","2024-04-21 19:35:11","sore throat x 3 days, itchy ears

lisinopril

wallgreens 747 east cross timbers","All","Yes","Ready");
INSERT INTO patients_record VALUES("576","2024042196053","BRETT","MARVEL","1982-08-22","Male","7132222222","1 the hill","118/67","99.2","16","55","190","72","95","2024042133042","nurse1","Palmas Del Mar","2024-04-21 20:07:00","body aches x 2 days
Nkda
phar: kroger atascosita","All","Yes","Ready");
INSERT INTO patients_record VALUES("577","2024042134432","","","","Male","","","","","","","","","","2024042144137","nurse1","Palmas Del Mar","2024-04-21 20:28:00","","All","","");
INSERT INTO patients_record VALUES("578","2024042123368","Mayra ","Rubalcava ","1982-01-03","Female","12345691241","1 the hill","132/83","98.7","16","77","100","63","99","2024042135972","nurse1","Palmas Del Mar","2024-04-21 20:42:27","Migraine Headache for 1 mth","All","Yes","Ready");
INSERT INTO patients_record VALUES("579","2024042159897","Rubi","Lopez","1981-09-02","Female","1231231234","12345 Elm sT ","113/76","97.8","18","80","140","40","99","2024042115931","nurse1","Palmas Del Mar","2024-04-21 20:58:05","Left leg pain x 2 days.
Allergic to tylenol and all nuts
Current taking. Pic on file","All","Yes","Ready");
INSERT INTO patients_record VALUES("580","2024042298153","Testy","McTesterson","1234-01-12","Male","","","","97.8","16","86","160","72","","2024042220191","nurse1","Palmas Del Mar","2024-04-22 13:42:14","test test","All","Yes","Finish");
INSERT INTO patients_record VALUES("581","2024042232660","esteban","valencia","","Male","","","","","","","","","","2024042236573","nurse1","Palmas Del Mar","2024-04-22 16:15:07","sinus","All","Yes","Finish");
INSERT INTO patients_record VALUES("582","2024042253987","Ken","Jones","6055-12-31","Male","","","","","","","","72","","202404221789","nurse1","Palmas Del Mar","2024-04-22 16:18:05","back pain","All","Yes","Finish");
INSERT INTO patients_record VALUES("583","2024042298751","Test","Test","","Male","","","","","","","","","","2024042210479","nurse1","Palmas Del Mar","2024-04-22 21:56:38","gerd","All","Yes","Ready");
INSERT INTO patients_record VALUES("584","2024042390740","Brett","Marvel","5615-04-05","Male","","","","97.7","","","190","72","","2024042329763","nurse1","Palmas Del Mar","2024-04-23 13:07:53","sore throat x 3 days

nkda

walgreens","All","Yes","Ready");
INSERT INTO patients_record VALUES("585","2024042397225","s;klrrmg","dsfgdf","1651-12-31","Male","","","","97.8","","","160","72","","2024042340910","nurse1","Palmas Del Mar","2024-04-23 14:10:06","dfhbdsfh","All","Yes","Ready");
INSERT INTO patients_record VALUES("586","2024042390212","michelle","gage","1989-09-14","Female","","","110/71","97.7","18","86","190","72","99","2024042316535","nurse1","Palmas Del Mar","2024-04-23 14:18:40","sorethroat","All","Yes","Finish");
INSERT INTO patients_record VALUES("587","2024042373545","TEST2","test","","Male","","","","97.7","","","","65","","202404232211","nurse1","Palmas Del Mar","2024-04-23 15:33:03","hurt","All","Yes","Finish");
INSERT INTO patients_record VALUES("588","2024042337842","Renzo","Sanch","1977-12-13","Male","1","1","120/66","98.0","18","60","160","69","99","2024042348744","nurse1","Palmas Del Mar","2024-04-23 17:36:46","Sick

NKDA

Rx;  Walgreens ","All","Yes","Finish");
INSERT INTO patients_record VALUES("589","2024042363370","michelle","gage","1989-09-14","Female","3239722961","","110/71","97.7","18","86","190","72","99","2024042327186","nurse1","Palmas Del Mar","2024-04-23 18:33:41","sorethroat","All","Yes","Ready");
INSERT INTO patients_record VALUES("590","2024042387740","Amanda","TORREZ","1983-04-30","Female","","","130/80","98.8","18","82","202","65","100","2024042341178","nurse1","Palmas Del Mar","2024-04-23 22:28:48","UTI SYMPTOMS ","All","Yes","Ready");
INSERT INTO patients_record VALUES("591","2024042332847","Michelle","test","1980-03-15","Male","","","130/80","","","","160","72","99","2024042317894","nurse1","Palmas Del Mar","2024-04-23 22:38:41","UTI","All","Yes","Finish");
INSERT INTO patients_record VALUES("592","2024042474456","TEST","TEST 1","","Male","","","120/86","98.6","60","18","230","65","100","2024042441979","nurse1","Palmas Del Mar","2024-04-24 17:21:20","RUNNY NOSE","All","Yes","Ready");
INSERT INTO patients_record VALUES("593","2024042441794","tiffany","ortiz","1987-06-19","Female","","","106/72","98.6","96","20","232","63","100","2024042449889","nurse1","Palmas Del Mar","2024-04-24 17:27:11","runny nose ","All","Yes","Finish");
INSERT INTO patients_record VALUES("594","2024042491472","test2","test","","Male","","","106/64","97.8","","","203","63","","2024042412981","nurse1","Palmas Del Mar","2024-04-24 17:38:07","sore throat ","All","Yes","Ready");
INSERT INTO patients_record VALUES("595","2024042477890","test1","test","","Male","","","","","","","","","","2024042436536","nurse1","Palmas Del Mar","2024-04-24 17:58:03","sore throat","All","Yes","Ready");
INSERT INTO patients_record VALUES("596","2024042469996","test","garcia","1987-10-14","Male","","","112/86","98.6","16","86","203","65","98","2024042438431","nurse1","Palmas Del Mar","2024-04-24 19:02:37","sore throat","All","Yes","Ready");
INSERT INTO patients_record VALUES("597","2024042497876","ben","test","","Male","","","","","","","","","","2024042447186","nurse1","Palmas Del Mar","2024-04-24 19:16:53","runny nose","All","Yes","Finish");
INSERT INTO patients_record VALUES("598","2024042417328","joe","dow","","Male","","","","","","","","65","","2024042421440","nurse1","Palmas Del Mar","2024-04-24 20:38:43","runny nose","All","Yes","Finish");
INSERT INTO patients_record VALUES("599","2024042585467","Jim","test","","Male","","","116/78","98.6","","","230","65","","2024042540692","nurse1","Palmas Del Mar","2024-04-25 13:56:39","sore throat","All","Yes","Finish");
INSERT INTO patients_record VALUES("600","2024042552948","Ashley","jones","2002-12-19","Female","7136895934","","116/74","98.6","18","86","230","63","100","2024042543478","nurse1","Palmas Del Mar","2024-04-25 20:39:18","Runny rose","All","Yes","Finish");
INSERT INTO patients_record VALUES("601","2024042649780","Test Test","S","1977-01-01","Male","1","1","120/66","98.0","18","60","160","69","99","2024042620253","nurse1","Palmas Del Mar","2024-04-26 17:41:10","Test Test","All","","");
INSERT INTO patients_record VALUES("602","2024042689734","1test","S","1998-04-24","Male","1","1","120/66","98.0","18","60","160","69","99","202404263528","nurse1","Palmas Del Mar","2024-04-26 17:43:15","sick","All","","");
INSERT INTO patients_record VALUES("603","2024042633764","","","","","","","","","","","","","","2024042624569","nurse1","Palmas Del Mar","2024-04-26 19:35:58","","","","");
INSERT INTO patients_record VALUES("604","2024042764218","Juan ","Juan ","1950-10-20","Male","1231234123","1230 HILL","110/71","97.7","18","86","230","63","100","2024042720246","nurse1","Palmas Del Mar","2024-04-27 14:06:14","back pain X4 days 
KNA 
Pharmacy Walgreens on Atascocita
Daily Medications Losartan,  
","All","Yes","Finish");
INSERT INTO patients_record VALUES("605","2024042746485","Stephanny","Lopez ","2003-09-02","Female","1235452525","1 the hill","110/71","97.7","16","68","196","72","98","2024042734449","nurse1","Palmas Del Mar","2024-04-27 14:38:24","Ear pain X 3 days 
KNA
Pharmacy Walgreens 747 e cross timbers 77016
Daily Medication : Vitamin D 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("606","2024042729996","Thomas ","Smith ","2008-10-20","Male","1234561212","","130/80","97.7","16","80","196","69","100","2024042711761","nurse1","Palmas Del Mar","2024-04-27 14:54:26","Ear pain , allergies X3 days 
KNA 
Pharmacy Kroger across the street 
Daily MEds. Allegra ","All","","");
INSERT INTO patients_record VALUES("607","2024042717732","Jose ","Pable","2000-05-05","Male","1234569478","12345 Elm sT ","112/86","97.7","16","80","160","63","99","2024042719994","nurse1","Palmas Del Mar","2024-04-27 15:01:26","Ear pain X 3 days 
NKA 
Pharmacy : Kroger across the street 3820 Atascocita RD 
Daily Meds Allegra 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("608","2024042862344","TEST2","Test","2000-10-20","Female","1231231236","","110/71","98.6","16","80","120","60","100","2024042818987","nurse1","Palmas Del Mar","2024-04-28 14:18:47","Rash on the hand X3 days. States partner was diagnosed with scabies. 
Allergic to Amoxicillin
Kroger 2818126397
No daily meds  ","All","Yes","Finish");
INSERT INTO patients_record VALUES("609","2024042845605","Lloyd ","Freeman ","1960-10-20","Male","8322050888","1234 Elm st ","130/80","98.6","18","80","186","72","100","2024042819479","nurse1","Palmas Del Mar","2024-04-28 22:49:00","Cough X 2 days 
Environmental allergies
, NKA to meds 
Pharmacy CVS Houston
 No daily medicataions 

","All","Yes","Finish");
INSERT INTO patients_record VALUES("610","2024042986785","test","test2","","Male","","","","","","","","","","2024042922296","nurse1","Palmas Del Mar","2024-04-29 14:05:40","runny nose","All","Yes","Finish");
INSERT INTO patients_record VALUES("611","2024042929929","Renzo","Sanch","1977-12-13","Male","5554443333","123","120/60","101.5","18","60","160","69","95","2024042940862","nurse1","Palmas Del Mar","2024-04-29 15:47:27","Sinus congestion and body aches x 2 days

NKDA

Rx:  Walmart 222-333-6666","All","Yes","Ready");
INSERT INTO patients_record VALUES("612","2024042964194","Vanessa","E","1999-08-30","Female","21022222222","1234 nnw","147/66","98.0","19","78","145","61","98","2024042939638","nurse1","Palmas Del Mar","2024-04-29 16:58:50","Headache, SOB

ALLERGIES: Nsaids

RX: HEB 2102222222","All","Yes","Finish");
INSERT INTO patients_record VALUES("613","2024042982943","","","","","","","","","","","","","","2024042935896","Humble","Humble","2024-04-29 17:39:06","","","","");
INSERT INTO patients_record VALUES("614","2024042967570","ADRI","G","1999-08-29","Female","873553446","11455 POTRANCO","133/89","98.1","18","77","160","62","98","2024042921881","nurse1","Palmas Del Mar","2024-04-29 17:40:23","","All","Yes","Ready");
INSERT INTO patients_record VALUES("615","2024042947762","Renzo","S","1977-12-13","Male","1","1","120/60","98.0","18","60","160","69","98","2024042937917","Castle Hills","Castle Hills","2024-04-29 18:21:42","Sick

NKDA

Rx:  Walmart 555-666-7788","All","Yes","Ready");
INSERT INTO patients_record VALUES("616","2024042986124","renz","san","1977-12-13","Male","1112223344","123 the st","113/71","99.5","18","81","160","70","78","2024042947036","Castle Hills","Castle Hills","2024-04-29 18:48:34","sinus congestion 
right ear decreased hearing 
left ear  discomfort
NKDA
rx: walmat 2107845222","All","Yes","Ready");
INSERT INTO patients_record VALUES("617","2024042980077","","","","","","","","","","","","","","2024042936871","Castle Hills","Castle Hills","2024-04-29 19:14:57","","","","");
INSERT INTO patients_record VALUES("618","2024042922098","Brett","Marvel","1982-08-22","Male","","","110/70","99.0","","53","190","72","99","2024042929676","Humble","Humble","2024-04-29 19:20:39","Pts kids have strep and pt has fullness in his ear. Pt gets ear infections in the past. Pts kid is feeling better with antibitoics, Pt states its been a few days


Allergic: none
Pharmacy: Kroger Atasctcia RD","All","Yes","Finish");
INSERT INTO patients_record VALUES("619","2024042920447","Kassy","Huiman","1999-12-13","Male","","","119/61","98.3","","71","227","63","97","202404294342","Humble","Humble","2024-04-29 19:55:24","pt has nasal congestion, runny nose, pt states its worse at night, pt states been happening for over a month now

Allergies: NKDA
Pharamacy; Walgreens of Atascocita rd and will clayton","All","Yes","Finish");
INSERT INTO patients_record VALUES("620","2024043094257","","","","Male","","","","","","","","","","2024043031996","Humble","Humble","2024-04-30 14:58:46","","All","","");
INSERT INTO patients_record VALUES("621","2024043042261","Michelle","Gage","","Male","","","120/80","98.6","","76","205","65","","2024043032247","nurse1","Palmas Del Mar","2024-04-30 15:32:55","sore throat x 3 days

nkda

walgreens","All","","");
INSERT INTO patients_record VALUES("622","2024043061921","","","","Male","","","","","","","","","","202404309194","nurse1","Palmas Del Mar","2024-04-30 15:34:21","","All","","");
INSERT INTO patients_record VALUES("623","2024043074710","","","","Male","","","","","","","","","","2024043039090","nurse1","Palmas Del Mar","2024-04-30 15:36:54","","All","","");
INSERT INTO patients_record VALUES("624","2024043026300","","","","Male","","","","","","","","","","202404301482","nurse1","Palmas Del Mar","2024-04-30 15:42:44","","All","","");
INSERT INTO patients_record VALUES("625","2024043091574","","","","Male","","","","","","","","","","2024043025018","nurse1","Palmas Del Mar","2024-04-30 15:54:48","","All","","");
INSERT INTO patients_record VALUES("626","2024043025772","Brett ","Marvel","1993-12-25","Male","2814496532","","106/98","98.5","16","76","205","65","100","2024043029675","nurse1","Palmas Del Mar","2024-04-30 15:59:48","sore throat 3x day
NKDA
Walgreens
281 445-6350","All","Yes","Finish");
INSERT INTO patients_record VALUES("627","2024043048943","sdgvzsdvb","zdbdzfbzdfb","","Male","5430455204","","106/98","98.7","","","120","65","","2024043016509","nurse1","Palmas Del Mar","2024-04-30 16:35:06","zsdfgdsfghdsf","All","Yes","Finish");
INSERT INTO patients_record VALUES("628","2024043043819","","","","Male","","","","","","","","","","2024043037413","nurse1","Palmas Del Mar","2024-04-30 16:41:17","","All","","");
INSERT INTO patients_record VALUES("629","2024043095936","test","test","0001-01-01","Male","1","1","120/66","98.0","18","60","160","69","98","2024043025702","Castle Hills","Castle Hills","2024-04-30 16:59:56","test test
","All","","");
INSERT INTO patients_record VALUES("630","2024043062128","test","test","0001-01-01","Male","1","1","120/66","98.0","18","60","160","69","98","2024043028925","Castle Hills","Castle Hills","2024-04-30 17:01:22","test test","All","Yes","Finish");
INSERT INTO patients_record VALUES("631","2024043018013","","","","Male","","","","","","","","","","2024043035192","Castle Hills","Castle Hills","2024-04-30 17:07:33","","All","","");
INSERT INTO patients_record VALUES("632","2024043082792","Test Renz","t","0001-01-01","Male","1","1","1","1","1","1","11","1","1","2024043040524","Humble","Humble","2024-04-30 21:58:19","Test ","All","Yes","Finish");
INSERT INTO patients_record VALUES("633","2024043028931","michelle","gage","1989-09-14","Female","","","130/80","98.6","18","80","190","65","99","2024043028211","Humble","Humble","2024-04-30 22:03:54","uti","All","Yes","Finish");
INSERT INTO patients_record VALUES("634","2024043063822","michelle","gage","1989-09-14","Female","3239722961","","130/80","98.6","18","86","190","65","99","2024043027746","Humble","Humble","2024-04-30 22:08:14","uti","All","Yes","Finish");
INSERT INTO patients_record VALUES("635","2024050136913","CH Test","Test","2001-01-01","Male","1","1","120/66","98.0","18","78","160","69","98","2024050147159","Castle Hills","Castle Hills","2024-05-01 15:12:45","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("636","2024050168744","test","test 4","2003-07-16","Male","","","122/67","98.2","","64","227","63","99","2024050138546","Humble","Humble","2024-05-01 16:57:44","runny nose, nasal pressure, buildup mucus ","All","Yes","Finish");
INSERT INTO patients_record VALUES("637","2024050281944","BRETT","test","1982-08-22","Male","1234567890","","112/86","98.6","18","64","190","72","100","202405022476","Humble","Humble","2024-05-02 13:39:19","1234567890","All","Yes","Ready");
INSERT INTO patients_record VALUES("638","2024050245679","Test","Test","","Male","","","","","","","","","","2024050211685","Humble","Humble","2024-05-02 14:25:57","ear ache","All","Yes","Finish");
INSERT INTO patients_record VALUES("639","2024050245090","BRETT","MARVEL","","Male","","","","98.6","","","190","72","","202405028819","Humble","Humble","2024-05-02 14:53:25","","All","Yes","Finish");
INSERT INTO patients_record VALUES("640","2024050253242","Test Renzo","San","0001-01-01","Male","1112223344","123 the street","115/75","98.0","18","66","160","69","97","2024050235084","Castle Hills","Castle Hills","2024-05-02 15:16:27","Flu like symptoms x 3 days

Allergies:  NKDA

Rx:  Walgreens 2103303333","All","Yes","Ready");
INSERT INTO patients_record VALUES("641","2024050253327","test","tes4","","Male","","","","","","","","","","2024050212495","Humble","Humble","2024-05-02 15:36:44","runny nose 
","All","Yes","Ready");
INSERT INTO patients_record VALUES("642","2024050299513","","","","Male","","","","","","","","","","2024050228371","Castle Hills","Castle Hills","2024-05-02 16:12:52","","All","","");
INSERT INTO patients_record VALUES("643","2024050223475","2 CH test","San","0001-01-01","Male","1","1","120/66","98.0","18","60","160","69","98","2024050248603","Castle Hills","Castle Hills","2024-05-02 16:23:29","Hurt

NKDA

Rx:  Walgreens 210-555-9988","All","Yes","Finish");
INSERT INTO patients_record VALUES("644","2024050258178","Joaquin","Lara","1970-08-16","Male","2105501961","624 Pecan Dr Schertz Tx 78154","118/78","97.8","18","68","180","67","98","202405025633","Castle Hills","Castle Hills","2024-05-02 17:14:14","Sore throat x 2 days 

NKDA

RX: Walgreens 210-55-5555","All","Yes","Finish");
INSERT INTO patients_record VALUES("645","2024050250326","Lorenzo","Sanchez","1970-08-16","Male","210550191","624 Pecan Dr Schertz Tx 78154","","","","","","","","2024050212258","Castle Hills","Castle Hills","2024-05-02 17:59:16","","All","","");
INSERT INTO patients_record VALUES("646","2024050286445","Lorenzo","Sanchez","1970-08-16","Male","2105501961","624 Pecan Dr Schertz Tx 78154","102/56","98.1","18","55","160","69","96","2024050227127","Castle Hills","Castle Hills","2024-05-02 18:01:15","Pressure to both ears x 1 week 
NKDA

RX Walmart 210-550-1960","All","Yes","Finish");
INSERT INTO patients_record VALUES("647","2024050229930","l","l","","Male","1","1","120/66","98.0","18","60","160","69","99","2024050246898","Castle Hills","Castle Hills","2024-05-02 18:21:37","1","All","Yes","Finish");
INSERT INTO patients_record VALUES("648","2024050320925","kjsdlfkj","a","0001-01-11","Male","1","1","120/60","98.0","18","60","160","69","98","202405033913","Castle Hills","Castle Hills","2024-05-03 14:56:04","sick

nkda

Rx:  Walmart","All","Yes","Finish");
INSERT INTO patients_record VALUES("649","2024050395801","","","","Male","","","","","","","","","","202405031610","Castle Hills","Castle Hills","2024-05-03 14:59:26","","All","","");
INSERT INTO patients_record VALUES("650","2024050390402","morales","marlene","1981-12-02","Female","2107053928","","144/98","97.5","17","78","120","64","78","2024050317706","Castle Hills","Castle Hills","2024-05-03 16:44:45","weak

heb pharmacy 2107777777

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("651","2024050375675","","","","","","","","","","","","","","2024050337182","Castle Hills","Castle Hills","2024-05-03 16:54:04","","","","");
INSERT INTO patients_record VALUES("652","2024050380571","morales","ernesto","1946-11-10","Male","2108234386","6910 spring lark","175/81","97.4","18","78","180","61","98","2024050340858","Castle Hills","Castle Hills","2024-05-03 16:56:32","ear ache
knda

cvs 2107777777","All","Yes","Finish");
INSERT INTO patients_record VALUES("653","2024050355789","Rebbeca","Barba","1950-01-29","Female","21012234567","1234 nnw","158/96","97.7","19","101","206","65","98","20240503839","Castle Hills","Castle Hills","2024-05-03 17:22:34","Cold Like symptoms

RX:Walmart 210123456

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("654","2024050364385","","","","Male","","","","","","","","","","2024050347813","Castle Hills","Castle Hills","2024-05-03 17:44:23","","All","","");
INSERT INTO patients_record VALUES("655","2024050363294","mARL","MORA","1981-12-02","Female","0","0","155/91","97.9","18","67","120","64","99","2024050345772","Castle Hills","Castle Hills","2024-05-03 18:17:08","SINUS CONGESTION X 4 DAYS
NKDA

Rx CVS 2103335566

","All","Yes","Finish");
INSERT INTO patients_record VALUES("656","2024050363294","mARL","MORA","1981-12-02","Female","0","0","155/91","97.9","18","67","120","64","99","2024050345772","Castle Hills","Castle Hills","2024-05-03 18:17:15","SINUS CONGESTION X 4 DAYS
NKDA

Rx CVS 2103335566

","All","Yes","Finish");
INSERT INTO patients_record VALUES("657","2024050377915","Lorenzo ","Sanchez","1977-12-13","Male","1","1","125/77","97","18","66","165","69","97","202405035036","Castle Hills","Castle Hills","2024-05-03 18:36:28","ST

Walmart

NKDA","All","","");
INSERT INTO patients_record VALUES("658","2024050377687","","","","","","","","","","","","","","202405038576","Castle Hills","Castle Hills","2024-05-03 19:05:08","","","","");
INSERT INTO patients_record VALUES("659","2024050398343","","","","","","","","","","","","","","2024050333685","Castle Hills","Castle Hills","2024-05-03 19:18:22","","","","");
INSERT INTO patients_record VALUES("660","2024050399503","","","","","","","","","","","","","","202405032948","nurse1","Palmas Del Mar","2024-05-04 01:50:35","","","","");
INSERT INTO patients_record VALUES("661","2024050363984","","","","Male","","","","","","","","","","2024050315882","Castle Hills","Castle Hills","2024-05-04 01:53:10","","All","","");
INSERT INTO patients_record VALUES("662","2024050414582","Heriberto","Rubalcava ","1979-10-01","Male","","12200 Saint Francis St. Crosby Tx. 77532","140/88","98.3","16","67","205.6","67","97","2024050445909","Humble","Humble","2024-05-04 14:30:49","Concern about high blood pressure readings.

No current medications

Walmart on 2100 Rd. in Crosby Tx.","All","","");
INSERT INTO patients_record VALUES("663","2024050424446","Castle ","Hills","0001-01-01","Male","2105556666","123 The Street","120/62","98.0","18","62","170","70","99","2024050432700","Castle Hills","Castle Hills","2024-05-04 14:34:20","Sinus congestion.  Earache

NKDA

Rx:  Walmart 2108887777","All","Yes","Finish");
INSERT INTO patients_record VALUES("664","2024050459411","Castle ","Hills","","Male","1","1","120/66","98.0","18","78","160","69","98","2024050443801","Castle Hills","Castle Hills","2024-05-04 15:01:53","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("665","2024050437948","","","","Male","","","","","","","","","","2024050445031","Castle Hills","Castle Hills","2024-05-04 15:14:46","","All","","");
INSERT INTO patients_record VALUES("666","2024050410926","Brett","Marvel","","Male","5743092476","406 South Bordon St","","98.6","","","190","72","","2024050449352","Reza","Palmas Del Mar","2024-05-04 18:57:35","rgagag","All","Yes","Finish");
INSERT INTO patients_record VALUES("667","2024050470881","jane","doe","2000-01-01","Female","7132022001","1234 Elm st ","112/86","97.8","16","64","120","60","99","2024050430701","Humble","Humble","2024-05-04 19:00:43","Ha x2 days","All","Yes","Ready");
INSERT INTO patients_record VALUES("668","2024050431988","","","","","","","","","","","","","","2024050429250","Humble","Humble","2024-05-04 19:03:49","","","","");
INSERT INTO patients_record VALUES("669","2024050482065","John","Test","2005-01-30","Male","7135665402","12345 Elm sT ","130/80","99.0","16","64","230","63","100","2024050419256","Humble","Humble","2024-05-04 19:06:03","cough x 5 days","All","Yes","Finish");
INSERT INTO patients_record VALUES("670","2024050435920","joe","smith","1986-02-04","Male","8325660214","1230 HILL","112/86","99.0","16","80","160","69","98","2024050426725","Humble","Humble","2024-05-04 19:09:23","HA x 1 week","All","","");
INSERT INTO patients_record VALUES("671","2024050438476","test","gage","1200-01-01","Male","7135222222","1 the hill","112/86","97.8","16","86","190","65","99","20240504352","Humble","Humble","2024-05-04 19:14:54","jg,kvmn ","All","Yes","Finish");
INSERT INTO patients_record VALUES("672","2024050475556","Jose","Lopez","1983-10-04","Male","8322064789","5201","148/92","98.1","20","96","200","68","97","2024050428613","Humble","Humble","2024-05-04 19:26:32","Back pain x 2 months off an on, worse at night. 6/10 pain level

OTC ibuprofen 

Pharmacy: Walgreens on Maxey Rd","All","","");
INSERT INTO patients_record VALUES("673","2024050427690","rosa","test","1947-09-05","Female","2815607890","5631 first st","126/74","99.0","20","86","160","60","95","202405044463","Humble","Humble","2024-05-04 19:44:51","Runny nose and cough x 5 days

No medications

Krogers in Atascosita ","All","","");
INSERT INTO patients_record VALUES("674","2024050465271","TEST2","test","1952-05-06","Female","2815602148","5601 first","126/74","99.0","20","18","175","60","95","2024050414274","Humble","Humble","2024-05-04 19:49:09","cold and cough","All","","");
INSERT INTO patients_record VALUES("675","2024050447190","","","","","","","","","","","","","","2024050442561","Humble","Humble","2024-05-04 19:51:06","","","","");
INSERT INTO patients_record VALUES("676","2024050487662","Rosa","Test","1950-05-04","Female","2815604102","12340  First","130/80","97.7","18","64","120","60","100","2024050446648","Humble","Humble","2024-05-04 19:52:01","cough and cold","All","Yes","Finish");
INSERT INTO patients_record VALUES("677","2024050469702","Juan","Garcia","1955-03-29","Male","7135802401","12200 Louis","136/89","98.1","18","85","185","65","98","2024050457","Humble","Humble","2024-05-04 20:10:33","Back pain x 1 week. Feel while he was cleaning the floor. 
Otc tylenol only
Walgreens on 2100 Rd Crosby Tx","All","Yes","Finish");
INSERT INTO patients_record VALUES("678","2024050412882","Teddy","Bear","1950-07-09","Male","2103080640","111 2nd st","142/86","98.6","18","99","179.6","65","99","2024050446688","Humble","Humble","2024-05-04 20:14:44","Sad lately
Lisinopril 10 mg qd
Sams on I10E and Uvalde ","All","Yes","Finish");
INSERT INTO patients_record VALUES("679","2024050454521","Mary","Canelo","1979-10-01","Female","4093601528","","112/68","97.4","16","79","145","60","98","2024050426608","Humble","Humble","2024-05-04 20:17:37","Rash on right arm x 7 days.
Otc cortisone.
Kroger in Atascosita","All","Yes","Finish");
INSERT INTO patients_record VALUES("680","2024050478758","Jose","Altuve","1983-01-03","Male","7132021663","123640.","130/80","97.7","16","80","175","63","100","2024050425510","Humble","Humble","2024-05-04 20:42:17","Sore throat x 4 days.
No meds
Kroger in Atascocita","All","Yes","Finish");
INSERT INTO patients_record VALUES("681","2024050455336","Alex ","Bregman","1983-01-03","Male","8324620354","","112/86","99.0","18","86","190","69","99","2024050424406","Humble","Humble","2024-05-04 20:59:52","Pink eye x 3 days
No meds
Kroger Atascosita","All","Yes","Finish");
INSERT INTO patients_record VALUES("682","2024050423167","Jeff","Bagwell","1955-03-19","Male","8320640620","","132/91","100.9","20","101","201","69","99","202405049547","Humble","Humble","2024-05-04 21:18:52","Sore throat and low grade fever x 3 days.
OTC Tylenol
Walmart 2100 Rd in Crosby","All","Yes","Finish");
INSERT INTO patients_record VALUES("683","2024050481063","Bryan","Morales","2003-02-24","Male","2811111111","","110/71","99.7","22","102","160","63","99","2024050449849","Humble","Humble","2024-05-04 22:37:59","Ear pain x 2 days.
Tylenol as needed
Walgreens on Main St.","All","Yes","Finish");
INSERT INTO patients_record VALUES("684","2024050598209","Heriberto","Rubalcava ","1979-10-01","Male","3466061945","12200 Saint Francis St. Crosby Tx 77532","132/93","98.5","16","82","206.6","67","97","2024050515908","Humble","Humble","2024-05-05 14:15:14","High blood pressure concerns. High readings at home.
Nkda
Not currently taking any meds
Walmart on 2100 Rd. in Crosby Tx.","All","Yes","Finish");
INSERT INTO patients_record VALUES("685","2024050511876","me","me","1983-01-10","Female","2301942032","","110/71","97.7","","64","175","65","","202405051485","Humble","Humble","2024-05-05 15:27:52","Fell from the stairs","All","Yes","Finish");
INSERT INTO patients_record VALUES("686","2024050521434","Christopher","Edmond","1991-04-25","Male","7135399629","","126/70","98","59","67","304.4","70","97","2024050534264","Humble","Humble","2024-05-05 15:42:33","Follow up from ER visit. Dx with acid reflux
Otc pepcid and famotidine
Nkda
Walgreens 59 and little york","All","Yes","Finish");
INSERT INTO patients_record VALUES("687","2024050537004","Abigail","Blaha","2005-08-21","Female","8326900604","","104/73","99.2","18","100","84.2","59","94","2024050533910","Humble","Humble","2024-05-05 19:22:29","Cough, runny nose, congestion x 6 days
Nkda
Kroger Atascocita","All","Yes","Finish");
INSERT INTO patients_record VALUES("688","2024050558498","Bryan","Lopez","2010-09-20","Male","8325665491","8210 Bauman Rd Houston Tx 77022","115/83","98.3","18","89","209.6","67","97","2024050530013","Humble","Humble","2024-05-05 21:24:18","Swollen inner eyelid x 2 days.
Nkda
Focalin 10 mg 1 daily
Walgreens on Crosstimbers 713-695-2427","All","Yes","Finish");
INSERT INTO patients_record VALUES("689","2024050625293","humble","test","","","","","","","","","","","","2024050643007","Humble","Humble","2024-05-06 14:07:02","test","All","","");
INSERT INTO patients_record VALUES("690","2024050661219","test","test","","","","","120/60","98.0","18","78","160","69","98","202405065584","Castle Hills","Castle Hills","2024-05-06 14:12:13","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("691","2024050681258","","","","","","","","","","","","","","2024050611769","Castle Hills","Castle Hills","2024-05-06 14:22:20","","","","");
INSERT INTO patients_record VALUES("692","2024050690196","morning","test","","","","","","","","","","","","2024050630905","Humble","Humble","2024-05-06 14:34:31","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("693","2024050619268","seb","esco","1988-11-22","","","","120/80","98.5","18","78","154","59","99","2024050645415","Castle Hills","Castle Hills","2024-05-06 16:32:30","ALLERGIES


KNDA



WALMART 2107777777","All","","");
INSERT INTO patients_record VALUES("694","2024050688572","VANESSA","ESCO","1989-01-02","","","","","","","","","","","2024050612306","Castle Hills","Castle Hills","2024-05-06 17:48:56","ALLERGIES


KNDA


WALMART 2107777777","All","","");
INSERT INTO patients_record VALUES("695","2024050682068","VANESSA","ESCO","1989-01-02","","","","","","","","","","","2024050633862","Castle Hills","Castle Hills","2024-05-06 19:36:14","ALLERGIES

KNDA


WALMART 210-777-7777","All","","");
INSERT INTO patients_record VALUES("696","2024050725071","michelle","gage","1989-09-14","","","","130/80","97.7","18","86","175","65","99","2024050730236","Humble","Humble","2024-05-07 13:53:44","sorethroat","All","Yes","Finish");
INSERT INTO patients_record VALUES("697","2024050761567","Morning","Test Run","2024-05-07","","","","00","00","00","00","00","00","00","2024050712761","Castle Hills","Castle Hills","2024-05-07 13:56:30","Morning test run","All","Yes","Ready");
INSERT INTO patients_record VALUES("698","2024050754682","test","test","2024-05-07","","","","","","","","","","","2024050743879","Castle Hills","Castle Hills","2024-05-07 14:30:01","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("699","2024050754682","","","","","","","","","","","","","","2024050743879","Castle Hills","Castle Hills","2024-05-07 14:30:39","","","Yes","Finish");
INSERT INTO patients_record VALUES("700","2024050744249","Adriana","Reyna","1971-02-08","","","","128/89","97.6","18","78","165","60","97","2024050738118","Castle Hills","Castle Hills","2024-05-07 16:00:30","Right hip pain.
Right bottom foot pain.

RX: 2104919976

Allergies:Propylene glycol. Dichlorophene.","All","Yes","Finish");
INSERT INTO patients_record VALUES("701","2024050737132","Jennifer","McElroy","2004-11-08","","","","","","","","","","","202405073434","Castle Hills","Castle Hills","2024-05-07 19:59:25","sore throat, redness swelling, white pactches. x3days

NKDA

RX: HEB 210341-3875","All","","");
INSERT INTO patients_record VALUES("702","2024050777390","Jennifer","McElroy","2004-11-08","","","","96/65","99.2","21","126","126","65","95","2024050731698","Castle Hills","Castle Hills","2024-05-07 21:09:25","sore throat, redness swelling, white patches

NKDA

RX: HEB 210-341-3875","All","Yes","Finish");
INSERT INTO patients_record VALUES("703","2024050719597","","","","","","","","","","","","","","2024050725781","Castle Hills","Castle Hills","2024-05-07 21:19:40","","","","");
INSERT INTO patients_record VALUES("704","2024050786148","AMANDA","BERMUDEZ","1959-09-13","","","","140/81","98.5","18","60","162","60","95","2024050718827","Humble","Humble","2024-05-07 22:26:12","PATIENT WAS DISCHARDED ON 5/2 PT WAS DIAGOSED WITH HIGH BP 
PT STATES WAS DRIVING AND HAD NO AC AND BODY STRATED SHAKING AND INTESE BLURRYNESS WITCH TRIGGERED PT TO DRIVE TO ER
PT STATES WAS SDMITTED FOR 2 DAYS 
PT STATES FEELS DIZZY BUT FEELS BETTER THAN WHEN ADMITTED 
PT WAS TOLD TO FIND A PCP 
ALLERGIES: NONE ","All","Yes","Finish");
INSERT INTO patients_record VALUES("705","2024050840282","MORINING ","TEST","","","","","120/80","98.6","","68","230","65","100","2024050824423","Humble","Humble","2024-05-08 14:03:00","RUNNY NOSE","All","Yes","Finish");
INSERT INTO patients_record VALUES("706","2024050810325","Test","Joaquin","1970-08-16","","","","120/66","97.8","18","60","170","69","98","2024050823027","Castle Hills","Castle Hills","2024-05-08 14:18:43","cough x 2 days

NKDA

RX: Walgreens (210-550-1961)","All","Yes","Finish");
INSERT INTO patients_record VALUES("707","2024050941309","TEST","TEST","1989-01-02","","","","","","","","","","","2024050916912","Castle Hills","Castle Hills","2024-05-09 15:51:09","TEST CALL","All","Yes","Ready");
INSERT INTO patients_record VALUES("708","2024050916724","Dayanna","Diaz","1994-02-26","","","","120/80","98.6","","80","245","63","100","2024050916590","Humble","Humble","2024-05-09 17:43:01","Demo","All","Yes","Finish");
INSERT INTO patients_record VALUES("709","2024050965579","Test","Test","1111-11-11","","","","1","1","1","1","1","1","1","2024050923080","nurse1","Palmas Del Mar","2024-05-10 02:02:18","t","All","Yes","Finish");
INSERT INTO patients_record VALUES("710","2024051061033","TEST","TEST","1989-01-02","","","","","","","","","","","202405101247","Castle Hills","Castle Hills","2024-05-10 13:51:17","TEST","All","","");
INSERT INTO patients_record VALUES("711","2024051016796","Humble"," Test","","","","","","","","","","","","202405108810","Humble","Humble","2024-05-10 14:01:59","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("712","2024051011688","TEST","TEST","1989-01-02","","","","","","","","","","","2024051017963","Castle Hills","Castle Hills","2024-05-10 14:04:44","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("713","2024051063770","Katrina","Adams","1976-01-22","","","","147/81","99.4","","68","210","62","95","2024051029432","Humble","Humble","2024-05-10 16:58:33","Pt was sneezing yesterday followed with cough, body chills, and body aches. 
Pt has headache with nasal pressure and congestion. 
no other family members sick.
PT is fasting
Pt cant take robatussin

Allergies: none

Pharmacy:
H-E-B
6430 Garth Rd
Baytown, TX 77521","All","Yes","Finish");
INSERT INTO patients_record VALUES("714","2024051150191","Test","Test","2024-05-11","","","","00","00","00","00","00","00","00","2024051145577","Castle Hills","Castle Hills","2024-05-11 14:02:12","Good Morning!","All","","");
INSERT INTO patients_record VALUES("715","2024051155440","test","test","2024-05-11","","","","00","00","00","00","00","00","00","202405113880","Castle Hills","Castle Hills","2024-05-11 14:18:21","good morning","All","Yes","Finish");
INSERT INTO patients_record VALUES("716","2024051141995","Heriberto ","Rubalcava ","1979-10-01","","",""," 139/84","98.0","18","67","207","67","97","2024051126450","Humble","Humble","2024-05-11 15:20:44","Pt is here for a follow up on labs
Kna
taking lisinopril 20 ml daily  
Walmart Crosby ","All","Yes","Finish");
INSERT INTO patients_record VALUES("717","2024051220850","","","","","","","110/69","98.1","18","60","160","69","99","2024051227524","nurse1","Palmas Del Mar","2024-05-12 13:41:08","","","Yes","Ready");
INSERT INTO patients_record VALUES("718","2024051294376","","","","","","","110/69","98.1","18","60","160","69","99","2024051217134","Reza","Palmas Del Mar","2024-05-12 13:46:40","test run","","Yes","Ready");
INSERT INTO patients_record VALUES("719","2024051275400","","","","","","","110/69","98.1","18","60","160","69","99","2024051240321","Castle Hills","Castle Hills","2024-05-12 13:50:02","test run

NKDA

Rx:  Walmart 210-333-3344","","Yes","Ready");
INSERT INTO patients_record VALUES("720","2024051238401","","","","","","","110/69","98.1","18","60","160","69","99","2024051237154","Castle Hills","Castle Hills","2024-05-12 13:54:21","test run ","","Yes","Ready");
INSERT INTO patients_record VALUES("721","2024051238401","","","","","","","110/69","98.1","18","60","160","69","99","2024051237154","Castle Hills","Castle Hills","2024-05-12 13:54:26","test run ","","Yes","Ready");
INSERT INTO patients_record VALUES("722","2024051214544","Test","Test","0002-02-22","","","","1","1","1","1","1","1","1","2024051223392","nurse1","Palmas Del Mar","2024-05-12 14:02:34","Test","All","Yes","Finish");
INSERT INTO patients_record VALUES("723","2024051180945","Test","test","2010-10-10","","","","120/80","98.6","20","68","120","63","100","2024051136667","Humble","Humble","2024-05-12 14:04:18","Pt is here with a sink rash X3 days
NKA
Daily meds : Losartan 
Pt states her partner was dx with scabies 1 week ago
Pharmacy Walgreens on Atascocita 281-812-4778 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("724","2024051221924","Renzo","mothersday","0001-01-01","","","","110/69","98.1","18","60","160","69","99","2024051240273","Reza","Palmas Del Mar","2024-05-12 14:07:26","renzo test","All","Yes","Finish");
INSERT INTO patients_record VALUES("725","2024051284334","Sunday Test","Test","2024-05-12","","","","00","00","00","00","00","00","00","2024051228747","Castle Hills","Castle Hills","2024-05-12 14:16:00","Sunday Test","All","Yes","Finish");
INSERT INTO patients_record VALUES("726","2024051240526","TEST2","Test","2000-02-10","","","","112/86","97.7","20","86","230","63","99","20240512858","Humble","Humble","2024-05-12 14:27:28","sore throat X 5 days
taking OTC Mucinex 
NKA 
No daily meds 
Pharmacy Kroger on Atascocita  ","All","Yes","Finish");
INSERT INTO patients_record VALUES("727","2024051240526","TEST2","Test","2000-02-10","","","","112/86","97.7","20","86","230","63","99","20240512858","Humble","Humble","2024-05-12 14:27:44","sore throat X 5 days
taking OTC Mucinex 
NKA 
No daily meds 
Pharmacy Kroger on Atascocita  ","All","Yes","Finish");
INSERT INTO patients_record VALUES("728","2024051213768","Sergio ","Lopez","1979-08-03","","","","118/76","98.5","16","79","172.6","66","98","2024051236343","Humble","Humble","2024-05-12 16:50:52","Physical Exam 
NKA
No Daily medications 
Pharmacy Walgreens 747 E Crosstimbers St Houston TX 713-695-4503 ","All","Yes","Finish");
INSERT INTO patients_record VALUES("729","2024051215982","Test Lopez","Test Lopez","1979-08-03","","","","130/80","98.6","18","86","190","63","99","2024051233851","Humble","Humble","2024-05-12 17:42:48","skin rash , cough ","All","Yes","Finish");
INSERT INTO patients_record VALUES("730","2024051221918","Mia","Mendez","2019-11-20","","","","","","","","","","","2024051220880","Castle Hills","Castle Hills","2024-05-12 17:57:37","","All","","");
INSERT INTO patients_record VALUES("731","2024051215352","Test Lopez","Test Lopez","","","","","120/80","98.6","18","68","230","72","100","2024051213561","Humble","Humble","2024-05-12 18:09:01","ear pain ","All","Yes","Finish");
INSERT INTO patients_record VALUES("732","2024051229396","Mia","Mendez","2019-11-20","","","","","99.0","24","156","35.2","38","98","2024051224118","Castle Hills","Castle Hills","2024-05-12 18:26:16","fever/uri/Cough/runny nose/ right ear pain/watery eyes

RX: HEB 210-341-3875

NKDA

","All","Yes","Finish");
INSERT INTO patients_record VALUES("733","2024051250729","Olinda","Moreira","1973-08-18","","","","131/89","97.5","19","88","195","66","93","2024051243057","Castle Hills","Castle Hills","2024-05-12 19:36:45","Wheezing, throat drainage

RX: Walmart 210-591-6285

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("734","2024051374262","hUMBLE","Test","","","","","","","","","","","","2024051323584","Humble","Humble","2024-05-13 14:05:31","Test","All","Yes","Finish");
INSERT INTO patients_record VALUES("735","2024051333401","TEST","TEST","","","","","","","","","","","","2024051336087","Castle Hills","Castle Hills","2024-05-13 14:24:27","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("736","2024051391665","TEST","TEST","","","","","","","","","","","","2024051322534","Castle Hills","Castle Hills","2024-05-13 16:25:35","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("737","2024051362219","humble","test","","","","","","","","","","","","2024051314288","Humble","Humble","2024-05-13 16:33:13","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("738","2024051432622","Michelle","Gage","1989-09-14","","","","120/80","98.6","18","86","190","65","99","202405143626","Humble","Humble","2024-05-14 17:30:32","uti symptoms","All","Yes","Finish");
INSERT INTO patients_record VALUES("739","2024051417553"," pr ","test","1978-10-10","","","","130/92","101.2","18","101","161","69","95","2024051421195","Humble","Humble","2024-05-14 17:33:26","45 y/o female pt cc is flu like symptoms w/ fever since yesterday morning.","All","Yes","Finish");
INSERT INTO patients_record VALUES("740","2024051446518","test","test","2010-10-10","","","","120/68","98.0","18","60","160","72","99","2024051431750","Humble","Humble","2024-05-14 17:56:17","","All","","");
INSERT INTO patients_record VALUES("741","2024051458387","RenzTest","S","0011-11-11","","","","110/68","98.6","18","60","160","69","99","20240514912","Humble","Humble","2024-05-14 18:58:11","Sore throat

NKDA

Rx:  Walmart 210-555-6677","All","Yes","Finish");
INSERT INTO patients_record VALUES("742","2024051416478","vam ","test","1122-11-12","","","","120/80","98.6","18","76","205","65","100","2024051448430","Humble","Humble","2024-05-14 19:13:24","sore throat 3x
nkda
walgreens","All","Yes","Finish");
INSERT INTO patients_record VALUES("743","2024051428810","Valerie","Sicky","1960-11-17","","","","106/98","98.6","18","76","165","65","100","2024051431160","Humble","Humble","2024-05-14 19:33:13","sore throat 3x
Iodine
CVS
281 658-5588","All","","");
INSERT INTO patients_record VALUES("744","2024051488476","Valerie","Sicky","1960-11-17","","","","","98.7","18","76","160","65","100","202405145848","Humble","Humble","2024-05-14 19:41:22","sore throat x3
fevers 
chills
headache
Allergic to IODINE

CVS 
281 590-4456","All","Yes","Finish");
INSERT INTO patients_record VALUES("745","2024051430141","Annabelle ","Castaneda","2014-08-01","","","","114/54","98.0","18","81","108.0","60","96","202405142838","Humble","Humble","2024-05-14 21:10:36","Sore throat X2
headache X2
coughing X2
No Fevers 
NKDA
Pharmacy
Walgreens 
281-446-1006","All","","");
INSERT INTO patients_record VALUES("746","2024051462822","Annabelle","Castaneda","2014-08-01","","","","114/54","98.0","18","81","108","60","96","2024051442440","Humble","Humble","2024-05-14 21:30:53","Sore throat x2
cough x2 
no fevers
Walgreens
 (281) 446-4209","All","Yes","Finish");
INSERT INTO patients_record VALUES("747","2024051594476","Renzo","Test","1980-12-13","","","","114/54","98.6","18","60","160","69","100","2024051538265","VAM","VAM","2024-05-15 12:10:32","Rash

NKDA

Rx:  Walmart 210-333-4455","All","Yes","Ready");
INSERT INTO patients_record VALUES("748","2024051560416","ZoTest","Test","2000-12-13","","","","120/68","98.0","18","60","160","69","99","2024051536660","Palmas","Palmas","2024-05-15 12:18:53","manfluenza like symptoms x 7 minutes

Allergy:  Amoxicillin

Rx:  Walgreens 787-868-9944","All","Yes","Ready");
INSERT INTO patients_record VALUES("749","2024051596514","Isai ","Suarez","1985-03-04","","","","147/134","97.8","20","65","209.4","69","97","202405152123","VAM","VAM","2024-05-15 14:02:56","flu like symptoms
dizzy
body aches
cough
congestion
nausea
4 days with symptoms
NKDA
Pref. Pharmacy
Walgreens
12702 Bammel North Houston Rd
281 587-1839




 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("750","2024051560221","Joaquin","TEST","1970-08-16","","","","120/66","98.1","18","60","160","66","98","2024051523889","Castle Hills","Castle Hills","2024-05-15 14:35:20","Cough x 2 days

NKDA

RX: Walgreens (210) 552-1841","All","","");
INSERT INTO patients_record VALUES("751","2024051574910","Joaquin","TEST","1970-08-16","","","","120/66","98.0","18","60","160","68","98","2024051532863","Castle Hills","Castle Hills","2024-05-15 14:59:03","Cough x 2 days

NKDA

RX: Walgreens (210) 550-1961","All","","");
INSERT INTO patients_record VALUES("752","2024051559645","Joaquin","TEST","1970-08-16","","","","120/66","98.0","18","60","160","68","98","202405158032","Castle Hills","Castle Hills","2024-05-15 15:05:50","Cough x 2 days","All","Yes","Finish");
INSERT INTO patients_record VALUES("753","2024051556980","Carlos","Mejia","1975-11-13","","","","125/78","97.7","18","64","194.9","65","97","202405152226","VAM","VAM","2024-05-15 15:07:11","Blood results","All","Yes","Finish");
INSERT INTO patients_record VALUES("754","2024051593469","Joaquin","TEST","1970-05-16","","","","120/66","98.0","18","60","160","66","98","2024051531213","Castle Hills","Castle Hills","2024-05-15 17:41:27","Cough x 2 days 

NKDA 

RX: Walmart (210) 333-4444","All","","");
INSERT INTO patients_record VALUES("755","2024051565268","Joaquin","TEST","1970-08-11","","","","120/66","98.0","18","60","180","66","98","2024051518753","Castle Hills","Castle Hills","2024-05-15 17:47:47","cough X 2 days

NKDA

RX: Walgreens (210) 333-4444","All","Yes","Finish");
INSERT INTO patients_record VALUES("756","2024051597299","CH Test Renz","S","1111-11-11","","","","120/66","98.0","18","66","160","68","98","202405154995","Castle Hills","Castle Hills","2024-05-15 18:17:01","Sore Throat

Allergy:  PCN

Rx:  Walmart 210-33-4433","All","Yes","Finish");
INSERT INTO patients_record VALUES("757","2024051525543","Joaquin","TEST","1970-08-16","","","","120/66","98.0","19","78","160","66","99","2024051512565","Castle Hills","Castle Hills","2024-05-15 18:34:41","Sore throat x 2 days

NKDA


RX: Walgreens 210-550-1961","All","Yes","Finish");
INSERT INTO patients_record VALUES("758","2024051563472","San Antonio","Demo","2024-05-15","","","","120/66","98.1","18","60","180","66","98","2024051547022","Castle Hills","Castle Hills","2024-05-15 19:16:20","URI x 2 days 

NKDA

RX: Wal-Mart (444) 444-4444","All","Yes","Finish");
INSERT INTO patients_record VALUES("759","2024051544383","Castle Hills","Demo","1970-08-16","","","","120/66","98.0","18","60","180","66","98","202405157843","Castle Hills","Castle Hills","2024-05-15 20:40:47","URI x 2 days

NKDA

RX: HEB (444) 444-4444","All","Yes","Ready");
INSERT INTO patients_record VALUES("760","2024051554071","Joaquin","TEST","","","","","","","","","","","","2024051522673","Castle Hills","Castle Hills","2024-05-15 20:55:58","hpi","All","Yes","Finish");
INSERT INTO patients_record VALUES("761","2024051682589","Celeste ","Jones","1976-07-18","","","","137/90","98.2","18","74","220","68","97","2024051623027","Palmas","Palmas","2024-05-16 14:25:38","47 y/o female pt is here for BP follow up. Pt c/o weight loss.","All","Yes","Finish");
INSERT INTO patients_record VALUES("762","2024051684885","Celeste ","Jones","1976-07-18","","","","130/90","98.2","18","74","220","68","97","2024051633162","Palmas","Palmas","2024-05-16 14:28:55","BP f/u. Weight loss","All","Yes","Finish");
INSERT INTO patients_record VALUES("763","2024051680150","","","","","","","","","","","","","","2024051614278","Castle Hills","Castle Hills","2024-05-16 14:32:05","","","","");
INSERT INTO patients_record VALUES("764","2024051651458","test","test","1988-10-25","","","","120/68","98.1","18","60","160","69","99","202405162800","Palmas","Palmas","2024-05-16 15:15:37","","All","Yes","Finish");
INSERT INTO patients_record VALUES("765","2024051621495","test","test","1978-10-10","","","","","","","","","","","2024051616744","Palmas","Palmas","2024-05-16 15:23:36","","All","","");
INSERT INTO patients_record VALUES("766","2024051625585","Test","Test","2024-05-16","","","","00","00","00","00","00","00","00","2024051644094","Castle Hills","Castle Hills","2024-05-16 16:21:28","Good morning!","All","Yes","Finish");
INSERT INTO patients_record VALUES("767","2024051630192","JAMES","SCHAEFFER","1965-05-12","","","","138/76","99.4","18","83","172","68","98","2024051620168","VAM","VAM","2024-05-16 16:43:16","PT STATES IS HAVING COLD LIKE SYMPTOMS THAT TUESDAY 
PT STATES HAS A SORETHROAT COUGH CONGESTION DRWSY HURTS WHEN COUGH
PT STATES HAS SLIGHT FATIGUE 
PT STATES HAS NOT TAKEN ANYTHING FOR PAIN 
PT STATES NO ONE AT HOME IS SICK 

ALLERGIES: NONE 

PHARMACY
WALMART Pharmacy
Open·until 7pm
Mon - Sat | 9am - 7pm
Sun | 10am - 6pm
Refill a Prescription

Collapse Pharmacy
281-644-6412
","All","Yes","Finish");
INSERT INTO patients_record VALUES("768","2024051673054","JAMES","SCHAEFFER","1965-05-12","","","","138/76","99.4","18","83","172","68","98","202405167539","VAM","VAM","2024-05-16 16:57:54","PT STTATES SYMPTOMS BEGAN TUESDAY AND HAVE GOTTEN WORSE 
PT STATES HAS SORETHROAT FATIGUE AND COUGH CONGESTION 
PT HAS NOT TAKEN ANYTHING 
PT STATES FEELS DROWSY

ALLERGIES: NONE 

PHARMACY
 WALMART Pharmacy
Open·until 7pm
Mon - Sat | 9am - 7pm
Sun | 10am - 6pm
Refill a Prescription

Collapse Pharmacy
281-644-6412
","All","Yes","Finish");
INSERT INTO patients_record VALUES("769","2024051644288","test","test","1992-09-02","","","","120/68","98.0","18","64","161","72","99","2024051623234","Palmas","Palmas","2024-05-16 17:03:23","40 yr old female pt visit the clinic c/o: fever/ headache/ congestion and sore throat.
Allergies : Penicillin, aspirin  
Pharmacy : Walgreens
Medications: not medications at the moment.
Surgery: left knee, histerectomy

 ","All","Yes","Finish");
INSERT INTO patients_record VALUES("770","2024051630045","Michelle","Gage","1989-09-14","","","","120/80","99.4","18","83","172","65","100","2024051617012","VAM","VAM","2024-05-16 17:43:57","uti","All","Yes","Finish");
INSERT INTO patients_record VALUES("771","2024051670816","Michelle","Gage","1989-09-14","","","","120/80","99.4","18","83","172","65","","202405166905","VAM","VAM","2024-05-16 17:53:22","uti","All","Yes","Finish");
INSERT INTO patients_record VALUES("772","2024051660838","Indira","Lopez","1976-10-06","","","","129/76","98.1","18","96","186","63","97","2024051645781","Palmas","Palmas","2024-05-16 19:16:07","47 y/o female patient visit the clinic c/o bilateral shoulder and neck pain for 5 days now.
Patient with history of PE, 02/02/2024. Patient with history of CLL since 2011.
Pharmacy: Marisel 1
Allergies: Cipro, Steroids
Surgical History: C- section x 1 (May 2001), Gallbladder( February 2002)

","All","Yes","Ready");
INSERT INTO patients_record VALUES("773","2024051631378","JOHN","FREEMAN","1986-03-02","","","","133/92","99.1","18","75","255","70","97","2024051610484","VAM","VAM","2024-05-16 19:59:37","PT STATES IS HAVING BACK PAIN 
PT STATES BEEN HAVING CONSTANT 5 YEARS 
PT STATES HAS BEEN ABLE TO DEAL WITH PAIN 
PT STATES WHEN WENT TO CHIRO WAS TOLD 2ND OR 3RD VERDABRAI HAS NO CUSION THAT WAS 5 YRS AGO 
PT STATES PAIN NOW HAS BEEN REALLY CONSTANT
PT STATES PAIN IS IN LOWER BACK THATS SORE TO THE TOUCH 
PT STATES GETS NECK POPPING AND PAIN RADIATES 
PT DENYS INJURY 
PT STATES DOES NOT TAKE ANYTHING FOR PAIN 

ALLERGIES: NONE 

PHARMACY: 
Store #7775

Walgreens Pharmacy at 
560 RAYFORD RD Spring, TX 77386
Cross streets: Southwest corner of RAYFORD & RICHARD

Phone : 281-298-0040","All","Yes","Finish");
INSERT INTO patients_record VALUES("774","2024051744375","test","test","1978-10-10","","","","120/68","98.0","18","60","160","69","99","2024051746708","Palmas","Palmas","2024-05-17 14:16:39","bnxfgj","All","Yes","Ready");
INSERT INTO patients_record VALUES("775","2024051755579","i","ii","","","","","120/68","98.0","18","60","160","69","99","2024051749183","Palmas","Palmas","2024-05-17 14:20:13","djfghjmkyu","All","","");
INSERT INTO patients_record VALUES("776","2024051767680","Renzo","test","1986-10-10","","","","","","","","","","","2024051731464","Palmas","Palmas","2024-05-17 14:23:04","","All","Yes","Ready");
INSERT INTO patients_record VALUES("777","2024051782939","test","test","1978-10-10","","","","","","","","","","","2024051725259","Palmas","Palmas","2024-05-17 14:31:05","","All","","");
INSERT INTO patients_record VALUES("778","2024051732896","Isaac","Myer","2021-05-27","","","","","98.1","24","124","38","36","98","202405171872","Palmas","Palmas","2024-05-17 16:04:51","Male patient  2yrs old coming with his mom c/o : fever on Wednesday, today  not presenting fever also has stuffy noses and congestion.
Medication: no medications at the moment.
Allergies: no allergies at the moment
Pharmacy:  Walgreens Calle Estela","All","Yes","Finish");
INSERT INTO patients_record VALUES("779","2024051798901","Melia ","Nordet","2016-09-08","","","","","101.4","17","101","49","","99","2024051739787","Palmas","Palmas","2024-05-17 19:22:49","7 y/o pt c/o covid symptoms.  
Fever, headaches and body aches

Pharmacy: Walmart  Plaza Palma Real
Mom gave her tylenol cold and flu 10 ml at 1:15 pm today","All","","");
INSERT INTO patients_record VALUES("780","2024051750449","Melia","Nordet","2016-09-08","","","","","101.1","17","101","49","","99","2024051713082","Palmas","Palmas","2024-05-17 19:34:23","Covid symptoms 
fever, headaches and Sore throat.
 mom gave tylenol cold and flu 10 ml at 1:15 pm today
Walmart Plaza Palma Real","All","Yes","Finish");
INSERT INTO patients_record VALUES("781","2024051838707","test","test","","","","","135","512","","","1235","432","","2024051818978","Reza","Palmas Del Mar","2024-05-18 13:58:59","dsasd","All","Yes","Finish");
INSERT INTO patients_record VALUES("782","2024051878610","test 1","test1","2010-10-10","","","","130/80","98.6","18","80","190","65","100","202405182288","Humble","Humble","2024-05-18 19:58:54","sore throat and cough x3 days
NKA
Taking Allegra 10ml daily
Kroger on Atascocita","All","Yes","Finish");
INSERT INTO patients_record VALUES("783","2024051811473","TEST","TEST","","","","","","","","","","","","2024051832511","Castle Hills","Castle Hills","2024-05-18 20:14:18","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("784","2024051943753","test","test","1989-01-02","","","","120/80","97.5","","","120","61","","2024051913034","Castle Hills","Castle Hills","2024-05-19 14:01:21","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("785","2024051968698","me ","me","1999-01-03","","","","120/80","98.6","18","86","160","65","99","202405198432","Humble","Humble","2024-05-19 14:46:45","sore throat, runny nose, headache x 3 days
nkda
tylenol
walmart in crosby","All","Yes","Finish");
INSERT INTO patients_record VALUES("786","2024051932286","Juan Pablo","Flores","1978-04-02","","","","162/97","97.9","16","59","184.6","67","97","202405196552","Humble","Humble","2024-05-19 15:10:48","Annual physical and HTN follow up
Lisinopril 10 mg once daily
Nkda
Walgreens on 2100 in Crosby Tx","All","Yes","Finish");
INSERT INTO patients_record VALUES("787","2024051984373","TEST","TEST","1989-01-02","","","","","99.5","","","120","61","","2024051949988","Castle Hills","Castle Hills","2024-05-19 16:03:33","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("788","2024052012888","Isaac","MYER","2021-05-27","","","","","98.1","19","96","","","99","2024052018057","Palmas","Palmas","2024-05-20 14:33:55","3 Y/O male pt was seen on Friday with fever. Over the weekend cough started and whizzing","All","Yes","Finish");
INSERT INTO patients_record VALUES("789","2024052088840","Celeste ","Jones","1976-07-18","","","","135/88","98.1","18","96","","","98","2024052034817","Palmas","Palmas","2024-05-20 15:38:01","47 y/o is here for an IM medroxyprogesterone 
150 mg/ml vial ","All","","");
INSERT INTO patients_record VALUES("790","2024052073528","Lauren","Baner","1933-09-14","","","","97/57","98.1","23","83","190","63","99","202405206057","Castle Hills","Castle Hills","2024-05-20 15:57:26","Flu like symptoms

RX: HEB 210-479-4350

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("791","2024052097859","","","","","","","","","","","","","","2024052027324","Castle Hills","Castle Hills","2024-05-20 16:32:50","","","","");
INSERT INTO patients_record VALUES("792","2024052014476","Sophia ","Nordet","2013-12-22","","","","","103","18","97","60","54","98","2024052037890","Palmas","Palmas","2024-05-20 18:10:04","10 y/o female pt is here c/o covid symptoms .
Mom, Dad and sister had covid the last month.

Pharmacy: Walmart Plaza Palma real Humacao","All","Yes","Finish");
INSERT INTO patients_record VALUES("793","2024052033915","John","Antanaitis","1995-07-03","","","","112/75","99.0","","153","210","70","98","2024052046776","Humble","Humble","2024-05-20 18:59:15","Pt has flu like symptoms, vomited 15 times yesterday
Pt has been feeling like this for over a month now
Pt has a history of IBS and just thought it was a stomach bug
PT was in Florida for about 30 days
Pt was vomiting chucks as well


Allergies: Melons, NKDA

Pharmacy: Humble Supercenter
Walmart Supercenter #744
6626 Fm 1960 Rd E, Humble, TX 77346
Open·until 11pm
281-852-4648","All","Yes","Finish");
INSERT INTO patients_record VALUES("794","2024052132529","Sergio","Barajas","2003-03-14","","","","126/72","98.1","18","71","232.8","68","98","202405215683","VAM","VAM","2024-05-21 13:17:26","sting by a yellow jacket

NKDA

Pharmacy of Pref.
HEB 
West Lake Houston
(281) 436-1969.","All","Yes","Finish");
INSERT INTO patients_record VALUES("795","2024052199742","Sergio","Barajas","2003-03-14","","","","126/72","98.1","18","71","238.9","68","98","2024052134255","VAM","VAM","2024-05-21 14:25:26","sting by a yellow jacket 
NKDA
Pharmacy:
HEB
 (281) 436-1969","All","Yes","Finish");
INSERT INTO patients_record VALUES("796","2024052127287","TEST","TEST","1993-05-21","","","","00","00","0","00","00","00","00","2024052116544","Castle Hills","Castle Hills","2024-05-21 15:17:13","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("797","2024052174923","Daylinn","Gill","1995-05-14","","","","143/98","98.1","20","83","263.9","70","97","2024052124077","VAM","VAM","2024-05-21 15:28:24","cough
congestion
red eyes 
running nose
sore throat
headache
NKDA
PHAR:
Kroger
(281) 397-6622","All","Yes","Finish");
INSERT INTO patients_record VALUES("798","2024052148535","Alec","Falgout","1998-09-24","","","","124/74","97.4","21","56","175","71","98","2024052142827","Castle Hills","Castle Hills","2024-05-21 15:34:08","PCP Eval

RX: HEB 210-479-4350

Allergies: Penicilian","All","Yes","Finish");
INSERT INTO patients_record VALUES("799","2024052114747","","","","","","","","","","","","","","2024052115125","VAM","VAM","2024-05-21 16:27:29","","","","");
INSERT INTO patients_record VALUES("800","2024052122856","test","test","1978-10-10","","","","","","","","","","","202405216728","Palmas","Palmas","2024-05-21 18:06:49","","All","","");
INSERT INTO patients_record VALUES("801","2024052150109","Eli ","Gonzales","1991-07-06","","","","142/85","98.6","18","89","185","72","98","2024052147060","VAM","VAM","2024-05-21 20:35:13","blood results","All","Yes","Finish");
INSERT INTO patients_record VALUES("802","2024052118362","Shari ","Williams ","1983-12-30","","","","158/98","99.5","18","72","202","64","99","2024052150","Palmas","Palmas","2024-05-21 20:59:17","40 y/o female pt is here c/o extreme tiredness and fatigue for a week.","All","Yes","Finish");
INSERT INTO patients_record VALUES("803","2024052273375","Sergio","Barajas Jr.","2003-03-14","","","","133/74","98.6","18","62","230.4","68","97","20240522188","VAM","VAM","2024-05-22 13:37:04","returning patient due to worsening symptoms of a sting from yellow jacket

NKDA

HEB 
(281) 361-0083","All","Yes","Finish");
INSERT INTO patients_record VALUES("804","2024052288305","Daylinn","Gill","1995-05-14","","","","132/95","97.7","18","88","262.3","71","97","2024052229373","VAM","VAM","2024-05-22 16:08:08","allergies 
NKDA
Pharm. Pref.
Kroger
 (281) 397-6622","All","Yes","Finish");
INSERT INTO patients_record VALUES("805","2024052223007","Test","Castle Hills","1970-08-16","","","","120/80","98.0","18","60","160","68","98","2024052214065","Castle Hills","Castle Hills","2024-05-22 18:32:53","cough x 2 days 

NKDA

RX: HEB 210-255-1961","All","Yes","Finish");
INSERT INTO patients_record VALUES("806","2024052280789","TEST","Castle Hills","1970-08-16","","","","120/80","98.0","19","60","160","66","98","2024052221923","Castle Hills","Castle Hills","2024-05-22 18:39:06","Cough x 2 days

NKDA

HEB 210-550-1961","All","Yes","Finish");
INSERT INTO patients_record VALUES("807","2024052280755","","","","","","","","","","","","","","2024052224152","VAM","VAM","2024-05-22 19:20:59","","","","");
INSERT INTO patients_record VALUES("808","2024052226408","Kristian","Benavides","2005-09-01","","","","156/60","98.4","18","100","250","67","98","2024052231059","Castle Hills","Castle Hills","2024-05-22 19:53:00","General exam for lab work CMP CBC Lithium

NKDA

RX: HEB 210-681-2301

","All","Yes","Finish");
INSERT INTO patients_record VALUES("809","2024052232203","val test","reyna","1963-11-18","","","","120/80","98.6","18","83","209.4","68","100","202405223592","VAM","VAM","2024-05-22 20:44:32","ear ache 2 days","All","Yes","Finish");
INSERT INTO patients_record VALUES("810","2024052320814","test","humble","","","","","","","","","","","","2024052335472","Humble","Humble","2024-05-23 13:55:29","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("811","2024052346173","TEST","TEST","","","","","","","","","","","","202405232881","Castle Hills","Castle Hills","2024-05-23 14:06:21","TEST RUN","All","Yes","Finish");
INSERT INTO patients_record VALUES("812","2024052328836","TEST","","","","","","","","","","","","","2024052322315","Castle Hills","Castle Hills","2024-05-23 14:18:40","TEST","All","","");
INSERT INTO patients_record VALUES("813","2024052385573","TEST","TEST","1989-01-02","","","","","98.1","","","145","61","","202405232038","Castle Hills","Castle Hills","2024-05-23 14:19:55","TEST RUN","All","Yes","Finish");
INSERT INTO patients_record VALUES("814","2024052371200","KAREN","CRUITT","1977-02-28","","","","137/91","99.0","18","74","216","71","98","202405233819","VAM","VAM","2024-05-23 14:23:36","PT STATES HAS A HISTORY OF HAVING CYST ON RT NIPPLE [breast} UNDER THE SKIN
PT STATES LAST DR GAVE AN ANTIBIOTIC 
PT STATES IS PAINFUL AND SWOLLEN 
PT STATES APPERED ON SATURDAY 
PT STATES HAS CLEAR DISCHARGE 
 ALLERGIES: TRAMADOL


PHARMACY: Store #10138

Walgreens Pharmacy at 
4849 N HIGHWAY 146 Baytown, TX 77520
Cross streets: Northwest corner of SH 146 & MASSEY TOMPKINS

Phone : 281-420-9827","All","Yes","Ready");
INSERT INTO patients_record VALUES("815","2024052371596","test","test","1989-09-19","","","","","","","","161","69","","2024052318747","Palmas","Palmas","2024-05-23 14:34:57","pt h","All","Yes","Finish");
INSERT INTO patients_record VALUES("816","2024052374472","KAREN","CRUITT","1977-02-28","","","","120/80","98.6","","","205","65","","2024052342469","VAM","VAM","2024-05-23 14:35:18","","All","Yes","Ready");
INSERT INTO patients_record VALUES("817","2024052376265","","","","","","","","","","","","","","2024052327910","Palmas","Palmas","2024-05-23 14:37:06","","","","");
INSERT INTO patients_record VALUES("818","2024052383493","test","test","","","","","","","","","","","","2024052348522","Humble","Humble","2024-05-23 14:37:11","test","All","Yes","Ready");
INSERT INTO patients_record VALUES("819","2024052337911","Haley","Borkowski","2007-03-14","","","","110/80","97.5","15","103","113","61","99","2024052346209","Palmas","Palmas","2024-05-23 14:46:01","17 yo female pt presents to the clinic for evaluation of pink eye.","All","Yes","Finish");
INSERT INTO patients_record VALUES("820","2024052333810","Elijah","Robles","2009-05-29","","","","112/65","98.8","","67","147.6","82","97","202405231817","Humble","Humble","2024-05-23 15:22:21","School Physical
Snellen chart 20/20","All","Yes","Finish");
INSERT INTO patients_record VALUES("821","2024052341174","Asher ","Borkowski","2012-10-25","","","","100/60","98.2","16","73","65","48","98","2024052336820","Palmas","Palmas","2024-05-23 15:35:51","11 y/o male pt presents to the clinic for evaluation of pink eye symptoms. ","All","Yes","Finish");
INSERT INTO patients_record VALUES("822","2024052391268","Haley","Borkowski","2007-03-14","","","","110/80","97.5","15","103","113","61","99","2024052325724","Palmas","Palmas","2024-05-23 15:42:11","17 y/o female patient presents to the clinic for evaluation of pink eye symptoms. 

HPI: 1 day onset with purulent discharge and pruritus. ","All","Yes","Finish");
INSERT INTO patients_record VALUES("823","2024052349939","","","","","","","","","","","","","","2024052315958","Palmas","Palmas","2024-05-23 15:44:52","","","","");
INSERT INTO patients_record VALUES("824","2024052319090","test","Test","","","","","","","","","","","","2024052340731","Palmas","Palmas","2024-05-23 15:58:36","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("825","2024052349800","Sidney","Myer","1987-04-18","","","","110/68","98.2","16","67","147","65","98","2024052343621","Palmas","Palmas","2024-05-23 18:00:18","36 y/o female pt presents to the clinic for evaluation of lab results + general wellness visit consult.","All","Yes","Finish");
INSERT INTO patients_record VALUES("826","2024052395274","","","","","","","","","","","","","","2024052312032","Palmas","Palmas","2024-05-23 18:07:26","","","","");
INSERT INTO patients_record VALUES("827","2024052348909","Olinda","Moreira","1973-08-18","","","","141/91","98.5","00","95","197.2","66","88","2024052324161","Castle Hills","Castle Hills","2024-05-23 18:15:03","PATIENT COMING BACK FOR A FOLLOW UP ON WEEZING AND CHEST TIGHTENING","All","Yes","Finish");
INSERT INTO patients_record VALUES("828","2024052372672","Sidney","Myer","1987-04-18","","","","","","","","","","","2024052346642","Palmas","Palmas","2024-05-23 18:21:48","","All","Yes","Finish");
INSERT INTO patients_record VALUES("829","2024052368005","","","","","","","","","","","","","","2024052324856","Palmas","Palmas","2024-05-23 18:37:47","","All","","");
INSERT INTO patients_record VALUES("830","2024052311654","","","","","","","","","","","","","","2024052341289","Palmas","Palmas","2024-05-23 18:43:20","","","","");
INSERT INTO patients_record VALUES("831","2024052369007","OLINDA","Moreira","1973-08-18","","","","147/66","98.5","","81","197","66","78","2024052313260","Castle Hills","Castle Hills","2024-05-23 18:55:17","FOLLOW UP ON WHEEZING","All","Yes","Ready");
INSERT INTO patients_record VALUES("832","2024052355527","","","","","","","","","","","","","","2024052342175","Palmas","Palmas","2024-05-23 18:56:45","","","","");
INSERT INTO patients_record VALUES("833","2024052388608","test","test","","","","","","","","","","","","2024052317766","Humble","Humble","2024-05-23 18:57:17","test","All","Yes","Ready");
INSERT INTO patients_record VALUES("834","2024052352139","Olinda","Moreira","1973-08-18","","","","135/93","98.5","","93","197.2","66","90","2024052335079","Castle Hills","Castle Hills","2024-05-23 19:09:37","follow up (wheezing)","All","Yes","Finish");
INSERT INTO patients_record VALUES("835","2024052356616","","","","","","","","","","","","","","2024052310458","Castle Hills","Castle Hills","2024-05-23 19:46:33","","","","");
INSERT INTO patients_record VALUES("836","2024052369317","Jenni","Perez","2000-05-17","","","","","","","","","63","","2024052340534","Humble","Humble","2024-05-23 22:51:06","Sore throat
","All","Yes","Ready");
INSERT INTO patients_record VALUES("837","2024052498717","TEST","TEST","1989-01-02","","","","","","","","","","","202405245689","Castle Hills","Castle Hills","2024-05-24 14:16:42","TEST RUN","All","Yes","Finish");
INSERT INTO patients_record VALUES("838","2024052453281","Shari","Williams","1983-12-30","","","","158/95","97.8","15","83","202","64","97","2024052416564","Palmas","Palmas","2024-05-24 15:03:09","Female pt presents to the clinic for evaluation of lab results.

Pt indicates she feels fine and is not in distress. ","All","Yes","Finish");
INSERT INTO patients_record VALUES("839","2024052459959","","","","","","","","","","","","","","2024052412661","Palmas","Palmas","2024-05-24 15:08:29","","All","","");
INSERT INTO patients_record VALUES("840","2024052448075","John","Forster","1971-09-28","","","","132/76","98.00","16","66","210","61","98","2024052447015","Palmas","Palmas","2024-05-24 15:43:03","52 y/o male patient presents to the clinic for evaluation of dog bite wound.","All","Yes","Finish");
INSERT INTO patients_record VALUES("841","2024052436003","","","","","","","","","","","","","","2024052424576","Palmas","Palmas","2024-05-24 17:07:45","","","","");
INSERT INTO patients_record VALUES("842","2024052492159","Brian","OConell","1959-03-26","","","","179/105","98.4","16","76","210","63","98","2024052432452","Palmas","Palmas","2024-05-24 18:37:40","65 y/o male patient presents to the clinic for evaluation of lower back pain. 
Pt indicates 6 day onset of pain in lower middle back after inciting event when picking up a kitchen table.","All","Yes","Finish");
INSERT INTO patients_record VALUES("843","2024052483530","Jillian","Leone","1984-05-04","","","","117/75","97.8","16","75","118","64","97","20240524444","Palmas","Palmas","2024-05-24 18:59:20","40 y/o female patient presents to the clinic for evaluation of lab results and wellness consult. Pt requests refills for meds which are being work with via PR medical director. ","All","Yes","Finish");
INSERT INTO patients_record VALUES("844","2024052446994","Pei ","Hua Cai","1944-01-07","","","","128/72","97.3","15","83","105","49","90","20240524516","Palmas","Palmas","2024-05-24 21:34:59","79 y/o female patient presents to the clinic for signs of unilateral left lower limb edema signs.

Pt indicates 1wk onset of inflammation, pruritus but no associated pain. There is redness on visual examination and swelling. 

Meds: Benazepril (10mg)
NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("845","2024052436514","Luz","Garcia","1980-10-11","","","","97/55","98.6","","78","161","62","97","2024052449281","Humble","Humble","2024-05-24 22:09:58","Pt has pain on URQ and shots pain to back side as well
pt states hurts more when applied pressure 
Pt has this pain for 3 month with UTI symptoms, has taken otc meds for uti
Pt state when she drinks fluids uti goes away but then comes back
Pt had a ct scan 2 yrs ago and found nothing
pt speaks spanish

Allergies; NKDA
Pharmacy; Walgreens 
Address: 6402 Farm to Market 1960 Rd W, Houston, TX 77069
Hours: 
Open ⋅ Closes 11 PM
Pharmacy: Open ⋅ Closes 8 PM · More hours
Phone: (281) 631-9736","All","Yes","Finish");
INSERT INTO patients_record VALUES("846","2024052427154","","","","","","","","","","","","","","202405245762","Palmas","Palmas","2024-05-24 22:26:45","","","","");
INSERT INTO patients_record VALUES("847","2024052522724","tEST","TEST","2024-05-25","","","","0","0","0","0","0","0","0","2024052517529","Castle Hills","Castle Hills","2024-05-25 14:18:21","Happy Saturday!","All","Yes","Finish");
INSERT INTO patients_record VALUES("848","2024052679957","test","test","2024-05-26","","","","0","0","0","0","0","0","0","2024052610282","Castle Hills","Castle Hills","2024-05-26 14:15:39","happy sunday!","All","Yes","Finish");
INSERT INTO patients_record VALUES("849","2024052649897","Test pT","STEPHANNY","2002-11-03","","","","101/58","98.5","20","84","99","","98","2024052614554","Humble","Humble","2024-05-26 14:24:09","Demo 
Pt with bump on rt ear lobe 
nka
no meds 
pharmacy 747 E Crosstimbers Walgreens 7136592427","All","Yes","Finish");
INSERT INTO patients_record VALUES("850","2024052830975","Javier","Ruiz","2021-06-02","","","","","99.0","20","114","36.7","41","99","2024052836074","VAM","VAM","2024-05-28 13:34:33","fever 10 hrs started at midnight 
given Tylenol
sneezing running nose
History of ear infections
Pref. pharm
 Walgreens
1403 CYPRESS CREEK PKWY Houston, TX 77090
281 444-1201","All","Yes","Finish");
INSERT INTO patients_record VALUES("851","2024052833215","Javier","Ruiz","2021-06-02","","","","","","","","","","","2024052835755","VAM","VAM","2024-05-28 14:17:26","","All","","");
INSERT INTO patients_record VALUES("852","2024052879012","1","1","1111-11-11","","","","","","","","","","","2024052832904","VAM","VAM","2024-05-28 14:21:52","1","All","Yes","Finish");
INSERT INTO patients_record VALUES("853","2024052829191","11","1","1111-11-11","","","","120/80","98.6","18","83","","1","98","2024052819603","VAM","VAM","2024-05-28 14:48:19","11","All","Yes","Finish");
INSERT INTO patients_record VALUES("854","2024052851228","","","","","","","","","","","","","","2024052828515","Palmas","Palmas","2024-05-28 14:56:08","","All","","");
INSERT INTO patients_record VALUES("855","2024052851228","","","","","","","","","","","","","","2024052828515","Palmas","Palmas","2024-05-28 15:06:25","","All","","");
INSERT INTO patients_record VALUES("856","2024052859072","Dylan","Neff","1998-03-04","","","","133/84","96.6","18","74","130","60","97","202405284092","Palmas","Palmas","2024-05-28 15:50:42","26 years male patient visit the clinic c/o nauseas, tired, loss appetite, joint pain. Syptoms begin on Friday. 
Allergies: no allergies 
Surgery: no
Medications: no

","All","Yes","Finish");
INSERT INTO patients_record VALUES("857","2024052813630","John","Freeman","","","","","142/90","98.2","18","93","257.1","68","95","2024052810517","VAM","VAM","2024-05-28 17:02:15","patient here with cough, sore throat, congestion for 4 days
nkda
Pref. pharm.
Walgreens
Rayford rd.
 281-298-0040

","All","Yes","Finish");
INSERT INTO patients_record VALUES("858","2024052813630","John","Freeman","","","","","142/90","98.2","18","93","257.1","68","95","2024052810517","VAM","VAM","2024-05-28 17:03:38","patient here with cough, sore throat, congestion for 4 days
nkda
Pref. pharm.
Walgreens
Rayford rd.
 281-298-0040

","All","Yes","Finish");
INSERT INTO patients_record VALUES("859","2024052812094","Katherine","Gray","1981-04-29","","","","107/67","96.4","17","77","130","65","97","2024052823513","Palmas","Palmas","2024-05-28 17:03:46","43 years old female patient came to the clinic c/o  sinus symptoms for around 10 days. she refer not present fever, no joint pain or any other symptoms.
Allergies: no
Medications: no
Patient also  make covid test at home an the result came negative.
Pharmacy: Walgreens Calle Stella (787) 285-0810","All","Yes","Finish");
INSERT INTO patients_record VALUES("860","2024052857518","Jose ","Martinez","1987-06-08","","","","143/101","97.8","20","97","193.6","65","100","2024052810676","VAM","VAM","2024-05-28 20:55:41","patient has currently body aches, no bowel sounds, nauseated before lunch

NKDA
Pref. 
Walgreens
(281) 350-5311","All","Yes","Finish");
INSERT INTO patients_record VALUES("861","2024052826577","Pei Hua","Cai","1944-01-07","","","","112/62","96.7","17","76","108","59","95","2024052840634","Palmas","Palmas","2024-05-28 21:33:03","80 years old female patient came for hospital follow up.","All","Yes","Finish");
INSERT INTO patients_record VALUES("862","2024052938869","Test","Humble","","","","","","","","","","","","2024052934386","Humble","Humble","2024-05-29 13:57:19","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("863","2024052994678","KAREN","CRUITT","1977-02-28","","","","152/92","97.9","22","75","216.1","71","98","2024052937180","VAM","VAM","2024-05-29 14:13:17","pt here for right breast pain one week already pain is not under control
has been taking Advil and Tylenol
NKDA
Walgreens
4849 N HIGHWAY 146 Baytown, TX 77520
 281-420-9827","All","Yes","Finish");
INSERT INTO patients_record VALUES("864","2024052968193","Chad","Thomas","1971-05-07","","","","145/101","97.7","20","80","273.6","71","96","2024052919085","VAM","VAM","2024-05-29 17:30:13","patient phlegm for months the color is clear
NKDA

Pref. Pharma
on file ","All","Yes","Finish");
INSERT INTO patients_record VALUES("865","2024052937932","Mark ","Mathis","1962-03-17","","","","119/73","98.5","18","54","185","70","98","202405295606","Palmas","Palmas","2024-05-29 19:57:38","Back rash since 2 weeks ago. Itching. Cortisone bid not helping.","All","Yes","Finish");
INSERT INTO patients_record VALUES("866","2024053026732","","","","","","","","","","","","","","2024053030430","Palmas","Palmas","2024-05-30 13:57:16","","All","","");
INSERT INTO patients_record VALUES("867","2024053031258","ephraim","garcia","1986-01-07","","","","137/86","98.9","18","76","200","66","97","2024053031690","VAM","VAM","2024-05-30 14:41:59","pt states symptoms began yesterday 
pt states has bodyaches headaches runny nose sneezing heavy fatigue 
pt states has throat itchness
pt states wife is sick at home with a cold
pt states took zyrtec dayquil no relief 


allergies: none 

pharmacy:
Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("868","2024053031258","ephraim","garcia","1986-01-07","","","","137/86","98.9","18","76","200","66","97","2024053031690","VAM","VAM","2024-05-30 14:50:11","pt states symptoms began yesterday 
pt states has bodyaches headaches runny nose sneezing heavy fatigue 
pt states has throat itchness
pt states wife is sick at home with a cold
pt states took zyrtec dayquil no relief 


allergies: none 

pharmacy:
Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("869","2024053066794","ephraim","garcia","","","","","","","","","","","","2024053044456","VAM","VAM","2024-05-30 14:57:34","","All","Yes","Ready");
INSERT INTO patients_record VALUES("870","2024053021628","Richard","Naing","1950-12-22","","","","121/74","95.0","17","75","200","71","97","2024053027954","Palmas","Palmas","2024-05-30 14:59:21","72 years old male patient visit the clinic to discuss about the medication Wegovy.

","All","Yes","Finish");
INSERT INTO patients_record VALUES("871","2024053014091","a","a","2003-12-31","","","","","","","","","","","2024053040128","Castle Hills","Castle Hills","2024-05-30 15:14:48","uri","All","","");
INSERT INTO patients_record VALUES("872","2024053057140","test","test","2024-05-30","","","","0","0","0","0","0","0","0","202405305704","Castle Hills","Castle Hills","2024-05-30 16:58:29","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("873","2024053057140","test","test","2024-05-30","","","","0","0","0","0","0","0","0","202405305704","Castle Hills","Castle Hills","2024-05-30 16:59:45","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("874","2024053072839","JACKSON","WILLIAMS","2015-04-10","","","","101/70","99.1","18","84","78.8","50","98","202405307260","VAM","VAM","2024-05-30 21:32:07","PT STATES THIS MORNING FELT NASUEATED AND COULD NOT EAT OR ANY APPETITE 
PT STATES HAD VOMITTIMG THIS MORNING AND DIARREHEA 
PT STATES HAD TO BE PICKED UP FROM SCHOOL DUE TO SYMPTOMS 
PT STATES NO ONE AT HOME IS SICK 
PT FATHER STATES ATE FROM THE SAME RESTAURANT THE NIGHT BEFORE AND FATHER IS NOT SICK 
PT STATES HAS NOT TAKEN ANYTHING FOR SYMPTOMS BUT DID TAKE CLARITAN FOR ALLERGIES
  ALLERGIES: NONE 

PHARMACY: COSTCO
Phone: (281) 707-7061
Mon-Fri. 10:00am - 7:00pm Sat. 9:30am - 6:00pm Sun. CLOSED","All","Yes","Ready");
INSERT INTO patients_record VALUES("875","2024053034626","JACKSON","WILLIAMS","","","","","","","","","","65","","202405303520","VAM","VAM","2024-05-30 21:53:19","","All","Yes","Finish");
INSERT INTO patients_record VALUES("876","2024053146251","Alec","Falgout","1998-09-24","","","","118/66","","21","60","","","99","2024053125101","Castle Hills","Castle Hills","2024-05-31 14:07:45","lab results","All","Yes","Finish");
INSERT INTO patients_record VALUES("877","2024053177418","andrea","vasquez","1991-12-21","","","","130/86","97.7","18","58","180","66","100","2024053112833","VAM","VAM","2024-05-31 15:35:08","pt states is here for a refill 
pt states has been constant headaches 
pt states woulf like to check thyroid levels  ot see if anything has changed 
pt states is currently on levothyroxine 0.150mg 
pt states today is feeling fine 

allergies: none 
pharmacy
 walgreens Store #7681

Walgreens Pharmacy at 
8505 FM 1960 RD W Humble, TX 77338
Cross streets: Northeast corner of FM 1960 & KENSWICK

Phone : 281-446-4209","All","Yes","Finish");
INSERT INTO patients_record VALUES("878","2024053131929","Leland","Myer","2020-08-01","","","","","97.1","24","103","38","39","98","202405315874","Palmas","Palmas","2024-05-31 15:46:50","3 years old male patient visit the clinic in company of mom, mom bring the kid c/o fell off the couch 2 weeks ago an he cut the bottom of the left foot  with an unspecified item. Patient have a red line in the cut. 

Allergies: no allergies
Medications: No medications at the moment
Pharmacy: Walgreens Calle Stella","All","Yes","Finish");
INSERT INTO patients_record VALUES("879","2024053181879","jose","robles","1987-02-17","","","","145/84","98.6","18","73","245","72","98","2024053144269","VAM","VAM","2024-05-31 16:27:01","hedache congestion ","All","Yes","Ready");
INSERT INTO patients_record VALUES("880","2024053125377","Habacuc","Cardona","1967-04-29","","","","128/77","97.8","16","88","214","68","95","2024053124994","Palmas","Palmas","2024-05-31 16:59:11","57 y/o male patient presents to the clinic for evaluation of URTI signs and symptoms. 
Pt indicates 3 day onset of symptoms of SOB, dry/productive cough, muscle aches and fever, with Ha.

Labs: Flu: negative","All","Yes","Finish");
INSERT INTO patients_record VALUES("881","2024053157099","Judith","Vargas","1976-05-03","","","","122/74","97.7","","67","160","61","96","2024053124122","Humble","Humble","2024-05-31 17:45:52","PT has sore throat for the last 4 days
PT has taken Mucinex/nightquil and Tylenol 
PT states no other house mm is feeling ill
PT has had body chills w/ ear aches, no fever in the last two days

Allergies: NKDA
Pharmacy: Walgreens
Store #3025
Walgreens Pharmacy at 
7440 FM 1960 RD E Humble, TX 77346
Cross streets: LAKE HOUSTON PARKWAY & FM 1960 EAST
Phone : 281-852-8088
","All","Yes","Finish");
INSERT INTO patients_record VALUES("882","2024053196899","Priscilla","Picasso","1977-04-11","","","","147/89","98.2","","82","200","64","95","2024053139919","Humble","Humble","2024-05-31 19:11:28","","All","Yes","Finish");
INSERT INTO patients_record VALUES("883","2024060122347","me","me","2000-01-01","","","","120/80","99.0","","","190","65","","2024060132582","Humble","Humble","2024-06-01 14:05:04","headache","All","Yes","Ready");
INSERT INTO patients_record VALUES("884","2024060191439","George","Skinner","1975-11-28","","","","133/92","98.8","18","67","290","68","98","2024060131039","Humble","Humble","2024-06-01 14:13:04","Right leg pain x 1 week.
OTC Tylenol
Nkda
Walgreens Atascocita Rd","All","Yes","Finish");
INSERT INTO patients_record VALUES("885","2024060157498","John","Smith","2000-01-01","","","","120/80","97.7","16","68","175","65","99","2024060144140","Humble","Humble","2024-06-01 15:37:21","Back pain x 1 month
No meds
Nkda
Kroger on Atascocita","All","Yes","Finish");
INSERT INTO patients_record VALUES("886","2024060130011","TEST","TEST","1989-01-02","","","","","","","","","","","2024060115028","Castle Hills","Castle Hills","2024-06-01 15:49:16","TEST RUN","All","Yes","Finish");
INSERT INTO patients_record VALUES("887","2024060150225","Test Renzo","T","1111-11-11","","","","120/66","98.0","18","60","160","69","98","202406014165","Castle Hills","Castle Hills","2024-06-01 16:47:35","Test","All","","");
INSERT INTO patients_record VALUES("888","2024060184652","1","","","","","","","","","","","","","202406019303","Castle Hills","Castle Hills","2024-06-01 17:14:44","","All","","");
INSERT INTO patients_record VALUES("889","2024060249789","Test","Test","1990-01-01","","","","190/98","98.6","18","80","190","65","","202406021809","Humble","Humble","2024-06-02 14:43:15","High blood pressure","All","Yes","Finish");
INSERT INTO patients_record VALUES("890","2024060225025","TEST","TEST","1989-01-02","","","","","","","","","","","2024060246551","Castle Hills","Castle Hills","2024-06-02 15:03:10","TEST CALL","All","Yes","Finish");
INSERT INTO patients_record VALUES("891","2024060313761","norma","Ruiz","1972-08-24","","","","118/75","98.1","18","74","198","64","99","2024060338299","VAM","VAM","2024-06-03 14:36:32","pt states was picking peaches and next day has puffiness drainage grainy on her left eye 
pt states has a slight itch 
pt states has facial pain and stuffiness to nose 
pt states took sudafed and zyzol 


allergies: iodine, penicillin, aspirin
pharmacy: Store #4133

Walgreens Pharmacy at 
3707 SPENCER HWY Pasadena, TX 77504
Cross streets: BURKE & SPENCER HIGHWAY

Phone : 713-946-4650","All","Yes","Finish");
INSERT INTO patients_record VALUES("892","2024060386861","Test CH","t","","","","","1","1","1","1","1","1","1","2024060347162","Castle Hills","Castle Hills","2024-06-03 14:45:22","Test","All","Yes","Finish");
INSERT INTO patients_record VALUES("893","2024060316718","Test Pedro","t","","","","","","","","","","","","2024060329865","Castle Hills","Castle Hills","2024-06-03 15:10:08","Sore Throat","All","Yes","Finish");
INSERT INTO patients_record VALUES("894","2024060369926","ANDREA","vasquez","1991-12-21","","","","127/85","98.9","18","63","180","66","99","2024060343423","VAM","VAM","2024-06-03 15:33:18","PT IS HERE F/U ON LAST VISIT 
PT IS HERE FOR HER REFILL AND LAB RESULT 
PT STATES OVER THE WEEKEND HAS BEEN EXPERIENCING  LEFT HAND PAIN AND CANNOT GRIP

ALLERGIES: NONE 

PHARMACY: Store #7681

Walgreens Pharmacy at 
8505 FM 1960 RD W Humble, TX 77338
Cross streets: Northeast corner of FM 1960 & KENSWICK

Phone : 281-446-4209","All","Yes","Finish");
INSERT INTO patients_record VALUES("895","2024060340130","","","","","","","","","","","","","","2024060323655","Castle Hills","Castle Hills","2024-06-03 15:56:24","","All","","");
INSERT INTO patients_record VALUES("896","2024060373940","Kyra","Hjelle","1988-04-25","","","","100/67","98.6","19","95","169","56","97","202406036105","Palmas","Palmas","2024-06-03 16:09:44","36 years old female patient visit the clinic c/o symptoms of congestion starting on Saturday and also have mild aches on the body with  light fever.
Pregnant: 26 weeks
Medication: Prenatal vitamins, Prozac 10mg, Benadryl as needed, Unisom as needed.
Allergies: Prednisone
Pharmacy: Walgreens Calle 3","All","Yes","Finish");
INSERT INTO patients_record VALUES("897","2024060378302","Adalverto","Castaneda","1994-12-22","","","","130/95","97.2","","89","257","70","96","2024060321064","Humble","Humble","2024-06-03 16:54:51","Pt has been having stomach issues, w/ nausea, vomiting.
Pt states it started Saturday night but was worse yesterday.
Pt could not get out of bed unless to use restroom, no other mms sick at home
Pt has not been able to hold foods or liquid down besides broth, pts wife is pregnant

Allergies: NKDA

Pharmacy: Address: 
Walgreens
8505 FM 1960, Humble, TX 77338
Hours: 
Open ⋅ Closes 12 AM
Pharmacy: Open ⋅ Closes 1:30 PM ⋅ Reopens 2 PM · More hours
Confirmed by this business 7 weeks ago
Phone: (281) 446-4209 ","All","Yes","Finish");
INSERT INTO patients_record VALUES("898","2024060327702","jerome","smith","1965-01-02","","","","137/99","98.6","18","108","183","65","96","2024060323888","VAM","VAM","2024-06-03 17:48:37","pt states has gone 2 days without bp med 
pt states has been experiencing sever headache 
pt states accompanied with heart burn 
pt states took bc powder  today and aleve and no relief 
 allergies : none 

","All","Yes","Finish");
INSERT INTO patients_record VALUES("899","2024060372344","shirley","pines","1967-08-15","","","","125/76","98.5","18","71","240","66","97","2024060342359","VAM","VAM","2024-06-03 20:09:40","pt states has been having pain in stomach since friday 
pt states has been experiencing diarrhea 
pt states threw up friday and started eating lighter throughout the days 
 allergies: none 


pharmacy: Store #16061

Walgreens Pharmacy at 
14021 STUEBNER AIRLINE RD Houston, TX 77069
Cross streets: Northwest corner of STUEBNER AIRLINE & FM 1960

Phone : 281-440-1604","All","Yes","Finish");
INSERT INTO patients_record VALUES("900","2024060377283","Luz","Garcia","1980-10-11","","","","93/49","99.7","","77","163","63","98","2024060324290","Humble","Humble","2024-06-03 21:06:54","F/u for BW and UA
pt still has pain in RUQ that goes to back","All","Yes","Finish");
INSERT INTO patients_record VALUES("901","2024060310310","jose ","robles","1987-02-17","","","","","","","","245","72","","2024060349223","VAM","VAM","2024-06-03 21:31:52","f/u from last visit states his throat feels better after medication 
 allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("902","2024060426433","test","test","2024-06-04","","","","","","","","","","","202406044448","Castle Hills","Castle Hills","2024-06-04 14:05:08","test tuesday","All","Yes","Finish");
INSERT INTO patients_record VALUES("903","2024060417163","Quang ","Anh Le","2001-12-21","","","","136/91","98.5","18","80","280.2","71","98","2024060414688","VAM","VAM","2024-06-04 14:15:59","pt with shoulder pain 3 days
no medication taken
NKDA
Pref .pharm
Walgreens
6768 HIGHWAY 6 S Houston, TX 77083
281-530-9768","All","Yes","Finish");
INSERT INTO patients_record VALUES("904","2024060454472","Diane","MacDonald","1959-12-31","","","","107/78","97.7","18","70","168","69","97","2024060446638","Palmas","Palmas","2024-06-04 14:29:11","","All","Yes","Finish");
INSERT INTO patients_record VALUES("905","2024060421261","Diane","MacDonald","1959-12-31","","","","","","","","","","","2024060431343","Palmas","Palmas","2024-06-04 15:07:06","","All","Yes","Finish");
INSERT INTO patients_record VALUES("906","2024060459916","diane","macdonald","1959-12-31","","","","","","","","","","","2024060443719","Palmas","Palmas","2024-06-04 15:09:54","","All","Yes","Finish");
INSERT INTO patients_record VALUES("907","2024060416733","Carlos","Hurtado","2018-05-26","","","","","98.1","23","93","47","46","99","2024060442116","Castle Hills","Castle Hills","2024-06-04 15:14:31","facial allergic reaction

NKDA

RX: 210-340-7786
","All","Yes","Finish");
INSERT INTO patients_record VALUES("908","2024060419383","Carlos","Hurtado","","","","","","","","","","","","202406041014","Castle Hills","Castle Hills","2024-06-04 15:41:18","","All","Yes","Finish");
INSERT INTO patients_record VALUES("909","2024060490120","carlos","","","","","","","","","","","","","2024060448470","Castle Hills","Castle Hills","2024-06-04 15:46:19","","All","","");
INSERT INTO patients_record VALUES("910","2024060493148","CH TEST","","","","","","","","","","","","","2024060437608","Castle Hills","Castle Hills","2024-06-04 16:11:09","","All","","");
INSERT INTO patients_record VALUES("911","2024060488759","CH TEST","CH TEST","","","","","","","","","","","","2024060412395","Castle Hills","Castle Hills","2024-06-04 16:11:49","","All","Yes","Finish");
INSERT INTO patients_record VALUES("912","2024060476996","Hugo","Jacobson","2020-03-11","","","","","97.5","21","102","38","42","99","2024060413071","Castle Hills","Castle Hills","2024-06-04 16:14:23","nose injury

RX: CVS 210-764-1095

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("913","2024060443890","Owen","OConnor","2006-11-13","","","","103/60","97.8","15","70","150","65","98","202406041095","Palmas","Palmas","2024-06-04 16:40:17","17 y/o male patient presents to the clinic for evaluation and physical examination. Pt brought in documentation required by school.

PE: Pt looks well and is not in distress. He indicates he feels well.

Allergy: Amoxicillin","All","Yes","Finish");
INSERT INTO patients_record VALUES("914","2024060479753","Alejandro","Garcia","1996-12-16","","","","125/75","97.8","20","82","256.2","69","82","2024060427986","VAM","VAM","2024-06-04 22:55:17","","All","Yes","Finish");
INSERT INTO patients_record VALUES("915","2024060569366","Alexander","Driscoll","2010-10-11","","","","119/64","96.9","15","75","130","65","96","2024060515527","Palmas","Palmas","2024-06-05 13:47:30","  13 y/o male patient presnets to the clinic for evaluation of signs and symptoms of URTI. 
Pt indicates 2-3d onset of symptoms. Pt indicates no HA, no fever, no sweating/chills, no dysphagia or vomit. 

PE: pending","All","Yes","Finish");
INSERT INTO patients_record VALUES("916","2024060576246","TEST","HUMBLE","","","","","","","","","","","","2024060529393","Humble","Humble","2024-06-05 13:52:59","","All","Yes","Finish");
INSERT INTO patients_record VALUES("917","2024060533180","TEST","Humble","","","","","","","","","","","","2024060544545","Humble","Humble","2024-06-05 13:53:46","","All","Yes","Finish");
INSERT INTO patients_record VALUES("918","2024060526382","TEST","Castle Hills","1970-08-16","","","","120/80","98.1","18","78","160","66","98","2024060513282","Castle Hills","Castle Hills","2024-06-05 14:15:40","Left ear pain x 1 day

Allergy : PCN

RX: HEB 210-550-1961","All","Yes","Finish");
INSERT INTO patients_record VALUES("919","2024060590974","Test","Test","2002-08-08","","","","98","98","98","98","98","98","98","2024060526964","Palmas","Palmas","2024-06-05 14:49:03","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("920","2024060571895","Shawn","Hanson","1971-09-11","","","","154/109","98.2","16","70","210","65","95","202406056451","Palmas","Palmas","2024-06-05 15:06:36","52 y/o male pt presents to the clinic for general wellness evaluation and refill of meds. 

HPI: Pt indicates he feels fine and requests general wellness consult. 

PMH: Losartan 50mg, 2nd digit fracture

PE:
Unremarkable signs and symptoms","All","Yes","Finish");
INSERT INTO patients_record VALUES("921","2024060511835","Richard","Pitbladdo","1957-07-23","","","","142/83","98.2","15","55","180","71","96","202406058316","Palmas","Palmas","2024-06-05 17:49:03","66 y/o male patient presents to the clinic for general wellness evaluation consult.

HPI: Unremarkable signs and symptoms. Pt requests longevity consult. 

PMH: Med list uploaded to file, NKDA, skin biopsy for skin cancer. ","All","Yes","Finish");
INSERT INTO patients_record VALUES("922","2024060598519","Stacey","Borkowski","1973-11-13","","","","123/74","97.7","16","80","115","62","97","2024060523095","Palmas","Palmas","2024-06-05 18:59:21","50 y/o female patient presents to the clinic for evaluation of signs and symptoms on conjunctivitis. 

HPI: Pt indicates 1 day onset of redness, pruritus and crusting on right eye. She states mild HA, no fever, no vomit, no nausea,  She states she feels it has migrated to right eye. 

PMH: heart murmur, NKDA
Meds: vitamins, allergy meds, ibuprophen as needed
","All","Yes","Finish");
INSERT INTO patients_record VALUES("923","2024060598496","","","","","","","","","","","","","","2024060513358","Palmas","Palmas","2024-06-05 19:14:26","","","","");
INSERT INTO patients_record VALUES("924","2024060636721","Celeste","Jones","1976-07-18","","","","128/90","96.9","16","74","220","65","96","2024060631387","Palmas","Palmas","2024-06-06 14:03:47","47 y/o female patient presents to the clinic for evaluation of BP measurements and consult of minor knee injury.

HPI: Pt indicates she has been feeling stable and no remarkable changes in BP readings. She also states she las been feeling left lower limb pain, specially in the posterior calf area.

PE: Pt feels pain on point palpation on posterior calf. ","All","Yes","Finish");
INSERT INTO patients_record VALUES("925","2024060610288","test","test","2002-02-02","","","","","","","","","","","202406062317","Palmas","Palmas","2024-06-06 14:49:37","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("926","2024060636738","Thursday ","Test","2024-06-06","","","","","","","","","","","20240606338","Castle Hills","Castle Hills","2024-06-06 15:01:51","Test.","All","Yes","Finish");
INSERT INTO patients_record VALUES("927","2024060612786","Alexandra","Ortiz","1981-08-04","","","","123/83","97.5","22","72","170","62","93","2024060626774","Castle Hills","Castle Hills","2024-06-06 15:24:07","wellness check, poss. High BP

Walgreens 210-434-5566

Allergies: Morphine","All","Yes","Finish");
INSERT INTO patients_record VALUES("928","2024060660625","tEST","HUMBLE","","","","","","","","","","","","2024060644671","Humble","Humble","2024-06-06 17:13:33","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("929","2024060626359","BRYCE","SAVAGE","2000-01-27","","","","129/99","99.1","18","103","265","68","98","2024060616713","VAM","VAM","2024-06-06 20:24:36","PT STATES IS HERE FOR A MED REFILL
TERBINAFINE 250 MG
PT STATES HAS A FU WITH TINA ON THE 18TH OF JUNE TO CHECK A1C
PT STATES IS TAKING METFORMIN SINCE JANUARY AND HAS LOST 20 POUNDS SO FAR
PT WILL DO A BLOODDRAW TODAY FOR UPCOMING APPT

ALLERGIES: NONE 

PHARMACY: WALGREENS 2814461006","All","Yes","Finish");
INSERT INTO patients_record VALUES("930","2024060710024","","","","","","","","","","","","","","2024060716014","Palmas","Palmas","2024-06-07 17:54:22","","All","","");
INSERT INTO patients_record VALUES("931","2024060837402","Test 1 ","Test 1 ","2010-02-20","","","","130/80","98.6","16","80","190","65","99","2024060842670","Humble","Humble","2024-06-08 15:56:24","skin rash X 2 days 
no daily meds 
NKA
Pharmacy - Kroger on Atascocita ","All","Yes","Finish");
INSERT INTO patients_record VALUES("932","2024060880104","Saturday Test","Test","2024-06-08","","","","","","","","","","","20240608167","Castle Hills","Castle Hills","2024-06-08 15:57:21","Test","All","Yes","Finish");
INSERT INTO patients_record VALUES("933","2024060854045","test","test","2010-02-02","","","","120/80","97.7","18","67","190","63","100","2024060818672","Humble","Humble","2024-06-08 16:02:44","Skin rash X 2 days 
KNA
Pharmacy - Kroger on Atascocita
No daily meds  ","All","Yes","Finish");
INSERT INTO patients_record VALUES("934","2024060854045","test","test","2010-02-02","","","","120/80","97.7","18","67","190","63","100","2024060818672","Humble","Humble","2024-06-08 16:02:53","Skin rash X 2 days 
KNA
Pharmacy - Kroger on Atascocita
No daily meds  ","All","Yes","Finish");
INSERT INTO patients_record VALUES("935","2024060881537","","","","","","","","","","","","","","2024060837078","Humble","Humble","2024-06-08 18:06:10","","","","");
INSERT INTO patients_record VALUES("936","2024061018121","TEST","TEST","","","","","","","","","","","","2024061012217","Castle Hills","Castle Hills","2024-06-10 14:53:05","test run","All","Yes","Finish");
INSERT INTO patients_record VALUES("937","2024061018121","TEST","TEST","","","","","","","","","","","","2024061012217","Castle Hills","Castle Hills","2024-06-10 14:53:17","test run","All","Yes","Finish");
INSERT INTO patients_record VALUES("938","2024061045078","TEST 1","TEST","","","","","","","","","","","","2024061022218","Castle Hills","Castle Hills","2024-06-10 15:02:51","TEST 1","All","Yes","Finish");
INSERT INTO patients_record VALUES("939","2024061044101","Test1","Test1","1977-12-13","","","","110/69","98.1","18","60","160","69","99","2024061014364","Reza","Palmas Del Mar","2024-06-10 15:38:35","Sore throat

NKDA

Rx:  Walmart 210-330-3333","All","Yes","Ready");
INSERT INTO patients_record VALUES("940","2024061086627","TEST ","2","1989-01-02","","","","120/80","98.5","","","156","61","","2024061022121","Castle Hills","Castle Hills","2024-06-10 15:50:17","TEST 2 
MONDAY JUNE 10TH","All","Yes","Ready");
INSERT INTO patients_record VALUES("941","2024061082339","Carroll","Kelly","1951-12-01","","","","146/88","97.1","16","89","268","64","97","2024061036810","Palmas","Palmas","2024-06-10 18:45:56","CC: Pt presents to the clinic for general evaluation. Pt indicates 1d onset episode of unsteady gait. Pt also indicates she is notices signs and symptoms of constant HA with chronic sinus.

PMH: Vit D labs on RXNT ","All","Yes","Finish");
INSERT INTO patients_record VALUES("942","2024061152444","Colby","Sebastian","1987-11-04","","","","147/99","99.1","20","94","201.8","72","97","2024061134555","VAM","VAM","2024-06-11 13:36:22","patient needs refill on inhaler

Pharm.
HEB
281 353-2420","All","Yes","Finish");
INSERT INTO patients_record VALUES("943","2024061168230","Zoey","Borkowski","2005-05-26","","","","142/73","97.1","18","70","171","62","97","2024061146474","Palmas","Palmas","2024-06-11 16:29:52","CC: 18 y/o female patient presents to the clinic for general evaluation and refill of meds.

PMH: N/A

PE: Unremarkable signs and symptoms","All","Yes","Finish");
INSERT INTO patients_record VALUES("944","2024061136309","Carl ","White","1956-06-18","","","","128/87","98.0","18","94","177.9","68","96","202406118197","VAM","VAM","2024-06-11 16:46:44","pt here for wellness labs","All","Yes","Ready");
INSERT INTO patients_record VALUES("945","2024061127078","test","test","1989-08-18","","","","","","","","","","","2024061132773","Palmas","Palmas","2024-06-11 22:14:57","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("946","2024061216277","TEST","Castle Hills","","","","","120/80","98.0","18","78","160","66","98","2024061221319","Castle Hills","Castle Hills","2024-06-12 13:50:07","Cough x 2 days 

Allergy: NKDA

RX: HEB 210-550-1961","All","","");
INSERT INTO patients_record VALUES("947","2024061254491","Carl ","White","1956-06-18","","","","128/87","98.0","18","95","177.2","68","96","2024061224735","VAM","VAM","2024-06-12 14:18:11","pt here for wellness labs","All","Yes","Finish");
INSERT INTO patients_record VALUES("948","2024061227948","Misael","Sanchez","1978-12-19","","","","125/89","98.6","18","84","179.6","65","95","2024061212218","VAM","VAM","2024-06-12 15:20:40","Patient is here coughing and  no phlegm body aches for 3 days
Has taken Tylenol over the counter cough medicine and Zertec
NKDA
Pharmacy:
Walgreens
244 24 Tomball tollway n
Tomball Tx 77375
281 290-0537
","All","Yes","Finish");
INSERT INTO patients_record VALUES("949","2024061263193","v","","","","","","120/80","98.6","18","83","205","65","98","2024061223264","VAM","VAM","2024-06-12 16:05:24","gg","All","","");
INSERT INTO patients_record VALUES("950","2024061263193","v","","","","","","120/80","98.6","18","83","205","65","98","2024061223264","VAM","VAM","2024-06-12 16:05:32","gg","All","","");
INSERT INTO patients_record VALUES("951","2024061270839","Dwayne","Smith","1960-03-23","","","","167.86","98.4","18","76","364.6","76","96","202406122951","VAM","VAM","2024-06-12 16:06:54"," Right shoulder top of arm pain, right leg pain. Pt states of falling a home at home when moving a box yesterday 6/11/2024. Patient has taken Advil.

Allergic to Codeine 

Pref Pharmacy
GR Cure Pharmacy
108 N Main st
Dayton Tx 77535
936 681-8335","All","Yes","Finish");
INSERT INTO patients_record VALUES("952","2024061249533","Reyna","Castro","1999-10-11","","","","130/98","100.2","","130","235","63","96","2024061227965","Humble","Humble","2024-06-12 17:04:20","pt has flu like symptoms 
pts has body aches, headaches, nauseas
pt has pressure on hip area, pain from the waist down
pt took ibuprofen this morning and had a temp of 99.8 
pt works at a school
pt has 8 mo old at home w/ slight dry cough

Allergies: 
penicillin
amoxicillin

Pharmacy: 
Store #3717
Walgreens Pharmacy at 
4841 MOUNT HOUSTON RD Houston, TX 77093
Cross streets: HIGHWAY 59 & MOUNT HOUSTON
Phone : 281-442-6392     ","All","Yes","Finish");
INSERT INTO patients_record VALUES("953","2024061227592","Andrea","Bryant","1976-09-29","","","","111/70","97.9","18","60","188.5","65","95","2024061235867","VAM","VAM","2024-06-12 19:37:59","pt here for rash on arms
no medication taken
NKDA
Pref. Pharmacy
Walgreens
1802 W Mt Houston Rd, Houston, TX 77038
281 925-2740","All","Yes","Finish");
INSERT INTO patients_record VALUES("954","2024061294491","Jason","Pierson","1978-08-18","","","","125/83","98.2","18","65","252.2","74","97","2024061224280","VAM","VAM","2024-06-12 20:05:38","Pt ear ache for 4 days

NKDA

Pref Pharmacy
Walgreens
560 RAYFORD RD Spring, TX 77386
281-298-0040","All","Yes","Finish");
INSERT INTO patients_record VALUES("955","2024061272706","Isai ","Estrada","1988-04-24","","","","144/85","99.1","18","85","222.7","99.1","96","2024061248538","VAM","VAM","2024-06-12 21:02:57","pt here for medication refill (Sertraline 50mg)
NKDA
Pref Pharm
Walgreens 
2240 NORTHPARK DR Kingwood, TX 77339
281-358-5458
","All","Yes","Finish");
INSERT INTO patients_record VALUES("956","2024061315343","test","test","1989-09-19","","","","","","","","","","","2024061328730","Palmas","Palmas","2024-06-13 13:51:26","test","All","","");
INSERT INTO patients_record VALUES("957","2024061359712","test","humble","","","","","","","","","","","","2024061340308","Humble","Humble","2024-06-13 13:53:28","","All","Yes","Finish");
INSERT INTO patients_record VALUES("958","2024061384884","Thursday","Test","2024-06-13","","","","0","0","0","0","0","0","0","2024061311452","Castle Hills","Castle Hills","2024-06-13 14:18:08","Happy Thursday!","All","Yes","Finish");
INSERT INTO patients_record VALUES("959","2024061316093","ANDREA","VASQUEZ","1991-12-21","","","","131/89","98.9","18","60","180","66","99","2024061331127","VAM","VAM","2024-06-13 15:34:34","PT IS HERE TO DISCUSS BLOODWORK
PT STATES HANDS ARE NOT STIFF ANYMORE STATES DOES GET TINGLING SENSATION


ALLERGIES: NONE ","All","Yes","Finish");
INSERT INTO patients_record VALUES("960","2024061354420","ALISIA","LAPERUTA","1997-07-07","","","","121/76","99.0","18","78","150","67","99","2024061324287","VAM","VAM","2024-06-13 15:54:49","PT STATES  HER DAUGHTER HAS STREP 
PT STATES HER THROAT IS HURTING AND WILL LIKE TO CHECK FOR STREP
PT STATES HAS SLIGHT DIARREHEA 


ALLERGIES: NONE 
PHARMACY: WALMART 936-760-2112","All","Yes","Finish");
INSERT INTO patients_record VALUES("961","2024061366614","Adrianna","Sustaita","1992-08-23","","","","105/79","97.3","18","57","180","69","97","2024061371","Castle Hills","Castle Hills","2024-06-13 17:04:50","ear pain.

Rx: HEB  210-341-3875

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("962","2024061381878","Adriana","S","1992-08-23","","","","","","","","","","","2024061323655","Castle Hills","Castle Hills","2024-06-13 18:18:51","","All","Yes","Finish");
INSERT INTO patients_record VALUES("963","2024061362298","DALY","DALY","1977-05-12","","","","136/86","98.9","18","72","194","72","97","202406131761","VAM","VAM","2024-06-13 22:33:15","PT STATES HAS BEEN EXPERIENCING SYMPTOMS SINCE YESTERDAY 
PT STATES HAS DIFICULTY SWALLOWING 
BODYACHES HEADACHES HURST TO SWALLOW AND HEAVY FATIGUE
PT STATES WAS OUT OF TOWN WITH ALOT OF PEOPLE 


ALLERGIES: NONE 
PHARMACY: WALGREENS 
Store #5423

Walgreens Pharmacy at 
1413 WIRT RD Houston, TX 77055
Cross streets: Northwest corner of WIRT & WESTVIEW

Phone : 713-467-4585","All","Yes","Finish");
INSERT INTO patients_record VALUES("964","2024061317417","casey","cottier","1988-03-10","","","","101/53","99.8","","78","105","63","97","2024061343755","Humble","Humble","2024-06-13 22:55:06","pt came in for a pregnancy test, pt has PCOS
pt states husband had a vasectomy back in November of 2020
pt lmp was 04/29/24 and none since","All","Yes","Finish");
INSERT INTO patients_record VALUES("965","2024061473198","RenzoTest","Test","1977-12-13","","","","110/69","101.2","18","115","160","69","99","2024061413755","Reza","Palmas Del Mar","2024-06-14 13:07:16","Sore Throat x 4 days

NKDA

Rx:  Walmart 210-333-4455","All","Yes","Finish");
INSERT INTO patients_record VALUES("966","2024061473873","test","test","1989-09-19","","","","","","","","","","","2024061429051","Palmas","Palmas","2024-06-14 13:52:06","test","All","","");
INSERT INTO patients_record VALUES("967","2024061421410","edgar","vasquez","1993-02-19","","","","122/76","98.9","18","68","247","72","96","2024061419524","VAM","VAM","2024-06-14 14:08:24","pt states is here for a wellness exam
pt states last visit his cholesterol was high and 1 point away from pre diabetes
pt states provider told him to come back 6 months later and retest while he practiced dieting and eating better 
pt states he feels good today no symptom
pt states has been suffering from discoloration under his arms 
pt states was given a cream but no did not give patient any relief 

allegies: none 
pharmacy:  Store #7681

Walgreens Pharmacy at 
8505 FM 1960 RD W Humble, TX 77338
Cross streets: Northeast corner of FM 1960 & KENSWICK

Phone : 281-446-4209","All","Yes","Finish");
INSERT INTO patients_record VALUES("968","2024061485247","Biffrey","Braxton","1978-08-02","","","","118/79","97.8","15","61","171","71","97","2024061410591","Palmas","Palmas","2024-06-14 14:28:54","45 by/o male pt presents to the clinic for evaluation and follow up of general wellness.

HPI: Pt is feeling well and indicates 

PE: Unremarkable initial visual signs","All","Yes","Finish");
INSERT INTO patients_record VALUES("969","2024061493061","ALISIA","LAPERUTA","1997-07-07","","","","113/87","100.3","18","107","150","66","99","2024061419208","VAM","VAM","2024-06-14 15:00:04","pt is here was diagnosed with strep yesterday
pt states is throwing up and having bodyaches 
pt states would like something given for the nausea and vomiting
pt was given antibiotics and is taking them as directed 


allegies; none 
pharmacy: walmart 
Mon - Sat | 9am - 7pm
Sun | 10am - 6pm
Refill a Prescription

Collapse Pharmacy
936-760-2112","All","Yes","Finish");
INSERT INTO patients_record VALUES("970","2024061426939","CARL","WHITE","1956-06-18","","","","","","","","175","68","","2024061422595","VAM","VAM","2024-06-14 16:03:21","PT IS HERE TO DISCUSS BLOODWORK

ALLERGIES: NONE ","All","Yes","Finish");
INSERT INTO patients_record VALUES("971","2024061437712","ivan","chacon","1993-07-03","","","","160/91","99.2","18","80","225","66","96","2024061410882","VAM","VAM","2024-06-14 18:23:05","pt is here for a refill on Lisinopril 
pt states he has not taken any today due to running out
pt is taking lisinopril 20 mg 
atorvastatin 20mg 

allergies: none 
pharmacy: HEB Pharmacy
Pharmacy Phone:
(713) 522-2100
Mon-Fri
8:00 AM - 8:00 PM
Sat
9:00 AM - 6:00 PM
Sun
10:00 AM - 5:00 PM
Drive Thru","All","Yes","Finish");
INSERT INTO patients_record VALUES("972","2024061541102","George ","Skinner ","1975-11-28","","","","132/85","98.8","18","64","290","68","98","2024061536819","Humble","Humble","2024-06-15 14:03:07","Pt c/o of knee pain on the right side. 
Pt states it helped with prescribed Prednisone given  for 7 days.
KNA 
Fasting 
Pharmacy Walgreens Atascocita 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("973","2024061541102","George ","Skinner ","1975-11-28","","","","132/85","98.8","18","64","290","68","98","2024061536819","Humble","Humble","2024-06-15 14:03:29","Pt c/o of knee pain on the right side. 
Pt states it helped with prescribed Prednisone given  for 7 days.
KNA 
Fasting 
Pharmacy Walgreens Atascocita 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("974","2024061566252","Brett","MARVEL","","","","","120/80","98.6","","","190","63","","2024061511812","Humble","Humble","2024-06-15 18:29:26","sore throat","All","","");
INSERT INTO patients_record VALUES("975","2024061510909","","","","","","","","","","","","","","202406153038","Humble","Humble","2024-06-15 18:30:40","","All","","");
INSERT INTO patients_record VALUES("976","2024061586062","","","","","","","","97.7","","","160","65","","2024061540563","Humble","Humble","2024-06-15 18:36:34","sore throat x 3 days, no fever, sick kid at home","All","","");
INSERT INTO patients_record VALUES("977","2024061644644","Desaree ","Rantala","1990-05-13","","","","115/67","98.4","18","76","151.8","60","99","2024061633458","Humble","Humble","2024-06-16 15:11:28","Lower abdominal pain for 1 day and pain after urinating 
No daily medications 
KNA
Pharmacy Walgreens 2818528088 ","All","Yes","Finish");
INSERT INTO patients_record VALUES("978","2024061745676","","","","","","","","","","","","","","2024061723556","Palmas","Palmas","2024-06-17 13:39:37","","","","");
INSERT INTO patients_record VALUES("979","2024061743776","edgar","vasquez","1993-02-19","","","","127/98","98.7","18","68","247","72","98","2024061718634","VAM","VAM","2024-06-17 14:08:44","pt is here to discuss bloodwork 
pt states has no symptoms today ","All","Yes","Finish");
INSERT INTO patients_record VALUES("980","2024061752903","james","lester","1963-08-20","","","","139/88","98.3","18","62","176.6","69","97","2024061740106","VAM","VAM","2024-06-17 15:11:48","","All","Yes","Finish");
INSERT INTO patients_record VALUES("981","2024061712848","aron","westmoreland","1978-07-05","","","","175/108","98.8","18","72","185","70","95","2024061739792","VAM","VAM","2024-06-17 15:41:13","pt states was taking out the trash last night and feel down the stairs
pt states has a wound in the middle of pinky and fell on left elbow
pt states is giving him pain 
pt states pain is a 7/10 pain 
pt states has not recieved a tetanus shot in over 20 yrs


allergies: none 

pharmacy:Mon-Sun

6:00 AM - 11:00 PM

Store Phone:

(713) 529-2475

Pharmacy Phone:

(713) 807-7293

Street map of this store
1701 WEST ALABAMA ST
HOUSTON, TX 77098-2807","All","Yes","Finish");
INSERT INTO patients_record VALUES("982","2024061738653","paul","cottier","","","","","","","","","","","","2024061734091","VAM","VAM","2024-06-17 18:21:57","","All","Yes","Finish");
INSERT INTO patients_record VALUES("983","2024061712196","luisana","rodriguez","1997-02-04","","","","113/71","98.7","18","81","184.6","61","98","2024061749832","VAM","VAM","2024-06-17 18:26:51","pt states was exposed to covid 
pt states is having warm dizzy and feels flushed 


allergies: none 
pharmacy: Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("984","2024061780353","Melia","Nordet","2016-09-08","","","","100/60","97.7","16","92","49","46","97","2024061725445","Palmas","Palmas","2024-06-17 19:48:50","CC: 7 y/o female pt presents to the clinic for general wellness evaluation for physical exam forms as well as evaluation of minor skin lesions.

HPI: Pt presents to the clinic with mother and sister, is feeling well and shows no remarkable URTI signs or symtoms.

PE: Pt arrived to clinic from summer camp in TPA, out in the sun for the day. ","All","Yes","Finish");
INSERT INTO patients_record VALUES("985","2024061715175","Sophia","Nordet","2013-12-22","","","","100/60","97.7","16","92","49","46","97","2024061737440","Palmas","Palmas","2024-06-17 20:37:13","9 y/o female pt presents to the clinic with her mother for evaluation of physical examination forms for upcoming schoolyear.

HPI: Pt indicates no remarkable signs and symptoms 

PE: Unremarkable initial visual signs","All","Yes","Finish");
INSERT INTO patients_record VALUES("986","2024061749520","kelli","scott","1990-02-18","","","","124/80","97.5","18","83","125","67","98","2024061726007","VAM","VAM","2024-06-17 21:33:57","pt is here for a refill on meds 
pt states only has 2 left 
pt needs refill on sertraline 100mg 


allergies: none","All","Yes","Finish");
INSERT INTO patients_record VALUES("987","2024061870628","test","Test","1999-09-09","","","","","","","","","","","202406182787","Palmas","Palmas","2024-06-18 13:48:27","test","All","","");
INSERT INTO patients_record VALUES("988","2024061881322","test","HUMBLE","","","","","","","","","","","","2024061835804","Humble","Humble","2024-06-18 13:57:08","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("989","2024061818972","tuesday","test","2024-06-18","","","","","","","","","","","2024061823927","Castle Hills","Castle Hills","2024-06-18 13:58:39","tuesday test","All","Yes","Finish");
INSERT INTO patients_record VALUES("990","2024061852868","","","","","","","","","","","","","","20240618301","Castle Hills","Castle Hills","2024-06-18 14:02:56","","","","");
INSERT INTO patients_record VALUES("991","2024061843999","Test","TEST","2024-06-18","","","","","","","","","","","2024061830444","Castle Hills","Castle Hills","2024-06-18 14:43:50","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("992","2024061841404","luisana","rodriguez","1997-02-04","","","","112/70","98.6","18","81","184","61","98","2024061841340","VAM","VAM","2024-06-18 14:55:22","pt is here to retest 
pt states feels better today no complaints 


allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("993","2024061869217","GRAHAM","NEIHEISEL","2017-08-16","","","","95/61","97.8","18","109","42.8","44","98","2024061842777","VAM","VAM","2024-06-18 17:01:35","PT STATES IS HAVING BEEN EXPERIENCING CONSISTANT COUGH 
PT STATES HAS TRIED OVER THE COUNTER AND NO RELIEF 
PT STATES COUGH IS WET WITH YELLOW MUCUS

ALLERGIES: NONE 
PHARMACY: 
Store #15638

Walgreens Pharmacy at 
26288 KUYKENDAHL RD Tomball, TX 77375
Cross streets: Southwest corner of KUYKENDAHL & NEW HARMONY

Phone : 281-378-2995","All","Yes","Finish");
INSERT INTO patients_record VALUES("994","2024061867349","cong","tran","1963-04-24","","","","145/98","99.1","18","82","130","65","99","2024061815132","VAM","VAM","2024-06-18 18:32:06","pt is having swelling to the left eye 
pt states has no pain just swelling 
pt states 3 weeks ago he lit a candle at ight and caught on fire while sleep and woke up to smoke and started coughing/ next day mucus was blk
pt states eye swelling has never happened 


allergies; none 
pharmacy:Store #7671

Walgreens Pharmacy at 
24424 STATE HIGHWAY 249 Tomball, TX 77375
Cross streets: Northeast corner of SH 249 & NORTH POINTE

Phone : 281-290-0537","All","Yes","Finish");
INSERT INTO patients_record VALUES("995","2024061847110","BRYCE","SAVAGE","2000-01-27","","","","133/77","98.8","18","96","269","68","98","202406189422","VAM","VAM","2024-06-18 20:46:51","pt states is here for lab results 
pt states has a cough since started the medication 
pt states has been stressed some days due to purchasing a house 

allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("996","2024061974535","Emily ","Owens","1990-05-10","","","","110/62","97.9","18","80","334.2","69","97","2024061911256","VAM","VAM","2024-06-19 14:51:04","patient is here for refill","All","Yes","Finish");
INSERT INTO patients_record VALUES("997","2024061913138","Monzert","Cuevas","2019-07-27","","","","109/70","97.8","22","108","50.7","45","99","2024061911098","VAM","VAM","2024-06-19 15:22:56","pt here for pink eye on right side for 2 days mom applied TOBRAMYCIN and DEXAMETHASOME OPHTHALMIC SUSPENSION THAT was expired 2022.
NKDA

pharmacy
CVS
1325 FM 1960 ROAD WEST, HOUSTON, TX 77090
1281 444-4582
","All","Yes","Finish");
INSERT INTO patients_record VALUES("998","2024061962846","TEST","Castle Hills","1970-08-16","","","","120/80","98.0","18","78","160","66","98","2024061916087","Castle Hills","Castle Hills","2024-06-19 15:44:28","Cough x 2 days

NKDA

RX: HEB 210-550-1961","All","Yes","Finish");
INSERT INTO patients_record VALUES("999","2024061967603","Chris","Guerrero","1982-09-03","","","","96/58","95.4","","68","169","69","98","2024061916100","Humble","Humble","2024-06-19 19:31:10","Pt came in with a a laceration on right hand index finger","All","Yes","Finish");
INSERT INTO patients_record VALUES("1000","2024061935235","Alejandro","Garcia","1996-12-16","","","","120/80","99.0","20","85","250","69","97","2024061946962","VAM","VAM","2024-06-19 19:59:21","Patient with COVID symptoms weakness, bone ache, congestion, sneezing, runny nose, sore throat  for 3 days.

Allergic to PCN

Preferred Pharmacy
HEB
2121 Farm to Market 2920, Spring, TX 77388
281 907-7950","All","Yes","Finish");
INSERT INTO patients_record VALUES("1001","2024061917725","Katie","Kniess","1987-03-10","","","","126/76","98.4","18","90","141.5","68","98","2024061930790","VAM","VAM","2024-06-19 21:16:03","patient here for pregnancy test
LMP 05/10/2024

Pref Pharm 
Krogers

18518 Kuykendahl
Spring Texas 77379
281 350-3630","All","Yes","Finish");
INSERT INTO patients_record VALUES("1002","2024062017089","test","humble","","","","","","","","","","","","2024062018567","Humble","Humble","2024-06-20 14:41:18","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("1003","2024062012725","","","","","","","","","","","","","","2024062027535","Palmas","Palmas","2024-06-20 15:09:30","","All","","");
INSERT INTO patients_record VALUES("1004","2024062071058","Test","test","1999-10-03","","","","100/60","98.2","18","60","160","65","98","202406206091","Palmas","Palmas","2024-06-20 15:10:17","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1005","2024062046998","Test","test","1999-10-10","","","","110/80","98.2","16","70","210","65","97","2024062034730","Palmas","Palmas","2024-06-20 15:14:11","jukjuil","All","Yes","Finish");
INSERT INTO patients_record VALUES("1006","2024062099623","Gabriela ","Leal","1993-12-01","","","","115/73","96.3","","99","172.2","66","69","2024062049283","Castle Hills","Castle Hills","2024-06-20 15:34:56","cough 
sore throat
ear ache
possible uti

Pharmacy: HEB 8503 NW Military Hwy78231","All","Yes","Finish");
INSERT INTO patients_record VALUES("1007","2024062095116","Alejandro","Garcia","1996-12-16","","","","148/82","98.6","18","83","252","69","98","2024062037234","VAM","VAM","2024-06-20 21:54:35","PT STATES WENT ON A CRUISE LAST WEEK FROM SUNDAY TO SUNDAY 
PT STATES SYMPTOMS BEGAN SUNDAY WITH SORETHROAT 
PT STATES PAIN WHEN COUGHS
PT STATES HAD BODYACHES HEADACHES FEELING WINDED 
PT STATES HAS CONGESTION AND RUNNY NOSE 
PT EARS FEEL MUFFLED 
PT STATES ALSO WANTS A PRESCRIPTION ON LEXAPRO DUE TO LAST PRESCRIPTION EXPIRED 


ALLERGIES; NONE 

PHARMACY: HEB Pharmacy
Pharmacy Phone:
(281) 907-7950
Mon-Fri
8:00 AM - 8:00 PM
Sat
9:00 AM - 6:00 PM
Sun
10:00 AM - 5:00 PM","All","Yes","Finish");
INSERT INTO patients_record VALUES("1008","2024062076309","test","hmble","","","","","","","","","","","","2024062013818","Humble","Humble","2024-06-20 22:31:03","","All","Yes","Ready");
INSERT INTO patients_record VALUES("1009","2024062116176","luisana","rodriguez","1997-02-04","","","","111/73","99.2","73","69","184","61","98","2024062111378","VAM","VAM","2024-06-21 15:04:46","pt is here to discuss results 



allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1010","2024062171458","","","","","","","","","","","","","","2024062128407","Palmas","Palmas","2024-06-21 20:15:48","","All","","");
INSERT INTO patients_record VALUES("1011","2024062149052","Marilyn ","Daily","1961-02-18","","","","127/76","97.8","18","81","160","64","97","2024062138855","Palmas","Palmas","2024-06-21 20:18:50"," Left arm Cat bite yesterday  5:30 pm 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1012","2024062216118","","","","","","","","","","","","","","2024062223942","Reza","Palmas Del Mar","2024-06-22 15:06:20","","All","","");
INSERT INTO patients_record VALUES("1013","2024062216579","Saturday","Test","2024-06-22","","","","","","","","","","","2024062211867","Castle Hills","Castle Hills","2024-06-22 15:09:40","Happy Saturday!","All","Yes","Ready");
INSERT INTO patients_record VALUES("1014","2024062270140","Test","Saturday","2024-06-22","","","","","","","","","","","2024062248619","Castle Hills","Castle Hills","2024-06-22 15:54:07","Saturday Test","All","Yes","Finish");
INSERT INTO patients_record VALUES("1015","2024062296930","Monique ","Lucas ","1987-11-15","","","","108/63","98.5","16","69","278","66","97","20240622555","Humble","Humble","2024-06-22 16:28:52","Physical Exam ( Adult )
Visual Accuity 20/20 bilateral
Not Known Allergies
Medication: Methimazole 5 mg ( Daily )


","All","Yes","Finish");
INSERT INTO patients_record VALUES("1016","2024062298622","Sydney","Hacholski","2005-04-07","","","","124/77","97.2","19","87","200","64","99","2024062210138","Castle Hills","Castle Hills","2024-06-22 17:00:03","blood draw, UA

HEB 210-340-7786

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1017","2024062295952","Test","Test","9999-01-01","","","","141/85","98.3","18","80","175","72","99","2024062216390","Humble","Humble","2024-06-22 17:53:22","Headaches ( 10 Days )
Pain in Ear ( Left Side )
Vitamin D, Iron Pills
NKA 
HEB Kingwood TX 77339
123456789","All","Yes","Ready");
INSERT INTO patients_record VALUES("1018","2024062220964","test","test","","","","","","","","","","","","2024062246499","Humble","Humble","2024-06-22 18:11:22","","All","","");
INSERT INTO patients_record VALUES("1019","2024062392000","TEST","Test","1980-12-15","","","","130/80","98.6","18","67","200","72","98","202406234957","Humble","Humble","2024-06-23 14:27:25","NKA
Cough
Fever
Chills
Krogers In Porter, TX","All","","");
INSERT INTO patients_record VALUES("1020","2024062353993","Sunday","Test","2024-06-23","","","","","","","","","","","202406239304","Castle Hills","Castle Hills","2024-06-23 14:59:19","Happy Sunday","All","Yes","Finish");
INSERT INTO patients_record VALUES("1021","2024062454065","Paula ","Chandler","1964-01-28","","","","159/80","98.5","","91","199","69","95","202406247231","Castle Hills","Castle Hills","2024-06-24 14:05:21","Fatigue and palpation

Pharmacy: 8503 NW Military Hwy","All","Yes","Finish");
INSERT INTO patients_record VALUES("1022","2024062414085","porfiria","cerda","1970-07-04","","","","139/89","97.7","18","83","175","60","98","2024062412722","VAM","VAM","2024-06-24 14:10:27","pt states has redness to her right eye
pt states has no itchy or pain 
pt states has gotten extensions 
pt states has some stuffiness to nose 
 pt states also will need a refill on metformin
pt states stopped taking it in march of this year
pt states has broken in a rash on arms back chest 

allergies: penicillin (rash)
pharmacy: Store #2428

Walgreens Pharmacy at 
2717 FM 1960 RD Houston, TX 77073
Cross streets: Northeast corner of TREASCHWIG & FM 1960

Phone : 281-443-2591","All","Yes","Finish");
INSERT INTO patients_record VALUES("1023","2024062494590","BRAD","HULL","1985-12-18","","","","124/74","98.7","18","68","184","72","98","2024062419628","VAM","VAM","2024-06-24 15:58:27","PT STATES HAS REDNESS TO RT EYE
PT STATES APPEARED SAT MORNING 
PT STATES SON WAS DIAGNOSED WITH PINK EYE
PT STATES HAS ITCHNESS TO RT EYE 
PT STATES HAS BEEN USING SOLUTION OITMENT THAT WAS PRESCRIBED TO SON 


ALLERGIES; NONE 
PHARMACY: Store #15638

Walgreens Pharmacy at 
26288 KUYKENDAHL RD Tomball, TX 77375
Cross streets: Southwest corner of KUYKENDAHL & NEW HARMONY

Phone : 281-378-2995","All","Yes","Finish");
INSERT INTO patients_record VALUES("1024","2024062471164","JOSE","ANAYA","1988-04-29","","","","112/84","99.2","18","87","175","65","98","2024062444244","VAM","VAM","2024-06-24 17:05:03","PT STATES HAS BEEN EXPERIENCING SYMPTOMS SINCE SATURDAY 
[T STATES HAS HEADACHES CONGESTION BODYACHES AND PRESSURE IN CHEST 
PT STATES HAS COUGH PRESSURE ON HIS HEAD 
PT STATES HASWEAKNES TO BODY 
PT STATES HAS BEEN TAKING DAYQUIL NO RELIEF 

ALLERGIES: NONE 
PHARMACY: WALGREENS 
Store #15155

Walgreens Pharmacy at 
107 W RANKIN RD Houston, TX 77090
Cross streets: KUYKENDAHL & RANKIN

Phone : 281-872-0612is not actionable to desktop users since it is disabled
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1025","2024062419859","AMELIA","Gonzales","2020-12-15","","","","","99.3","18","124","40","38","100","2024062413276","VAM","VAM","2024-06-24 19:18:12","PT STATES HAS BEEN RUNNING FEVER FRIDAY 
PT STATES HAS BEEN COUGHING MILD HEAD PAIN 
PT STATES SHE WAS GIVEN TYLENOL FOR KIDS 
PT ALSO HAD STREP 2 WEEKS AGO AND HAS FINISHED HER ANTIBIOTIC

ALLERGIES
 NONE 
PHARMACY: WALMART IN CONROE
Pharmacy
Open·until 7pm
Mon - Sat | 9am - 7pm
Sun | 10am - 6pm
Refill a Prescription

 Pharmacy
936-760-2112","All","Yes","Finish");
INSERT INTO patients_record VALUES("1026","2024062486577","Jason","Sanders","1982-06-16","","","","97/58","98.3","18","73","139.6","63","95","202406245514","Humble","Humble","2024-06-24 20:32:33","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1027","2024062488189","adeline","Gonzales","2019-11-19","","","","too small","98.4","18","116","39.9","40","100","2024062448480","VAM","VAM","2024-06-24 20:45:58","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1028","2024062525827","Vicki","Pitbladdo","1968-07-18","","","","99/67","98.4","18","75","107","64","98","2024062518804","Palmas","Palmas","2024-06-25 15:02:21","55 y/o female pt is here for a annual visit.
Lymphedema.
Glaucoma history.
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1029","2024062572746","vicki","Pitbladdo","1968-07-18","","","","99/77","98.5","18","75","107","64","98","2024062544588","Palmas","Palmas","2024-06-25 16:07:14","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1030","2024062524160","james","Gee","1988-10-22","","","","140/88","98.1","18","70","240","66","96","2024062519941","VAM","VAM","2024-06-25 19:09:14","pt states was stung by a bee or some insect on June 19th 
pt states next day had swelling to his middle of neck and behind left ear 
pt states has soreness and stiffness to neck 
pt states has not taken anything but would like a recommendation 
pt states has exercise asthma

allergies: none 
pharmacy: amazon pharmacy 8552063605 fax 5128845981 ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1031","2024062532118","jesus ","garza","1991-07-13","","","","133/90","98.7","18","62","200","69","98","2024062540898","VAM","VAM","2024-06-25 22:25:50","pt states came to check bp after feeling some slight dizzyness
pt states had not taken bp med in 3 days so wonders if that what it can be 
pt is taking 50mg losartan prescribed by lorenzo fnp

allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1032","2024062628498","TEST","Castle Hills","1970-08-16","","","","","","","","","","","2024062611308","Castle Hills","Castle Hills","2024-06-26 14:16:00","","All","","");
INSERT INTO patients_record VALUES("1033","2024062681089","Isabella","Cuevas","2016-06-05","","","","122/74","97.4","22","102","62.5","34","99","2024062649726","VAM","VAM","2024-06-26 14:22:47","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1034","2024062675883","Jammie","Page","1984-07-22","","","","132/84","99.0","","62","130","62","99","2024062620877","Humble","Humble","2024-06-26 16:53:22","Pt came in for work physical, pt is getting a travel agency job.
Pt takes amlodipine besylate 10 mg, airtazapine 7.5 mg and needs refills on both 
Vision is 20/20


Allergies: NKDA
Pharmacy: Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1035","2024062625932","Jason","Sanders","1982-06-16","","","","122/54","99.6","","83","144","71","99","2024062630620","Humble","Humble","2024-06-26 17:25:44","Pt has chronic back pain that has gotten worse since Monday.
pt has a bulge growing in the groan area. hard for pt to sit at times
Pt has pain in hips and shoots down to LT knee. ALL pain on LT side. 


Allergies: NKDA

Pharmacy: Walmart
Humble Supercenter
Walmart Supercenter #744
6626 Fm 1960 Rd E, Humble, TX 77346
Open·until 11pm
281-852-4648","All","Yes","Finish");
INSERT INTO patients_record VALUES("1036","2024062694290","Angel","Cisneros","1994-01-19","","","","116/74","97.9","18","89","239.2","66","97","2024062626202","VAM","VAM","2024-06-26 18:12:24","patient here for medication refill
NKDA
Pref. pharmacy
Walgreens
9375 Veterans Memorial Dr 
Hou Tx 77088
Phone:
281 591-1430","All","Yes","Finish");
INSERT INTO patients_record VALUES("1037","2024062654713","Jonathan ","Franchi","1982-12-22","","","","129/73","98.4","20","82","191.7","71","96","2024062645190","VAM","VAM","2024-06-26 19:04:37","Patient is here for itchy throat no fever , coughing for 2 days, runny nose.
Pref Pharmacy
Walgreens
2808 GESSNER RD Houston, TX 77080
713-460-0535","All","Yes","Finish");
INSERT INTO patients_record VALUES("1038","2024062769773","test","humble","","","","","","","","","","","","2024062716834","Humble","Humble","2024-06-27 14:02:37","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1039","2024062791731","Test","Humble 2","","","","","","","","","","","","2024062743741","Humble","Humble","2024-06-27 14:04:21","test","All","","");
INSERT INTO patients_record VALUES("1040","2024062739209","wendy","pirolo","1989-09-19","","","","134/83","98.8","18","89","140","62","98","2024062721698","VAM","VAM","2024-06-27 14:16:13","pt states lasy night symptoms began 
pt states has had bodyaches headaches
pt states has sore throat chills 
pt states took tylenol 
allergies: none 

covid- negative flu-negative 
pharmacy: Store #6782

Walgreens Pharmacy at 
19215 INTERSTATE 45 S Shenandoah, TX 77385
Cross streets: Southeast corner of I-45 FRONTAGE ROAD & TAMINA

Phone : 281-419-6247","All","Yes","Finish");
INSERT INTO patients_record VALUES("1041","2024062728829","ronald","graham","1988-01-13","","","","142/96","97.5","18","65","255","68","97","2024062731024","VAM","VAM","2024-06-27 14:36:18","pt states  has been feeling very fatigued for 2 days working in the heat 
pt states feels lethargic 
pt states has headache 
pt states took b c powder with minimal relief 
pt states feels nauseated

allergies: none 

pharmacy:  kroger Pharmacy
281–332–2551

View My Prescriptions
Schedule a Vaccine
Open until 8 PM
Sun: 10 AM - 5 P","All","Yes","Finish");
INSERT INTO patients_record VALUES("1042","2024062743732","james","Gee","1988-10-22","","","","150/86","98.2","18","84","240","66","96","2024062714542","VAM","VAM","2024-06-27 17:32:13","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1043","2024062731421","lectoria","payne","1979-05-09","","","","155/100","98.8","18","118","220","63","97","202406272424","VAM","VAM","2024-06-27 19:17:06","pt states symptoms began today 
pt states has body aches headache 
pt states has redness to eyes 
pt states no one at home is sick 

allergies: none 
pharmacy: Store #3424

Walgreens Pharmacy at 
23110 ALDINE WESTFIELD RD Spring, TX 77373
Cross streets: WOODRIVER & ALDINE WESTFIELD ROAD

Phone : 281-350-5311is not actionable to desktop users since it is disabled
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1044","2024062732173","George","Skinner","1975-11-28","","","","160/97","98.2","","67","290","68","96","202406278635","Humble","Humble","2024-06-27 20:58:35","Pt is her for f/u of x-ray on R knee","All","Yes","Finish");
INSERT INTO patients_record VALUES("1045","2024062857127","Sydney","Hacholski","2005-04-07","","","","132/80","97.4","18","75","","","99","2024062815116","Castle Hills","Castle Hills","2024-06-28 16:47:03","Review labs.","All","Yes","Finish");
INSERT INTO patients_record VALUES("1046","2024062899462","Benjamin","Draper","1998-03-24","","","","","","","","170","70","","20240628223","Humble","Humble","2024-06-28 19:14:13","pt needs rx refill of vyvanse","All","Yes","Finish");
INSERT INTO patients_record VALUES("1047","2024062888576","Mia","Kallevig","2009-08-25","","","","105/69","98.7","18","86","110","63","99","2024062835851","Palmas","Palmas","2024-06-28 20:26:57","13 y/o female pt is here for lab results and  a back rash for a few months. ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1048","2024062957767","Test Pt ","Test pt ","2010-10-10","","","","120/80","97.7","18","67","190","63","99","2024062948946","Humble","Humble","2024-06-29 16:16:44","Skin rash X 3 days 
NKA 
No daily med
Kroger Pharmacy on Atascocita 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1049","2024062957767","Test Pt ","Test pt ","2010-10-10","","","","120/80","97.7","18","67","190","63","99","2024062948946","Humble","Humble","2024-06-29 16:17:02","Skin rash X 3 days 
NKA 
No daily med
Kroger Pharmacy on Atascocita 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1050","2024062959753","Test","test","2010-10-10","","","","130/80","98.6","18","67","190","68","99","2024062935612","Humble","Humble","2024-06-29 16:27:47","Skin rash ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1051","2024062959753","Test","test","2010-10-10","","","","130/80","98.6","18","67","190","68","99","2024062935612","Humble","Humble","2024-06-29 16:27:55","Skin rash ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1052","2024062912379","test","test","2010-10-10","","","","120/80","98.6","18","86","190","72","99","202406293850","Humble","Humble","2024-06-29 16:36:21","Skin rash 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1053","2024062912379","test","test","2010-10-10","","","","120/80","98.6","18","86","190","72","99","202406293850","Humble","Humble","2024-06-29 16:36:30","Skin rash 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1054","2024062912297","test 2","test 2","2010-10-10","","","","130/80","98.6","","67","190","65","99","2024062943530","Humble","Humble","2024-06-29 16:39:07","skin
","All","","");
INSERT INTO patients_record VALUES("1055","2024062912297","test 2","test 2","2010-10-10","","","","130/80","98.6","","67","190","65","99","2024062943530","Humble","Humble","2024-06-29 16:39:22","skin
","All","","");
INSERT INTO patients_record VALUES("1056","2024062994969","test","Test","2010-10-10","","","","120/80","97.7","18","67","190","63","99","2024062923080","Humble","Humble","2024-06-29 16:43:20","skin rash","All","","");
INSERT INTO patients_record VALUES("1057","2024062994969","test","Test","2010-10-10","","","","120/80","97.7","18","67","190","63","99","2024062923080","Humble","Humble","2024-06-29 16:43:28","skin rash","All","","");
INSERT INTO patients_record VALUES("1058","2024062951348","Test CH","TEST","1989-01-01","","","","","","","","","","","2024062924534","Castle Hills","Castle Hills","2024-06-29 16:49:15","test 1","All","Yes","Finish");
INSERT INTO patients_record VALUES("1059","2024062979911","Test CH 2","TEST","1989-01-02","","","","","","","","","","","2024062936791","Castle Hills","Castle Hills","2024-06-29 17:12:30","test 2","All","Yes","Finish");
INSERT INTO patients_record VALUES("1060","2024062996002","Johnny ","Ramos","1983-09-24","","","","124/72","98.5","","80","241.6","65","98","2024062921190","Castle Hills","Castle Hills","2024-06-29 18:51:08","Physical (cleared for work)

","All","Yes","Finish");
INSERT INTO patients_record VALUES("1061","2024063032792","Humle Test ","Humble Test","","","","","120/80","98.6","18","86","190","68","98","2024063035541","Humble","Humble","2024-06-30 13:58:45","Cough X 3 days 
Pharmacy Walgreens Atascocita 
KNA ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1062","2024063015657","test","Test","","","","","120/80","98.6","18","67","160","65","99","2024063027122","Humble","Humble","2024-06-30 15:13:49","Cough ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1063","2024063015657","test","Test","","","","","120/80","98.6","18","67","160","65","99","2024063027122","Humble","Humble","2024-06-30 15:13:59","Cough ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1064","2024063092547","Cristian ","Iracheta ","1996-08-28","","","","119/70","100.8","24","107","200","74","98","2024063034826","Humble","Humble","2024-06-30 19:08:09","sore throat X 3 days 
KNA 
Pharmacy Kroger on 1960 281-973-5089
Cough drops with minimal pain reduced 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1065","2024070142288","MICHAEL","BAILEY","1975-05-03","","","","139/88","97.9","18","83","195","69","97","2024070127673","VAM","VAM","2024-07-01 17:33:11","PT STATES HAD A PERSONAL INJURY 
PT STATES WAS MOVING A SHELF AND TH ESHELF HIT HIS LEG 
PT STATES HAS SOME SWELLING 
PT STATES PAIN IS WEIGHT BARRING 
PT STATES RADIATES DOWN TO FOOT 
PT HAS FIRM AND REDNESS TO LOWER LEG 
PT STATES HAS NOT TAKEN ANYTHING FOR PAIN 
PT IS A SMOKER 
ALLERGIES: NONE 

PHARMACY: Store #4696

Walgreens Pharmacy at 
411 S MASON RD Katy, TX 77450
Cross streets: Southeast corner of MASON & PROVINCAL

Phone : 281-579-0910","All","Yes","Finish");
INSERT INTO patients_record VALUES("1066","2024070176129","Jonathan ","FRANCHI","1982-12-22","","","","134/80","97.9","18","76","190","71","97","2024070113123","VAM","VAM","2024-07-01 18:24:23","PT IS HERE FOR LEFT SHOULDER BLADE PAIN 
PT STATES RADIATES TO NECK AND ARM 
PT DENYS INJURY 
PT STATES PAIN BGAN SATURDAY 
PT STATES HAS BECOME CONSTANT 

ALLERGIES: NONE 
PHARMACY;Store #5536

Walgreens Pharmacy at 
2808 GESSNER RD Houston, TX 77080
Cross streets: Northeast corner of GESSNER & KEMPWOOD

Phone : 713-460-0535","All","Yes","Finish");
INSERT INTO patients_record VALUES("1067","2024070118441","RAYMOND","WEST","1975-10-15","","","","155/96","98.3","18","92","330","74","96","202407015286","VAM","VAM","2024-07-01 18:47:12","PT IS HERE WITH REDNESS TO RT EYE 
PT WEARS PRECRIBED LENSES
PT STATES HAS BURNING AND IRRITATION
PT STATES WOKE UP WITH DRAINAGE TO THE EYE 
PT STATES STARED 1 WEEK AGO 
PT STATES IS HAVING THE SAME SYMPTOMS TO LT EYE AS WELL 

ALLERGIES: MORPHINE (SEPTIC SHOCK)
PHARMACY: Store #15542

Walgreens Pharmacy at 
20824 FM 1485 RD New Caney, TX 77357
Cross streets: Northwest corner of HWY 59 (FRONTAGE) & FM1485

Phone : 281-689-0002","All","Yes","Finish");
INSERT INTO patients_record VALUES("1068","2024070183799","MICHAEL","BANNER","1977-02-01","","","","125/93","98.1","18","88","280","71","96","2024070148378","VAM","VAM","2024-07-01 19:07:36","PT HAS A POSSIBLE STY ON RT EYE 
PT STATES STY APPERED ON FRIDAY
PT STATES HE TOUCHES HIS EYE SOMETIMES 
PT STATES RT EYE IS PAINFUL 
PT STATES HAS DRAINAGE


ALLERGIES: NONE
PHARMACY: Store #3424

Walgreens Pharmacy at 
23110 ALDINE WESTFIELD RD Spring, TX 77373
Cross streets: WOODRIVER & ALDINE WESTFIELD ROAD

Phone : 281-350-5311","All","Yes","Finish");
INSERT INTO patients_record VALUES("1069","2024070185971","Ayanna","Chevis","2010-10-16","","","","107/54","98.6","","73","123.2","64","97","2024070116512","Humble","Humble","2024-07-01 19:38:48","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1070","2024070142434","Ryan","Moriarty","1980-09-23","","","","138/84","98.0","18","97","210","74","97","20240701255","Palmas","Palmas","2024-07-01 21:59:12","43 years old male patient visit the clinic as a walk- in looking for prescription of Telmisartan 80mg, Finasteride 1mg.
Allergies: no
Surgery: no
Pharmacy: Walgreens Calle Cruz Stella 787-285-0810
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1071","2024070222538","","","","","","","","","","","","","","20240702528","VAM","VAM","2024-07-02 13:51:23","","","","");
INSERT INTO patients_record VALUES("1072","2024070318284","GRAHAM","NEIHEISEL","2017-08-16","","","","","99.3","20","78","40.9","40","98","2024070347054","VAM","VAM","2024-07-03 14:12:04","Patient here with nausea vomiting for 2days has been taking Zofran for nausea
NKDA
Pharmacy
Walgreens
26288 Kuykendahl rd
Tomball TX 77375
281 378-2995","All","Yes","Finish");
INSERT INTO patients_record VALUES("1073","2024070345756","indira","lopez","1976-10-06","","","","123/72","98.0","18","96","180","63","98","2024070339333","Palmas","Palmas","2024-07-03 14:19:55","throat and ear pain  ","All","","");
INSERT INTO patients_record VALUES("1074","2024070383103","MICHAEL","BAILEY","1975-05-03","","","","120/83","97.4","20","87","200.9","69","97","2024070317638","VAM","VAM","2024-07-03 14:46:49","Patient here for follow up on injury on right leg.

NKDA

Pref Pharm
Walgreens
 411 S MASON RD Katy, TX 77450
281-579-0910","All","Yes","Finish");
INSERT INTO patients_record VALUES("1075","2024070325364","Austin Henry Lee "," Jurand","2011-08-17","","","","111/65","98.7","","91","105.8","64","99","2024070322043","Castle Hills","Castle Hills","2024-07-03 15:49:17","Sports Physical


Pharmacy: From out of town","All","Yes","Finish");
INSERT INTO patients_record VALUES("1076","2024070380819","Joshua","Henslee","2001-09-21","","","","160/93","98.5","","68","198.4","68","99","2024070342981","Castle Hills","Castle Hills","2024-07-03 21:12:54","Blood work","All","Yes","Finish");
INSERT INTO patients_record VALUES("1077","2024070343029","Adeline","Gonzales","2019-11-19","","","","90/79","100.4","22","108","39.7","42","99","2024070321976","VAM","VAM","2024-07-03 21:29:03","Patient here for fever 100.4 started today and complaining of mouth pain
No Diarrhea
No vomiting
No nausea
NKDA
Pref Pharm
Walmart
1407 N Loop 336 W. Conroe, TX 77304
936-788-5400","All","Yes","Finish");
INSERT INTO patients_record VALUES("1078","2024070562703","bernadette","Sanchez","1976-01-05","","","","125/83","98.5","","69","165","67","99","2024070524256","Castle Hills","Castle Hills","2024-07-05 14:45:55","tb test","All","Yes","Finish");
INSERT INTO patients_record VALUES("1079","2024070580177","Kiri","levy","1999-03-16","","","","124/80","98.3","","90","160","61","99","2024070518536","Humble","Humble","2024-07-05 14:51:00","Pt has a rash that started on Tuesday on L thigh
Pt states it started to spread from there on in the next days
Pt states it has gone up all the way to her face /neck
Rash is from head to toe as of now, pt took Benadryl since Wednesday
Pt states rash is itchy 

Allergies: NKDA

Pharmacy:
Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1080","2024070567713","Luis","Baez Rodriguez","1966-04-20","","","","115/75","98.0","18","79","150","54","98","202407058693","Palmas","Palmas","2024-07-05 15:07:44","58 years old male patient visit the clinic c/o trauma in his finger (left hand) , accident occur on Tuesday in the evening around 4PM.  Patient is already taking antibiotics Cephalexin 500mg and triple antibiotic cream.
Allergies: no
Surgery: Gallbladder 
Medications: Crestor, Synthroid 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1081","2024070553483","Iris","Rivera Ortiz","1964-01-15","","","","134/83","97.0","19","86","132","52","97","2024070530435","Palmas","Palmas","2024-07-05 16:27:38","11:40am - 60 years old female patient came to visit as a walk in c/o that at 11:30 am by mistake she take the wrong pills of her mom.  Those pills was Metropolol 50mg and Lisinopril 10mg.

In  his concern she came to the clinic to check his B/P because she feel dry month symptoms and also feels nervous.
11:45am- Vitals Sings:
B/P- 134/83
P- 86
SAT- 97
Dr. Morales order to start IV Fluid 1000ml full drip to run in 1 hr. IV was started at 11:50 AM in the left arm, with a 20g needle. Patient not present any concern and the area of the IV have not any sign of edema or erythema at the moment. IV was placed by Hector Cotto BSN 82543
In 1 hr vitals signs will be taken again ordered by Dr Morales.

12:50PM- vitals signs( after 1 hr with IV fluids)
B/P-126/83
P-75
SAT-99


 ","All","","");
INSERT INTO patients_record VALUES("1082","2024070546067","Cortney ","Christten","1988-05-07","","","","115/70","98.8","","84","194","66","97","2024070526566","Humble","Humble","2024-07-05 19:51:42","Pt has been having hot flash symptoms for the last 2 months
Pt states even inside home, building she still feels hot
Pt has bw orders from OBGYN that she needs to get done
Pt also has been having shortness of breath when moving around too much, w/dizziness 
LMP: march 2024, pt took a urine hcg and came back negative


Allergies: NKDA

Pharmacy: Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1083","2024070619091","Happy","Saturday","2024-07-06","","","","0","0","0","0","0","0","0","2024070617580","Castle Hills","Castle Hills","2024-07-06 16:07:58","Good Morning!","All","Yes","Finish");
INSERT INTO patients_record VALUES("1084","2024070610193","Francisco","Montanes","1991-02-26","","","","","","","","","","","2024070617001","Castle Hills","Castle Hills","2024-07-06 17:35:27","wellness check

RX: Walgreens 210-932-0138

Allergies: PENICILIAN","All","Yes","Finish");
INSERT INTO patients_record VALUES("1085","2024070795019","Kaylee","Schane","2004-01-13","","","","","","","","","","","2024070744391","Castle Hills","Castle Hills","2024-07-07 16:03:35","UTI 

RX: Walmart 210-637-1888

NKDA","All","","");
INSERT INTO patients_record VALUES("1086","2024070717802","Kaylee","Schane","2004-01-13","","","","","","","","","","","2024070711209","Castle Hills","Castle Hills","2024-07-07 16:20:30","uti

rx:walmart 210-637-1888

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1087","2024070730995","Jesse","Ramirez","2010-09-12","","","","","","","","","","","2024070748594","Castle Hills","Castle Hills","2024-07-07 19:14:03","sport physical

rx: HEB 210-696-1073

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1088","2024070725129","Olinda","Moreira","1973-08-18","","","","","","","","","","","2024070732978","Castle Hills","Castle Hills","2024-07-07 20:42:03","SOB, Wheezing

rx: walmart 210-591-6285

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1089","2024070798472","","","","","","","","","","","","","","202407077705","Humble","Humble","2024-07-07 21:06:56","","","","");
INSERT INTO patients_record VALUES("1090","2024070739308","Emmanuel","Reyes","2022-12-15","","","","110/70","98.0","","67","25.8","32","","2024070728361","Humble","Humble","2024-07-07 21:09:53","Patient arrive with multiple skin rash around the body
Parent felt patient had fever.","All","Yes","Finish");
INSERT INTO patients_record VALUES("1091","2024070784768","Annabelle","Castaneda","2014-08-01","","","","99/52","98.4","","83","109.4","59","97","2024070711590","Humble","Humble","2024-07-07 22:06:54","Skin Rash all over body and Itching

Walgreens 8505 FM 1960 RD W
Humble, TX 77338

No Fever
NKA
No Coughing
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1092","2024070724703","Catalina","Castaneda","2017-08-20","","","","98/53","97.7","","98","100.2","53","96","2024070738894","Humble","Humble","2024-07-07 22:50:23","Skin Rash in legs 

NKA

No Fever

","All","","");
INSERT INTO patients_record VALUES("1093","2024070824022","","","","","","","","","","","","","","2024070821831","Palmas","Palmas","2024-07-08 15:06:13","","All","","");
INSERT INTO patients_record VALUES("1094","2024070921077","Test","test","2012-10-10","","","","100/60","98.2","16","70","210","65","98","2024070930471","Palmas","Palmas","2024-07-09 16:53:09","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1095","2024070921077","Test","test","2012-10-10","","","","100/60","98.2","16","70","210","65","98","2024070930471","Palmas","Palmas","2024-07-09 16:54:29","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1096","2024070967053","test","Test","2010-10-10","","","","","","","","","","","2024070924579","Palmas","Palmas","2024-07-09 17:00:49","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1097","2024070979357","Ronald ","Poe","1970-01-09","","","","179/103","98.7","18","63","240","73","97","2024070944420","Palmas","Palmas","2024-07-09 17:05:36","NP lab results.","All","Yes","Finish");
INSERT INTO patients_record VALUES("1098","2024070944479","Victoria ","Dunrod","1999-06-09","","","","134/87","98.2","18","73","185","67","99","2024070924714","Palmas","Palmas","2024-07-09 17:49:07","NP test results.","All","Yes","Finish");
INSERT INTO patients_record VALUES("1099","2024071075355","test","humble","","","","","","","","","","","","2024071026600","Humble","Humble","2024-07-10 14:31:55","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1100","2024071068796","Wednesday","TEST","2024-07-10","","","","","","","","","","","2024071021940","Castle Hills","Castle Hills","2024-07-10 14:48:08","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("1101","2024071128321","test","test","2010-10-10","","","","100/60","98.2","16","70","210","65","97","2024071146698","Palmas","Palmas","2024-07-11 16:23:10","lio;.knjl/;.","All","","");
INSERT INTO patients_record VALUES("1102","2024071188954","test","test","1976-06-10","","","","120/68","98.2","18","103","160","65","97","2024071130641","Palmas","Palmas","2024-07-11 16:29:35","head ache","All","","");
INSERT INTO patients_record VALUES("1103","2024071133248","ISABELLA","CARRANZA","2016-05-21","","","","103/71","97.8","18","109","59","46","97","2024071121331","VAM","VAM","2024-07-11 17:38:53","PT STATES IS HERE FOR CONSTANT COUGH THAT STARTED FRIDAY 
PT TAKEN TO URGENT CARE WHERE SHE TOOK A COVID AND FLU THAT WAS NEGATIVE 
PT STATES WAS ONLY GIVENMOTRIN NO MEDS WHERE SENT 
PT WAS GIVEN BROMPHEN MED
PT STATES COUGH HAS NOT CHANGED AND HAS BECOME MORE CONSTANT 
 PT STATES NO ONE AT HOME IS SICK

ALLERGIES: NONE 
PHHARMACY: WALMART 2819999963
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1104","2024071192288","Cristian","Iracheta ","1996-08-28","","","","116/79","97.9",""," 116","195","73","98","2024071120153","Humble","Humble","2024-07-11 18:44:14","Pt had a sore throat on last visit on 6/30, but now has a cough that has gotten worse
Pt states rx from last visit helped but not with cough now
Pt has nasal congestion/pressure
Pt has no other fam mm that are sick, works at VAM

Allergies: NKDA

Pharmacy: Kroger
Address: 9475 Farm to Market 1960 Bypass Rd W, Humble, TX 77338
Open ⋅ Closes 8 PM
Phone: (281) 973-5090","All","Yes","Finish");
INSERT INTO patients_record VALUES("1105","2024071153278","Eduardo","Lujan","2012-06-12","","","","116/66","97.3","22","66","125","58","94","2024071111941","Castle Hills","Castle Hills","2024-07-11 19:19:34","sport physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1106","2024071170057","test","humble","","","","","","","","","","","","202407113711","Humble","Humble","2024-07-11 19:24:36","","All","","");
INSERT INTO patients_record VALUES("1107","2024071119749","test","humble","","","","","","","","","","","","2024071149473","Humble","Humble","2024-07-11 20:11:59","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1108","2024071162702","JOSE ","RUIZ","1989-09-23","","","","111/64","98.0","18","64","155","70","98","202407114569","VAM","VAM","2024-07-11 20:43:46","PT IS HERE STATES HE IS HAVING RT WRIST PAIN 
PT STATES PAIN BEGAN SATURDAY 
PT STATES EVERYTIME HE WOULD MOVE HAND HAS PAIN AND PAIN HAS GOTTEN WORSE OVER THE DAYS 
PT STATES DID NOT HAVE INJURY 
PT STATES PAIN IS WHEN HE MOVES WRIST ITS A 2/10 BUT WHEN HE PRESSES ON THE WRIST PAIN IS A 8/10
PT STATES PAIN RADIATES TO HALF OF HIS FOREARM

ALLERGIES: NONE 
PHARMACY: Pharmacy
281–602–0313

View My Prescriptions
Schedule a Vaccine
Open until 8 PM
Sun: 10 AM - 5 PM
Mon - Fri: 9 AM - 8 PM
Sat: 9 AM - 6 PM","All","Yes","Finish");
INSERT INTO patients_record VALUES("1109","2024071139400","Antwon","Robinson","2004-03-25","","","","120/66","99.3","","76","125","67","98","2024071134660","Humble","Humble","2024-07-11 21:28:24","Pt needs rx for STI, was dx back in 05/2024
Pt had rx but left in home state, needs rx refill to start taking here in tx

Allergies: NKDA
Pharmacy: 
Walgreens
Address: 3755 Atascocita Road, Humble, TX 77396
Open ⋅ Closes 11 PM
Pharmacy: Open ⋅ Closes 10 PM · More hours
Confirmed by this business 7 weeks ago
Phone: (281) 812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1110","2024071290503","Courtney ","Christten","1988-05-07","","","","109/72","98.1","","74","193","66","96","2024071239304","Humble","Humble","2024-07-12 14:22:03","f/u for bw results","All","Yes","Finish");
INSERT INTO patients_record VALUES("1111","2024071273011","Rebecca","Yu","1971-04-09","","","","115/81","98.0","18","68","140","64","97","2024071224692","Palmas","Palmas","2024-07-12 14:39:02","lab results.","All","Yes","Finish");
INSERT INTO patients_record VALUES("1112","2024071235456","Rogelio","Flores","1951-07-07","","","","135/80","97.2","17","70","211","74","95","2024071229122","Castle Hills","Castle Hills","2024-07-12 14:57:51","wellness check.

RX: Ortiz Pharmacy 210-432-2361
2515 Castroville Rd, SA tx 78237

Allergies: Tramadol","All","Yes","Finish");
INSERT INTO patients_record VALUES("1113","2024071235872","Ethan","Anthony","2002-11-19","","","","148/92","98.2","","115","110","70","96","2024071218394","Humble","Humble","2024-07-12 15:01:04","Pt has been vomiting since last night, non stop
Pt has chest pain in middle of sternum, light headed , dizzy
Pt states it burns when vomiting, yellow liquid
Pt has body chills/pain after vomiting


Allergies: NKDA
Pharmacy: 
Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1114","2024071238949","Carrol","Kelly","1951-12-01","","","","139/85","98.2","18","83","237","67","97","202407126466","Palmas","Palmas","2024-07-12 16:53:21"," c/c Dizziness when standing up and problems with balance.
Orthostatic VS 
Lie down BP 13/67
P-85
 Standing up BP 140/93
P-100","All","Yes","Finish");
INSERT INTO patients_record VALUES("1115","2024071259118","alex","ramirez","1974-08-25","","","","109/66","98.6","18","72","220","76","97","2024071249615","VAM","VAM","2024-07-12 19:44:15","pt states is having runny nose 
pt is having congestion chills  slight sorethroat
pt states is having cough slight headache 
pt states ears feel full 

allergies; none 
pharmacy: Pharmacy HEB
Pharmacy Phone:
(713) 647-5950
Mon-Fri
8:00 AM - 8:00 PM
Sat
9:00 AM - 6:00 PM
Sun","All","Yes","Finish");
INSERT INTO patients_record VALUES("1116","2024071247392","alex","","","","","","","","","83","","","98","2024071216050","VAM","VAM","2024-07-12 20:02:47","PT","All","","");
INSERT INTO patients_record VALUES("1117","2024071272881","alex","ramirez","1974-08-25","","","","109/66","98.6","18","76","220","76","97","2024071213207","VAM","VAM","2024-07-12 20:05:45","pt is positive for covid ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1118","2024071268382","Jean","Harris","1954-02-19","","","","153/80","99.1","","80","240","65","98","2024071239120","Humble","Humble","2024-07-12 22:48:02","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1119","2024071320876","Test","Test","1977-12-12","","","","120/70","99.1","18","88","160","69","97","2024071315003","Dr. Marvel","Waco","2024-07-13 13:39:30","Sore Throat x 2 days

Allergies:  NKDA

Pharmacy:  CVS 210-313-4567","All","Yes","Finish");
INSERT INTO patients_record VALUES("1120","2024071328846","TEST","TEST","","","","","","","","","","","","202407133072","Castle Hills","Castle Hills","2024-07-13 14:37:39","test call ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1121","2024071327202","Nina ","Alvarez","2010-03-23","","","","109/77","98.5","88","88","109.2","62","99","2024071328180","Castle Hills","Castle Hills","2024-07-13 15:05:58","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1122","2024071355582","Ernest","Alvarez","2011-01-21","","","","96/98","98.5","","81","70","57","","2024071342062","Castle Hills","Castle Hills","2024-07-13 15:33:09","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1123","2024071344955","Test","Test","1980-12-15","","","","120/80","98.6","18","68","230","68","97","2024071341112","Humble","Humble","2024-07-13 15:59:54","Pain in Joints

Coughing

Rash in Arm ( Left )

NKA

HEB Kingwood Route 69  Kingwood, TX 77339

","All","","");
INSERT INTO patients_record VALUES("1124","2024071381090","Test","Test","1980-12-15","","","","120/80","97.7","18","68","230","68","97","2024071332554","Humble","Humble","2024-07-13 16:07:04","Coughing

Rash in Arm ( left )

NKA

HEB Kingwood Route 69 
Kingwood, TX 77339","All","Yes","Finish");
INSERT INTO patients_record VALUES("1125","2024071356931","TEST2","test2","1980-12-15","","","","120/80","97.7","18","67","230","68","98","2024071317231","Humble","Humble","2024-07-13 17:02:24","Coughing

Sore Throat

NKA

HEB Kingwood Route 69
Kingwood, TX 77339","All","Yes","Finish");
INSERT INTO patients_record VALUES("1126","2024071346373","Marcera","Williams","2004-08-05","","","","91/57","98.5","","77","126","63","99","20240713248","Castle Hills","Castle Hills","2024-07-13 17:02:41","Breathing Problems","All","Yes","Finish");
INSERT INTO patients_record VALUES("1127","2024071324725","TEST2","Test","1980-12-15","","","","120/80","97.7","18","67","230","68","97","2024071335578","Humble","Humble","2024-07-13 17:16:46","Coughing

Sore Throat

NKA

HEB Kingwood Route 69
Kingwood, TX 77339","All","Yes","Finish");
INSERT INTO patients_record VALUES("1128","2024071318815","Test","Test","","","","","","","","","","","","2024071323876","Castle Hills","Castle Hills","2024-07-13 17:39:56","Test call","All","Yes","Finish");
INSERT INTO patients_record VALUES("1129","2024071350934","Test","Test","1980-12-15","","","","120/80","97.7","18","67","230","68","98","2024071312248","Humble","Humble","2024-07-13 19:36:03","Body Ache

Flu like Symptoms

NKA

HEB Kingwood Route 69
Kingwood, TX 77339","All","","");
INSERT INTO patients_record VALUES("1130","2024071429902","TEST2","test","2010-02-10","","","","120/80","98.6","18","86","160","70","","2024071445794","Humble","Humble","2024-07-14 14:02:39","skin rash ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1131","2024071429902","TEST2","test","2010-02-10","","","","120/80","98.6","18","86","160","70","","2024071445794","Humble","Humble","2024-07-14 14:02:50","skin rash ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1132","2024071475887","TEST2","test","2020-10-20","","","","130/80","97.7","16","86","160","67","99","2024071434087","Humble","Humble","2024-07-14 16:22:50","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1133","2024071428515","Eliseo ","Juarez","1992-01-02","","","","131/86","98.6","","86","175","69","96","2024071448604","Castle Hills","Castle Hills","2024-07-14 20:49:56","Social Anxiety 

Pharmacy: 8503 nw military hwy","All","Yes","Finish");
INSERT INTO patients_record VALUES("1134","2024071518546","HUMBLE","Test","","","","","","","","","","","","202407157593","Humble","Humble","2024-07-15 13:50:55","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1135","2024071544480","Monday ","Test","2024-07-15","","","","0","0","00","0","0","0","0","2024071526463","Castle Hills","Castle Hills","2024-07-15 13:57:35","Good morning!","All","Yes","Finish");
INSERT INTO patients_record VALUES("1136","2024071545206","fernando ","lopez","1959-01-01","","","","133/86","97.9","18","95","210","73","97","202407155423","VAM","VAM","2024-07-15 14:10:25","pt states was aroung poisen ivy while cutting trees since laST WEEK 
PT STATES HAS RASH ON LEGS ARMS 
PT STATES HAS ALOT OF BURNING AND ITCHYNESS 
PT STATES USED CALAMINE AND ALEGRA 

ALLERGIES: NONE 
PHARMACY: Store #21238

Walgreens Pharmacy at 
1501 W CHURCH ST Livingston, TX 77351
Cross streets: SEC

Phone : 936-327-1086","All","Yes","Finish");
INSERT INTO patients_record VALUES("1137","2024071564192","Denver","Griffen","1979-08-31","","","","131/98","98.2","18","99","185","70","98","202407153440","Palmas","Palmas","2024-07-15 14:29:18","Py is here as a walk in for medication refill.
Methylphenid 5 mg tab  ( 2 tabs 3 to 4 ti9mes a day as needed)
Medical History of narcolepsy and cancer (squamous cell carcinoma throat ) cancer 
H pillory 
 meds: Viagra and trimix ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1138","2024071544582","CARL","WHITE","1956-06-18","","","","135/97","97.9","18","72","175","68","99","20240715817","VAM","VAM","2024-07-15 15:23:11","PT IS HERE FOR A BLOOD DRAW ASKED BY HIS PCP
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1139","2024071544582","CARL","WHITE","1956-06-18","","","","135/97","97.9","18","72","175","68","99","20240715817","VAM","VAM","2024-07-15 15:25:12","PT IS HERE FOR A BLOOD DRAW ASKED BY HIS PCP
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1140","2024071558580","Steven","Buckley","1986-03-31","","","","155/125","97.2","23","82","203","73","97","202407153051","Castle Hills","Castle Hills","2024-07-15 16:55:36","sore thrat.

RX: Walgreens 210-979-6575

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1141","2024071522712","CHRISTOPHER","VILLAGOMEZ","1990-09-23","","","","153/88","97.7","18","64","240","71","98","2024071536343","VAM","VAM","2024-07-15 17:23:32","PT STATES GOT WAS CLEANING BACK YARD AND GOT AROUNG TO SOME POISEN IVY 
PT STATES IS HAVING ITCHYNESS TO THE ARMS
PT STATES HAPPNED 4 DAYS AGO 
PT STATES HAS NOT TAKEN ANYTHING 


ALLERGIES; NONE 
PHARMACY:
Store #12015

Walgreens Pharmacy at 
747 E CROSSTIMBERS ST Houston, TX 77022
Cross streets: Northwest corner of IRVINGTON & CROSSTIMBERS

Phone : 713-695-2427","All","Yes","Finish");
INSERT INTO patients_record VALUES("1142","2024071524015","Magaly","Aham","1968-05-07","","","","129/74","101.3","18","71","127","61","97","2024071528859","Palmas","Palmas","2024-07-15 22:34:49","Female pt c/o a stye on her left eye for a week. 
Pt tried gentamicin but is not getting better. 
Allergies shellfish  and sulfacetamin.
Medication: fluoxetine 20 mg once a day","All","Yes","Finish");
INSERT INTO patients_record VALUES("1143","2024071639248","Tuesday","Test","2024-07-16","","","","","","","","","","","2024071611690","Castle Hills","Castle Hills","2024-07-16 13:57:09","Good morning","All","","");
INSERT INTO patients_record VALUES("1144","2024071666222","Tuesday","TEST","2024-07-16","","","","","","","","","","","2024071645544","Castle Hills","Castle Hills","2024-07-16 13:58:36","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1145","2024071653324","Randi ","Newman","1975-04-09","","","","145/84","97.8","18","68","179","60","96","202407165355","Palmas","Palmas","2024-07-16 14:01:53","Lab results.","All","Yes","Finish");
INSERT INTO patients_record VALUES("1146","2024071693621","CHRISTOPHER","VILLAGOMEZ","1990-09-23","","","","143/89","98.0","18","63","250.9","71","98","2024071615734","VAM","VAM","2024-07-16 14:08:00","Patient here for wellness check

NKDA

Pref. Pharmacy on file","All","Yes","Finish");
INSERT INTO patients_record VALUES("1147","2024071661757","jason","sanders","1982-06-16","","","","102/57","98.9","16","68","145","71","98","202407167841","Humble","Humble","2024-07-16 14:48:00","pt is here f/u from imagining results 
pt states feels better today 

allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1148","2024071678777","Karen","Mann","1956-02-03","","","","136/91","97.3","19","70","211","64","93","2024071629106","Castle Hills","Castle Hills","2024-07-16 16:01:43","Rx Refill 

RX: Stone oak pharmacy 210-494-4272 
(compound RXs)

Walmart 210-774-2736 (bisprolol, amlidopine, vit D 100mg per week

Allergies: Penicilian, Iodine, Sulfate ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1149","2024071639824","Janelle","Pierson","2014-12-02","","","","","97.9","20","89","88.5","52","99","2024071643462","VAM","VAM","2024-07-16 16:10:32","","All","","");
INSERT INTO patients_record VALUES("1150","2024071661035","Janelle","Pierson","2014-12-02","","","","","97.9","20","89","88.5","52","99","2024071631758","VAM","VAM","2024-07-16 16:23:13","","All","","");
INSERT INTO patients_record VALUES("1151","2024071653465","Janelle","Pierson","2014-12-02","","","","","97.9","20","89","88.5","52","99","2024071641937","VAM","VAM","2024-07-16 16:26:06","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1152","2024071683359","Alejandro","Ramirez","1974-08-25","","","","113/73","97.9","20","73","244.0","74","95","2024071615071","VAM","VAM","2024-07-16 16:59:13","patient is here for retest for COVID patient stated his initial start date with symptoms was Tuesday 7-9-24
NKDA
Pref Pharmacy
Walgreens
12850 Memorial Dr
Hou. TX 77024
713 722-7247","All","Yes","Finish");
INSERT INTO patients_record VALUES("1153","2024071624688","Laura","Cruz Cortina","1985-06-21","","","","136/84","97.9","20","59","185.7","60","100","2024071625757","VAM","VAM","2024-07-16 19:59:52","Patient is here for prescription refill.

NKDA

Pref. Pharmacy
Walgreens
21106 KUYKENDAHL RD, Spring, TX 77379
281 355-6325","All","Yes","Finish");
INSERT INTO patients_record VALUES("1154","2024071623203","Kent","McElroy","1955-08-24","","","","117/76","97.1","18","62","153","67","95","2024071612577","Castle Hills","Castle Hills","2024-07-16 21:21:15","Forearm irritation

RX: HEB 210-341-3875

Allergies: Codeine","All","Yes","Finish");
INSERT INTO patients_record VALUES("1155","2024071614079","Test","test","1976-02-02","","","","100/60","98.2","18","74","160","65","98","2024071645175","Palmas","Palmas","2024-07-16 21:43:58","","All","","");
INSERT INTO patients_record VALUES("1156","2024071619019","Rikki","Parnell","1984-12-07","","","","157/107","98.0","20","88","178.1","68","95","2024071624559","VAM","VAM","2024-07-16 21:50:07","Patient her for Lisinopril 30mg refill

NKDA
Pref. Pharmacy
Krogers
22030 Market Place Dr New Caney,TX 77357
(281) 747-5089","All","Yes","Finish");
INSERT INTO patients_record VALUES("1157","2024071612170","Maxwell","Ulbert","1997-06-12","","","","152/88","97.3","18","56","210","71","99","202407166552","Castle Hills","Castle Hills","2024-07-16 22:22:19","check  up, rx refill

RX: HEB 210-491-9976

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1158","2024071673973","","","","","","","","","","","","","","2024071646978","Castle Hills","Castle Hills","2024-07-16 22:25:35","","","","");
INSERT INTO patients_record VALUES("1159","2024071617143","Maxwell","Ulbert","1997-06-12","","","","152/88","97.3","18","56","210","71","99","202407169587","Castle Hills","Castle Hills","2024-07-16 22:26:09","check up, rx refill

RX: HEB 210-491-9976

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1160","2024071778096","TEST","Castle Hills","1970-08-16","","","","120/80","98.5","18","60","160","66","98","2024071720274","Castle Hills","Castle Hills","2024-07-17 14:30:41","Just testing scopes if you see this Lorenzo.

Thanks","All","","");
INSERT INTO patients_record VALUES("1161","2024071777370","Alisia","Laperuta","1997-07-07","","","","103/67","99.6","","115","147","67","95","2024071726855","Humble","Humble","2024-07-17 18:30:42","Pt came in for a headache/sore throat since Friday
Pt had ear pain w/popping on Sunday
Pt is losing her voice starting Monday
Pt states starting today she has sore throat, both ears hurt, nasal congestion/pressure
Pt has not taken anything OTC, PTs daughter was positive for covid 2 weeks ago and strep a month ago. Pt had shortness of breath 

Allergies: KNDA

Pharmacy: Walmart
Conroe Supercenter
Walmart Supercenter #400
1407 N Loop 336 W, Conroe, TX 77304
Open·until 11pm
936-788-5400","All","Yes","Finish");
INSERT INTO patients_record VALUES("1162","2024071755356","Claudia","Gomez","1968-11-08","","","","123/80","99.0","","74","130","62","98","2024071743809","Humble","Humble","2024-07-17 20:03:14","Pt is here for a dog bite
Pt states dogs vaccines are up to date
Pt was able to clean it but it hurts still and bleeding a little

Allergies: NKDA

Pharmacy: 
Walgreens 
Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1163","2024071775182","Esmeralda","Lopez","1998-05-20","","","","142/85","98.8","20","84","315.5","64","96","2024071719774","VAM","VAM","2024-07-17 20:20:25","Patient is her for nausea and vomiting and has taken pregnancy test 07/06/2024 was negative.
NKDA

Pref. Pharmacy
CVS
15207 HWY 6 
Rosharon Tx 77583
281 431-0601","All","Yes","Finish");
INSERT INTO patients_record VALUES("1164","2024071727107","Thomas","Hickman","1968-07-28","","","","124/74","98.1","18","78","327.7","61","97","2024071713713","VAM","VAM","2024-07-17 20:41:00","Pt here for RX refill
CELECOXIB 100MG
TRIAMTERENE 37.5MG/HCTZ 25MG 

Pref. Pharm
Walgreens
19710 Holzwarth
Spring tx 77338
281 350-1500","All","Yes","Finish");
INSERT INTO patients_record VALUES("1165","2024071776817","Esmeralda","Lopez","1998-05-20","","","","","","","","","","","2024071739135","VAM","VAM","2024-07-17 21:07:02","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1166","2024071793156","Keira","Lefler","2012-06-18","","","","90/56","98.5","","115","68","54","94","202407171317","Humble","Humble","2024-07-17 21:09:40","Pt needs a sports physical for school 

Allergies: NKDA

Pharmacy: HEB 
6:00 AM - 11:00 PM
Store Phone:
(281) 812-4357
Business Center Hours:
Mon-Sat 9:00 AM - 7:00 PM
Sun 10:00 AM - 6:00 PM
Pharmacy Phone:
(281) 812-4729
Street map of this store
7405 FM 1960 EAST
HUMBLE, TX 77346-3128","All","Yes","Finish");
INSERT INTO patients_record VALUES("1167","2024071760829","Alejandro","Badayos","1964-03-18","","","","157/86","98.6","18","67","184.6","72","99","2024071735780","VAM","VAM","2024-07-17 21:41:20","Patient here for RX refill Triamcinolone 
NKDA
Pref. Pharmacy
Walgreens
12611 S GESSNER RD Houston, TX 77071
713 266-1853
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1168","2024071713692","Andrea","Wilkerson","1997-09-01","","","","101/65","99.3","","90","150","65","97","2024071740573","Humble","Humble","2024-07-17 21:57:49","Pt states she is concerned she is bruising too easy or when she scratches it turns into a bruise.
Pt states it started about a week ago, she fell on a metal fireplace and scratched/bruise on her back R leg
Pt just had a cold for 4 days long

Allergies: NKDA

Pharmacy: 
Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1169","2024071754028","Courtney","Christten","1988-05-07","","","","110/60","98.0","","88","190","66","99","2024071733963","Humble","Humble","2024-07-17 22:34:11","Pt is here for a f/u over bw","All","Yes","Finish");
INSERT INTO patients_record VALUES("1170","2024071877854","test","humble","","","","","","","","","","","","202407188390","Humble","Humble","2024-07-18 14:09:58","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1171","2024071877854","test","humble","","","","","","","","","","","","202407188390","Humble","Humble","2024-07-18 14:10:03","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1172","2024071877727","Alexandra","Ortiz","1981-08-04","","","","120/72","","","79","170","62","91","202407181065","Castle Hills","Castle Hills","2024-07-18 16:11:36","Refill of RX 


Pharmacy: Walgreens 4703 03 W Commerce","All","Yes","Finish");
INSERT INTO patients_record VALUES("1173","2024071845697","Emma ","Moreno","2010-02-12","","","","113/61","98.6","","82","101.2","60","92","20240718591","Castle Hills","Castle Hills","2024-07-18 19:35:12","Sports Physical

","All","Yes","Finish");
INSERT INTO patients_record VALUES("1174","2024071824964","Kayla","Moreno","2007-08-31","","","","106/60","98.5","","95","108.6","55","99","2024071827795","Castle Hills","Castle Hills","2024-07-18 19:52:49","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1175","2024071894373","Zoie ","Moreno","2012-09-26","","","","111/55","98.6","","84","95","55","98","2024071821756","Castle Hills","Castle Hills","2024-07-18 20:03:19","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1176","2024071822034","Roel","Repollo","1966-07-09","","","","143/84","97.5","","74","205","67","96","2024071830442","Humble","Humble","2024-07-18 21:40:44","Pt needs rx refills on Metformin 500 mg, Glipizide 10 mg, Lisinopril 20 mg, Atorvastatin 40 mg
Pt has all bottles


Allergies: NKDA

Pharmacy: Walgreens
Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1177","2024071837403","cherece","mendieta","1973-06-23","","","","132/74","98.5","18","60","168","66","97","2024071815152","VAM","VAM","2024-07-18 21:44:41","pt states has redness to both eyes 
pt states woke up with both eyes crusted over with drainage
pt states has alot of itchyness to both eyes
pt states has congestion 
pt states has facial pressure 
pt states left ear slight pain 

allergies;ciproflaxin ( hives) racing heart 

pharmacy:
Pharmacy
Open·until 7pm
Mon - Sat | 9am - 7pm
Sun | 10am - 6pm
Refill a prescription

Collapse Pharmacy
281-651-0216","All","Yes","Finish");
INSERT INTO patients_record VALUES("1178","2024071981052","ronald","Graham","1988-01-13","","","","140/96","98.7","18","65","260","68","97","2024071925092","VAM","VAM","2024-07-19 16:54:10","pt states is here due to left shoulder pain 
pt states when turns head pain radiates to neck and down back
pt states when left arm is raised is when pain is constant 
pt states took 800mg ibuprofen 
pt states pain is 4/10 
pt states pain on left shoulder began last yr and has become constant that has triggered his anxiety 
pt states is off medication 
pt states has been having frequent urination and dry mouth 

allergies: none 

pharmacy: same pharmacy on file","All","Yes","Finish");
INSERT INTO patients_record VALUES("1179","2024071921225","Sarinah","Salazar","2011-11-22","","","","109/70","98.5","","74","96.6","57","99","2024071914475","Castle Hills","Castle Hills","2024-07-19 19:42:25","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1180","2024071922345","Joshua","Henslee","2001-09-21","","","","140/71","98.6","","52","200","68","98","2024071942930","Castle Hills","Castle Hills","2024-07-19 21:12:04","Review lab results","All","Yes","Finish");
INSERT INTO patients_record VALUES("1181","2024072057840","Renzo Test","Test","1977-12-13","","","","110/69","98.1","18","60","160","69","99","2024072023433","nurse1","Palmas Del Mar","2024-07-20 14:09:55","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1182","2024072095959","","","","","","","","","","","","","","2024072035734","nurse1","Palmas Del Mar","2024-07-20 14:18:59","","","","");
INSERT INTO patients_record VALUES("1183","2024072031387","Adriana","TEST","2024-07-20","","","","0","0","0","0","0","0","0","202407209155","Castle Hills","Castle Hills","2024-07-20 14:37:10","Test","All","","");
INSERT INTO patients_record VALUES("1184","2024072041240","","","","","","","","","","","","","","2024072042862","Castle Hills","Castle Hills","2024-07-20 14:42:11","","","","");
INSERT INTO patients_record VALUES("1185","2024072046283","Anderson","Fox","2009-09-25","","","","128/82","97.4","19","83","136","68","97","2024072016883","Castle Hills","Castle Hills","2024-07-20 17:25:48","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1186","2024072059215","Andrea","Melendez","2012-03-21","","","","99/56","97.3","17","87","126","61","97","2024072016122","Castle Hills","Castle Hills","2024-07-20 20:40:08","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1187","2024072025599","Lilee-Ana","Villanueva","2008-08-06","","","","118/65","97.0","18","75","132","62","97","2024072038096","Castle Hills","Castle Hills","2024-07-20 21:07:16","sports physical


nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1188","2024072194905","Carolina","Munoz","1993-11-29","","","","114/85","97.3","19","77","195","63","97","2024072133666","Castle Hills","Castle Hills","2024-07-21 15:13:13","fatigue,headaches

RX: CVS 210-616-0482

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1189","2024072191449","Ashley","Gomez","1995-06-06","","","","105/65","97.6","21","53","210","62","99","2024072116111","Castle Hills","Castle Hills","2024-07-21 19:09:31","facial irritation,rash,

RX: Walgreens 210-558-7138

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1190","2024072220578","Sophie","Perkins","1998-01-30","","","","11/75","98.2","18","75","130","62","99","2024072213350","Palmas","Palmas","2024-07-22 14:15:00","eye redness and swollen with tearing . Pt wear contacts.
allergies: latex
Pharmacy: Walgreens calle 3  ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1191","2024072252475","Sophie","Perkins","1998-01-30","","","","","","","","","","","2024072249737","Palmas","Palmas","2024-07-22 14:20:05","","All","","");
INSERT INTO patients_record VALUES("1192","2024072249475","Kassandra","Huiman","1999-12-13","","","","110/70","98.7","","67","235","63","98","2024072219266","Humble","Humble","2024-07-22 14:28:39","Pt has lower/mid left side back pain, hurts more when moving in bed or stretching around
PT states no injuries or changes in diet/stool or urine, no vomiting


allergies: nkda
Pharmacy: CVS 
Address: 17900 W Lake Houston Pkwy, Humble, TX 77346
Hours: 
Open ⋅ Closes 11 PM
Pharmacy: Open ⋅ Closes 1:30 PM ⋅ Reopens 2 PM · More hours
Phone: (281) 319-0001","All","Yes","Finish");
INSERT INTO patients_record VALUES("1193","2024072295108","ronald","Graham","1988-01-13","","","","138/104","98.2","18","60","260","68","98","2024072239733","VAM","VAM","2024-07-22 15:27:20","pt is here f/u on last visit pt last visit had a a1c blood draw and would like results
pt also was recommended to have a ekg done 
pt states medication that was prescribed for anxiety has helped tremendously


allergies: none 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1194","2024072293562","Kaitlynn ","Peck","2012-04-03","","","","95/54","98.6","","67","121.2","60","99","2024072227143","Castle Hills","Castle Hills","2024-07-22 15:31:05","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1195","2024072253113","","","","","","","","","","","","","","2024072244073","Palmas","Palmas","2024-07-22 15:48:25","","","","");
INSERT INTO patients_record VALUES("1196","2024072292370","Indira ","Lopez","1976-06-10","","","","128/74","98.2","18","83","185","63","97","2024072238831","Palmas","Palmas","2024-07-22 15:48:37","47 y/o female pt is here c/o throat pain for the last week. 
Pt has an Hx  of CLL 2010 , DVT 2021 and PE 2024.
Allergies: Cipro and  Morphine

","All","Yes","Ready");
INSERT INTO patients_record VALUES("1197","2024072292370","Indira ","Lopez","1976-06-10","","","","128/74","98.2","18","83","185","63","97","2024072238831","Palmas","Palmas","2024-07-22 15:53:33","47 y/o female pt is here c/o throat pain for the last week. 
Pt has an Hx  of CLL 2010 , DVT 2021 and PE 2024.
Allergies: Cipro and  Morphine

","All","Yes","Ready");
INSERT INTO patients_record VALUES("1198","2024072292370","Indira ","Lopez","1976-06-10","","","","128/74","98.2","18","83","185","63","97","2024072238831","Palmas","Palmas","2024-07-22 15:54:14","47 y/o female pt is here c/o throat pain for the last week. 
Pt has an Hx  of CLL 2010 , DVT 2021 and PE 2024.
Allergies: Cipro and  Morphine

","All","Yes","Ready");
INSERT INTO patients_record VALUES("1199","2024072223474","ronald","Graham","","","","","","","","","","68","98","2024072234828","VAM","VAM","2024-07-22 15:56:48","o","All","Yes","Finish");
INSERT INTO patients_record VALUES("1200","2024072265200","","","","","","","","","","","","","","2024072226562","Palmas","Palmas","2024-07-22 16:02:47","","All","","");
INSERT INTO patients_record VALUES("1201","2024072284319","","","","","","","","","","","","","","2024072221849","Palmas","Palmas","2024-07-22 16:04:08","","All","","");
INSERT INTO patients_record VALUES("1202","2024072283381","Aubrie","Valdez","2011-08-10","","","","114/78","98.5","","73","126.6","63","99","2024072220906","Castle Hills","Castle Hills","2024-07-22 16:14:38","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1203","2024072270789","","","","","","","","","","","","","","2024072218432","Palmas","Palmas","2024-07-22 16:37:30","","","","");
INSERT INTO patients_record VALUES("1204","2024072223333","test","test","1993-04-27","","","","132/86","98.0","17","89","177","68","97","2024072235145","Palmas","Palmas","2024-07-22 16:38:45","abdominal pain, pt indicates the pain is 8 of 10. Pain began when he woke up in the morning at 7:30. 
hx patient has history of colitis
  ","All","","");
INSERT INTO patients_record VALUES("1205","2024072220913","emiliano","tino","1979-08-08","","","","133/86","98.3","18","68","178","69","97","2024072211325","VAM","VAM","2024-07-22 16:44:21","pt states has congestion and voice is raspy 
pt states both ears feels diffrent 
pt states throat feels scratchy 
pt states has alot of mucus
pt states his daughter mild 

allergies: none 
pharmacy: Walgreens Pharmacy at 
1088 W MAIN ST League City, TX 77573
Cross streets: Northeast corner of CALDER & F.M. 518

Phone : 281-332-3445","All","Yes","Finish");
INSERT INTO patients_record VALUES("1206","2024072223333","test","test","1993-04-27","","","","132/86","98.0","17","89","177","68","97","2024072235145","Palmas","Palmas","2024-07-22 16:44:44","abdominal pain, pt indicates the pain is 8 of 10. Pain began when he woke up in the morning at 7:30. 
hx patient has history of colitis
  ","All","","");
INSERT INTO patients_record VALUES("1207","2024072223333","test","test","1993-04-27","","","","132/86","98.0","17","89","177","68","97","2024072235145","Palmas","Palmas","2024-07-22 16:44:54","abdominal pain, pt indicates the pain is 8 of 10. Pain began when he woke up in the morning at 7:30. 
hx patient has history of colitis
  ","All","","");
INSERT INTO patients_record VALUES("1208","2024072210537","Andera","Silva","2011-07-31","","","","111/66","98.5","","64","139","64","99","2024072236679","Castle Hills","Castle Hills","2024-07-22 17:06:57","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1209","2024072269950","Dalianis","Roque","1994-11-29","","","","108/68","98.9","","74","127","61","98","2024072240837","Humble","Humble","2024-07-22 17:28:46","Pt needs pre-op bw done, surgery is 08/13/24 in Miami, FL
Pt LMP, 06/30/24, not preg now


Allergies: NKDA
Pharmacy: 
Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778","All","Yes","Ready");
INSERT INTO patients_record VALUES("1210","2024072363091","CHRISTOPHER","VILLAGOMEZ","1990-09-23","","","","140/93","98.0","18","68","240","61","95","2024072323355","VAM","VAM","2024-07-23 14:10:37","pt here for blood results
NKDA
Walgreens 
on file","All","Yes","Finish");
INSERT INTO patients_record VALUES("1211","2024072349087","Amanda","Valdez","1986-11-05","","","","134/28","98.6","","86","151","66","96","2024072328534","Castle Hills","Castle Hills","2024-07-23 14:26:22","ER Follow up","All","Yes","Finish");
INSERT INTO patients_record VALUES("1212","2024072311601","test","test","1976-10-10","","","","","","","","","","","2024072347956","Palmas","Palmas","2024-07-23 17:51:56","","All","","");
INSERT INTO patients_record VALUES("1213","2024072350885","Test","test","1976-10-10","","","","","","","","","","","202407238670","Palmas","Palmas","2024-07-23 17:55:24","","All","","");
INSERT INTO patients_record VALUES("1214","2024072319257","James E ","White","1972-09-17","","","","150/86","98.3","18","76","268.5","73","98","2024072345350","VAM","VAM","2024-07-23 21:25:32","Pt here with flu like symptoms
alergic to : Demurral
pref. pharmacy
Krogers
2301 Rayford Rd Spring, TX 77386
832 813-0300","All","Yes","Finish");
INSERT INTO patients_record VALUES("1215","2024072410582","","","","","","","","","","","","","","2024072423588","VAM","VAM","2024-07-24 13:46:05","","","","");
INSERT INTO patients_record VALUES("1216","2024072421686","Esmeralda ","Lopez","1998-05-20","","","","166/99","98.0","22","95","320.5","64","98","2024072424427","VAM","VAM","2024-07-24 17:39:04","Pt here for follow up 7/17/24
no nausea or no vomiting
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1217","2024072466773","Michael","Lenton","2012-09-06","","","","105/54","97.9","18","68","142","59","98","2024072441375","Castle Hills","Castle Hills","2024-07-24 21:09:16","11 y/o for Sports Physical

NKDA 

RX Walgreen 7019 Zarzamora SA Tx","All","Yes","Finish");
INSERT INTO patients_record VALUES("1218","2024072448527","Michael","lenton","2012-09-06","","","","105/54","97.9","18","68","142","59","98","2024072430490","Castle Hills","Castle Hills","2024-07-24 21:19:55","11 y/o for Sprots Physical

NKDA

RX: 7019 S Zarzamora","All","Yes","Finish");
INSERT INTO patients_record VALUES("1219","2024072466771","Michael","Lenton","2012-09-06","","","","105/54","97.8","18","68","142","68","98","202407243528","Castle Hills","Castle Hills","2024-07-24 21:29:43","11 y/o for sports phy

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1220","2024072465464","Michael","Lenton","","","","","","","","","","","","2024072425218","Castle Hills","Castle Hills","2024-07-24 21:42:57","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1221","2024072436236","Jose","Anaya","1988-04-29","","","","162/97","98.5","22","106","175.0","66","98","2024072426932","VAM","VAM","2024-07-24 21:44:27","pt here with back pain for 2days
has taken Diclofenac for 2 days
NKDA
Pref. Pharm
Walgreens
107 West Rankin Rd
239 309-8398","All","Yes","Finish");
INSERT INTO patients_record VALUES("1222","2024072429393","test","Castle Hills","1970-08-16","","","","","","","","","","","2024072413951","Castle Hills","Castle Hills","2024-07-24 22:00:24","","All","","");
INSERT INTO patients_record VALUES("1223","2024072417222","TEST","","","","","","","","","","","","","2024072429817","Castle Hills","Castle Hills","2024-07-24 22:10:15","","All","","");
INSERT INTO patients_record VALUES("1224","2024072530484","ADRIAN","VALVANEDA","1989-06-14","","","","124/78","99.6","18","72","180","68","98","202407256499","VAM","VAM","2024-07-25 14:30:51","PT STATES HAS A HEADACHE AND SORETHROAT  WITH BODYACHES THAT STARTED LAST NIGHT 
PT STATES NO ONE AT HOME IS SICK 
PT STATES MAY HAVE FEVER AND ALSO HAS SLIGHT EAR PAIN
PT STATES TOOK 400MG IBUPROFEN NO RELIEF 


ALLERGIES: NONE 
PHARMACY: HEB 
(281) 907-7950

Street map of this store
2121 FM 2920
SPRING, TX 77388-3412","All","Yes","Finish");
INSERT INTO patients_record VALUES("1225","2024072547036","Jason","Goldman","1996-07-27","","","","126/63","98.4","","77","180","69","94","202407257628","Humble","Humble","2024-07-25 17:16:23","Pt is having chest pains for the last 6 months on an doff, no light head or dizziness
Pt has a headaches, no vomiting or nausea
Pt states it comes in waves the pain, middle of sternum 

Allergies: NKDA  

Pharmacy: 
Address: 19300 W Lake Houston Pkwy, Humble, TX 77346
Hours: 
Closes soon ⋅ 1 PM ⋅ Reopens 1:30 PM
Phone: (281) 812-4499","All","Yes","Finish");
INSERT INTO patients_record VALUES("1226","2024072514433","JOSE ","robles","1987-02-17","","","","143/84","98.7","18","69","245","72","98","2024072516007","VAM","VAM","2024-07-25 18:10:59","PT STATES IS HAVING LOWER BACK PAIN THAT STARTED LAST WEEK WEDNESDAY 
PT STATES DOES NOT RECALL INJURY OR LIFTING ANYTHING HEAVY
PT STATES WHEN HE TAKES A BREATH IS WHEN HE FEELS LOWER BACK PAIN 
PT STATES HAS NOT TAKEN ANYTHING FOR PAIN 
PT STATES WHN MOVING PAIN IS 8/10
PT STATES PAIN IS ON BOTH SIDES OF LOWER BACK

ALLERGIES: NONE 
PHARMACY: Store #10613

Walgreens Pharmacy at 
32320 STATE HIGHWAY 249 Pinehurst, TX 77362
Cross streets: Southeast corner of SH 249 & HARDIN STORE

Phone : 832-934-0415","All","Yes","Finish");
INSERT INTO patients_record VALUES("1227","2024072510092","CIPRIANO","HERNANDEZ","1981-02-02","","","","138/87","97.8","18","53","285","66","98","2024072544617","VAM","VAM","2024-07-25 20:10:39","PT STATES HIS LEFT EAR HAS SLIGHT PRESSURE FEELS LIKE SOMETHING IS INSIDE 
PT STATES HAS BEEN EXPERIEBCING PRESSURE IN THE EAR FOR 2 WEEKS 
PT STATES HAS NO PAIN 
PT STATES NO DISCHARGE NO PAIN SLIGHT PRESSURE 


ALLERGIES: NONE 
PHARMACY: KROGER Pharmacy
713–453–8446

View My Prescriptions
Schedule a Vaccine
Open until 8 PM
Sun: 10 AM - 5 PM
Mon - Fri: 8 AM - 8 PM","All","Yes","Finish");
INSERT INTO patients_record VALUES("1228","2024072544503","LUIS","MERAZ","1981-02-27","","","","124/79","98.1","18","60","160","65","99","2024072526124","VAM","VAM","2024-07-25 21:01:19","PT IS HERE FOR WELLNESS LABS 
PT STATES LAST TIME HE DID BLOODWORK WAS LASY YR 
PT STATES LAST YEAR WAS TOLD HE HAD A FATTY LIVER 
PT STATES WILL NEED REFILL LISINPRIL 10MG PT STATES STOP TAKING IT 2 MONTHS AGO 
PT STATES HAS CONSTANT PAIN IN LOWER BACK BOTH SIDES 



ALLERGIES: NONE
PHARMACY:Store #2428

Walgreens Pharmacy at 
2717 FM 1960 RD Houston, TX 77073
Cross streets: Northeast corner of TREASCHWIG & FM 1960

Phone : 281-443-2591","All","Yes","Finish");
INSERT INTO patients_record VALUES("1229","2024072547611","April","Lara","1990-04-22","","","","126/81","97.8","18","69","180","62","98","2024072540995","Castle Hills","Castle Hills","2024-07-25 21:58:42","painful lymph nodes

rx: heb 210-969-1073

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1230","2024072659414","Julio ","Munoz","1996-02-09","","","","140/82","98.6","18","99","170","57","98","20240726162","Palmas","Palmas","2024-07-26 14:19:04","28 years old male patient visit the clinic c/o sore throat, fever an headache since yesterday at night. Patient was not in contact with person with covid or flu.
Allergies: no
Medications: no
Surgery: no
Pharmacy: Walgreens Calle Cruz Stella
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1231","2024072696403","jose ","robles","1987-02-17","","","","123/77","97.6","18","66","245","72","98","2024072636297","VAM","VAM","2024-07-26 14:19:41","pt is here for blood draw
pt has concerns for bp

allergies: none","All","Yes","Finish");
INSERT INTO patients_record VALUES("1232","2024072681030","edgar","VASQUEZ","1993-02-19","","","","125/74","97.5","18","72","245","72","97","2024072625177","VAM","VAM","2024-07-26 14:52:52","pt is here for a f/u o his lipid panel 
pt was recommended to diet and exercise 
pt states was prescribed medication for triglyceride and cholesterol 
pt states is fasting today 


allergies: none 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1233","2024072638766","Celeste","Jones","1976-07-18","","","","142/90","97.7","18","65","213","59","98","20240726801","Palmas","Palmas","2024-07-26 15:18:40","48 years old female patient c/o suffering from migraines due to stress , need doctors notes for time off work and follow up on bp medication and also migraine medications. 
Allergies: no
Medications: Amlodipine 160mg 
Pharmacy: Walgreens Calle Cruz Stella","All","Yes","Finish");
INSERT INTO patients_record VALUES("1234","2024072647914","Amanda","Torrez","1983-04-30","","","","112/67","98.3","","80","204","65","96","2024072616216","Humble","Humble","2024-07-26 15:35:49","Pt has been having flu like symptoms for the past 3 days, with nasal congestion/pressure
Pt has been taking Allegra D for the past 3 day, Ears also hurting, with R side headaches

Allergies: NKDA

Pharmacy: 
Kroger
Address: 3820 Atascocita Road, Humble, TX 77396
Hours: 
Open ⋅ Closes 1 PM ⋅ Reopens 1:30 PM
 · More hours
Confirmed by this business 10 weeks ago
Phone: (281) 812-6397  ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1235","2024072622710","Saire","Dolberry","2010-01-20","","","","132/68","97.2","17","65","116","66","96","2024072632800","Castle Hills","Castle Hills","2024-07-26 16:54:52","sports physical

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1236","2024072624341","Bella","Hughes","2011-06-30","","","","109/61","97.4","19","84","130","61","98","2024072639555","Castle Hills","Castle Hills","2024-07-26 18:24:13","Sports Physical

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1237","2024072638102","Logan","Johnson","1988-08-22","","","","135/70","99.1","","70","233","70","98","2024072611697","Humble","Humble","2024-07-26 18:25:55","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1238","2024072643823","Lilee-Ana","Villanueva","2008-08-06","","","","114/73","97.7","19","94","","","96","2024072627267","Castle Hills","Castle Hills","2024-07-26 19:51:01","sore throat

Rx: 210-495-0572

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1239","2024072672549","Khalil","Jupiter","2004-08-24","","","","91/50","98.6","16","76","116","60","98","202407266955","Humble","Humble","2024-07-26 20:01:32","Pt needs a sports physical for cheer
Pt states has done it for 5 years and no issues in the pass

Allergies: NKDA

Pharmacy: Lives in Los Angeles, here for summer break ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1240","2024072617068","jose","anaya","1988-04-29","","","","123/75","98.7","18","95","175","66","97","2024072615901","VAM","VAM","2024-07-26 20:32:50","pt is here f/u from last visit pt states has been experiencing sharp pain on his lower back on both sides 
pt states it has made it difficult to get out of bed and walk without pain 
pt states was prescribed anti inflammatory and muscle relaxer for pain 
pt states medication has been working slightly but still has a heavy limp 
pt would like more days off to get better 
pt states is experiencing constipation and would like a recommendation on what to do
pt states pain is local  and pain today is 7/10 when getting up 

allergies: none","All","Yes","Finish");
INSERT INTO patients_record VALUES("1241","2024072675224","Paola","Ramirez Martinez","2009-11-20","","","","124/76","97.6","17","88","175","61","99","202407269481","Castle Hills","Castle Hills","2024-07-26 20:54:19","Sports Physical

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1242","2024072615668","Howard","Phillips","1984-04-18","","","","140/89","97.1","17","100","140","60","98","2024072635101","Palmas","Palmas","2024-07-26 20:55:22","40 years male patient visit the clinic c/o  stomach pain . 
Allergies: Septra
Medications: no
Surgery: Ear tubes, lungs
Pharmacy: Walgreens Calle Cruz Stella 
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1243","2024072681075","manuel","ayala","1965-06-07","","","","160/77","99.6","18","74","175","67","96","2024072610878","VAM","VAM","2024-07-26 21:54:41","pt states yesterday was exposed with an employee that has covid 
pt states today has been having body aches chills congestion sore throat headache 
pt states no one at home is sick 
pt states has not taken anything for symptoms 
pt states has been vaccinated 3 times
pt is covid positive today 


allergies; none 
pharmacy: Store #7725

Walgreens Pharmacy at 
14625 FM 529 RD Houston, TX 77095
Cross streets: Southeast corner of HUFFMEISTER & FM 529

Phone : 281-463-9088","All","Yes","Finish");
INSERT INTO patients_record VALUES("1244","2024072613650","Jason","Goldman","1996-07-27","","","","120/69","98.3","","76","180","69","95","2024072632579","Humble","Humble","2024-07-26 22:34:34","Pt is here for fu from bw","All","Yes","Finish");
INSERT INTO patients_record VALUES("1245","2024072757715","Cherece","Mendieta","1973-06-23","","","","125/70","98.4","","58","165","66","97","2024072717160","Humble","Humble","2024-07-27 18:33:28","Pain and Redness in Both Eyes

Scratch in Eye ( Left )

Headaches

Walmart 
155 Louetta Crossing
Spring, TX 77373
281-651-0216","All","Yes","Finish");
INSERT INTO patients_record VALUES("1246","2024072869180","TEST","TEST","1989-01-02","","","","","","","","","","","2024072831155","Castle Hills","Castle Hills","2024-07-28 16:53:51","tEST cALL","All","Yes","Finish");
INSERT INTO patients_record VALUES("1247","2024072982136","","","","","","","","","","","","","","2024072947628","Palmas","Palmas","2024-07-29 14:04:05","","All","","");
INSERT INTO patients_record VALUES("1248","2024072994491","edgar","VASQUEZ","1993-02-19","","","","128/77","98.7","18","75","245","72","98","2024072936008","VAM","VAM","2024-07-29 14:28:59","pt is here to discuss lab results 

allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1249","2024072940267","Joshua","Pushia","2010-08-21","","","","114/60","99.2","","55","119.2","63","98","2024072930617","Humble","Humble","2024-07-29 15:27:52","Pt is here for Sports physical
Pt plays soccer and Cross country 

Allergies: NKDA

Pharmacy: 
Store #9203
Walgreens Pharmacy at 
9510 N SAM HOUSTON PKWY E Humble, TX 77396
Cross streets: Southeast corner of WILSON & BELTWAY 8","All","Yes","Finish");
INSERT INTO patients_record VALUES("1250","2024072959026","robert","lopez","1979-05-31","","","","","","","","229","67","","2024072942423","VAM","VAM","2024-07-29 15:38:31","pt is here with symptoms ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1251","2024072930470","Emily ","owens","1990-05-10","","","","140/97","97.9","18","78","310","69","98","2024072938815","VAM","VAM","2024-07-29 16:57:10","pt states symptoms began yesterday 
pt states bodyaches congestion cough fever weak 
pt has dizzyness 

positive for covid
allergies:none 
pharmacy: walgreens 2813585458","All","Yes","Finish");
INSERT INTO patients_record VALUES("1252","2024072926560","Maverick Elias ","HEATH","2023-06-06","","","","","98.5","19","","22 LBS","","99","2024072938918","Palmas","Palmas","2024-07-29 19:04:53","13 MONTHS OLD WITH A MOSQUITO BITE 4 DAYS AGO WITH RASH ALL OVER HIS BODY.
ALLERGIES: NO
 VACCINES: NO VACCINES","All","","");
INSERT INTO patients_record VALUES("1253","2024072911534","MAVERICK ELIAS ","HEATH","2023-06-06","","","","","","","","","","","2024072949001","Palmas","Palmas","2024-07-29 19:11:54","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1254","2024072926556","Sol","Velasquez","2008-11-04","","","","111/64","97.3","17","66","148","70","97","2024072940501","Castle Hills","Castle Hills","2024-07-29 19:37:33","sports physical

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1255","2024072998621","","","","","","","","","","","","","","2024072934385","Palmas","Palmas","2024-07-29 19:43:05","","All","","");
INSERT INTO patients_record VALUES("1256","2024072923078","luis","meraz","1981-02-27","","","","139/87","98.6","18","82","165","66","97","2024072932431","VAM","VAM","2024-07-29 20:13:16","pt is here to discuss bloodwork 
pt states has no symptoms 


allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1257","2024072956992","nathan ","canter","1966-06-16","","","","120/73","97.8","18","72","210","67","96","2024072916888","VAM","VAM","2024-07-29 20:34:37","positive for covid 

allergies none

pharmacy: same as last time","All","Yes","Ready");
INSERT INTO patients_record VALUES("1258","2024072998584","Sophie","Perkins","1998-01-30","","","","129/85","101.5","18","83","131","63","99","2024072924926","Palmas","Palmas","2024-07-29 20:56:09","Lab results.
Allergies : gluten
Meds: no

","All","","");
INSERT INTO patients_record VALUES("1259","2024072970282","aron","westmoreland","1978-07-05","","","","146/90","97.8","18","77","190","70","97","2024072922647","VAM","VAM","2024-07-29 21:00:10","pt is positive for covid 

allergies: none 
personal number 3465993604
 pharmacy: same thats on file ","All","Yes","Ready");
INSERT INTO patients_record VALUES("1260","2024072926936","Taylor","Day","1998-10-06","","","","126/75","98.2","81","79","150","67","99","2024072916305","Palmas","Palmas","2024-07-29 21:03:29","Lab results NP
Allergies: no 
Meds: no","All","Yes","Finish");
INSERT INTO patients_record VALUES("1261","2024072929355","Ranasia","watson","2009-06-13","","","","94/53","98.6","","96","137","61","96","2024072936332","Humble","Humble","2024-07-29 21:35:04","Pt is here for a sports physical for volleyball, first sport

Allergies: NKDA

Pharmacy: ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1262","2024072985214","Dramell","Lamar","2006-10-10","","","","147/75","97.3","19","64","240","71","96","2024072944437","Castle Hills","Castle Hills","2024-07-29 22:36:06","Sports Physical

allergies: penicillin","All","Yes","Finish");
INSERT INTO patients_record VALUES("1263","2024073088383","Carl","Alfaro","2009-11-05","","","","110/57","97.4","16","55","114","64","98","2024073041849","Castle Hills","Castle Hills","2024-07-30 14:58:40","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1264","2024073073061","francisco","esquivel","1995-01-18","","","","136/87","97.6","18","76","185","70","97","2024073042064","VAM","VAM","2024-07-30 15:02:48","pt states symptoms began 2 days ago 
body aches fatigue headache coughing and congestion 
pt states was exposed to someone with covid 
pt states has pressure in both eyes
pt states only took a advil minimum relief 

allergies: none 
pharmacy: walmart Pharmacy
Open·until 7pm
Mon - Sat | 9am - 7pm
Sun | 10am - 6pm
Refill a prescription

Collapse Pharmacy
281-852-4466","All","Yes","Ready");
INSERT INTO patients_record VALUES("1265","2024073095370","francisco","esquivel","1995-01-18","","","","136/87","97.6","18","76","195","70","97","2024073046671","VAM","VAM","2024-07-30 15:15:19","pt states symptoms began 2 days ago
pt states has bodyaches cough facial pressure congestion 
pt states has headaches 
pt states took advil no relief 
pt states was exposed to covid 
pt states has not been vaccinated 

positive for covid 
allergies: none 
pharmacy: walmart  Pharmacy
Open·until 7pm
Mon - Sat | 9am - 7pm
Sun | 10am - 6pm
Refill a prescription

Collapse Pharmacy
281-852-4466","All","","");
INSERT INTO patients_record VALUES("1266","2024073035373","francisco","esquivel","1995-01-18","","","","","","","","","70","97","202407306724","VAM","VAM","2024-07-30 15:20:33","pt started symptoms 2 day ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1267","2024073022963","Jason","Goldman","1996-07-27","","","","107/59","98.1","","78","180","69","96","2024073031766","Humble","Humble","2024-07-30 15:29:42","Pt is here for a follow up for bw","All","Yes","Finish");
INSERT INTO patients_record VALUES("1268","2024073075173","Gregory","Bissell","1973-05-08","","","","123/74","99.2","18","73","160","69","97","2024073035397","Palmas","Palmas","2024-07-30 15:58:10","Join pain, neck pain with vertigo and dizziness.
 Allergies: no
Meds: sertraline 50 mg once a day","All","Yes","Ready");
INSERT INTO patients_record VALUES("1269","2024073054959","alberto","sanchez","1983-03-26","","","","145/94","100.0","18","115","211","68","99","2024073048410","VAM","VAM","2024-07-30 17:01:55","pt is here experiencing symptoms began with a scratchy throat started Saturday 
pt states had covid last month and states still has congestion and coughing 
pt states has stuffy nose 
pt states took Mucinex and ibuprofen mild relief 
pt states no one at home is sick 

PATIENT IS POSITIVE FOR COVID 




allergies: none 
pharmacy:    HEB Pharmacy
Pharmacy Phone:
(281) 353-2420
Mon-Fri
8:00 AM - 8:00 PM
Sat
9:00 AM - 6:00 PM","All","Yes","Finish");
INSERT INTO patients_record VALUES("1270","2024073041234","Camila","Serna","2009-08-09","","","","119/72","97.6","17","65","145","65","98","2024073015940","Castle Hills","Castle Hills","2024-07-30 18:27:41","sports physical

allergies: amoxicillan","All","Yes","Finish");
INSERT INTO patients_record VALUES("1271","2024073010394","Kash","Burns","2018-11-28","","","","80/44","98.9","","90","42","44","96","2024073047768","Humble","Humble","2024-07-30 20:27:36","Pt is here for back to school physical
Pts vaccines are up to date
Pt is 5 years old and going to kindergarten

Allergies:  NKDA  ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1272","2024073013955","Noe","Garza","2011-07-08","","","","122/69","97.4","17","81","145","62","97","2024073048373","Castle Hills","Castle Hills","2024-07-30 22:55:14","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1273","2024073125190","Jose","Robles","1987-02-17","","","","142/86","98.3","18","79","245","72","98","2024073137320","VAM","VAM","2024-07-31 14:09:40","Pt is here for blood test results

NKDA

Pref. PHARM
Walgreens
32320 STATE HIGHWAY 249 Pinehurst, TX 77362
(832) 934-0415","All","Yes","Finish");
INSERT INTO patients_record VALUES("1274","2024073148476","","","","","","","","","","","","","","2024073143892","Palmas","Palmas","2024-07-31 14:52:20","","All","","");
INSERT INTO patients_record VALUES("1275","2024073150035","TEST","Castle Hills","1970-08-16","","","","105/54","98.5","17","68","160","66","99","2024073133148","Castle Hills","Castle Hills","2024-07-31 14:53:58","","All","","");
INSERT INTO patients_record VALUES("1276","2024073193662","Alexander","Arias","1999-08-31","","","","131/83","97.9","20","100","295.6","72","87","20240731707","VAM","VAM","2024-07-31 15:16:07","Pt here with fever, chills, body achesFor 3 days
NKDA
Pref. Pharm.
Walgreens
12097 Veterans Memorial Dr
Hou. Tx 77067
281 444-6304","All","Yes","Finish");
INSERT INTO patients_record VALUES("1277","2024073116468","Manuel","Ayala","1965-06-07","","","","144/77","98.9","18","71","177.7","67","96","2024073136587","VAM","VAM","2024-07-31 15:31:23","patient is here to get retested for COVID

NKDA

Pref. Pharm.

Walgreens
14625 FM 529 RD Houston, TX 77095
281-463-9088
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1278","2024073165293","Garrett","Mendelsohn","1993-06-23","","","","133/83","97.7","18","76","200","71","97","2024073128206","Palmas","Palmas","2024-07-31 15:56:16","31 years old male patient visit the clinic c/o a lump on the neck. Patient refer that he sneeze and he felt a lump the right side of the neck. Patient not have pain at the moment. 

Allergies: ChloraPrep 
Medication: Testosterone, anastrozole
Surgery: Feet ( both)
Pharmacy:  Walgreens Calle Cruz Stella
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1279","2024073112259","Draeden","Bailey","2011-03-02","","","","101/63, 104/64, 106/67","98.1","18","78","122","66.5","97","20240731813","Castle Hills","Castle Hills","2024-07-31 17:28:18","13 y/o male patient for Sports Physical

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1280","2024073187988","Danny","Davis","1982-12-11","","","","124/79","99.8","","90","170","68","97","2024073140136","Humble","Humble","2024-07-31 18:07:32","Pt has light cough, chest pressure, itchy throat, slight headache
Pt came with wife and wife was sick a week ago with runny nose and sore throat, over it now
Pt works in an office and wife works from home
Pt states this all started last night

Allergies: NKDA

Pharmacy: Kroger 
Address: 3820 Atascocita Road, Humble, TX 77396
Hours: 
Opens soon ⋅ 1:30 PM
 · More hours
Confirmed by this business 11 weeks ago
Phone: (281) 812-6397","All","Yes","Finish");
INSERT INTO patients_record VALUES("1281","2024073129341","Sacha","Sparrow","2012-10-08","","","","128/83","96.9","18","76","105","61","97","2024073113636","Palmas","Palmas","2024-07-31 18:37:51","11 years old female patient visit the clinic in company of his mom c/o rash since Monday the mom noticed in the forearm, right hand and both feet. Patient refer she feel like itching in the rash areas.
Allergies: no
Mom gave Benadryl (1:15pm)
Pharmacy: Walgreens Calle Cruz Stella
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1282","2024073182440","Nanayakkara","Crishanthi","1995-02-12","","","","119/77","98.9","20","69","188.9","68","99","2024073120359","VAM","VAM","2024-07-31 21:28:09","Pt here with here with covid flu like symptoms for 3 days. 
Allergic: Clindamycin
Pref. Pharmacy

Walgreens
11994 RICHMOND AVE Houston, TX 77082
281-556-5918
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1283","2024080156378","Jane","Griffith","2008-11-13","","","","114/70","98.6","82","","140","66","99","2024080139670","Castle Hills","Castle Hills","2024-08-01 14:01:38","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1284","2024080122758","dwayne","smith","1960-03-23","","","","162/83","97.4","18","71","365","76","95","202408014712","VAM","VAM","2024-08-01 14:08:02","pt is here for a wellness exam 
pt states is fasting today 

allergies: codeine ( rash ) ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1285","2024080147658","Michael","Crowe","2008-11-30","","","","147/84*140/83*147/86","98.5","","67","195","73","99","2024080135319","Castle Hills","Castle Hills","2024-08-01 15:00:57","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1286","2024080177561","John","Crowe","2007-01-24","","","","108/61*118/67*119/68","98.5","","84","190","69","99","2024080146473","Castle Hills","Castle Hills","2024-08-01 15:36:11","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1287","2024080115545","Alitza ","Flores","2011-12-19","","","","105/55*123/45*96/57","98.6","","90","77","55","95","2024080131279","Castle Hills","Castle Hills","2024-08-01 20:40:37","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1288","2024080178352","April","Lara","1990-04-22","","","","123/83","","","77","175","62","99","2024080147910","Castle Hills","Castle Hills","2024-08-01 22:13:14","Lab results","All","Yes","Finish");
INSERT INTO patients_record VALUES("1289","2024080232500","TEST","TEST","","","","","","","","","","","","2024080230975","Castle Hills","Castle Hills","2024-08-02 13:53:54","Test Call","All","Yes","Finish");
INSERT INTO patients_record VALUES("1290","2024080275950","rafael","RUIZ","1994-11-27","","","","137/79","97.8","18","63","180","69","100","2024080248033","VAM","VAM","2024-08-02 14:13:52","pt is here for wellness labs 
pt states last time he did bloodwork was 2 yrs ago 
pt states was told he had high bp 
pt states has high bp in fam 
pt states is fasting 


allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1291","2024080231656","fernando ","lopez","1959-01-01","","","","137/99","97.9","18","77","214","73","98","2024080227701","VAM","VAM","2024-08-02 14:20:57","pt is here f/u on rt shoulder that he is still experiencing pain 
pt states medication was given gave him some relief but pain came back 
pt states pain wakes him up at night when he lays on rt side 
pt states gets numbness on the rt side shoulder that comes and goes 
pt states takes aleve minimum relief 


allergies: none 
pharmacy ocated in: WALGREENS
Address: 1501 W Church St Ste 500, Livingston, TX 77351
Hours: 
Open ⋅ Closes 1:30 PM ⋅ Reopens 2 PM
 · More hours
Confirmed by this business 3 weeks ago
Phone: (936) 327-1086
Suggest an edit","All","Yes","Finish");
INSERT INTO patients_record VALUES("1292","2024080223047","Howard ","Phillips","1984-04-18","","","","119/75","98.2","18","103","140","69","98","2024080237627","Palmas","Palmas","2024-08-02 14:45:03","Lab Results","All","Yes","Finish");
INSERT INTO patients_record VALUES("1293","2024080224533","roger","rodriguez","1993-11-14","","","","120/68","99.6","18","88","169","66","97","2024080211956","VAM","VAM","2024-08-02 15:39:29","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1294","2024080211659","Abran","Almanza","2008-05-26","","","","121/72*130/80*132/84","","","79","121","69","98","2024080246941","Castle Hills","Castle Hills","2024-08-02 16:14:29","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1295","2024080246352","Rodarte","Joaquin","2008-06-08","","","","131/79*122/79*122/82","98.6","","84","148.6","71","97","202408023067","Castle Hills","Castle Hills","2024-08-02 18:46:06","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1296","2024080275247","xavier","brumfield","1990-07-28","","","","139/82","98.7","18","80","220","72","95","2024080243590","VAM","VAM","2024-08-02 19:58:22","pt states has been experiencing lower middle back pain 
pt states pain began last Saturday 
pt states have been having cramps i his stomached 
pt states symptoms comes and goes 
pt states back pain aggravates when laying flat 


allergies: none 
pharmacy: Store #6619

Walgreens Pharmacy at 
1215 W 43RD ST Houston, TX 77018
Cross streets: Southwest corner of ELLA & 43RD

Phone : 713-956-1827","All","Yes","Finish");
INSERT INTO patients_record VALUES("1297","2024080284740","martin","pastrano","1970-06-15","","","","152/82","97.7","18","80","192","66","98","2024080242115","VAM","VAM","2024-08-02 20:34:08","pt states symptoms began 1 day ago 
pt states today woke up with chills fatigue bodyaches 
pt states has a runny nose dry mouth 
pt states has been vaccinated 
pt states never had covid 
pt states has heart condition 


positive for covid today
allergies: none 
pharmacy:Store #9601

Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON

Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1298","2024080281666","Pei Hua","Cai","1944-01-07","","","","138/77","97.5","17","78","108","58","97","2024080243408","Palmas","Palmas","2024-08-02 21:06:30","79 years old female patient visit the clinic c/o rash on the body . She feels itching on the area of the rash.
Allergies: no
Medications :Eliquis, Benazepril, Thyroid ( Armour)
Pharmacy: Walgreens Calle Cruz Stella
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1299","2024080292629","Destiny","Salinas","1999-02-04","","","","120/81","98.6","","105","260","66","99","2024080227240","Castle Hills","Castle Hills","2024-08-02 21:21:52","Discomfort Swallowing","All","Yes","Finish");
INSERT INTO patients_record VALUES("1300","2024080246776","Avan","Leija","2009-05-14","","","","123/65","98.6","","70","207.6","70","98","2024080237580","Castle Hills","Castle Hills","2024-08-02 22:05:04","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1301","2024080285030","Amanda ","Valdez","1986-11-05","","","","127/83","98.5","","85","246.8","66","98","2024080243436","Castle Hills","Castle Hills","2024-08-02 22:25:31","Lab review","All","Yes","Finish");
INSERT INTO patients_record VALUES("1302","2024080399037","","","","","","","","","","","","","","202408035575","Castle Hills","Castle Hills","2024-08-03 14:07:14","","","","");
INSERT INTO patients_record VALUES("1303","2024080323497","Saturday ","Test","2024-08-03","","","","1","1","1","1","1","1","1","202408038862","Castle Hills","Castle Hills","2024-08-03 14:26:00","HAPPY SATURDAY","All","Yes","Ready");
INSERT INTO patients_record VALUES("1304","2024080363649","Joseph","Gutierrez","2009-05-12","","","","124/75","97.1","17","63","103","63","98","2024080343616","Castle Hills","Castle Hills","2024-08-03 14:44:11","Sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1305","2024080332527","Teresa","Robledo","1963-10-15","","","","152/81","98.9","","89","276.6","65","91","2024080332286","Humble","Humble","2024-08-03 16:34:05","Coughing
Pain all over Body
Sweating 
Symptoms has been on site since 07/30/2024
Headaches
Patient stays that Family Travel to Cancun, Mexico and all arrived with same Symptoms 
Performed Covid and Flu Test ( Covid + )

NKA

Walgreens 
12959 Aldine Westfield Rd
Houston, TX 77039
","All","Yes","Finish");
INSERT INTO patients_record VALUES("1306","2024080367487","Jayden","Trinidad","2008-06-17","","","","122/73","97.4","19","54","161","71","98","2024080312356","Castle Hills","Castle Hills","2024-08-03 16:45:40","Sports Physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1307","2024080330275","Vincent","Villarreal","2010-08-20","","","","125/69","97.3","16","71","156","65","99","2024080344882","Castle Hills","Castle Hills","2024-08-03 18:16:43","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1308","2024080499034","Sunday","Test","2024-08-04","","","","1","1","1","1","1","1","1","2024080441428","Castle Hills","Castle Hills","2024-08-04 14:38:09","HAPPY SUNDAY","All","Yes","Finish");
INSERT INTO patients_record VALUES("1309","2024080499034","Sunday","Test","2024-08-04","","","","1","1","1","1","1","1","1","2024080441428","Castle Hills","Castle Hills","2024-08-04 14:38:51","HAPPY SUNDAY","All","Yes","Finish");
INSERT INTO patients_record VALUES("1310","2024080493854","Elijah","Martinez","2010-02-10","","","","129/77","97.2","18","101","130","60","99","2024080428066","Castle Hills","Castle Hills","2024-08-04 20:08:21","Sports Physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1311","2024080445870","Emani","Pyles","2009-09-21","","","","108/79","98.7","","101","111","60","99","2024080445397","Humble","Humble","2024-08-04 22:22:15","New Patient

Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1312","2024080444255","Jose","Cantu","2010-05-11","","","","119/67","97.5","16","68","116","65","97","2024080447176","Castle Hills","Castle Hills","2024-08-04 22:27:41","sports physical

ALLERGIES: Amoxicillin","All","Yes","Finish");
INSERT INTO patients_record VALUES("1313","2024080532022","Quang ","LE","2001-12-21","","","","126/82","97.8","18","78","270","73","98","2024080529775","VAM","VAM","2024-08-05 14:22:14","PT STATES YESTERDAY WAS PICKING UP HIS TRANSMISSION AND TIGHTENED UP WHEN LIFTING IT UP 
PT STATES NEXT DAY HAS BEEN HAVING CONSTANT PAIN ON BACK ON BOTH SIDES 
PT STATES TOOK 7 TYLENOL PILLS AT 5AM THATWHERE 5OOMG EACH 
PT STATES THE PAIN IS AT 8/10 
PT STATES IS HARD TO WORK 

ALLERGIES: NONE 
PHARMACY: WALGREENS Store #3661

Walgreens Pharmacy at 
6768 HIGHWAY 6 S Houston, TX 77083
Cross streets: HIGHWAY 6 & BELLAIRE

Phone : 281-530-9768","All","Yes","Finish");
INSERT INTO patients_record VALUES("1314","2024080518563","Quang ","LE","","","","","","","","","","","","2024080546680","VAM","VAM","2024-08-05 14:32:22","BACK PAIN","All","","");
INSERT INTO patients_record VALUES("1315","2024080548123","Quang ","LE","","","","","","","","","","","","2024080540036","VAM","VAM","2024-08-05 14:33:51","back pain","All","Yes","Finish");
INSERT INTO patients_record VALUES("1316","2024080522358","Andrew","Campos","1998-11-29","","","","104/57","99.5","","74","190","69","96","2024080543714","Humble","Humble","2024-08-05 15:38:21","Pt is here for lower back pain, more on R side, pain goes down to leg as well
Pt states he goes to the gym and plays soccer, pt is also a Plummer
Pt has trouble sleeping on R side at night, Pt has taken Tylenol and used patches/creams for pain as well

Allergies: NKDA

Pharmacy:
Store #7773
Walgreens Pharmacy at 
12959 ALDINE WESTFIELD RD Houston, TX 77039
Cross streets: Southwest corner of ALDINE WESTFIELD & ALDINE MAIL
Phone : 281-442-3604   ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1317","2024080570168","Test","test","1992-09-02","","","","","","","","","","","2024080546160","Palmas","Palmas","2024-08-05 16:07:14","","All","","");
INSERT INTO patients_record VALUES("1318","2024080581075","chuks","ugwuegbu","1982-03-01","","","","135/95","98.1","18","71","152","71","97","2024080532473","VAM","VAM","2024-08-05 16:12:35","pt states has been experiencing some symptoms of runny nose slight body aches and headache 
pt states he has heard some people in his budling with covid 
pt states took aleve this morning 
pt states no one at home is sick 
pt states has some nausea

allergies: none 
pharmacy: cvs tore ID: #5667

19715 TOMBALL PARKWAY, HOUSTON, TX 77070
Get directions
(281) 517-1767","All","Yes","Finish");
INSERT INTO patients_record VALUES("1319","2024080548687","Nicolas","Duran","2009-07-04","","","","130/74*125/75*130/76","98.6","","80","122.2","65","99","202408051300","Castle Hills","Castle Hills","2024-08-05 17:45:35","Sports physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1320","2024080598542","Oscar","Duran","2008-01-01","","","","130/75*132/79*134/81","98.5","","84","228","68","99","2024080510290","Castle Hills","Castle Hills","2024-08-05 18:29:32","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1321","2024080532507","ruben","duron sr ","1967-11-18","","","","142/92","98.2","18","76","215","65","96","2024080532441","VAM","VAM","2024-08-05 19:09:19","pt is here states has not been feeling good past few days 
pt states has been exposed to covid states coworkers has told him
pt has gotten tested last week and today and is negative today
pt states has been getting headaches backaches and chest pain 
pt states has been feeling tingling in lips 
pt alos states has been working in the heat for 7 days straight 
pt states has some symptoms that could be related to a possible heat stroke 
 allergies: none 
covid: negative 

pharmacy: Store #4133

Walgreens Pharmacy at 
3707 SPENCER HWY Pasadena, TX 77504
Cross streets: BURKE & SPENCER HIGHWAY

Phone : 713-946-4650","All","Yes","Finish");
INSERT INTO patients_record VALUES("1322","2024080573625","alex ","Ramirez","1974-08-25","","","","110/66","98.2","18","65","220","76","97","2024080534293","VAM","VAM","2024-08-05 20:05:53","pt states has been experiencing acid reflux for 2 weeks 
pt states has been eating spicy foods 
pt states has been taking alkacelzer that gave no relief
pt states has burning in chest 
pt states feels like something stuck in his esophagus  
pt states wife gave him a over the counter omeprazole that gave him some relief 
pt states anything he eats or drink is causing  a flare up 
pt states feels like something is stuck 

allergies: none 

pharmacy: walgreens  7137227247
12850 memorial dr houston tx 77024","All","Yes","Finish");
INSERT INTO patients_record VALUES("1323","2024080574147","xavier ","brumfield","1990-07-28","","","","132/84","98.4","18","82","220","72","98","2024080548403","VAM","VAM","2024-08-05 20:29:43","pt is here f/u from last visit 
pt states has new symptoms of all of back and inner chest pain 
pt states when he lays on rt and left side has pain 
pt states pain arises when laying down 


allergies: none 
pharmacy: same pharmacy","All","Yes","Finish");
INSERT INTO patients_record VALUES("1324","2024080527174","Edwien","Garcia","2012-08-16","","","","111/49","99.4","","90","127.2","61","94","2024080525223","Humble","Humble","2024-08-05 21:11:20","Pt is here for a sports physical for soccer
Pt has practice at another location, with no issues
Pt broke his jaw when he was 5 yr old

Allergies: NKDA

Pharmacy:   
Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1325","2024080533424","Edwin","Brizuela","2009-10-28","","","","131/73","98.4","","85","160","65","96","202408054684","Humble","Humble","2024-08-05 22:18:56","Pt is here or sports physical for soccer, pt has been playing for 3 yrs already

Allergies: NKDA

Pharmacy: Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778","All","Yes","Finish");
INSERT INTO patients_record VALUES("1326","2024080615475","Marlene","Morales","2021-01-01","","","","120/70","98","15","78","130","69","99","2024080630256","nurse1","Palmas Del Mar","2024-08-06 13:32:23","URI sxs x4 days
NKDA
Pharmacy: Walgreens 210-705-5050","All","Yes","Finish");
INSERT INTO patients_record VALUES("1327","2024080645199","M test","M test","2020-01-01","","","","110/69","98.1","15","60","160","69","99","2024080648495","nurse1","Palmas Del Mar","2024-08-06 13:40:55","uri 
nkda
walgreens","All","Yes","Finish");
INSERT INTO patients_record VALUES("1328","2024080677267","test","test","2010-10-10","","","","100/60","98.2","16","75","210","65","97","2024080635913","Palmas","Palmas","2024-08-06 14:14:36","fijbua][
q]E=","All","","");
INSERT INTO patients_record VALUES("1329","2024080639347","val test","RE","","","","","120/80","98.6","20","76","245","66","96","2024080631287","VAM","VAM","2024-08-06 14:33:40","
HELLO","All","Yes","Finish");
INSERT INTO patients_record VALUES("1330","2024080686478","Sabine","Cuny","2010-12-05","","","","111/61*106/60*105/57","98.6","","75","179","72","98","2024080625698","Castle Hills","Castle Hills","2024-08-06 15:05:32","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1331","2024080651189","test","test","1989-09-09","","","","120/80","98.6","18","67","190","65","98","202408061462","Humble","Humble","2024-08-06 15:49:38","back pain","All","Yes","Finish");
INSERT INTO patients_record VALUES("1332","2024080631036","Test","Test","","","","","","","","","","","","2024080616919","Castle Hills","Castle Hills","2024-08-06 16:07:19","Test Call","All","Yes","Finish");
INSERT INTO patients_record VALUES("1333","2024080639347","val test","RE","","","","","120/80","98.6","20","76","245","66","96","2024080631287","VAM","VAM","2024-08-06 16:22:30","
HELLO","All","Yes","Finish");
INSERT INTO patients_record VALUES("1334","2024080694623","Jose ","Velasquez","1968-03-19","","","","124/77","98.5","","73","255","65","97","2024080618302","Castle Hills","Castle Hills","2024-08-06 16:59:43","Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1335","2024080647120","Adeline","Gonzales","2019-11-19","","","","","97.7","20","103","41.7","","99","2024080638229","VAM","VAM","2024-08-06 17:09:11","Patient has urinating every 5 min but not much urine for last week.

NKDA

Pref pharmacy
on file","All","Yes","Finish");
INSERT INTO patients_record VALUES("1336","2024080643413","Garrett","Mendelsohn","1993-06-23","","","","142/74","98.2","18","63","200","73","99","2024080643809","Palmas","Palmas","2024-08-06 18:33:30","Lab and images results","All","","");
INSERT INTO patients_record VALUES("1337","2024080654935","Adeline","Gonzales","2019-11-19","","","","","","","","","","","2024080642965","VAM","VAM","2024-08-06 21:01:39","frequent urination","All","Yes","Ready");
INSERT INTO patients_record VALUES("1338","2024080622718","","","","","","","","","","","","","","2024080623299","VAM","VAM","2024-08-06 21:37:11","","","","");
INSERT INTO patients_record VALUES("1339","2024080695073","mickenzie","lynch","2009-11-24","","","","136/81","98.9","18","73","201.6","64","99","202408063048","Humble","Humble","2024-08-06 21:58:03","pt is here for sports physical 
pt Denys any allergies 
pt states does not wear prescribed lenese 
pt states is accompanied by mother  (leanne)

allergies: none 
 
patient passed eye exam 20/20 vision in both eyes ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1340","2024080736029","Pilar","Mata","1952-09-17","","","","132/71","97.8","","98","145","64","94","2024080748766","Humble","Humble","2024-08-07 13:59:07","Pt is here for possible bronchitis, 
Pt has been coughing hard for 3 days, w/frequent urination w/ weak bladder
Pt states the cough keeps her up at night, w/shortness of breathe, sometimes w/mucus
Pt has been taking Advil and Tylenol but no help, pt has rib/side pain

Allergies: NKDA

Pharmacy: Kroger
Will Clayton
3820 Atascocita Rd, Humble, TX, 77396
(281) 812-6397","All","Yes","Finish");
INSERT INTO patients_record VALUES("1341","2024080743587","TEST","CH TEST","1970-08-16","","","","105/54","98.6","18","84","160","66","99","2024080732835","Castle Hills","Castle Hills","2024-08-07 14:01:01","test","All","","");
INSERT INTO patients_record VALUES("1342","2024080754060","Rafael","Ruiz","1994-11-27","","","","","","","","","","","2024080713426","VAM","VAM","2024-08-07 14:09:00","","All","","");
INSERT INTO patients_record VALUES("1343","2024080733195","","","","","","","","","","","","","","20240807603","VAM","VAM","2024-08-07 14:28:33","","","","");
INSERT INTO patients_record VALUES("1344","2024080761285","Rafael","Ruiz","1994-11-27","","","","138/76","98.6","18","65","189.2","69","98","2024080746038","VAM","VAM","2024-08-07 14:29:16","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1345","2024080794594","Christine","Hernandez","2010-08-01","","","","111/61","97.8","18","70","128","61.5","97%","2024080742685","Castle Hills","Castle Hills","2024-08-07 14:46:48","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1346","2024080710981","Anna","Garza","1974-01-24","","","","128/74","99.1","16","79","202","65"","98%","2024080710376","Castle Hills","Castle Hills","2024-08-07 17:29:20","50 y/o female patient for office visit and possible blood work.  States has been about 2 years since last primary care visit.

NKDA

RX: Walmart Pharmacy Blanco Rd 210-591-6285","All","Yes","Finish");
INSERT INTO patients_record VALUES("1347","2024080769772","Adayis","Mendoza","2009-07-07","","","","104/61","97.1","16","64","136","69.5","97%","202408079425","Castle Hills","Castle Hills","2024-08-07 19:03:54","15 y/o Male patient for Sports physical.

NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1348","2024080710405","","","","","","","","","","","","","","20240807904","Castle Hills","Castle Hills","2024-08-07 20:13:13","","","","");
INSERT INTO patients_record VALUES("1349","2024080796786","Sunni-Bell","Urena","2012-08-15","","","","110/60","97.8","20","74","64.6","54"","97","2024080731071","Castle Hills","Castle Hills","2024-08-07 20:14:47","","All","","");
INSERT INTO patients_record VALUES("1350","2024080743820","Sunni-Bell","Urena","2012-08-15","","","","110/60","97.8","20","74","64.6","54","98","202408078595","Castle Hills","Castle Hills","2024-08-07 20:20:30","11 y/o female for Sports Physical
NKDA","All","Yes","Finish");
INSERT INTO patients_record VALUES("1351","2024080786460","Nathalie","Perez","1960-02-24","","","","116/69","98.2","18","74","170","65"","98","2024080734226","Castle Hills","Castle Hills","2024-08-07 20:52:40","64 y/o female patient complains of swelling and possible infection to gum line to lower left jaw x 4 days 

NKDA

Rx: Wal-Mart  Vance Jackson 210-737-0754","All","Yes","Finish");
INSERT INTO patients_record VALUES("1352","2024080763528","Faith","Lopez","2011-12-18","","","","116/65","97.9","18","65","93.6","60"","97%","2024080747258","Castle Hills","Castle Hills","2024-08-07 22:17:05","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1353","2024080794741","Elijah","Castaneda","2007-05-11","","","","119/65","97.9","18","59","169","65.5"","98%","202408072369","Castle Hills","Castle Hills","2024-08-07 22:52:20","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1354","2024080820966","Michelle","gage","1989-01-09","","","","120/80","98.6","18","","245","66","98","2024080816351","VAM","VAM","2024-08-08 14:28:42","sick visit","All","Yes","Finish");
INSERT INTO patients_record VALUES("1355","2024080834739","TEST","THURSDAY","2024-08-08","","","","1","1","12","1","1","1","1","2024080831673","Castle Hills","Castle Hills","2024-08-08 14:57:36","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("1356","2024080819658","test","Gonzales","1111-12-12","","","","120/80","97.9","18","76","245","66","98","2024080847138","VAM","VAM","2024-08-08 15:36:24","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("1357","2024080819009","JOHN","boyd","1963-02-03","","","","168/88","98.1","18","88","182","68","96","2024080821904","VAM","VAM","2024-08-08 15:39:08","pt states has been experiencing sciatica pain for 2 weeks 
pt states pain is weight barring 
pt states pain radiates to groin and leg where he fels a burning sensation 
pt states takes tylenol 
pt states standing is what aggravates it 


allergies: none 
pharmacy:   heb  Mon-Sun

6:00 AM - 11:00 PM

Store Phone:

(936) 272-2000

Pharmacy Phone:

(936) 272-1027

Street map of this store
12350 INTERSTATE 45 N,
WILLIS, TX 77378-9999","All","Yes","Finish");
INSERT INTO patients_record VALUES("1358","2024080869902","alex","alba","1984-07-29","","","","152/91","98.1","18","86","165","72","97","2024080833725","VAM","VAM","2024-08-08 16:00:50","pt states has been experiencing symptoms for 3 days 
pt states has been exposed to coworker with covid 
pt states has body aches headaches stuffy nose diarrhea  sore throat cough congestion 
pt states no one at home is sick 
pt states took Dayquil only 
pt states has facial pain 
  
allergies: none ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1359","2024080815534","sarah","meraz","2019-06-28","","","","unable","100.3","18","100","38.7","20","97","2024080833480","VAM","VAM","2024-08-08 16:31:24","","All","Yes","Finish");
INSERT INTO patients_record VALUES("1360","2024080812207","luis","meraz","1981-02-27","","","","121/76","97.7","18","76","160","66","96","2024080831762","VAM","VAM","2024-08-08 16:48:29","pt i here for a covid test 
pt states has body aches headaches  chills 
pt was exposed to coworker 

allergies: none 
pharmacy: Store #2428

Walgreens Pharmacy at 
2717 FM 1960 RD Houston, TX 77073
Cross streets: Northeast corner of TREASCHWIG & FM 1960

Phone : 281-443-2591","All","Yes","Finish");
INSERT INTO patients_record VALUES("1361","2024080821195","","","","","","","","","","","","","","2024080816590","VAM","VAM","2024-08-08 18:03:47","","","","");
INSERT INTO patients_record VALUES("1362","2024080833801","Ricardo","Segovia","2012-09-14","","","","82/53","97.5","17","70","131","64","99","202408082960","Castle Hills","Castle Hills","2024-08-08 18:22:44","sports physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1363","2024080811448","Ashley","Gomez","1995-06-06","","","","104/64","97.3","17","63","215","62","98","2024080849065","Castle Hills","Castle Hills","2024-08-08 19:05:17","Rx f/u

rx: walgreens 210-558-7138

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1364","2024080843819","lectoria","payne","1979-05-09","","","","138/88","98.7","18","100","240","62","97","202408083158","VAM","VAM","2024-08-08 19:29:42","pt is here experiencing chronic cough that started monday 
pt states cough has gotten constant 
pt states when cough has pain in lower and upper back 
pt states took ibuprofen mild relief 
pt states has a wet cough 
pt states is a still tobacco

covid test is = negative 


allergies: none 
pharmacy: Store #3424

Walgreens Pharmacy at 
23110 ALDINE WESTFIELD RD Spring, TX 77373
Cross streets: WOODRIVER & ALDINE WESTFIELD ROAD

Phone : 281-350-5311","All","Yes","Finish");
INSERT INTO patients_record VALUES("1365","2024080844540","Vanessa","Maples","1973-10-10","","","","140/86","99.8","","80","124","50","99","202408083858","Humble","Humble","2024-08-08 20:35:09","Pt thought she had a cold/flu, pt took Theraflu and no help for the last week
PT has earache now and has taken Tylenol for sinus and helped a little  
Pt has itchy throat, stuffy nose and ear blockage, low fever w/mild headaches

Allergies: NKDA

Pharmacy: 
Store #9601
Walgreens Pharmacy at 
3755 ATASCOCITA RD Humble, TX 77396
Cross streets: Southwest corner of ATASCOCITA & WILL CLAYTON
Phone : 281-812-4778

","All","Yes","Finish");
INSERT INTO patients_record VALUES("1366","2024080877275","Lauren","Joseph","2010-10-24","","","","103/72","99.0 ","","76","112.6","60","94","202408089364","Humble","Humble","2024-08-08 21:33:14","Pt is here for school Sports Physical ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1367","2024080886766","Cruz","Serna","2014-02-25","","","","118/70","97.3","18","71","150","62","99","2024080819881","Castle Hills","Castle Hills","2024-08-08 22:32:31","stomach pain

walgreens 210-979-6575

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1368","2024080956661","Zemira","Esaw","2007-12-17","","","","113/72","97.4","16","74","125","61","96","2024080937104","Castle Hills","Castle Hills","2024-08-09 14:25:19","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1369","2024080914197","Wyatt","Enderlin Brewer","2009-08-12","","","","125/80","97.2","18","59","146","73","98","2024080946299","Castle Hills","Castle Hills","2024-08-09 14:46:12","sports physical

Allgergies; Penicillin","All","Yes","Finish");
INSERT INTO patients_record VALUES("1370","2024080932465","Xander","Pearson","2007-07-03","","","","134/78","97.4","17","67","195","73","97","202408092421","Castle Hills","Castle Hills","2024-08-09 16:20:01","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1371","2024080995755","Catalina","Perez","2011-12-07","","","","97/53","98.1","16","101","112","53","98","2024080949214","Castle Hills","Castle Hills","2024-08-09 19:55:37","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1372","2024081073395","Kevin ","Hawkins","2006-12-22","","","","140/80","98.6","","68","237.4","68","99","2024081023419","Castle Hills","Castle Hills","2024-08-10 14:23:06","Sports Physical","All","","");
INSERT INTO patients_record VALUES("1373","2024081097724","Kevin","Hawkins","2006-12-22","","","","140/80","98.6","","68","237.4","68","99","2024081049296","Castle Hills","Castle Hills","2024-08-10 14:27:42","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1374","2024081062311","Evan","Hawkins","2010-02-23","","","","","98.6","","55","145.8","68","99","20240810128","Castle Hills","Castle Hills","2024-08-10 14:51:05","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1375","2024081085345","Bella","Gomez","2011-06-03","","","","114/71*114/63*112/65","98.7","","70","154.4","60","96","202408101478","Castle Hills","Castle Hills","2024-08-10 15:32:29","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1376","2024081039666","Gisela ","Villanueva ","1982-01-18","","","","95/62","99.1","20","113","150","62","98","202408102997","Humble","Humble","2024-08-10 15:55:35","Fever, sore throat , chills , body aches X3 days 
HX of Covid 1 week ago 
Borderline Bipolar 
RX lamictal 200 daily 
Pharmacy CVS 281-812-4377","All","Yes","Finish");
INSERT INTO patients_record VALUES("1377","2024081095123","Ethan","Melchor","2006-11-17","","","","138/83*137/90/136/82","98.6","","53","179","70","97","202408105622","Castle Hills","Castle Hills","2024-08-10 16:01:01","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1378","2024081040555","Cameron","Lauterstin","2006-12-21","","","","107/69*115/65*112/69","98.6","","62","131.4","70","99","2024081017324","Castle Hills","Castle Hills","2024-08-10 16:38:14","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1379","2024081189673","Keshawn ","Singleton ","2010-05-11","","","","","","","","","","","2024081120981","Humble","Humble","2024-08-11 17:24:57","Sports Physical 
KNA
No daily meds ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1380","2024081189673","","","","","","","","","","","","","","2024081120981","Humble","Humble","2024-08-11 17:27:41","","","Yes","Finish");
INSERT INTO patients_record VALUES("1381","2024081179673","Chan ","Mondole ","2000-09-21","","","","137/50","97.2","20","69","145","67","99","2024081143282","Humble","Humble","2024-08-11 19:20:27","Sore throat, Fever , chills, body aches X3 days 
KNA 
Alternating  Tylenol and Ibuprofen  
Walgreens on 1960 281-443-2591","All","Yes","Finish");
INSERT INTO patients_record VALUES("1382","2024081179673","Chan ","Mondole ","2000-09-21","","","","137/50","97.2","20","69","145","67","99","2024081143282","Humble","Humble","2024-08-11 19:25:04","Sore throat, Fever , chills, body aches X3 days 
KNA 
Alternating  Tylenol and Ibuprofen  
Walgreens on 1960 281-443-2591","All","Yes","Finish");
INSERT INTO patients_record VALUES("1383","2024081160419","Nolan","Richter","2007-01-27","","","","134/66","98.6","","64","180.6","73","97","20240811529","Castle Hills","Castle Hills","2024-08-11 19:36:58","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1384","2024081166832","Diego ","Rodriguez","2008-10-06","","","","132/70","98.7","","72","171.8","73","96","2024081126411","Castle Hills","Castle Hills","2024-08-11 21:25:11","Sports Physical","All","Yes","Finish");
INSERT INTO patients_record VALUES("1385","2024081217125","test","test","2021-08-12","","","","1","1","1","1","1","1","1","202408128421","Castle Hills","Castle Hills","2024-08-12 19:01:10","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("1386","2024081232472","Monday","TEST","2024-08-12","","","","1","1","1","1","1","1","1","2024081216381","Castle Hills","Castle Hills","2024-08-12 19:09:32","TEST","All","Yes","Finish");
INSERT INTO patients_record VALUES("1387","2024081276768","Damarea","Washington","2011-10-01","","","","126/72","97.5","16","72","152","61","99","2024081219518","Castle Hills","Castle Hills","2024-08-12 21:00:30","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1388","2024081295755","Damya","Washington","2013-03-12","","","","103/62","97.4","17","70","96","56","99","2024081215755","Castle Hills","Castle Hills","2024-08-12 21:23:00","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1389","2024081220400","luisana","rodriguez","1997-02-04","","","","110/72","98.9","18","74","187","61","99","2024081215355","VAM","VAM","2024-08-12 21:34:37","pt is here with symptoms of runny nose ear itchiness 
pt has congestion and cough that dry 
pt states symptoms began yesterday 
pt states no one at hoe is sick but was around alot of people 

allergies: none 
pharmacy: same as on file 
negative for covid and flu ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1390","2024081283875","test","test","","","","","","","18","","","61","99","2024081243211","VAM","VAM","2024-08-12 21:49:55","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("1391","2024081220487","test","test","1997-02-07","","","","","","","","","61","99","2024081241389","VAM","VAM","2024-08-12 21:52:08","test","All","Yes","Finish");
INSERT INTO patients_record VALUES("1392","2024081268532","katie","kniess","1987-03-10","","","","121/73","97.9","18","80","145","67","99","2024081248659","VAM","VAM","2024-08-12 22:14:27","pt is here with symptoms of possible uti 
pt states has been experiencig burning fequesnt urine not much urine coming out 
pt states has took azo no relief 
pt states symptoms began 1 week 

allergies: pennicillin, sulfur ( hives ) 

pharmacy: Pharmacy
281–350–3591

View My Prescriptions
Schedule a Vaccine
Open until 8 PM
Sun: 10 AM - 5 PM
Mon - Fri: 9 AM - 8 PM   ","All","Yes","Finish");
INSERT INTO patients_record VALUES("1393","2024081281804","Hanna","Goodman","2010-04-15","","","","114/66","97.3","18","83","126","61","97","202408121601","Castle Hills","Castle Hills","2024-08-12 22:19:05","sports physical

nkda","All","Yes","Finish");
INSERT INTO patients_record VALUES("1394","2024081214908","Nathaniel","Robledo","2007-02-27","","","","122/85","97.2","17","84","190.8","72","97","2024081241024","Castle Hills","Castle Hills","2024-08-12 22:48:32","sports physical

nkda","All","Yes","Finish");



CREATE TABLE `tbl_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'role_id',
  `role` varchar(255) DEFAULT NULL COMMENT 'role_text',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

INSERT INTO tbl_roles VALUES("1","ICT");
INSERT INTO tbl_roles VALUES("2","Doctor");
INSERT INTO tbl_roles VALUES("3","Nurse");



CREATE TABLE `tbl_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pod` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `sex` varchar(100) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `mobile` varchar(25) DEFAULT NULL,
  `tgl_lahir` date NOT NULL,
  `roleid` tinyint(4) DEFAULT NULL,
  `isActive` tinyint(4) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastlogin_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `u_ID` varchar(255) NOT NULL,
  `f_profile` varchar(355) DEFAULT NULL,
  `doctor_permission` varchar(225) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4;

INSERT INTO tbl_users VALUES("1","Palmas Del Mar","Reza","Male","PODICT","cyber@providerondemand.com","8151e41c465d23729a35c96aa08b9c8a2175f3e6","089633919827","1992-01-15","1","0","2020-03-12 16:23:01","2020-03-12 16:23:01","2023-11-26 13:14:04","POD1","5061Reza.png","All");
INSERT INTO tbl_users VALUES("2","Waco","Dr. Marvel","Male","POD2","marvel@providerondemand.com","8151e41c465d23729a35c96aa08b9c8a2175f3e6","08888888881","2023-11-26","2","0","2020-03-13 05:11:02","2020-03-13 05:11:02","2023-11-26 13:14:04","POD2","1330Dr Marvel.jpg","All");
INSERT INTO tbl_users VALUES("24","Palmas Del Mar","nurse1","Female","POD3","nurse01@providerondemand.com","8151e41c465d23729a35c96aa08b9c8a2175f3e6","081200000080","1991-01-15","3","0","2023-12-03 19:47:36","2023-12-03 19:47:36","2023-12-03 19:47:36","POD3","2938clay-elliot-mpDV4xaFP8c-unsplash.jpg","All");
INSERT INTO tbl_users VALUES("25","Humble","Humble","Female","POD4","humble@providerondemand.com","e2af65845b0730afeb53614b9a583547c6bc2766","111111","1991-01-15","3","0","2024-04-29 16:37:09","2024-04-29 16:37:09","2024-04-29 16:37:09","POD4","314POD Logo Appointment Email.png","No");
INSERT INTO tbl_users VALUES("27","Castle Hills","Castle Hills","Male","POD5","castlehills@providerondemand.com","e2af65845b0730afeb53614b9a583547c6bc2766","111111","1995-01-15","3","0","2024-04-29 16:40:50","2024-04-29 16:40:50","2024-04-29 16:40:50","POD5","8682POD Logo Appointment Email.png","No");
INSERT INTO tbl_users VALUES("28","VAM","VAM","Male","POD6","vam@providerondemand.com","e2af65845b0730afeb53614b9a583547c6bc2766","111111","1992-01-15","3","0","2024-05-15 05:44:05","2024-05-15 05:44:05","2024-05-15 05:44:05","POD6","8480POD Logo Appointment Email.png","No");
INSERT INTO tbl_users VALUES("29","Palmas","Palmas","Male","POD7","palmas@providerondemand.com","e2af65845b0730afeb53614b9a583547c6bc2766","111111","1992-01-15","3","0","2024-05-15 05:45:07","2024-05-15 05:45:07","2024-05-15 05:45:07","POD7","3907POD Logo Appointment Email.png","No");

