<?php
include 'bridge.php'; // Include the database connection file

// Function to update the already_oncall field
function updateAlreadyOnCall($record_id) {
    global $conn;

    // Prepare and execute SQL statement to update the already_oncall field
    $sql = "UPDATE patients_record SET already_oncall = 'Finish' WHERE record_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $record_id);
    $stmt->execute();

    // Check if the update was successful
    if ($stmt->affected_rows > 0) {
        return true; // Return true if update successful
    } else {
        return false; // Return false if update failed
    }

    // Close prepared statement
    $stmt->close();
}

// Function to generate the URL
function generateURL($fname, $lname, $record_id) {
    $roomName = $fname . " " . $lname . " " . $record_id;
    return "https://oncall.providerondemandapp.com/" . urlencode($roomName);
}

// Get the record_id parameter from the URL
$record_id = isset($_GET['id']) ? $_GET['id'] : null;

if (!$record_id) {
    // Handle the case when the record_id parameter is not provided
    echo "Record ID not provided.";
    exit();
}

// Call the function to update already_oncall field
if (updateAlreadyOnCall($record_id)) {
    // Fetch patient's first name and last name from the database
    $query = "SELECT patient_fname, patient_lname FROM patients_record WHERE record_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $record_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $fname = $row['patient_fname'];
        $lname = $row['patient_lname'];

        // Generate URL
        $url = generateURL($fname, $lname, $record_id);

        // Open the URL in a new tab using JavaScript
        echo "<script>window.open('$url', '_blank');</script>";
        // Automatically navigate back after 3 seconds
        echo "<script>setTimeout(function() { window.history.back(); }, 3000);</script>";
    } else {
        echo "Failed to fetch patient information";
    }

    // Close prepared statement
    $stmt->close();
} else {
    echo "Failed to update already_oncall field";
}

// Close database connection
$conn->close(); 
?>
