<?php
include 'bridge.php';

// Check if record_id is provided
if(isset($_GET['id'])) {
    $record_id = $_GET['id'];

    // Prepare and execute your SQL query using prepared statement to update the record
    $sql = "UPDATE patients_record SET already_oncall = 'Ready' WHERE record_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $record_id);
    $stmt->execute();

    // Check if the update was successful
    if($stmt->affected_rows > 0) {
        // Return a success response
        echo "Success";
    } else {
        // Return an error response if no rows were affected
        echo "Error: Record not found or already updated";
    }
    $stmt->close();
} else {
    // Return an error response if record_id is not provided
    echo "Error: Record ID not provided";
}
?>
