<?php
include 'bridge.php';
?>
<?php
// Get the record_id parameter from the URL
$record_id = isset($_GET['id']) ? $_GET['id'] : null;

if (!$record_id) {
    // Handle the case when the record_id parameter is not provided
    echo "Record ID not provided.";
    exit();
}
// Enable Server-Sent Events
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');
session_start();
//Check Session
if (isset($_SESSION['id']))
  {
  // if a valid user session is found then the user level is checked, if the
  // user has level 3 access they will be granted access if not a access denied
  //message be displayed and the user will be redirected.
	 if ($_SESSION['roleid'] <= 3) {}

  else
  {
	header("Refresh: 1; url=403/index.php");
	exit(); // Quit the script.
  }  
  }
  // if no valid session is found then the user is not logged in and will
  // receive a access denied message and will be redirected to the login page.
  else if (!isset($_SESSION['user_id'])) {

  header("Refresh: 3; url=login.php");
  echo '<h3>Access Denied!! - You do not have permission to access this page!</h3>';
  echo '<p>You will be redirected in 3 seconds</p>';
  include ('403/index.html');
  exit(); // Quit the script.
  } 
// Function to fetch patient files information
function fetchPatientFiles($record_id) {
    global $servername, $username, $password, $dbname;

    // Establish database connection
    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Use prepared statement to avoid SQL injection
    $sql = "SELECT picts, device_type, record_date, record_at FROM patients_files WHERE record_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $record_id);
    $stmt->execute();

    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Fetch patient files information
        $filesData = $result->fetch_all(MYSQLI_ASSOC);
        echo "data: " . json_encode($filesData) . "\n\n";
        ob_flush();
        flush();
    } else {
        // Return JSON-encoded message if no records found
        echo "data: " . json_encode(['error' => 'No files found for the given record_id']) . "\n\n";
        ob_flush();
        flush();
    }

    $stmt->close();
    $conn->close();
}

// Fetch and send patient files information in a loop (real-time)
while (true) {
    // Fetch patient files information and send it
    fetchPatientFiles($record_id);

    // Pause for a short interval (e.g., 1 second) before fetching again
    sleep(1);
}

?>