<?php
include 'bridge.php';
?>
<?php
// Get the record_id parameter from the URL
$record_id = isset($_GET['id']) ? $_GET['id'] : null;

if (!$record_id) {
    // Handle the case when the record_id parameter is not provided
    echo "Record ID not provided.";
    exit();
}

// Enable Server-Sent Events
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');

// Function to fetch patient information
function fetchPatientInfo($record_id) {
    global $servername, $username, $password, $dbname;

    // Establish database connection
    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Use prepared statement to avoid SQL injection
    $sql = "SELECT vbp, vtemp, vresp, vhr, vweight, vhg, vsot FROM patients_record WHERE record_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $record_id);
    $stmt->execute();

    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Fetch patient information
        $row = $result->fetch_assoc();
        $patientInfo = [
            'vbp' => $row['vbp'],
            'vtemp' => $row['vtemp'],
            'vresp' => $row['vresp'],
            'vhr' => $row['vhr'],
            'vweight' => $row['vweight'],
            'vhg' => $row['vhg'],
            'vsot' => $row['vsot'],
            // Add additional fields as needed
        ];

        // Return JSON-encoded patient information
        echo "data: " . json_encode($patientInfo) . "\n\n";
        ob_flush();
        flush();
    } else {
        // Return JSON-encoded message if record not found
        echo "data: " . json_encode(['error' => 'Record not found']) . "\n\n";
        ob_flush();
        flush();
    }

    $stmt->close();
    $conn->close();
}

// Fetch and send patient information in a loop (real-time)
while (true) {
    // Fetch patient information and send it
    fetchPatientInfo($record_id);

    // Pause for a short interval (e.g., 1 second) before fetching again
    sleep(1);
}

?>