<?php
session_start();
include 'bridge.php';

// Check if a valid user session is found
if (isset($_SESSION['roleid'])) {
    // Check user access level
    if ($_SESSION['roleid'] <= 3) {
        // User has access
    } else {
        header("Refresh: 1; url=403/index.php");
        exit(); // Quit the script.
    }  
} else if (!isset($_SESSION['user_id'])) {
    // No valid session found, redirect to login page
    header("Refresh: 3; url=login.php");
    echo '<h3>Access Denied!! - You do not have permission to access this page!</h3>';
    echo '<p>You will be redirected in 3 seconds</p>';
    include ('403/index.html');
    exit(); // Quit the script.
}

// Function to fetch data based on location ID
function fetchData($location_id) {
    global $conn;
    
    // Prepare and execute SQL statement
    $sqlpatient = "SELECT patient_fname, patient_lname, patient_dob, patient_sex, patient_contact, record_date, record_id FROM patients_record WHERE record_at = ? AND already_oncall ='Finish' AND DATE(record_date) = CURDATE() ORDER BY record_date DESC";
    $stmt = $conn->prepare($sqlpatient);
    if (!$stmt) {
        die("Error in preparing statement: " . $conn->error);
    }
    $stmt->bind_param("s", $location_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if (!$result) {
        die("Error in fetching data: " . $conn->error);
    }
    
    // Fetch data and construct table rows
    $rows = '';
    while ($row = $result->fetch_assoc()) {
        $rows .= "<tr>";
        $rows .= "<td>" . $row['patient_fname'] . "</td>";
        $rows .= "<td>" . $row['patient_lname'] . "</td>";
        $rows .= "<td>" . $row['patient_dob'] . "</td>";
        $rows .= "<td>" . $row['patient_sex'] . "</td>";
        $rows .= "<td>" . $row['patient_contact'] . "</td>";
        $rows .= "<td>" . $row['record_date'] . "</td>";
        // Display Record ID as a button linking to patient-details.php
        $rows .= "<td><a href='patient-details.php?id=" . $row['record_id'] . "' class='btn btn-primary'>View Details</a></td>";
        $rows .= "<td><button class='re-call-btn-location btn' href='#' onclick='recallRecordLocation(" . $row['record_id'] . ")' data-record-id='" . $row['record_id'] . "' style='background-color: rgb(51 171 227 / 38%); color:#182848; font-weight:600; padding:0.375rem 1.75rem;'>Recall</button></td>";
        $rows .= "</tr>";
    }

    // Close prepared statement
    $stmt->close();

    return $rows;
}

// Check if 'podname' is set in the session
if (isset($_SESSION['podname'])) {
    // Get 'podname' from session
    $location_id = $_SESSION['podname'];

    // Fetch data based on location ID
    $data = fetchData($location_id);
    echo $data;
} else {
    echo "Location ID (podname) is not set in session.";
}

// Close database connection
$conn->close();
?>