<?php
include 'header.php';
session_start();

// Check if the user is not authenticated, redirect to login page
if (!isset($_SESSION["authenticated"]) || $_SESSION["authenticated"] !== true) {
    header("Location: wawai-auth.php");
    exit();
}
?>

<div class="uk-section">
  <div class="uk-container container-xxsmall">
    <h1 class="uk-article-title">Changelog posts</h1>
    <div class="article-content">
    </div>
    <article class="uk-article uk-margin-medium-top">
      <hr class="uk-margin-medium-bottom">
      <div class="uk-position-relative">
        <h2>🚀 April Updates</h2>
        <div class="uk-position-center-left-out uk-position-large uk-visible@m uk-text-small uk-text-muted">
          <time datetime="2019-04-22T00:00:00+00:00">
            Apr 22, 2019
          </time>
        </div>
        <div class="uk-hidden@m uk-text-small uk-text-muted uk-margin-bottom">
          <time datetime="2019-04-22T00:00:00+00:00">
            Apr 22, 2019
          </time>
        </div>
      </div>
      <div class="article-content">
        <p>April comes with a whole bunch of updates across our stack, the main focus for this month in regards to what
          was released is around:</p>
        <p>Further improving system, and allowing you to compare your results against wide averages for deflection rates
          Improvements to our tool to give you and your team more control
          And various other new features, updates, and bug fixes along the way.</p>
        <p><span class="uk-label" style="background-color: #3778ff">Added</span></p>
        <ul>
          <li>Some scheduled changelogs, tweets, and slack messages queued up this weekend and were not published on
            time. We fixed the issue and all delayed publications should be out.</li>
          <li>We now prioritize keywords over title and body so customers can more effectively influence search results
          </li>
          <li>Support form in the Assistant is now protected with reCaptcha to reduce spam reinitializeOnUrlChange added
            to the JavaScript API to improve support for pages with turbolinks</li>
        </ul>
        <p><span class="uk-label" style="background-color: #ff4772">Fixed</span></p>
        <ul>
          <li>Fixed an issue with the sync autolinker only interlinking selectively.</li>
          <li>Fixed up an issue with prematurely logging out users</li>
        </ul>
      </div>
    </article>
    <article class="uk-article uk-margin-medium-top">
      <hr class="uk-margin-medium-bottom">
      <div class="uk-position-relative">
        <h2>February Updates</h2>
        <div class="uk-position-center-left-out uk-position-large uk-visible@m uk-text-small uk-text-muted">
          <time datetime="2019-02-02T00:00:00+00:00">
            Feb 2, 2019
          </time>
        </div>
        <div class="uk-hidden@m uk-text-small uk-text-muted uk-margin-bottom">
          <time datetime="2019-02-02T00:00:00+00:00">
            Feb 2, 2019
          </time>
        </div>
      </div>
      <div class="article-content">
        <p>February updates across our stack, the main focus for this month in regards to what was released is around:
        </p>
        <p>Migrating all companies to new access control
          Migrating all companies using ticket deflection to the new system
          Further improving system, and allowing you to compare your results against wide averages for deflection rates
        </p>
        <p><span class="uk-label" style="background-color: #3aaa55">Changed</span></p>
        <ul>
          <li>Better support for using applying additional filters to posts_tax_query for categories for custom
            WordPress syncs</li>
          <li>Reporting fine-tuning for speed improvements (up to 60% improvement in latency)</li>
          <li>Search engine upgraded. Bringing with it enhancements and bug fixes.</li>
          <li>Replaced login / registration pre-app screens with a cleaner design</li>
        </ul>
        <p><span class="uk-label" style="background-color: #ff4772">Fixed</span></p>
        <ul>
          <li>Fixed an issue with the sync autolinker only interlinking selectively.</li>
          <li>Fixed up an issue with prematurely logging out users</li>
        </ul>
      </div>
    </article>
    <article class="uk-article uk-margin-medium-top">
      <hr class="uk-margin-medium-bottom">
      <div class="uk-position-relative">
        <h2>🚧 January Updates v1.0.5</h2>
        <div class="uk-position-center-left-out uk-position-large uk-visible@m uk-text-small uk-text-muted">
          <time datetime="2019-01-17T00:00:00+00:00">
            Jan 17, 2019
          </time>
        </div>
        <div class="uk-hidden@m uk-text-small uk-text-muted uk-margin-bottom">
          <time datetime="2019-01-17T00:00:00+00:00">
            Jan 17, 2019
          </time>
        </div>
      </div>
      <div class="article-content">
        <p>Create your own labels, set text and color:</p>
        <p><span class="uk-label" style="background-color: #3778ff">Added</span></p>
        <p><span class="uk-label" style="background-color: #3aaa55">Changed</span></p>
        <p><span class="uk-label" style="background-color: #333333">Deprecated</span></p>
        <p><span class="uk-label" style="background-color: #17caf0">Removed</span></p>
        <p><span class="uk-label" style="background-color: #ff4772">Fixed</span></p>
        <p><span class="uk-label" style="background-color: #fb3434">Security</span></p>
        <p><span class="uk-label" style="background-color: #a037ff">Unreleased</span></p>
      </div>
    </article>
    <article class="uk-article uk-margin-medium-top">
      <hr class="uk-margin-medium-bottom">
      <div class="uk-position-relative">
        <h2>November Update</h2>
        <div class="uk-position-center-left-out uk-position-large uk-visible@m uk-text-small uk-text-muted">
          <time datetime="2018-11-11T00:00:00+00:00">
            Nov 11, 2018
          </time>
        </div>
        <div class="uk-hidden@m uk-text-small uk-text-muted uk-margin-bottom">
          <time datetime="2018-11-11T00:00:00+00:00">
            Nov 11, 2018
          </time>
        </div>
      </div>
      <div class="article-content">
        <p><span class="uk-label" style="background-color: #ff4772">Fixed</span></p>
        <div class="language-html highlighter-rouge">
          <div class="highlight">
<pre class="highlight"><code><span class="nt">&lt;head&gt;</span>
  <span class="nt">&lt;meta</span> <span class="na">name=</span><span class="s">"viewport"</span> <span class="na">content=</span><span class="s">"width=device-width, initial-scale=1"</span><span class="nt">&gt;</span>
  <span class="nt">&lt;link</span> <span class="na">rel=</span><span class="s">"stylesheet"</span> <span class="na">href=</span><span class="s">"/assets/css/main.css"</span><span class="nt">&gt;</span>
  <span class="nt">&lt;link</span> <span class="na">rel=</span><span class="s">"shortcut icon"</span> <span class="na">type=</span><span class="s">"image/png"</span> <span class="na">href=</span><span class="s">"/assets/img/favicon.png"</span> <span class="nt">&gt;</span>
  <span class="nt">&lt;script </span><span class="na">src=</span><span class="s">"/assets/js/main.js"</span><span class="nt">&gt;&lt;/script&gt;</span>
<span class="nt">&lt;/head&gt;</span>
</code></pre>
          </div>
        </div>
      </div>
    </article>
  </div>
</div>

<div id="offcanvas-docs" data-uk-offcanvas="overlay: true">
  <div class="uk-offcanvas-bar">
    <button class="uk-offcanvas-close" type="button" data-uk-close></button>
    <h5 class="uk-margin-top">Getting Started</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li class="uk-active"><a href="doc.html">Template setup</a></li>
      <li><a href="doc.html">Basic theme setup</a></li>
      <li><a href="doc.html">Navigation bar</a></li>
      <li><a href="doc.html">Footer options</a></li>
      <li><a href="doc.html">Creating your first post</a></li>
      <li><a href="doc.html">Creating docs posts</a></li>
      <li><a href="doc.html">Enabling comments</a></li>
      <li><a href="doc.html">Google Analytics</a></li>
    </ul>
    <h5 class="uk-margin-top">Product Features</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li><a href="doc.html">Hero page header</a></li>
      <li><a href="doc.html">Category boxes section</a></li>
      <li><a href="doc.html">Fearured docs section</a></li>
      <li><a href="doc.html">Video lightbox boxes section</a></li>
      <li><a href="doc.html">Frequently asked questions section</a></li>
      <li><a href="doc.html">Team members section</a></li>
      <li><a href="doc.html">Call to action section</a></li>
      <li><a href="doc.html">Creating a changelog</a></li>
      <li><a href="doc.html">Contact form</a></li>
      <li><a href="doc.html">Adding media to post and doc content</a></li>
      <li><a href="doc.html">Adding table of contents to docs</a></li>
      <li><a href="doc.html">Adding alerts to content</a></li>
    </ul>
    <h5 class="uk-margin-top">Customization</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li><a href="doc.html">Translation</a></li>
      <li><a href="doc.html">Customization</a></li>
      <li><a href="doc.html">Development</a></li>
      <li><a href="doc.html">Sources and credits</a></li>
    </ul>
    <h5 class="uk-margin-top">Help</h5>
    <ul class="uk-nav uk-nav-default doc-nav">
      <li><a href="doc.html">Contacting support</a></li>
    </ul>
  </div>
</div>

<?php
include 'footer.php';
?>