<?php
session_start();

// Check if the user is not authenticated, redirect to login page
if (!isset($_SESSION["authenticated"]) || $_SESSION["authenticated"] !== true) {
    header("Location: wawai-auth.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en-gb" dir="ltr">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex">
    <title>Docs | Documentation HTML Template</title>
    <link rel="shortcut icon" type="image/png" href="https://via.placeholder.com/20.png" >
    <link href="https://fonts.googleapis.com/css?family=Heebo:300,400" rel="stylesheet">
    <link rel="stylesheet" href="css/main.css" />
    <link rel="stylesheet" href="css/forceteknologi.css" />
    <script src="js/uikit.js"></script>
    <script src="js/forceteknologi.js"></script>
</head>

<body>

<header>
	<div data-uk-sticky="animation: uk-animation-slide-top; sel-target: .uk-navbar-container; cls-active: uk-navbar-sticky; cls-inactive: uk-navbar-transparent; top: 200">
	  <nav class="uk-navbar-container">
	    <div class="uk-container">
	      <div data-uk-navbar>
	        <div class="uk-navbar-left">
	          <a class="uk-navbar-item uk-logo uk-visible@m" href="index">Docs</a>
	          <a class="uk-navbar-toggle uk-hidden@m" href="#offcanvas-docs" data-uk-toggle><span
	              data-uk-navbar-toggle-icon></span> <span class="uk-margin-small-left">Docs</span></a>
	          <ul class="uk-navbar-nav uk-visible@m">
	            <li <?php if (basename($_SERVER['PHP_SELF']) == 'index.php') echo 'class="uk-active"'; ?>><a href="index">Home</a></li>
	            <li <?php if (basename($_SERVER['PHP_SELF']) == 'doc.php') echo 'class="uk-active"'; ?>><a href="doc">Docs</a></li>
	            <li <?php if (basename($_SERVER['PHP_SELF']) == 'blog.php') echo 'class="uk-active"'; ?>><a href="blog">Blog</a></li>
	            <li <?php if (basename($_SERVER['PHP_SELF']) == 'changelog-timeline.php' || basename($_SERVER['PHP_SELF']) == 'changelog-posts.php') echo 'class="uk-active"'; ?>>
	              <a href="#">Changelogs</a>
	              <div class="uk-navbar-dropdown">
	                <ul class="uk-nav uk-navbar-dropdown-nav">
	                  <li><a href="changelog-timeline">Timeline Style</a></li>
	                  <li><a href="changelog-posts">Post Style</a></li>
	                </ul>
	              </div>            
	            </li>
	          </ul>
	        </div>
	        <div class="uk-navbar-center uk-hidden@m">
	          <a class="uk-navbar-item uk-logo" href="index">Docs</a>
	        </div>
	        <div class="uk-navbar-right">
	          <div>
	            <a id="search-navbar-toggle" class="uk-navbar-toggle" data-uk-search-icon href="#"></a>
	            <div class="uk-background-default uk-border-rounded"
	              data-uk-drop="mode: click; pos: left-center; offset: 0">
	              <form class="uk-search uk-search-navbar uk-width-1-1" onsubmit="return false;">
	                <input id="search-navbar" class="uk-search-input" type="search" placeholder="Search for answers"
	                  autofocus autocomplete="off" data-minchars="1" data-maxitems="30">
	              </form>
	            </div>
	          </div>
	          <ul class="uk-navbar-nav uk-visible@m">
	            <li>
	              <div class="uk-navbar-item">
	                <a class="uk-button uk-button-primary-outline" href="changelog-timeline">Changelog</a>
	              </div>
	            </li>
	            <li>
	              <div class="uk-navbar-item">
	                <a class="uk-button uk-button-success" href="contact">Contact</a>
	              </div>
	            </li>
	          </ul>
	          <a class="uk-navbar-toggle uk-hidden@m" href="#offcanvas" data-uk-toggle><span
	              data-uk-navbar-toggle-icon></span> <span class="uk-margin-small-left">Menu</span></a>
	        </div>
	      </div>
	    </div>
	  </nav>
	</div>
</header>