<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Webcam Snapshot Upload</title>
    <style>
        /* Add your styles here */
    </style>
</head>
<body>
    <h1>Webcam Snapshot Upload</h1>
    <div id="formWizard">
        <!-- Step 1: Webcam Capture -->
        <div id="step1" class="step">
            <video id="video" width="640" height="480" autoplay onclick="captureSnapshot()"></video>
            <button id="captureBtn">Capture Snapshot</button>
        </div>

        <!-- Step 2: Additional Fields -->
        <div id="step2" class="step">
            <form id="additionalFieldsForm">
                <label for="fullName">Full Name:</label>
                <input type="text" id="fullName" name="fullName" required>

                <label for="email">Email:</label>
                <input type="email" id="email" name="email" required>

                <label for="dob">Date of Birth:</label>
                <input type="date" id="dob" name="dob" required>

                <button type="button" onclick="moveToStep(1)">Back</button>
                <button type="button" onclick="saveAdditionalFields()">Next</button>
            </form>
        </div>

        <!-- Step 3: Finish -->
        <div id="step3" class="step">
            <button type="button" onclick="moveToStep(2)">Back</button>
            <button type="button" onclick="finish()">Finish</button>
        </div>
    </div>

    <div id="snapshotContainer"></div>

    <div id="successPopup" style="display: none;">
        <p>Data successfully saved!</p>
        <button onclick="closePopup()">Close</button>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.5.0-beta4/html2canvas.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const video = document.getElementById('video');
            const captureBtn = document.getElementById('captureBtn');
            const snapshotContainer = document.getElementById('snapshotContainer');
            const formWizard = document.getElementById('formWizard');
            const successPopup = document.getElementById('successPopup');
            let mediaStream;
            let counter = 1;

            // Access the user's camera
            if (navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
                navigator.mediaDevices.getUserMedia({ video: true })
                    .then(function (stream) {
                        video.srcObject = stream;
                        mediaStream = stream;
                    })
                    .catch(function (error) {
                        console.error('Error accessing the camera: ', error);
                    });
            } else {
                console.error('getUserMedia not supported in this browser');
            }

            // Capture snapshot on video click
            window.captureSnapshot = function () {
                if (mediaStream) {
                    const canvas = document.createElement('canvas');
                    canvas.width = video.videoWidth;
                    canvas.height = video.videoHeight;
                    const context = canvas.getContext('2d');
                    context.drawImage(video, 0, 0, canvas.width, canvas.height);

                    // Display snapshot
                    const img = document.createElement('img');
                    img.src = canvas.toDataURL('image/png');

                    // Add a class to the img element
                    img.classList.add('snapshot-image');

                    // Assign a unique name to each image
                    img.alt = `Snapshot ${counter++}`;

                    // Create a remove button
                    const removeBtn = document.createElement('button');
                    removeBtn.textContent = 'Remove';
                    removeBtn.classList.add('removeBtn');

                    // Add click event to remove button
                    removeBtn.addEventListener('click', function () {
                        snapshotContainer.removeChild(img);
                    });

                    // Append the image and remove button to the container
                    snapshotContainer.appendChild(img);
                    snapshotContainer.appendChild(removeBtn);
                }
            };

            // Move to the specified step in the form wizard
            window.moveToStep = function (step) {
                formWizard.querySelectorAll('.step').forEach(s => s.style.display = 'none');
                formWizard.querySelector(`#step${step}`).style.display = 'block';
            };

            // Save additional fields to the database
            window.saveAdditionalFields = function () {
                const fullName = document.getElementById('fullName').value;
                const email = document.getElementById('email').value;
                const dob = document.getElementById('dob').value;

                const snapshotImages = document.querySelectorAll('.snapshot-image');
                const snapshots = [];

                snapshotImages.forEach(img => {
                    snapshots.push({
                        name: img.alt,
                        src: img.src,
                        fullName: fullName,
                        email: email,
                        dob: dob
                    });
                });

                if (snapshots.length > 0) {
                    // Send snapshots to the server using AJAX
                    const xhr = new XMLHttpRequest();
                    xhr.open('POST', 'your-save-endpoint-url', true);
                    xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState === XMLHttpRequest.DONE) {
                            if (xhr.status === 200) {
                                console.log('Snapshots and additional fields saved to the database successfully');
                            } else {
                                console.error('Error saving data: ', xhr.statusText);
                            }
                        }
                    };

                    // Convert snapshots array to JSON and send it
                    const data = JSON.stringify({ snapshots: snapshots });
                    xhr.send(data);

                    moveToStep(2); // Move to the next step
                }
            };

            // Finish the process and show success popup
            window.finish = function () {
                html2canvas(document.body).then(function (canvas) {
                    const image = canvas.toDataURL('image/png');

                    // Include the captured screen image in the snapshots
                    const snapshotImages = document.querySelectorAll('.snapshot-image');
                    const snapshots = [];

                    snapshotImages.forEach(img => {
                        snapshots.push({
                            name: img.alt,
                            src: img.src,
                            fullName: img.nextSibling.value,
                            email: img.nextSibling.nextSibling.value,
                            dob: img.nextSibling.nextSibling.nextSibling.value,
                            screenCapture: image
                        });
                    });

                    if (snapshots.length > 0) {
                        // Send snapshots to the server using AJAX
                        const xhr = new XMLHttpRequest();
                        xhr.open('POST', 'save.php', true);
                        xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
                        xhr.onreadystatechange = function () {
                            if (xhr.readyState === XMLHttpRequest.DONE) {
                                if (xhr.status === 200) {
                                    console.log('Snapshots and additional fields saved to the database successfully');
                                    successPopup.style.display = 'block';
                                } else {
                                    console.error('Error saving data: ', xhr.statusText);
                                }
                            }
                        };

                        // Convert snapshots array to JSON and send it
                        const data = JSON.stringify({ snapshots: snapshots });
                        xhr.send(data);
                    }
                });
            };

            // Close success popup
            window.closePopup = function () {
                successPopup.style.display = 'none';
            };
        });
    </script>
</body>
</html>
