let mediaRecorder;
let audioChunks = [];
let audiohb = document.getElementById("audiohb");
let audiolungs = document.getElementById("audiolungs");

function startRecording(playerId) {
  const constraints = { audio: true };
  navigator.mediaDevices
    .getUserMedia(constraints)
    .then((stream) => {
      mediaRecorder = new MediaRecorder(stream);
      mediaRecorder.ondataavailable = (e) => {
        if (e.data.size > 0) {
          audioChunks.push(e.data);
        }
      };
      mediaRecorder.onstop = () => {
        const audioBlob = new Blob(audioChunks, { type: "audio/wav" });
        const audioUrl = URL.createObjectURL(audioBlob);
        document.getElementById(playerId).src = audioUrl;
      };
      mediaRecorder.start();
    })
    .catch((err) => console.error("Error accessing microphone:", err));
}

function stopRecording() {
  if (mediaRecorder && mediaRecorder.state === "recording") {
    mediaRecorder.stop();
    audioChunks = [];
  }
}

function uploadFile(playerId) {
  const audioBlob = new Blob(audioChunks, { type: "audio/wav" });
  const formData = new FormData();
  formData.append("audioFile", audioBlob, "recording.wav");

  $.ajax({
    url: "http://localhost/mPanel/inc/medical/recorduploader.php",
    type: "POST",
    data: formData,
    processData: false,
    contentType: false,
    success: function (response) {
      alert("File uploaded successfully!");
      // You can perform additional actions after successful upload
    },
    error: function (error) {
      console.error("Error uploading file:", error);
    },
  });
}
