document.addEventListener("DOMContentLoaded", function () {
  const video = document.getElementById("cam_exam_ear");
  const captureBtn = document.getElementById("captureBtn");
  const uploadBtn = document.getElementById("uploadBtn");
  const snapshotContainer = document.getElementById("snapshotContainer");
  let mediaStream;
  let snapshots = [];
  let counter = 1;

  // Access the user's camera
  if (navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
    navigator.mediaDevices
      .getUserMedia({ video: true })
      .then(function (stream) {
        video.srcObject = stream;
        mediaStream = stream;
      })
      .catch(function (error) {
        console.error("Error accessing the camera: ", error);
      });
  } else {
    console.error("getUserMedia not supported in this browser");
  }

  // Capture snapshot on video click
  window.captureSnapshot = function () {
    if (mediaStream) {
      const canvas = document.createElement("canvas");
      canvas.width = video.videoWidth;
      canvas.height = video.videoHeight;
      const context = canvas.getContext("2d");
      context.drawImage(video, 0, 0, canvas.width, canvas.height);

      // Display snapshot
      const img = document.createElement("img");
      img.src = canvas.toDataURL("image/png");

      // Add a class to the img element
      img.classList.add("snapshot-image");

      // Assign a unique name to each image
      img.name = `earsnapshots_${counter++}`;
      img.id = `earsnapshots_${counter++}`;

      // Create a remove button
      const removeBtn = document.createElement("button");
      removeBtn.textContent = "";
      removeBtn.classList.add("removeBtn");

      // Add click event to remove button
      removeBtn.addEventListener("click", function () {
        snapshotContainer.removeChild(img);
        snapshotContainer.removeChild(removeBtn);
      });

      // Append the image and remove button to the container
      snapshotContainer.appendChild(img);
      snapshotContainer.appendChild(removeBtn);
    }
  };

  // Capture snapshot on button click
  captureBtn.addEventListener("click", function () {
    captureSnapshot();
  });

  // Upload snapshots
  uploadBtn.addEventListener("click", function () {
    const snapshotImages = document.querySelectorAll(".snapshot-image");
    const snapshots = Array.from(snapshotImages).map((img) => ({
      name: img.alt,
      src: img.src,
    }));

    if (snapshots.length > 0) {
      // Send snapshots to the server using AJAX
      const xhr = new XMLHttpRequest();
      xhr.open("POST", "your-upload-endpoint-url", true);
      xhr.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
      xhr.onreadystatechange = function () {
        if (xhr.readyState === XMLHttpRequest.DONE) {
          if (xhr.status === 200) {
            console.log("Snapshots uploaded successfully");
            // Clear the snapshot container
            snapshotContainer.innerHTML = "";
            counter = 1; // Reset the counter
          } else {
            console.error("Error uploading snapshots: ", xhr.statusText);
          }
        }
      };

      // Convert snapshots array to JSON and send it
      const data = JSON.stringify({ snapshots: snapshots });
      xhr.send(data);
    }
  });
});
