let currentStep = 1;

document.addEventListener("DOMContentLoaded", function () {
  showStep(currentStep);
  updatePageNumber();
  updatePagination();
});

function gotoStep(step) {
  const formStep = document.getElementById(`step-${step}`);
  if (formStep) {
    currentStep = step;
    showStep(currentStep);
    updatePageNumber();
    updatePagination();
  }
}

function showStep(step) {
  const formSteps = document.querySelectorAll(".form-step");
  formSteps.forEach((stepElement) => stepElement.classList.remove("active"));

  const currentFormStep = document.getElementById(`step-${step}`);
  if (currentFormStep) {
    currentFormStep.classList.add("active");
  }
}

function nextStep() {
  if (currentStep < 5) {
    currentStep++;
    showStep(currentStep);
    updatePageNumber();
    updatePagination();
  }
}

function prevStep() {
  if (currentStep > 1) {
    currentStep--;
    showStep(currentStep);
    updatePageNumber();
    updatePagination();
  }
}

function updatePageNumber() {
  const pageNumber = document.getElementById("page-number");
  pageNumber.innerText = `Step ${currentStep} of 5`;
}
//Submit Step 2 Data
function substep2() {
  var recordid = $("#recordid").val();
  var patientid = $("#patientid").val();
  var fname = $("#fname").val();
  var lname = $("#lname").val();
  var pdob = $("#pdob").val();
  //var psex = $("#psex").val();
  //var contact = $("#pcontact").val();
  var doctorpermis = $("#doctorpermis").val();
  //var address = $("#address").val();
  $.ajax({
    url: "https://providerondemandapp.com/mPanel/patients/substep2.php",
    type: "POST",
    data: {
      recordid: recordid,
      patientid: patientid,
      fname: fname,
      lname: lname,
      pdob: pdob,
      //psex: psex,
      //contact: contact,
      doctorpermis: doctorpermis,
      //address : address,
    },
  });
}
//Submit Step 3 Data
function substep3() {
  var recordid = $("#recordid").val();
  var patientid = $("#patientid").val();
  var chiefcomplaint = $("#chiefcomplaint").val();
  $.ajax({
    url: "https://providerondemandapp.com/mPanel/patients/substep3.php",
    type: "POST",
    data: {
      recordid: recordid,
      patientid: patientid,
      chiefcomplaint: chiefcomplaint,
    },
  });
}
//Submit Step 4 Data
function substep4() {
  var recordid = $("#recordid").val();
  var patientid = $("#patientid").val();
  var vbp = $("#vbp").val();
  var vtemp = $("#vtemp").val();
  var vresp = $("#vresp").val();
  var vhr = $("#vhr").val();
  var vweight = $("#vweight").val();
  var vhg = $("#vhg").val();
  var vsot = $("#vsot").val();
  var final = $("#final").val();
  var startoncall = $("#startoncall").val();
  $.ajax({
    url: "https://providerondemandapp.com/mPanel/patients/substep4.php",
    type: "POST",
    data: {
      recordid: recordid,
      patientid: patientid,
      vhg: vhg,
      vbp: vbp,
      vtemp: vtemp,
      vresp: vresp,
      vhr: vhr,
      vweight: vweight,
      vsot: vsot,
      final: final,
      startoncall: startoncall,
    },
  });
}
//Submit Step 5 OnCall Data
function substep5oncall() {
    var recordid = $("#recordid").val();
    var patientid = $("#patientid").val();
    var startoncall = $("#startoncall").val();
    var final = $("#final").val();
    $.ajax({
        url: "https://providerondemandapp.com/mPanel/patients/substep5_oncall.php",
        type: "POST",
        data: {
            recordid: recordid,
            patientid: patientid,
            startoncall: startoncall,
            final: final,
        },
    });
}

function updatePagination() {
  const pageItems = document.querySelectorAll(".pagination .page-item");
  pageItems.forEach((pageItem) => pageItem.classList.remove("active"));

  const currentPaginationItem = document.getElementById(`page-${currentStep}`);
  if (currentPaginationItem) {
    currentPaginationItem.classList.add("active");
  }
  // Logic Next Prev Button
  const prevPreviousbtn = document.getElementById("med-prev");
  const pagspan = document.getElementById("page-number");
  const nextButton = document.getElementById("med-next");
  const sbmtButton = document.getElementById("med-submit");
  const paginationframe = document.getElementById("page-lists");
  const lftpag1 = document.getElementById("page1lftnm");
  const lftpag2 = document.getElementById("page2lftnm");
  const lftpag3 = document.getElementById("page3lftnm");
  const lftpag4 = document.getElementById("page4lftnm");
  if (currentStep === 5) {
    prevPreviousbtn.removeAttribute("disabled", "");
    nextButton.style.display = "none"; // or use nextButton.remove() to completely remove the button
    sbmtButton.style.display = "block";
    //add class and remove class
    paginationframe.classList.add("finish");
    nextButton.classList.remove("sbmtbtnstep2");
    nextButton.classList.remove("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep4");
    //add checklist to left pagnation number
    lftpag4.classList.add("done");
  }
  if (currentStep === 1) {
    nextButton.style.display = "none";
    sbmtButton.style.display = "none";
    pagspan.style.display = "none";
    prevPreviousbtn.style.display = "none";
    nextButton.classList.remove("sbmtbtnstep2");
    nextButton.classList.remove("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep4");
    nextButton.classList.remove("sbmtbtnstep5");
  }
  if (currentStep === 2) {
    prevPreviousbtn.setAttribute("disabled", "");
    nextButton.style.display = "block";
    sbmtButton.style.display = "none";
    pagspan.style.display = "block";
    prevPreviousbtn.style.display = "block";
    //add class and remove class
    nextButton.classList.add("sbmtbtnstep2");
    nextButton.classList.remove("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep4");
    //add checklist to left pagnation number
    lftpag1.classList.add("done");
    lftpag2.classList.remove("done");
    $("#med-next").click(function () {
      console.log("Step 2 Update Successfully!");
      substep2();
    });
  }
  if (currentStep === 3) {
    prevPreviousbtn.removeAttribute("disabled", "");
    nextButton.style.display = "block";
    sbmtButton.style.display = "none";
    pagspan.style.display = "block";
    prevPreviousbtn.style.display = "block";
    //add class and remove class
    nextButton.classList.add("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep2");
    nextButton.classList.remove("sbmtbtnstep4");
    //add checklist to left pagnation number
    lftpag2.classList.add("done");
    lftpag3.classList.remove("done");
    $("#med-next").click(function () {
      console.log("Step 3 Update Successfully!");
      substep3();
    });
  }
  if (currentStep === 4) {
    prevPreviousbtn.removeAttribute("disabled", "");
    nextButton.style.display = "block";
    sbmtButton.style.display = "none";
    pagspan.style.display = "block";
    prevPreviousbtn.style.display = "block";
    //add class and remove class
    nextButton.classList.add("sbmtbtnstep4");
    nextButton.classList.remove("sbmtbtnstep3");
    nextButton.classList.remove("sbmtbtnstep2");
    //add checklist to left pagnation number
    lftpag3.classList.add("done");
    lftpag4.classList.remove("done");
    $("#med-next").click(function () {
      console.log("Step 4 Update Successfully!");
      substep4();
    });
  }
}
/* 
function validateForm() {
    var recordid = $("#recordid").val();
    var fname = $("#fname").val();
    var lname = $("#lname").val();
    if (!recordid.trim()) {
        // If recordid is not filled, show a sweet alert
        Swal.fire({
            title: "Error!",
            text: "Please fill out the recordid field before submitting.",
            icon: "error",
            confirmButtonText: "OK",
        });
        return;
    }

       // If recordid is filled, proceed with form submission
    Swal.fire({
        title: "Success!",
        text: "Form submitted successfully.",
        icon: "success",
        confirmButtonText: "Call Provider",
    }).then((result) => {
        console.log("Call Provider button clicked");
        if (result.isConfirmed) {
            // Run your other function here when "Call Provider" button is clicked
            console.log("Call Provider confirmed");
            callProviderFunction(recordid, fname, lname);
        }
    });
  }
function callProviderFunction(recordid, fname, lname) {
    console.log("Calling provider function");
    var password = recordid; 
    var roomName = fname + lname + "Room"; 
    createJitsiMeetRoom(roomName, password);
  }

function createJitsiMeetRoom(roomName, password) {
    console.log("Creating Jitsi Meet room");
    var domain = "oncall.providerondemandapp.com";
    var options = {
        roomName: roomName,
        parentNode: document.getElementById('meet'),
        userInfo: {
            displayName: 'Provider'
        },
        configOverwrite: {
            startWithAudioMuted: true,
            startWithVideoMuted: true
        },
        interfaceConfigOverwrite: {
            toolbarButtons: [
    'microphone', 'camera', 'closedcaptions', 'desktop', 'embedmeeting', 'fullscreen',
    'fodeviceselection', 'hangup', 'profile', 'chat', 'recording',
    'livestreaming', 'etherpad', 'sharedvideo', 'shareaudio', 'settings', 'raisehand',
    'videoquality', 'filmstrip', 'invite', 'feedback', 'stats', 'shortcuts',
    'tileview', 'select-background', 'download', 'help', 'mute-everyone', 'mute-video-everyone', 'security'
    ],
    //toolbarButtons: [
    //'microphone', 'camera', 'closedcaptions', 'desktop', 'embedmeeting', 'fullscreen',
    //'fodeviceselection', 'hangup', 'profile', 'chat', 'recording',
    //'livestreaming', 'etherpad', 'sharedvideo', 'shareaudio', 'settings', 'raisehand',
    //'videoquality', 'filmstrip', 'invite', 'feedback', 'stats', 'shortcuts',
    //'tileview', 'select-background', 'download', 'help', 'mute-everyone', 'mute-video-everyone', 'security'
    //],
        },
        onload: function () {
            console.log("Jitsi Meet room loaded");
            api.executeCommand('password', password);
            // Open a new tab with the Jitsi Meet room URL
            var roomUrl = "https://oncall.providerondemandapp.com/" + roomName;
            // Double confirmation before opening the Jitsi Meet room
            Swal.fire({
                title: "Confirmation",
                text: "Are you sure you want to proceed to the provider room?",
                icon: "info",
                showCancelButton: true,
                confirmButtonText: "Yes, proceed",
                cancelButtonText: "No, cancel"
            }).then((result) => {
                console.log("Confirmed to proceed to meeting room");
                if (result.isConfirmed) {
                    window.open(roomUrl, '_blank');
                }
                else {
                    console.log("Cancelled, redirecting to standby");
                    // Redirect to standby if the user cancels
                    window.location.href = "https://providerondemandapp.com/mPanel/standby";
                }
            });
        }
    };
    var api = new JitsiMeetExternalAPI(domain, options);
  }
  
 */
  
 function validateForm() {
    var recordid = $("#recordid").val();
    var fname = $("#fname").val();
    var lname = $("#lname").val();
    
    if (!recordid.trim() || !fname.trim() || !lname.trim()) {
        // If any of the fields are not filled, show a sweet alert
        Swal.fire({
            title: "Error!",
            text: "Please fill out all fields before submitting.",
            icon: "error",
            confirmButtonText: "OK",
        });
        return;
    }

    // If all fields are filled, proceed with form submission
    Swal.fire({
        title: "Success!",
        text: "Form submitted successfully.",
        icon: "success",
        confirmButtonText: "Call Provider",
    }).then((result) => {
        if (result.isConfirmed) {
            // Call the function to create Jitsi Meet room with password
            var roomName = fname + lname + recordid;
            callProviderFunction(recordid, roomName);
            // Call the function to submit Step 5 OnCall Data
            substep5oncall();
        }
    });
  }

  function callProviderFunction(recordid, roomName) {
    // Show confirmation for calling the provider
    Swal.fire({
        title: "Provider Called!",
        text: "Do you want to join the meeting?",
        icon: "info",
        showCancelButton: true,
        confirmButtonText: "Join Meeting",
        cancelButtonText: "Not Now",
    }).then((result) => {
        if (result.isConfirmed) {
            // Open a new tab with the Jitsi Meet room URL
            var fixRoomName = decodeURIComponent(roomName).replace(/\s/g, '');
            var roomUrl = "https://oncall.providerondemandapp.com/" + fixRoomName;
            window.open(roomUrl, '_blank');
            window.location.href = "https://providerondemandapp.com/mPanel/standby";
        }
        else{
            window.location.href = "https://providerondemandapp.com/mPanel/standby";
        }
    });
  }
  
  
  
// Alert if the user tries to refresh the page
window.onbeforeunload = function () {
  return true;
};
