// menampilkan kamera dengan menentukan ukuran, format dan kualitas
Webcam.set({
  width: 320,
  height: 240,
  video: {
    optional: [
      { minWidth: 320, minHeight: 240 }, // Minimum width and height
      { minWidth: 640, minHeight: 480 },
      { minWidth: 1024, minHeight: 768 },
      { minWidth: 1280, minHeight: 720 },
      { minWidth: 1920, minHeight: 1080 },
      { minWidth: 2560, minHeight: 1440 }, // Maximum width and height
      { maxWidth: 3840, maxHeight: 2160 } // Example for maximum width and height
    ]
  },

  image_format: "jpeg",
  jpeg_quality: 90,
  deviceId: null,
});

//menampilkan webcam di dalam file html dengan id medical_camera
Webcam.attach("#medical_camera");
//Capture Button
const captureBtn = document.getElementById("captureit");
const video = document.getElementById("medical_camera");

// saat dokumen selesai dibuat jalankan fungsi update
$(document).ready(function () {
  updategallery();
});

// jalankan aksi saat tombol register disubmit
$(".tombol-simpan").click(function () {
  event.preventDefault();
    // Create a canvas element
        var canvas = document.createElement('canvas');
        canvas.width = video.videoWidth;
        canvas.height = video.videoHeight;
    // Draw the current frame of the video onto the canvas
        var ctx = canvas.getContext('2d');
        ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
    // Get the data URL of the canvas
        var dataUrl = canvas.toDataURL('image/png');
        
        
  // membuat variabel image
  var image = "";

  //mengambil data dari form dengan id name
  var branchid = $("#branchid").val();
  var recordid = $("#recordid").val();
  var checkdevice = $("#checkdevice").val();
  var patientid = $("#patientid").val();
  
  //mengirimkan data ke file action.php dengan teknik ajax
  $.ajax({
    url: "https://providerondemandapp.com/mPanel/finalapps-act.php",
    type: "POST",
    data: {
      branchid: branchid,
      recordid: recordid,
      patientid: patientid,
      checkdevice: checkdevice,
      image: dataUrl,
    },
    success: function () {
      Swal.fire({
        title: "Success!",
        text: "Image has been saved.",
        icon: "success",
        confirmButtonText: "OK",
      });
      // menjalankan fungsi update setelah kirim data selesai dilakukan
      updategallery();
    },
  });
});

//fungsi update untuk menampilkan data
function updategallery() {
  var recordid = $("#recordid").val();
  $.ajax({
    url: "https://providerondemandapp.com/mPanel/finalapps-data.php",
    type: "get",
    data: {
      recordid: recordid,
    },
    success: function (data) {
      $("#data").html(data);
    },
  });
}
