<?php
require 'dompdf/autoload.inc.php'; // Adjust the path to autoload.inc.php

use Dompdf\Dompdf;
use Dompdf\Options;

include('bridge.php'); // Include your database connection code
$record_id = isset($_GET['id']) ? $_GET['id'] : null;

if (!$record_id) {
    // Handle the case when the record_id parameter is not provided
    echo "Record ID not provided.";
    exit();
}
 
// Check if record_id is provided

    // Prepare and execute the SELECT query
    $stmt = $conn->prepare("SELECT patient_lname, patient_fname, patient_dob, patient_sex FROM patients_record WHERE record_id = ?");
    $stmt->bind_param('i', $record_id);
    $stmt->execute();

   // Get the result set
$result = $stmt->get_result();

// Fetch data as an associative array
$patientRecordData = $result->fetch_assoc();

// Close the statement
$stmt->close();

// Initialize dompdf
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isPhpEnabled', true);
$options->set('isRemoteEnabled', true); // Enable fetching remote images
$dompdf = new Dompdf($options);

// Build HTML content for the PDF using the retrieved data
$html = '
<html>
<head>
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 16px;
        }
        .footer {
            position: fixed;
            bottom: 20px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
        }
        .page-break {
            page-break-before: always;
        }
        h1{
            font-weight: bold;
            font-family: Arial, Helvetica, sans-serif !important;
            font-size: 2em;
            color: #222222;
        }
        h2{
            font-weight: bold;
            font-family: Arial, Helvetica, sans-serif !important;
            font-size: 1.167em;
            padding-bottom: 10px;
            padding-top: 10px;
            color:#444444;
        }
        h3{
            font-weight: bold;
            font-size: 16px;
            font-family: Arial, Helvetica, sans-serif !important;

        }
        .header {
            width: 100%;
            text-align: center;
            margin-bottom: 20px;
            display: flex;
            align-content: center;
            align-items: center;
            border-bottom: double 4px #32ABE2;
            padding-bottom: 7px;
            margin: 0px 5px 0px 5px;
            justify-content: space-between;
            flex-wrap: nowrap;
            flex-direction: row;
        }
        .left-header{
            width:30%;
        }
        .right-header{
            width:70%;
            float:right;
            text-align: -webkit-right;
        }
        .table-header{
            float:right;
        }
        .header img {
            width:100%;
        }
        .isi {
            margin-bottom: 20px;
            margin: 0px 5px 0px 5px;
        }
        .isi .judul-isi{
            text-align: center;
        }
        .isi p {
            margin: 5px 0;
        }
        /*Table 1*/
        .table-p1{
            width: 100%;
        }
        .table-p1, .table-p1 th, .table-p1 td{
            border: 1px solid #000000;
            border-collapse: collapse;
        }
        .table-sub{
            text-align: left;
            background: #32ABE2;
            font-weight: 600;
            font-size: 20px;
            line-height: 27px;
        }
        .data .data-title{
            font-size: 12px;
            color:#373737;
        }
        .gallery{
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
        }
        .gallery div{
            padding-top: 10px;
            padding-bottom: 10px;
        }
        .gallery p{
            font-weight: 600;
        }
        .audio{
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
        }
        .audiosrc{
            display: flex;
        }
        .audio .audiosrc img{
            width: 25px;
            margin-right: 10px;
        }
        .imggal{
            vertical-align: top;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="left-header">
            <img src="https://providerondemand.com/do-not-remove/logo-POD-dark.svg">
        </div>
        <div class="right-header">
            <table class="table-header">
                <tbody>
                    <tr>
                        <td>Record Date</td>
                        <td>:</td>
                        <td>2023-01-15</td>
                    </tr>
                    <tr>
                        <td>POD Location</td>
                        <td>:</td>
                        <td>Palmas Del Mar</td>
                    </tr>
                    <tr>
                        <td>Patient Care Specialist</td>
                        <td>:</td>
                        <td>Reza</td>
                    </tr>
                </tbody>
            </table>
            
        </div>
    </div>
    <div class="isi">
        <div class="judul-isi">
            <h1>Patient Record Details</h1>
        </div>
        <div class="card-isi">
            <p>The patient data below is taken directly from our database. The nurse uses Provider on Demand mPanel Medical program during the examination session to communicate directly with the Doctor. This PDF file is not stored on the server, but can only be downloaded. The database source we use to display the data below will also be automatically deleted on our server in less than 2 days, from the time this data is retrieved.</p>
        </br>
            <table class="table-p1">
                <tbody>
                    <tr>
                        <td colspan="4"class="table-sub">Patient Information</td>
                    </tr>
                    <tr class="data">
                        <td><p class="data-title">First Name</p>
                            <p class="data-isi">' . $patientRecordData['patient_fname'] . '</p>
                        </td>
                        <td><p class="data-title">Last Name</p>
                            <p class="data-isi">' . $patientRecordData['patient_lname'] . '</p>
                        </td>
                        <td><p class="data-title">Date of Birth</p>
                            <p class="data-isi">' . $patientRecordData['patient_dob'] . '</p>
                        </td>
                        <td><p class="data-title">Sex/Gender</p>
                            <p class="data-isi">' . $patientRecordData['patient_sex'] . '</p>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="4" class="table-sub">Medical Records Summary Information</td>
                    </tr>
                    <tr>
                        <td colspan="4"  style="height: 40px;">Summary of Patient Medical Records at <span style="border-bottom: solid 1px;">2024-02-01 20:20:14</span></td>
                    </tr>
                    <tr class="data">
                        <td colspan="3"><p class="data-title">Patient Care Specialist</p>
                                        <p class="data-isi">Reza</p>
                        </td>
                        <td><p class="data-title">Location</p>
                            <p class="data-isi">Palmas Del Mar</p>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="4" class="table-sub">Patient Vital Records</td>
                    </tr>
                    <tr class="data">
                        <td><p class="data-title">BP</p></td>
                        <td colspan="3"><p class="data-isi">111</p></td>
                    </tr>
                    <tr class="data">
                        <td><p class="data-title">Temp</p></td>
                        <td colspan="3"><p class="data-isi">111</p></td>
                    </tr>
                    <tr class="data">
                        <td><p class="data-title">Resp</p></td>
                        <td colspan="3"><p class="data-isi">111</p></td>
                    </tr>
                    <tr class="data">
                        <td><p class="data-title">HR</p></td>
                        <td colspan="3"><p class="data-isi">111</p></td>
                    </tr>
                    <tr class="data">
                        <td><p class="data-title">Wight</p></td>
                        <td colspan="3"><p class="data-isi">111</p></td>
                    </tr>
                    <tr class="data">
                        <td><p class="data-title">O2 SOT</p></td>
                        <td colspan="3"><p class="data-isi">111</p></td>
                    </tr>
                    <tr>
                        <td colspan="4" class="table-sub">Chief Complaint Information</td>
                    </tr>
                    <tr>
                        <td colspan="4"  style="height: 40px;">Over confident, Feels realy handsome, The muscle is too big</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="page-break"></div>
        <div class="isi">
            <div class="judul-isi">
                <h1>Exam Image Results</h1>
            </div>
            <div class="card-isi">
                <div class="gallery">
                    <div><img class="imggal" src="https://providerondemand.com/do-not-remove/Ear_1706793732.png"><p>Skin</p><span>Record Date: 2024-02-01 20:21:50</span></br><span>PCS: Reza</span></div>
                    <div><img class="imggal" src="https://providerondemand.com/do-not-remove/Ear_1706793732.png"><p>Skin</p><span>Record Date: 2024-02-01 20:21:50</span></br><span>PCS: Reza</span></div>
                    <div><img class="imggal" src="https://providerondemand.com/do-not-remove/Ear_1706793732.png"><p>Skin</p><span>Record Date: 2024-02-01 20:21:50</span></br><span>PCS: Reza</span></div>
                    <div><img class="imggal" src="https://providerondemand.com/do-not-remove/Ear_1706793732.png"><p>Skin</p><span>Record Date: 2024-02-01 20:21:50</span></br><span>PCS: Reza</span></div>
                    <div><img class="imggal" src="https://providerondemand.com/do-not-remove/Ear_1706793732.png"><p>Skin</p><span>Record Date: 2024-02-01 20:21:50</span></br><span>PCS: Reza</span></div>
                    <div><img class="imggal" src="https://providerondemand.com/do-not-remove/Ear_1706793732.png"><p>Skin</p><span>Record Date: 2024-02-01 20:21:50</span></br><span>PCS: Reza</span></div>
                </div>
            </div>
        </div>
        <div class="page-break"></div>
        <div class="isi">
            <div class="judul-isi">
                <h1>Exam Audio Results</h1>
            </div>
            <div class="card-isi">
                <div class="audio">
                    <div class="audiosrc"><img src="https://providerondemand.com/do-not-remove/Speaker_Icon.svg"><a href=""><p>FileName</p></a></div>
                    <div class="audiosrc"><img src="https://providerondemand.com/do-not-remove/Speaker_Icon.svg"><a href=""><p>FileName</p></a></div>
                    <div class="audiosrc"><img src="https://providerondemand.com/do-not-remove/Speaker_Icon.svg"><a href=""><p>FileName</p></a></div>
                    <div class="audiosrc"><img src="https://providerondemand.com/do-not-remove/Speaker_Icon.svg"><a href=""><p>FileName</p></a></div>
                    <div class="audiosrc"><img src="https://providerondemand.com/do-not-remove/Speaker_Icon.svg"><a href=""><p>FileName</p></a></div>
                </div>
            </div>
        </div>
</body>
</html>
';

// Load HTML content
$dompdf->loadHtml($html);

// Set paper size (optional)
$dompdf->setPaper('letter', 'portrait');

// Render PDF (first pass to get the total number of pages)
$dompdf->render();


// Construct the filename using patient's last name and first name
$filename = $patientRecordData['patient_lname'] . '_' . $patientRecordData['patient_fname'] . '_record.pdf';

// Stream the file for download with the constructed filename
$dompdf->stream($filename, ['Attachment' => 0]);

// Close the database connection
$conn->close();
?>