<?php
include 'bridge.php'; // Include the database connection file
// Get the record_id parameter from the URL
$record_id = isset($_GET['id']) ? $_GET['id'] : null;

if (!$record_id) {
    // Handle the case when the record_id parameter is not provided
    echo "Record ID not provided.";
    exit();
}

if (isset($_POST['get_data'])) {
    $query = "SELECT vbp, vtemp, vresp, vhr, vweight, vsot, vhg FROM patients_record WHERE record_id = ?";
    
    // Use prepared statement to avoid SQL injection
    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $record_id); // Assuming record_id is an integer, adjust 'i' if it's a different type
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result) {
        $data = $result->fetch_all(MYSQLI_ASSOC);
        echo json_encode($data);
    } else {
        echo json_encode(['error' => 'Error executing the query: ' . $conn->error]);
    }

    // Close the prepared statement and database connection
    $stmt->close();
    $conn->close();
    exit();
}
?>