<?php
include 'bridge.php';
?>
<?php
// Get the record_id parameter from the URL
$record_id = isset($_GET['id']) ? $_GET['id'] : null;

if (!$record_id) {
    // Handle the case when the record_id parameter is not provided
    echo "Record ID not provided.";
    exit();
}
// Enable Server-Sent Events
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');
session_start();
//Check Session
if (isset($_SESSION['id']))
  {
  // if a valid user session is found then the user level is checked, if the
  // user has level 3 access they will be granted access if not a access denied
  //message be displayed and the user will be redirected.
	 if ($_SESSION['roleid'] <= 3) {}

  else
  {
	header("Refresh: 1; url=403/index.php");
	exit(); // Quit the script.
  }  
  }
  // if no valid session is found then the user is not logged in and will
  // receive a access denied message and will be redirected to the login page.
  else if (!isset($_SESSION['user_id'])) {

  header("Refresh: 3; url=login.php");
  echo '<h3>Access Denied!! - You do not have permission to access this page!</h3>';
  echo '<p>You will be redirected in 3 seconds</p>';
  include ('403/index.html');
  exit(); // Quit the script.
  }  



function fetchDataFromDatabase($record_id) {
    global $servername, $username, $password, $dbname;

    // Establish database connection
    $conn = new mysqli($servername, $username, $password, $dbname);
    // Check the connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Replace the placeholders in the SQL query with actual column names
    $sql = "SELECT files, device_type, record_date, record_by FROM patients_audio WHERE record_id = ?";

    
    // Prepare the SQL statement
    $stmt = $conn->prepare($sql);

    // Bind the record ID parameter as a string
    $stmt->bind_param("s", $record_id);

    // Execute the query
    $stmt->execute();

    // Get the result
    $result = $stmt->get_result();

    // Fetch all records as an associative array
    $records = [];
    while ($row = $result->fetch_assoc()) {
        $records[] = $row;
    }

    // Close the statement and connection
    $stmt->close();
    $conn->close();

    return $records;
}
// Fetch initial data
$initialData = fetchDataFromDatabase($record_id);

// Send the initial data to the client
echo "data: " . json_encode($initialData) . "\n\n";
ob_flush();
flush();

// Loop to check for new data and send updates
while (true) {
    // Fetch the latest data from the database
    $latestData = fetchDataFromDatabase($record_id);

    // Check if there's new data
    if ($latestData !== $initialData) {
        // Send the updated data to the client
        echo "data: " . json_encode($latestData) . "\n\n";
        ob_flush();
        flush();

        // Update the initial data for the next iteration
        $initialData = $latestData;
    }

    // Simulate a delay (replace this with your actual database query)
    sleep(1);
}
?>