<?php
session_start();
include 'bridge.php';

// Get location_id from the PHP session

//Check Session
if (isset($_SESSION['roleid']))
  {
  // if a valid user session is found then the user level is checked, if the
  // user has level 3 access they will be granted access if not a access denied
  //message be displayed and the user will be redirected.
	 if ($_SESSION['roleid'] <= 2) {}

  else
  {
	header("Refresh: 1; url=403/index.php");
	exit(); // Quit the script.
  }  
  }
  // if no valid session is found then the user is not logged in and will
  // receive a access denied message and will be redirected to the login page.
  else if (!isset($_SESSION['user_id'])) {

  header("Refresh: 3; url=login.php");
  echo '<h3>Access Denied!! - You do not have permission to access this page!</h3>';
  echo '<p>You will be redirected in 3 seconds</p>';
  include ('403/index.html');
  exit(); // Quit the script.
  }  
// Function to fetch data based on location ID
function fetchData($location_id) {
    global $conn;
    
    // Prepare and execute SQL statement
    $sqlpatient = "SELECT final, already_oncall, patient_fname, patient_lname, patient_dob, patient_sex, record_at, record_date, record_id FROM patients_record WHERE DATE(record_date) = CURDATE() AND doctor_permission = ? ORDER BY record_date DESC";
    $stmt = $conn->prepare($sqlpatient);
    $stmt->bind_param("s", $location_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    // Fetch data and construct table rows
    $rows = '';
    while ($row = $result->fetch_assoc()) {
        if ($row['already_oncall'] == 'Finish') {
            continue; // Skip this row
        }
        $statoncallbg = '';
        $statoncallact = '';
        $animation ='';
    if ($row['final'] == 'Yes') {
        $statoncallbg = '#00cc00;';
        $statoncallact ='auto;';
        $animation ='none;';
    } elseif ($row['final'] == 'No') {
        $statoncallbg = '#ff0000;';
        $statoncallact ='none;';
        $animation ='none;';
    } elseif (is_null($row['final'])) {
        $statoncallbg = '#ff0000;';
        $statoncallact ='none;';
        $animation ='animationbtndanger 1300ms infinite;';
    }
        $rows .= "<tr>";
        $rows .= "<td>" . $row['patient_fname'] . "</td>";
        $rows .= "<td>" . $row['patient_lname'] . "</td>";
        $rows .= "<td>" . $row['patient_dob'] . "</td>";
        $rows .= "<td>" . $row['patient_sex'] . "</td>";
        $rows .= "<td>" . $row['record_at'] . "</td>";
        $rows .= "<td>" . $row['record_date'] . "</td>";
        // Display Record ID as a button linking to patient-details.php
        $rows .= "<td><a href='patient-details.php?id=" . $row['record_id'] . "' class='btn'  style='background-color:#00cc00; color:white;'>View</a></td>";
        $rows .= "<td><a class='on-call-btn btn' href='conference/conference-oncall.php?id=" . $row['record_id'] . "' style='background-color: " . $statoncallbg . "; color:white; pointer-events: " . $statoncallact . "; font-weight:600;animation: " . $animation . ";'>On Call</a></td>";
        $rows .= "</tr>";
    }

    // Close prepared statement
    $stmt->close();

    return $rows;
}

// Check if 'podname' is set in the session
if (isset($_SESSION['dpermis'])) {
    // Get 'podname' from session
    $location_id = $_SESSION['dpermis'];

    // Fetch data based on location ID
    $data = fetchData($location_id);
    echo $data;
} else {
    echo "You Dont have Doctor Permission (dpermis) in session.";
}

// Close database connection
$conn->close();

?>