<?php
include 'bridge.php';
require_once('tcpdf/tcpdf.php');
?>
<?php
// Create a new TCPDF object
$pdf = new TCPDF();

// Add a page to the PDF
$pdf->AddPage();

// Set font
$pdf->SetFont('helvetica', '', 12);

// Connect to the database
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch data from the patients_record table
$sql = "SELECT patient_fname, patient_lname FROM patients_record";
$result = $conn->query($sql);

// Check if any rows were returned
if ($result->num_rows > 0) {
    // Output data to the PDF
    while ($row = $result->fetch_assoc()) {
        $content = "Patient Name: " . $row['patient_fname'] . " " . $row['patient_lname'] . "\n";
        $pdf->writeHTML($content, true, false, true, false, '');
    }
} else {
    $content = "No patient records found.";
    $pdf->writeHTML($content, true, false, true, false, '');
}

// Close the database connection
$conn->close();

// Set the filename and directory for the PDF
$filename = __DIR__ . '/mPanel/Patients/Delivery Note.pdf';

// Output the PDF with the specified filename and directory
$pdf->Output($filename, 'F');


echo "PDF generated successfully.";
?>